/*
 * Decompiled with CFR 0.152.
 */
package com.google.dataflow.v1beta3.stub;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.dataflow.v1beta3.CreateJobFromTemplateRequest;
import com.google.dataflow.v1beta3.GetTemplateRequest;
import com.google.dataflow.v1beta3.GetTemplateResponse;
import com.google.dataflow.v1beta3.Job;
import com.google.dataflow.v1beta3.LaunchTemplateRequest;
import com.google.dataflow.v1beta3.LaunchTemplateResponse;
import com.google.dataflow.v1beta3.stub.GrpcTemplatesServiceCallableFactory;
import com.google.dataflow.v1beta3.stub.TemplatesServiceStub;
import com.google.dataflow.v1beta3.stub.TemplatesServiceStubSettings;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class GrpcTemplatesServiceStub
extends TemplatesServiceStub {
    private static final MethodDescriptor<CreateJobFromTemplateRequest, Job> createJobFromTemplateMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.dataflow.v1beta3.TemplatesService/CreateJobFromTemplate").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateJobFromTemplateRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Job.getDefaultInstance())).build();
    private static final MethodDescriptor<LaunchTemplateRequest, LaunchTemplateResponse> launchTemplateMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.dataflow.v1beta3.TemplatesService/LaunchTemplate").setRequestMarshaller(ProtoUtils.marshaller((Message)LaunchTemplateRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)LaunchTemplateResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetTemplateRequest, GetTemplateResponse> getTemplateMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.dataflow.v1beta3.TemplatesService/GetTemplate").setRequestMarshaller(ProtoUtils.marshaller((Message)GetTemplateRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)GetTemplateResponse.getDefaultInstance())).build();
    private final UnaryCallable<CreateJobFromTemplateRequest, Job> createJobFromTemplateCallable;
    private final UnaryCallable<LaunchTemplateRequest, LaunchTemplateResponse> launchTemplateCallable;
    private final UnaryCallable<GetTemplateRequest, GetTemplateResponse> getTemplateCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcTemplatesServiceStub create(TemplatesServiceStubSettings settings) throws IOException {
        return new GrpcTemplatesServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcTemplatesServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcTemplatesServiceStub(TemplatesServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcTemplatesServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcTemplatesServiceStub(TemplatesServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcTemplatesServiceStub(TemplatesServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcTemplatesServiceCallableFactory());
    }

    protected GrpcTemplatesServiceStub(TemplatesServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings createJobFromTemplateTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createJobFromTemplateMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("location", String.valueOf(request.getLocation()));
            builder.add("project_id", String.valueOf(request.getProjectId()));
            return builder.build();
        }).build();
        GrpcCallSettings launchTemplateTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(launchTemplateMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("location", String.valueOf(request.getLocation()));
            builder.add("project_id", String.valueOf(request.getProjectId()));
            return builder.build();
        }).build();
        GrpcCallSettings getTemplateTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getTemplateMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("location", String.valueOf(request.getLocation()));
            builder.add("project_id", String.valueOf(request.getProjectId()));
            return builder.build();
        }).build();
        this.createJobFromTemplateCallable = callableFactory.createUnaryCallable(createJobFromTemplateTransportSettings, settings.createJobFromTemplateSettings(), clientContext);
        this.launchTemplateCallable = callableFactory.createUnaryCallable(launchTemplateTransportSettings, settings.launchTemplateSettings(), clientContext);
        this.getTemplateCallable = callableFactory.createUnaryCallable(getTemplateTransportSettings, settings.getTemplateSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<CreateJobFromTemplateRequest, Job> createJobFromTemplateCallable() {
        return this.createJobFromTemplateCallable;
    }

    @Override
    public UnaryCallable<LaunchTemplateRequest, LaunchTemplateResponse> launchTemplateCallable() {
        return this.launchTemplateCallable;
    }

    @Override
    public UnaryCallable<GetTemplateRequest, GetTemplateResponse> getTemplateCallable() {
        return this.getTemplateCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

