/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.metastore.v1alpha;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.cloud.metastore.v1alpha.CreateFederationRequest;
import com.google.cloud.metastore.v1alpha.DataprocMetastoreFederationSettings;
import com.google.cloud.metastore.v1alpha.DeleteFederationRequest;
import com.google.cloud.metastore.v1alpha.Federation;
import com.google.cloud.metastore.v1alpha.FederationName;
import com.google.cloud.metastore.v1alpha.GetFederationRequest;
import com.google.cloud.metastore.v1alpha.ListFederationsRequest;
import com.google.cloud.metastore.v1alpha.ListFederationsResponse;
import com.google.cloud.metastore.v1alpha.LocationName;
import com.google.cloud.metastore.v1alpha.OperationMetadata;
import com.google.cloud.metastore.v1alpha.UpdateFederationRequest;
import com.google.cloud.metastore.v1alpha.stub.DataprocMetastoreFederationStub;
import com.google.cloud.metastore.v1alpha.stub.DataprocMetastoreFederationStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class DataprocMetastoreFederationClient
implements BackgroundResource {
    private final DataprocMetastoreFederationSettings settings;
    private final DataprocMetastoreFederationStub stub;
    private final com.google.api.gax.httpjson.longrunning.OperationsClient httpJsonOperationsClient;
    private final OperationsClient operationsClient;

    public static final DataprocMetastoreFederationClient create() throws IOException {
        return DataprocMetastoreFederationClient.create(DataprocMetastoreFederationSettings.newBuilder().build());
    }

    public static final DataprocMetastoreFederationClient create(DataprocMetastoreFederationSettings settings) throws IOException {
        return new DataprocMetastoreFederationClient(settings);
    }

    public static final DataprocMetastoreFederationClient create(DataprocMetastoreFederationStub stub) {
        return new DataprocMetastoreFederationClient(stub);
    }

    protected DataprocMetastoreFederationClient(DataprocMetastoreFederationSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((DataprocMetastoreFederationStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected DataprocMetastoreFederationClient(DataprocMetastoreFederationStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final DataprocMetastoreFederationSettings getSettings() {
        return this.settings;
    }

    public DataprocMetastoreFederationStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final com.google.api.gax.httpjson.longrunning.OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final ListFederationsPagedResponse listFederations(LocationName parent) {
        ListFederationsRequest request = ListFederationsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listFederations(request);
    }

    public final ListFederationsPagedResponse listFederations(String parent) {
        ListFederationsRequest request = ListFederationsRequest.newBuilder().setParent(parent).build();
        return this.listFederations(request);
    }

    public final ListFederationsPagedResponse listFederations(ListFederationsRequest request) {
        return (ListFederationsPagedResponse)((Object)this.listFederationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListFederationsRequest, ListFederationsPagedResponse> listFederationsPagedCallable() {
        return this.stub.listFederationsPagedCallable();
    }

    public final UnaryCallable<ListFederationsRequest, ListFederationsResponse> listFederationsCallable() {
        return this.stub.listFederationsCallable();
    }

    public final Federation getFederation(FederationName name) {
        GetFederationRequest request = GetFederationRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getFederation(request);
    }

    public final Federation getFederation(String name) {
        GetFederationRequest request = GetFederationRequest.newBuilder().setName(name).build();
        return this.getFederation(request);
    }

    public final Federation getFederation(GetFederationRequest request) {
        return (Federation)this.getFederationCallable().call((Object)request);
    }

    public final UnaryCallable<GetFederationRequest, Federation> getFederationCallable() {
        return this.stub.getFederationCallable();
    }

    public final OperationFuture<Federation, OperationMetadata> createFederationAsync(LocationName parent, Federation federation, String federationId) {
        CreateFederationRequest request = CreateFederationRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setFederation(federation).setFederationId(federationId).build();
        return this.createFederationAsync(request);
    }

    public final OperationFuture<Federation, OperationMetadata> createFederationAsync(String parent, Federation federation, String federationId) {
        CreateFederationRequest request = CreateFederationRequest.newBuilder().setParent(parent).setFederation(federation).setFederationId(federationId).build();
        return this.createFederationAsync(request);
    }

    public final OperationFuture<Federation, OperationMetadata> createFederationAsync(CreateFederationRequest request) {
        return this.createFederationOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateFederationRequest, Federation, OperationMetadata> createFederationOperationCallable() {
        return this.stub.createFederationOperationCallable();
    }

    public final UnaryCallable<CreateFederationRequest, Operation> createFederationCallable() {
        return this.stub.createFederationCallable();
    }

    public final OperationFuture<Federation, OperationMetadata> updateFederationAsync(Federation federation, FieldMask updateMask) {
        UpdateFederationRequest request = UpdateFederationRequest.newBuilder().setFederation(federation).setUpdateMask(updateMask).build();
        return this.updateFederationAsync(request);
    }

    public final OperationFuture<Federation, OperationMetadata> updateFederationAsync(UpdateFederationRequest request) {
        return this.updateFederationOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateFederationRequest, Federation, OperationMetadata> updateFederationOperationCallable() {
        return this.stub.updateFederationOperationCallable();
    }

    public final UnaryCallable<UpdateFederationRequest, Operation> updateFederationCallable() {
        return this.stub.updateFederationCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteFederationAsync(FederationName name) {
        DeleteFederationRequest request = DeleteFederationRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteFederationAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteFederationAsync(String name) {
        DeleteFederationRequest request = DeleteFederationRequest.newBuilder().setName(name).build();
        return this.deleteFederationAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteFederationAsync(DeleteFederationRequest request) {
        return this.deleteFederationOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteFederationRequest, Empty, OperationMetadata> deleteFederationOperationCallable() {
        return this.stub.deleteFederationOperationCallable();
    }

    public final UnaryCallable<DeleteFederationRequest, Operation> deleteFederationCallable() {
        return this.stub.deleteFederationCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final Policy setIamPolicy(SetIamPolicyRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final Policy getIamPolicy(GetIamPolicyRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final TestIamPermissionsResponse testIamPermissions(TestIamPermissionsRequest request) {
        return (TestIamPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListFederationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListFederationsRequest, ListFederationsResponse, Federation, ListFederationsPage, ListFederationsFixedSizeCollection> {
        private ListFederationsFixedSizeCollection(List<ListFederationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFederationsFixedSizeCollection createEmptyCollection() {
            return new ListFederationsFixedSizeCollection(null, 0);
        }

        protected ListFederationsFixedSizeCollection createCollection(List<ListFederationsPage> pages, int collectionSize) {
            return new ListFederationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListFederationsPage
    extends AbstractPage<ListFederationsRequest, ListFederationsResponse, Federation, ListFederationsPage> {
        private ListFederationsPage(PageContext<ListFederationsRequest, ListFederationsResponse, Federation> context, ListFederationsResponse response) {
            super(context, (Object)response);
        }

        private static ListFederationsPage createEmptyPage() {
            return new ListFederationsPage(null, null);
        }

        protected ListFederationsPage createPage(PageContext<ListFederationsRequest, ListFederationsResponse, Federation> context, ListFederationsResponse response) {
            return new ListFederationsPage(context, response);
        }

        public ApiFuture<ListFederationsPage> createPageAsync(PageContext<ListFederationsRequest, ListFederationsResponse, Federation> context, ApiFuture<ListFederationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListFederationsPagedResponse
    extends AbstractPagedListResponse<ListFederationsRequest, ListFederationsResponse, Federation, ListFederationsPage, ListFederationsFixedSizeCollection> {
        public static ApiFuture<ListFederationsPagedResponse> createAsync(PageContext<ListFederationsRequest, ListFederationsResponse, Federation> context, ApiFuture<ListFederationsResponse> futureResponse) {
            ApiFuture<ListFederationsPage> futurePage = ListFederationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListFederationsPagedResponse((ListFederationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListFederationsPagedResponse(ListFederationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFederationsFixedSizeCollection.createEmptyCollection());
        }
    }
}

