/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataproc.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dataproc.v1.CreateSessionTemplateRequest;
import com.google.cloud.dataproc.v1.DeleteSessionTemplateRequest;
import com.google.cloud.dataproc.v1.GetSessionTemplateRequest;
import com.google.cloud.dataproc.v1.ListSessionTemplatesRequest;
import com.google.cloud.dataproc.v1.ListSessionTemplatesResponse;
import com.google.cloud.dataproc.v1.LocationName;
import com.google.cloud.dataproc.v1.SessionTemplate;
import com.google.cloud.dataproc.v1.SessionTemplateControllerSettings;
import com.google.cloud.dataproc.v1.SessionTemplateName;
import com.google.cloud.dataproc.v1.UpdateSessionTemplateRequest;
import com.google.cloud.dataproc.v1.stub.SessionTemplateControllerStub;
import com.google.cloud.dataproc.v1.stub.SessionTemplateControllerStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class SessionTemplateControllerClient
implements BackgroundResource {
    private final SessionTemplateControllerSettings settings;
    private final SessionTemplateControllerStub stub;

    public static final SessionTemplateControllerClient create() throws IOException {
        return SessionTemplateControllerClient.create(SessionTemplateControllerSettings.newBuilder().build());
    }

    public static final SessionTemplateControllerClient create(SessionTemplateControllerSettings settings) throws IOException {
        return new SessionTemplateControllerClient(settings);
    }

    public static final SessionTemplateControllerClient create(SessionTemplateControllerStub stub) {
        return new SessionTemplateControllerClient(stub);
    }

    protected SessionTemplateControllerClient(SessionTemplateControllerSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((SessionTemplateControllerStubSettings)settings.getStubSettings()).createStub();
    }

    protected SessionTemplateControllerClient(SessionTemplateControllerStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final SessionTemplateControllerSettings getSettings() {
        return this.settings;
    }

    public SessionTemplateControllerStub getStub() {
        return this.stub;
    }

    public final SessionTemplate createSessionTemplate(LocationName parent, SessionTemplate sessionTemplate) {
        CreateSessionTemplateRequest request = CreateSessionTemplateRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setSessionTemplate(sessionTemplate).build();
        return this.createSessionTemplate(request);
    }

    public final SessionTemplate createSessionTemplate(String parent, SessionTemplate sessionTemplate) {
        CreateSessionTemplateRequest request = CreateSessionTemplateRequest.newBuilder().setParent(parent).setSessionTemplate(sessionTemplate).build();
        return this.createSessionTemplate(request);
    }

    public final SessionTemplate createSessionTemplate(CreateSessionTemplateRequest request) {
        return (SessionTemplate)this.createSessionTemplateCallable().call((Object)request);
    }

    public final UnaryCallable<CreateSessionTemplateRequest, SessionTemplate> createSessionTemplateCallable() {
        return this.stub.createSessionTemplateCallable();
    }

    public final SessionTemplate updateSessionTemplate(SessionTemplate sessionTemplate) {
        UpdateSessionTemplateRequest request = UpdateSessionTemplateRequest.newBuilder().setSessionTemplate(sessionTemplate).build();
        return this.updateSessionTemplate(request);
    }

    public final SessionTemplate updateSessionTemplate(UpdateSessionTemplateRequest request) {
        return (SessionTemplate)this.updateSessionTemplateCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateSessionTemplateRequest, SessionTemplate> updateSessionTemplateCallable() {
        return this.stub.updateSessionTemplateCallable();
    }

    public final SessionTemplate getSessionTemplate(SessionTemplateName name) {
        GetSessionTemplateRequest request = GetSessionTemplateRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getSessionTemplate(request);
    }

    public final SessionTemplate getSessionTemplate(String name) {
        GetSessionTemplateRequest request = GetSessionTemplateRequest.newBuilder().setName(name).build();
        return this.getSessionTemplate(request);
    }

    public final SessionTemplate getSessionTemplate(GetSessionTemplateRequest request) {
        return (SessionTemplate)this.getSessionTemplateCallable().call((Object)request);
    }

    public final UnaryCallable<GetSessionTemplateRequest, SessionTemplate> getSessionTemplateCallable() {
        return this.stub.getSessionTemplateCallable();
    }

    public final ListSessionTemplatesPagedResponse listSessionTemplates(LocationName parent) {
        ListSessionTemplatesRequest request = ListSessionTemplatesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listSessionTemplates(request);
    }

    public final ListSessionTemplatesPagedResponse listSessionTemplates(String parent) {
        ListSessionTemplatesRequest request = ListSessionTemplatesRequest.newBuilder().setParent(parent).build();
        return this.listSessionTemplates(request);
    }

    public final ListSessionTemplatesPagedResponse listSessionTemplates(ListSessionTemplatesRequest request) {
        return (ListSessionTemplatesPagedResponse)((Object)this.listSessionTemplatesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListSessionTemplatesRequest, ListSessionTemplatesPagedResponse> listSessionTemplatesPagedCallable() {
        return this.stub.listSessionTemplatesPagedCallable();
    }

    public final UnaryCallable<ListSessionTemplatesRequest, ListSessionTemplatesResponse> listSessionTemplatesCallable() {
        return this.stub.listSessionTemplatesCallable();
    }

    public final void deleteSessionTemplate(SessionTemplateName name) {
        DeleteSessionTemplateRequest request = DeleteSessionTemplateRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteSessionTemplate(request);
    }

    public final void deleteSessionTemplate(String name) {
        DeleteSessionTemplateRequest request = DeleteSessionTemplateRequest.newBuilder().setName(name).build();
        this.deleteSessionTemplate(request);
    }

    public final void deleteSessionTemplate(DeleteSessionTemplateRequest request) {
        this.deleteSessionTemplateCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteSessionTemplateRequest, Empty> deleteSessionTemplateCallable() {
        return this.stub.deleteSessionTemplateCallable();
    }

    public final Policy setIamPolicy(SetIamPolicyRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final Policy getIamPolicy(GetIamPolicyRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final TestIamPermissionsResponse testIamPermissions(TestIamPermissionsRequest request) {
        return (TestIamPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListSessionTemplatesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListSessionTemplatesRequest, ListSessionTemplatesResponse, SessionTemplate, ListSessionTemplatesPage, ListSessionTemplatesFixedSizeCollection> {
        private ListSessionTemplatesFixedSizeCollection(List<ListSessionTemplatesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListSessionTemplatesFixedSizeCollection createEmptyCollection() {
            return new ListSessionTemplatesFixedSizeCollection(null, 0);
        }

        protected ListSessionTemplatesFixedSizeCollection createCollection(List<ListSessionTemplatesPage> pages, int collectionSize) {
            return new ListSessionTemplatesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListSessionTemplatesPage
    extends AbstractPage<ListSessionTemplatesRequest, ListSessionTemplatesResponse, SessionTemplate, ListSessionTemplatesPage> {
        private ListSessionTemplatesPage(PageContext<ListSessionTemplatesRequest, ListSessionTemplatesResponse, SessionTemplate> context, ListSessionTemplatesResponse response) {
            super(context, (Object)response);
        }

        private static ListSessionTemplatesPage createEmptyPage() {
            return new ListSessionTemplatesPage(null, null);
        }

        protected ListSessionTemplatesPage createPage(PageContext<ListSessionTemplatesRequest, ListSessionTemplatesResponse, SessionTemplate> context, ListSessionTemplatesResponse response) {
            return new ListSessionTemplatesPage(context, response);
        }

        public ApiFuture<ListSessionTemplatesPage> createPageAsync(PageContext<ListSessionTemplatesRequest, ListSessionTemplatesResponse, SessionTemplate> context, ApiFuture<ListSessionTemplatesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListSessionTemplatesPagedResponse
    extends AbstractPagedListResponse<ListSessionTemplatesRequest, ListSessionTemplatesResponse, SessionTemplate, ListSessionTemplatesPage, ListSessionTemplatesFixedSizeCollection> {
        public static ApiFuture<ListSessionTemplatesPagedResponse> createAsync(PageContext<ListSessionTemplatesRequest, ListSessionTemplatesResponse, SessionTemplate> context, ApiFuture<ListSessionTemplatesResponse> futureResponse) {
            ApiFuture<ListSessionTemplatesPage> futurePage = ListSessionTemplatesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListSessionTemplatesPagedResponse((ListSessionTemplatesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListSessionTemplatesPagedResponse(ListSessionTemplatesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListSessionTemplatesFixedSizeCollection.createEmptyCollection());
        }
    }
}

