/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataproc.v1.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dataproc.v1.CreateNodeGroupRequest;
import com.google.cloud.dataproc.v1.GetNodeGroupRequest;
import com.google.cloud.dataproc.v1.NodeGroup;
import com.google.cloud.dataproc.v1.NodeGroupOperationMetadata;
import com.google.cloud.dataproc.v1.ResizeNodeGroupRequest;
import com.google.cloud.dataproc.v1.stub.GrpcNodeGroupControllerCallableFactory;
import com.google.cloud.dataproc.v1.stub.NodeGroupControllerStub;
import com.google.cloud.dataproc.v1.stub.NodeGroupControllerStubSettings;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcNodeGroupControllerStub
extends NodeGroupControllerStub {
    private static final MethodDescriptor<CreateNodeGroupRequest, Operation> createNodeGroupMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dataproc.v1.NodeGroupController/CreateNodeGroup").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateNodeGroupRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<ResizeNodeGroupRequest, Operation> resizeNodeGroupMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dataproc.v1.NodeGroupController/ResizeNodeGroup").setRequestMarshaller(ProtoUtils.marshaller((Message)ResizeNodeGroupRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<GetNodeGroupRequest, NodeGroup> getNodeGroupMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dataproc.v1.NodeGroupController/GetNodeGroup").setRequestMarshaller(ProtoUtils.marshaller((Message)GetNodeGroupRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)NodeGroup.getDefaultInstance())).build();
    private static final MethodDescriptor<SetIamPolicyRequest, Policy> setIamPolicyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.iam.v1.IAMPolicy/SetIamPolicy").setRequestMarshaller(ProtoUtils.marshaller((Message)SetIamPolicyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Policy.getDefaultInstance())).build();
    private static final MethodDescriptor<GetIamPolicyRequest, Policy> getIamPolicyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.iam.v1.IAMPolicy/GetIamPolicy").setRequestMarshaller(ProtoUtils.marshaller((Message)GetIamPolicyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Policy.getDefaultInstance())).build();
    private static final MethodDescriptor<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.iam.v1.IAMPolicy/TestIamPermissions").setRequestMarshaller(ProtoUtils.marshaller((Message)TestIamPermissionsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)TestIamPermissionsResponse.getDefaultInstance())).build();
    private final UnaryCallable<CreateNodeGroupRequest, Operation> createNodeGroupCallable;
    private final OperationCallable<CreateNodeGroupRequest, NodeGroup, NodeGroupOperationMetadata> createNodeGroupOperationCallable;
    private final UnaryCallable<ResizeNodeGroupRequest, Operation> resizeNodeGroupCallable;
    private final OperationCallable<ResizeNodeGroupRequest, NodeGroup, NodeGroupOperationMetadata> resizeNodeGroupOperationCallable;
    private final UnaryCallable<GetNodeGroupRequest, NodeGroup> getNodeGroupCallable;
    private final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable;
    private final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable;
    private final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcNodeGroupControllerStub create(NodeGroupControllerStubSettings settings) throws IOException {
        return new GrpcNodeGroupControllerStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcNodeGroupControllerStub create(ClientContext clientContext) throws IOException {
        return new GrpcNodeGroupControllerStub(NodeGroupControllerStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcNodeGroupControllerStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcNodeGroupControllerStub(NodeGroupControllerStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcNodeGroupControllerStub(NodeGroupControllerStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcNodeGroupControllerCallableFactory());
    }

    protected GrpcNodeGroupControllerStub(NodeGroupControllerStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings createNodeGroupTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createNodeGroupMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings resizeNodeGroupTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(resizeNodeGroupMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings getNodeGroupTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getNodeGroupMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings setIamPolicyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(setIamPolicyMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        GrpcCallSettings getIamPolicyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getIamPolicyMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        GrpcCallSettings testIamPermissionsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(testIamPermissionsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        this.createNodeGroupCallable = callableFactory.createUnaryCallable(createNodeGroupTransportSettings, settings.createNodeGroupSettings(), clientContext);
        this.createNodeGroupOperationCallable = callableFactory.createOperationCallable(createNodeGroupTransportSettings, settings.createNodeGroupOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.resizeNodeGroupCallable = callableFactory.createUnaryCallable(resizeNodeGroupTransportSettings, settings.resizeNodeGroupSettings(), clientContext);
        this.resizeNodeGroupOperationCallable = callableFactory.createOperationCallable(resizeNodeGroupTransportSettings, settings.resizeNodeGroupOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.getNodeGroupCallable = callableFactory.createUnaryCallable(getNodeGroupTransportSettings, settings.getNodeGroupSettings(), clientContext);
        this.setIamPolicyCallable = callableFactory.createUnaryCallable(setIamPolicyTransportSettings, settings.setIamPolicySettings(), clientContext);
        this.getIamPolicyCallable = callableFactory.createUnaryCallable(getIamPolicyTransportSettings, settings.getIamPolicySettings(), clientContext);
        this.testIamPermissionsCallable = callableFactory.createUnaryCallable(testIamPermissionsTransportSettings, settings.testIamPermissionsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<CreateNodeGroupRequest, Operation> createNodeGroupCallable() {
        return this.createNodeGroupCallable;
    }

    @Override
    public OperationCallable<CreateNodeGroupRequest, NodeGroup, NodeGroupOperationMetadata> createNodeGroupOperationCallable() {
        return this.createNodeGroupOperationCallable;
    }

    @Override
    public UnaryCallable<ResizeNodeGroupRequest, Operation> resizeNodeGroupCallable() {
        return this.resizeNodeGroupCallable;
    }

    @Override
    public OperationCallable<ResizeNodeGroupRequest, NodeGroup, NodeGroupOperationMetadata> resizeNodeGroupOperationCallable() {
        return this.resizeNodeGroupOperationCallable;
    }

    @Override
    public UnaryCallable<GetNodeGroupRequest, NodeGroup> getNodeGroupCallable() {
        return this.getNodeGroupCallable;
    }

    @Override
    public UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.setIamPolicyCallable;
    }

    @Override
    public UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.getIamPolicyCallable;
    }

    @Override
    public UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.testIamPermissionsCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

