/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore;

import com.google.cloud.datastore.BaseEntity;
import com.google.cloud.datastore.FullEntity;
import com.google.cloud.datastore.IncompleteKey;
import com.google.cloud.datastore.Key;
import com.google.common.base.Preconditions;

public final class Entity
extends FullEntity<Key> {
    private static final long serialVersionUID = 2312315289215899118L;

    Entity(Builder builder) {
        super(builder);
    }

    Entity(FullEntity<Key> from) {
        super(from);
        Preconditions.checkArgument((from.getKey() != null ? 1 : 0) != 0);
    }

    static Entity convert(FullEntity<Key> from) {
        if (from instanceof Entity) {
            return (Entity)from;
        }
        return new Entity(from);
    }

    public static Builder newBuilder(Key key) {
        return new Builder(key);
    }

    public static Builder newBuilder(Entity copyFrom) {
        return new Builder(copyFrom);
    }

    public static Builder newBuilder(Key key, FullEntity<?> copyFrom) {
        return new Builder(key, copyFrom);
    }

    public static Entity fromPb(com.google.datastore.v1.Entity entityPb) {
        return ((Builder)new Builder().fill(entityPb)).build();
    }

    public static int calculateSerializedSize(BaseEntity<? extends IncompleteKey> entity) {
        Preconditions.checkNotNull(entity);
        return entity.toPb().getSerializedSize();
    }

    public static final class Builder
    extends BaseEntity.Builder<Key, Builder> {
        private Builder() {
        }

        private Builder(Key key) {
            super((Key)Preconditions.checkNotNull((Object)key));
        }

        private Builder(Entity entity) {
            super(entity);
        }

        private Builder(Key key, FullEntity<?> entity) {
            this.setProperties(entity.getProperties());
            this.setKey(key);
        }

        @Override
        public Builder setKey(Key key) {
            super.setKey((Key)Preconditions.checkNotNull((Object)key));
            return this;
        }

        public Entity build() {
            Preconditions.checkState((this.key() != null ? 1 : 0) != 0);
            return new Entity(this);
        }
    }
}

