/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore;

import com.google.cloud.datastore.AggregationQuery;
import com.google.cloud.datastore.Entity;
import com.google.cloud.datastore.EntityQuery;
import com.google.cloud.datastore.GqlQuery;
import com.google.cloud.datastore.Key;
import com.google.cloud.datastore.KeyQuery;
import com.google.cloud.datastore.ProjectionEntity;
import com.google.cloud.datastore.ProjectionEntityQuery;
import com.google.common.base.MoreObjects;
import com.google.common.collect.Maps;
import com.google.datastore.v1.EntityResult;
import java.io.Serializable;
import java.util.Map;

public abstract class Query<V>
implements Serializable {
    private static final long serialVersionUID = 7967659059395653941L;
    private final String namespace;

    Query(String namespace) {
        this.namespace = namespace;
    }

    public String getNamespace() {
        return this.namespace;
    }

    MoreObjects.ToStringHelper toStringHelper() {
        return MoreObjects.toStringHelper((Object)this).add("namespace", (Object)this.namespace);
    }

    public static GqlQuery.Builder<?> newGqlQueryBuilder(String gql) {
        return Query.newGqlQueryBuilder(ResultType.UNKNOWN, gql);
    }

    public static <V> GqlQuery.Builder<V> newGqlQueryBuilder(ResultType<V> resultType, String gql) {
        return new GqlQuery.Builder<V>(resultType, gql);
    }

    public static EntityQuery.Builder newEntityQueryBuilder() {
        return new EntityQuery.Builder();
    }

    public static KeyQuery.Builder newKeyQueryBuilder() {
        return new KeyQuery.Builder();
    }

    public static ProjectionEntityQuery.Builder newProjectionEntityQueryBuilder() {
        return new ProjectionEntityQuery.Builder();
    }

    public static AggregationQuery.Builder newAggregationQueryBuilder() {
        return new AggregationQuery.Builder();
    }

    public static abstract class ResultType<V>
    implements Serializable {
        private static final long serialVersionUID = 2104157695425806623L;
        private static final Map<EntityResult.ResultType, ResultType<?>> PB_TO_INSTANCE = Maps.newEnumMap(EntityResult.ResultType.class);
        static final ResultType<?> UNKNOWN = new ResultType<Object>(null, Object.class){
            private static final long serialVersionUID = 1602329532153860907L;

            @Override
            Object convert(com.google.datastore.v1.Entity entityPb) {
                if (entityPb.getPropertiesMap().isEmpty()) {
                    if (!entityPb.hasKey()) {
                        return null;
                    }
                    return Key.fromPb(entityPb.getKey());
                }
                return ProjectionEntity.fromPb(entityPb);
            }
        };
        public static final ResultType<Entity> ENTITY = new ResultType<Entity>(EntityResult.ResultType.FULL, Entity.class){
            private static final long serialVersionUID = 7712959777507168274L;

            @Override
            Entity convert(com.google.datastore.v1.Entity entityPb) {
                return Entity.fromPb(entityPb);
            }
        };
        public static final ResultType<Key> KEY = new ResultType<Key>(EntityResult.ResultType.KEY_ONLY, Key.class){
            private static final long serialVersionUID = -8514289244104446252L;

            @Override
            Key convert(com.google.datastore.v1.Entity entityPb) {
                return Key.fromPb(entityPb.getKey());
            }
        };
        public static final ResultType<ProjectionEntity> PROJECTION_ENTITY = new ResultType<ProjectionEntity>(EntityResult.ResultType.PROJECTION, ProjectionEntity.class){
            private static final long serialVersionUID = -7591409419690650246L;

            @Override
            ProjectionEntity convert(com.google.datastore.v1.Entity entityPb) {
                return ProjectionEntity.fromPb(entityPb);
            }
        };
        private final Class<V> resultClass;
        private final EntityResult.ResultType queryType;

        private ResultType(EntityResult.ResultType queryType, Class<V> resultClass) {
            this.queryType = queryType;
            this.resultClass = resultClass;
            if (queryType != null) {
                PB_TO_INSTANCE.put(queryType, this);
            }
        }

        public Class<V> resultClass() {
            return this.resultClass;
        }

        public int hashCode() {
            return this.resultClass.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof ResultType)) {
                return false;
            }
            ResultType other = (ResultType)obj;
            return this.resultClass.equals(other.resultClass);
        }

        public String toString() {
            MoreObjects.ToStringHelper toStringHelper = MoreObjects.toStringHelper((Object)this);
            toStringHelper.add("queryType", (Object)this.queryType);
            toStringHelper.add("resultClass", this.resultClass);
            return toStringHelper.toString();
        }

        boolean isAssignableFrom(ResultType<?> otherResultType) {
            return this.resultClass.isAssignableFrom(otherResultType.resultClass);
        }

        abstract V convert(com.google.datastore.v1.Entity var1);

        static ResultType<?> fromPb(EntityResult.ResultType typePb) {
            return (ResultType)MoreObjects.firstNonNull(PB_TO_INSTANCE.get(typePb), UNKNOWN);
        }
    }
}

