/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore;

import com.google.api.core.InternalApi;
import com.google.cloud.datastore.StructuredQuery;
import com.google.cloud.datastore.execution.request.ProtoPreparer;
import com.google.datastore.v1.Projection;
import com.google.datastore.v1.PropertyReference;
import com.google.datastore.v1.Query;
import com.google.protobuf.Int32Value;

@InternalApi
public class StructuredQueryProtoPreparer
implements ProtoPreparer<StructuredQuery<?>, Query> {
    @Override
    public Query prepare(StructuredQuery<?> query) {
        Query.Builder queryPb = Query.newBuilder();
        if (query.getKind() != null) {
            queryPb.addKindBuilder().setName(query.getKind());
        }
        if (query.getStartCursor() != null) {
            queryPb.setStartCursor(query.getStartCursor().getByteString());
        }
        if (query.getEndCursor() != null) {
            queryPb.setEndCursor(query.getEndCursor().getByteString());
        }
        if (query.getOffset() > 0) {
            queryPb.setOffset(query.getOffset());
        }
        if (query.getLimit() != null) {
            queryPb.setLimit(Int32Value.of((int)query.getLimit()));
        }
        if (query.getFilter() != null) {
            queryPb.setFilter(query.getFilter().toPb());
        }
        for (StructuredQuery.OrderBy orderBy : query.getOrderBy()) {
            queryPb.addOrder(orderBy.toPb());
        }
        for (String string : query.getDistinctOn()) {
            queryPb.addDistinctOn(PropertyReference.newBuilder().setName(string).build());
        }
        for (String string : query.getProjection()) {
            Projection expressionPb = Projection.newBuilder().setProperty(PropertyReference.newBuilder().setName(string).build()).build();
            queryPb.addProjection(expressionPb);
        }
        return queryPb.build();
    }
}

