/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore;

import com.google.api.core.BetaApi;
import com.google.cloud.ExceptionHandler;
import com.google.cloud.datastore.DatastoreException;
import com.google.cloud.datastore.DatastoreImpl;

@BetaApi
public class TransactionExceptionHandler {
    public static final ExceptionHandler.Interceptor TRANSACTION_EXCEPTION_HANDLER_INTERCEPTOR = new ExceptionHandler.Interceptor(){
        private static final long serialVersionUID = -1240723093072535978L;
        private static final int ABORTED_CODE = 10;

        public ExceptionHandler.Interceptor.RetryResult beforeEval(Exception exception) {
            DatastoreException e;
            if (exception instanceof DatastoreException && ((e = this.getInnerException((DatastoreException)((Object)exception))).getCode() == 10 || e.getReason() != null && e.getReason().equals("ABORTED"))) {
                return ExceptionHandler.Interceptor.RetryResult.RETRY;
            }
            return ExceptionHandler.Interceptor.RetryResult.CONTINUE_EVALUATION;
        }

        public ExceptionHandler.Interceptor.RetryResult afterEval(Exception exception, ExceptionHandler.Interceptor.RetryResult retryResult) {
            return ExceptionHandler.Interceptor.RetryResult.CONTINUE_EVALUATION;
        }

        private DatastoreException getInnerException(DatastoreException exception) {
            while (exception.getCause() instanceof DatastoreException) {
                exception = (DatastoreException)((Object)exception.getCause());
            }
            return exception;
        }
    };

    public static ExceptionHandler build() {
        return ExceptionHandler.newBuilder().abortOn(new Class[]{RuntimeException.class}).addInterceptors(new ExceptionHandler.Interceptor[]{DatastoreImpl.EXCEPTION_HANDLER_INTERCEPTOR, TRANSACTION_EXCEPTION_HANDLER_INTERCEPTOR}).build();
    }

    private TransactionExceptionHandler() {
    }
}

