/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.cx.v3beta1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dialogflow.cx.v3beta1.Agent;
import com.google.cloud.dialogflow.cx.v3beta1.AgentGenerativeSettingsName;
import com.google.cloud.dialogflow.cx.v3beta1.AgentName;
import com.google.cloud.dialogflow.cx.v3beta1.AgentValidationResult;
import com.google.cloud.dialogflow.cx.v3beta1.AgentValidationResultName;
import com.google.cloud.dialogflow.cx.v3beta1.AgentsSettings;
import com.google.cloud.dialogflow.cx.v3beta1.CreateAgentRequest;
import com.google.cloud.dialogflow.cx.v3beta1.DeleteAgentRequest;
import com.google.cloud.dialogflow.cx.v3beta1.ExportAgentRequest;
import com.google.cloud.dialogflow.cx.v3beta1.ExportAgentResponse;
import com.google.cloud.dialogflow.cx.v3beta1.GenerativeSettings;
import com.google.cloud.dialogflow.cx.v3beta1.GetAgentRequest;
import com.google.cloud.dialogflow.cx.v3beta1.GetAgentValidationResultRequest;
import com.google.cloud.dialogflow.cx.v3beta1.GetGenerativeSettingsRequest;
import com.google.cloud.dialogflow.cx.v3beta1.ListAgentsRequest;
import com.google.cloud.dialogflow.cx.v3beta1.ListAgentsResponse;
import com.google.cloud.dialogflow.cx.v3beta1.LocationName;
import com.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest;
import com.google.cloud.dialogflow.cx.v3beta1.UpdateAgentRequest;
import com.google.cloud.dialogflow.cx.v3beta1.UpdateGenerativeSettingsRequest;
import com.google.cloud.dialogflow.cx.v3beta1.ValidateAgentRequest;
import com.google.cloud.dialogflow.cx.v3beta1.stub.AgentsStub;
import com.google.cloud.dialogflow.cx.v3beta1.stub.AgentsStubSettings;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import com.google.protobuf.Struct;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class AgentsClient
implements BackgroundResource {
    private final AgentsSettings settings;
    private final AgentsStub stub;
    private final com.google.api.gax.httpjson.longrunning.OperationsClient httpJsonOperationsClient;
    private final OperationsClient operationsClient;

    public static final AgentsClient create() throws IOException {
        return AgentsClient.create(AgentsSettings.newBuilder().build());
    }

    public static final AgentsClient create(AgentsSettings settings) throws IOException {
        return new AgentsClient(settings);
    }

    public static final AgentsClient create(AgentsStub stub) {
        return new AgentsClient(stub);
    }

    protected AgentsClient(AgentsSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((AgentsStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected AgentsClient(AgentsStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final AgentsSettings getSettings() {
        return this.settings;
    }

    public AgentsStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final com.google.api.gax.httpjson.longrunning.OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final ListAgentsPagedResponse listAgents(LocationName parent) {
        ListAgentsRequest request = ListAgentsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listAgents(request);
    }

    public final ListAgentsPagedResponse listAgents(String parent) {
        ListAgentsRequest request = ListAgentsRequest.newBuilder().setParent(parent).build();
        return this.listAgents(request);
    }

    public final ListAgentsPagedResponse listAgents(ListAgentsRequest request) {
        return (ListAgentsPagedResponse)((Object)this.listAgentsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListAgentsRequest, ListAgentsPagedResponse> listAgentsPagedCallable() {
        return this.stub.listAgentsPagedCallable();
    }

    public final UnaryCallable<ListAgentsRequest, ListAgentsResponse> listAgentsCallable() {
        return this.stub.listAgentsCallable();
    }

    public final Agent getAgent(AgentName name) {
        GetAgentRequest request = GetAgentRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getAgent(request);
    }

    public final Agent getAgent(String name) {
        GetAgentRequest request = GetAgentRequest.newBuilder().setName(name).build();
        return this.getAgent(request);
    }

    public final Agent getAgent(GetAgentRequest request) {
        return (Agent)this.getAgentCallable().call((Object)request);
    }

    public final UnaryCallable<GetAgentRequest, Agent> getAgentCallable() {
        return this.stub.getAgentCallable();
    }

    public final Agent createAgent(LocationName parent, Agent agent) {
        CreateAgentRequest request = CreateAgentRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setAgent(agent).build();
        return this.createAgent(request);
    }

    public final Agent createAgent(String parent, Agent agent) {
        CreateAgentRequest request = CreateAgentRequest.newBuilder().setParent(parent).setAgent(agent).build();
        return this.createAgent(request);
    }

    public final Agent createAgent(CreateAgentRequest request) {
        return (Agent)this.createAgentCallable().call((Object)request);
    }

    public final UnaryCallable<CreateAgentRequest, Agent> createAgentCallable() {
        return this.stub.createAgentCallable();
    }

    public final Agent updateAgent(Agent agent, FieldMask updateMask) {
        UpdateAgentRequest request = UpdateAgentRequest.newBuilder().setAgent(agent).setUpdateMask(updateMask).build();
        return this.updateAgent(request);
    }

    public final Agent updateAgent(UpdateAgentRequest request) {
        return (Agent)this.updateAgentCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateAgentRequest, Agent> updateAgentCallable() {
        return this.stub.updateAgentCallable();
    }

    public final void deleteAgent(AgentName name) {
        DeleteAgentRequest request = DeleteAgentRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteAgent(request);
    }

    public final void deleteAgent(String name) {
        DeleteAgentRequest request = DeleteAgentRequest.newBuilder().setName(name).build();
        this.deleteAgent(request);
    }

    public final void deleteAgent(DeleteAgentRequest request) {
        this.deleteAgentCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteAgentRequest, Empty> deleteAgentCallable() {
        return this.stub.deleteAgentCallable();
    }

    public final OperationFuture<ExportAgentResponse, Struct> exportAgentAsync(ExportAgentRequest request) {
        return this.exportAgentOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<ExportAgentRequest, ExportAgentResponse, Struct> exportAgentOperationCallable() {
        return this.stub.exportAgentOperationCallable();
    }

    public final UnaryCallable<ExportAgentRequest, Operation> exportAgentCallable() {
        return this.stub.exportAgentCallable();
    }

    public final OperationFuture<Empty, Struct> restoreAgentAsync(RestoreAgentRequest request) {
        return this.restoreAgentOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<RestoreAgentRequest, Empty, Struct> restoreAgentOperationCallable() {
        return this.stub.restoreAgentOperationCallable();
    }

    public final UnaryCallable<RestoreAgentRequest, Operation> restoreAgentCallable() {
        return this.stub.restoreAgentCallable();
    }

    public final AgentValidationResult validateAgent(ValidateAgentRequest request) {
        return (AgentValidationResult)this.validateAgentCallable().call((Object)request);
    }

    public final UnaryCallable<ValidateAgentRequest, AgentValidationResult> validateAgentCallable() {
        return this.stub.validateAgentCallable();
    }

    public final AgentValidationResult getAgentValidationResult(AgentValidationResultName name) {
        GetAgentValidationResultRequest request = GetAgentValidationResultRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getAgentValidationResult(request);
    }

    public final AgentValidationResult getAgentValidationResult(String name) {
        GetAgentValidationResultRequest request = GetAgentValidationResultRequest.newBuilder().setName(name).build();
        return this.getAgentValidationResult(request);
    }

    public final AgentValidationResult getAgentValidationResult(GetAgentValidationResultRequest request) {
        return (AgentValidationResult)this.getAgentValidationResultCallable().call((Object)request);
    }

    public final UnaryCallable<GetAgentValidationResultRequest, AgentValidationResult> getAgentValidationResultCallable() {
        return this.stub.getAgentValidationResultCallable();
    }

    public final GenerativeSettings getGenerativeSettings(AgentGenerativeSettingsName name, String languageCode) {
        GetGenerativeSettingsRequest request = GetGenerativeSettingsRequest.newBuilder().setName(name == null ? null : name.toString()).setLanguageCode(languageCode).build();
        return this.getGenerativeSettings(request);
    }

    public final GenerativeSettings getGenerativeSettings(String name, String languageCode) {
        GetGenerativeSettingsRequest request = GetGenerativeSettingsRequest.newBuilder().setName(name).setLanguageCode(languageCode).build();
        return this.getGenerativeSettings(request);
    }

    public final GenerativeSettings getGenerativeSettings(GetGenerativeSettingsRequest request) {
        return (GenerativeSettings)this.getGenerativeSettingsCallable().call((Object)request);
    }

    public final UnaryCallable<GetGenerativeSettingsRequest, GenerativeSettings> getGenerativeSettingsCallable() {
        return this.stub.getGenerativeSettingsCallable();
    }

    public final GenerativeSettings updateGenerativeSettings(GenerativeSettings generativeSettings, FieldMask updateMask) {
        UpdateGenerativeSettingsRequest request = UpdateGenerativeSettingsRequest.newBuilder().setGenerativeSettings(generativeSettings).setUpdateMask(updateMask).build();
        return this.updateGenerativeSettings(request);
    }

    public final GenerativeSettings updateGenerativeSettings(UpdateGenerativeSettingsRequest request) {
        return (GenerativeSettings)this.updateGenerativeSettingsCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateGenerativeSettingsRequest, GenerativeSettings> updateGenerativeSettingsCallable() {
        return this.stub.updateGenerativeSettingsCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListAgentsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListAgentsRequest, ListAgentsResponse, Agent, ListAgentsPage, ListAgentsFixedSizeCollection> {
        private ListAgentsFixedSizeCollection(List<ListAgentsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListAgentsFixedSizeCollection createEmptyCollection() {
            return new ListAgentsFixedSizeCollection(null, 0);
        }

        protected ListAgentsFixedSizeCollection createCollection(List<ListAgentsPage> pages, int collectionSize) {
            return new ListAgentsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListAgentsPage
    extends AbstractPage<ListAgentsRequest, ListAgentsResponse, Agent, ListAgentsPage> {
        private ListAgentsPage(PageContext<ListAgentsRequest, ListAgentsResponse, Agent> context, ListAgentsResponse response) {
            super(context, (Object)response);
        }

        private static ListAgentsPage createEmptyPage() {
            return new ListAgentsPage(null, null);
        }

        protected ListAgentsPage createPage(PageContext<ListAgentsRequest, ListAgentsResponse, Agent> context, ListAgentsResponse response) {
            return new ListAgentsPage(context, response);
        }

        public ApiFuture<ListAgentsPage> createPageAsync(PageContext<ListAgentsRequest, ListAgentsResponse, Agent> context, ApiFuture<ListAgentsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListAgentsPagedResponse
    extends AbstractPagedListResponse<ListAgentsRequest, ListAgentsResponse, Agent, ListAgentsPage, ListAgentsFixedSizeCollection> {
        public static ApiFuture<ListAgentsPagedResponse> createAsync(PageContext<ListAgentsRequest, ListAgentsResponse, Agent> context, ApiFuture<ListAgentsResponse> futureResponse) {
            ApiFuture<ListAgentsPage> futurePage = ListAgentsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListAgentsPagedResponse((ListAgentsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListAgentsPagedResponse(ListAgentsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListAgentsFixedSizeCollection.createEmptyCollection());
        }
    }
}

