/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.v2;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dialogflow.v2.Fulfillment;
import com.google.cloud.dialogflow.v2.FulfillmentName;
import com.google.cloud.dialogflow.v2.FulfillmentsSettings;
import com.google.cloud.dialogflow.v2.GetFulfillmentRequest;
import com.google.cloud.dialogflow.v2.UpdateFulfillmentRequest;
import com.google.cloud.dialogflow.v2.stub.FulfillmentsStub;
import com.google.cloud.dialogflow.v2.stub.FulfillmentsStubSettings;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class FulfillmentsClient
implements BackgroundResource {
    private final FulfillmentsSettings settings;
    private final FulfillmentsStub stub;

    public static final FulfillmentsClient create() throws IOException {
        return FulfillmentsClient.create(FulfillmentsSettings.newBuilder().build());
    }

    public static final FulfillmentsClient create(FulfillmentsSettings settings) throws IOException {
        return new FulfillmentsClient(settings);
    }

    public static final FulfillmentsClient create(FulfillmentsStub stub) {
        return new FulfillmentsClient(stub);
    }

    protected FulfillmentsClient(FulfillmentsSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((FulfillmentsStubSettings)settings.getStubSettings()).createStub();
    }

    protected FulfillmentsClient(FulfillmentsStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final FulfillmentsSettings getSettings() {
        return this.settings;
    }

    public FulfillmentsStub getStub() {
        return this.stub;
    }

    public final Fulfillment getFulfillment(FulfillmentName name) {
        GetFulfillmentRequest request = GetFulfillmentRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getFulfillment(request);
    }

    public final Fulfillment getFulfillment(String name) {
        GetFulfillmentRequest request = GetFulfillmentRequest.newBuilder().setName(name).build();
        return this.getFulfillment(request);
    }

    public final Fulfillment getFulfillment(GetFulfillmentRequest request) {
        return (Fulfillment)this.getFulfillmentCallable().call((Object)request);
    }

    public final UnaryCallable<GetFulfillmentRequest, Fulfillment> getFulfillmentCallable() {
        return this.stub.getFulfillmentCallable();
    }

    public final Fulfillment updateFulfillment(Fulfillment fulfillment, FieldMask updateMask) {
        UpdateFulfillmentRequest request = UpdateFulfillmentRequest.newBuilder().setFulfillment(fulfillment).setUpdateMask(updateMask).build();
        return this.updateFulfillment(request);
    }

    public final Fulfillment updateFulfillment(UpdateFulfillmentRequest request) {
        return (Fulfillment)this.updateFulfillmentCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateFulfillmentRequest, Fulfillment> updateFulfillmentCallable() {
        return this.stub.updateFulfillmentCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }
}

