/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.v2beta1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dialogflow.v2beta1.AnswerRecord;
import com.google.cloud.dialogflow.v2beta1.AnswerRecordsClient;
import com.google.cloud.dialogflow.v2beta1.GetAnswerRecordRequest;
import com.google.cloud.dialogflow.v2beta1.ListAnswerRecordsRequest;
import com.google.cloud.dialogflow.v2beta1.ListAnswerRecordsResponse;
import com.google.cloud.dialogflow.v2beta1.UpdateAnswerRecordRequest;
import com.google.cloud.dialogflow.v2beta1.stub.AnswerRecordsStub;
import com.google.cloud.dialogflow.v2beta1.stub.GrpcAnswerRecordsStub;
import com.google.cloud.dialogflow.v2beta1.stub.HttpJsonAnswerRecordsStub;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class AnswerRecordsStubSettings
extends StubSettings<AnswerRecordsStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/dialogflow").build();
    private final UnaryCallSettings<GetAnswerRecordRequest, AnswerRecord> getAnswerRecordSettings;
    private final PagedCallSettings<ListAnswerRecordsRequest, ListAnswerRecordsResponse, AnswerRecordsClient.ListAnswerRecordsPagedResponse> listAnswerRecordsSettings;
    private final UnaryCallSettings<UpdateAnswerRecordRequest, AnswerRecord> updateAnswerRecordSettings;
    private final PagedCallSettings<ListLocationsRequest, ListLocationsResponse, AnswerRecordsClient.ListLocationsPagedResponse> listLocationsSettings;
    private final UnaryCallSettings<GetLocationRequest, Location> getLocationSettings;
    private static final PagedListDescriptor<ListAnswerRecordsRequest, ListAnswerRecordsResponse, AnswerRecord> LIST_ANSWER_RECORDS_PAGE_STR_DESC = new PagedListDescriptor<ListAnswerRecordsRequest, ListAnswerRecordsResponse, AnswerRecord>(){

        public String emptyToken() {
            return "";
        }

        public ListAnswerRecordsRequest injectToken(ListAnswerRecordsRequest payload, String token) {
            return ListAnswerRecordsRequest.newBuilder((ListAnswerRecordsRequest)payload).setPageToken(token).build();
        }

        public ListAnswerRecordsRequest injectPageSize(ListAnswerRecordsRequest payload, int pageSize) {
            return ListAnswerRecordsRequest.newBuilder((ListAnswerRecordsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListAnswerRecordsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListAnswerRecordsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<AnswerRecord> extractResources(ListAnswerRecordsResponse payload) {
            return payload.getAnswerRecordsList() == null ? ImmutableList.of() : payload.getAnswerRecordsList();
        }
    };
    private static final PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location> LIST_LOCATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location>(){

        public String emptyToken() {
            return "";
        }

        public ListLocationsRequest injectToken(ListLocationsRequest payload, String token) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageToken(token).build();
        }

        public ListLocationsRequest injectPageSize(ListLocationsRequest payload, int pageSize) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListLocationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListLocationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Location> extractResources(ListLocationsResponse payload) {
            return payload.getLocationsList() == null ? ImmutableList.of() : payload.getLocationsList();
        }
    };
    private static final PagedListResponseFactory<ListAnswerRecordsRequest, ListAnswerRecordsResponse, AnswerRecordsClient.ListAnswerRecordsPagedResponse> LIST_ANSWER_RECORDS_PAGE_STR_FACT = new PagedListResponseFactory<ListAnswerRecordsRequest, ListAnswerRecordsResponse, AnswerRecordsClient.ListAnswerRecordsPagedResponse>(){

        public ApiFuture<AnswerRecordsClient.ListAnswerRecordsPagedResponse> getFuturePagedResponse(UnaryCallable<ListAnswerRecordsRequest, ListAnswerRecordsResponse> callable, ListAnswerRecordsRequest request, ApiCallContext context, ApiFuture<ListAnswerRecordsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_ANSWER_RECORDS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return AnswerRecordsClient.ListAnswerRecordsPagedResponse.createAsync((PageContext<ListAnswerRecordsRequest, ListAnswerRecordsResponse, AnswerRecord>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, AnswerRecordsClient.ListLocationsPagedResponse> LIST_LOCATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, AnswerRecordsClient.ListLocationsPagedResponse>(){

        public ApiFuture<AnswerRecordsClient.ListLocationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListLocationsRequest, ListLocationsResponse> callable, ListLocationsRequest request, ApiCallContext context, ApiFuture<ListLocationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_LOCATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return AnswerRecordsClient.ListLocationsPagedResponse.createAsync((PageContext<ListLocationsRequest, ListLocationsResponse, Location>)pageContext, futureResponse);
        }
    };

    @Deprecated
    public UnaryCallSettings<GetAnswerRecordRequest, AnswerRecord> getAnswerRecordSettings() {
        return this.getAnswerRecordSettings;
    }

    public PagedCallSettings<ListAnswerRecordsRequest, ListAnswerRecordsResponse, AnswerRecordsClient.ListAnswerRecordsPagedResponse> listAnswerRecordsSettings() {
        return this.listAnswerRecordsSettings;
    }

    public UnaryCallSettings<UpdateAnswerRecordRequest, AnswerRecord> updateAnswerRecordSettings() {
        return this.updateAnswerRecordSettings;
    }

    public PagedCallSettings<ListLocationsRequest, ListLocationsResponse, AnswerRecordsClient.ListLocationsPagedResponse> listLocationsSettings() {
        return this.listLocationsSettings;
    }

    public UnaryCallSettings<GetLocationRequest, Location> getLocationSettings() {
        return this.getLocationSettings;
    }

    public AnswerRecordsStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcAnswerRecordsStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonAnswerRecordsStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "dialogflow.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "dialogflow.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return AnswerRecordsStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(AnswerRecordsStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(AnswerRecordsStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return AnswerRecordsStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected AnswerRecordsStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.getAnswerRecordSettings = settingsBuilder.getAnswerRecordSettings().build();
        this.listAnswerRecordsSettings = settingsBuilder.listAnswerRecordsSettings().build();
        this.updateAnswerRecordSettings = settingsBuilder.updateAnswerRecordSettings().build();
        this.listLocationsSettings = settingsBuilder.listLocationsSettings().build();
        this.getLocationSettings = settingsBuilder.getLocationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<AnswerRecordsStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<GetAnswerRecordRequest, AnswerRecord> getAnswerRecordSettings;
        private final PagedCallSettings.Builder<ListAnswerRecordsRequest, ListAnswerRecordsResponse, AnswerRecordsClient.ListAnswerRecordsPagedResponse> listAnswerRecordsSettings;
        private final UnaryCallSettings.Builder<UpdateAnswerRecordRequest, AnswerRecord> updateAnswerRecordSettings;
        private final PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, AnswerRecordsClient.ListLocationsPagedResponse> listLocationsSettings;
        private final UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.getAnswerRecordSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listAnswerRecordsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_ANSWER_RECORDS_PAGE_STR_FACT);
            this.updateAnswerRecordSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listLocationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_LOCATIONS_PAGE_STR_FACT);
            this.getLocationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getAnswerRecordSettings, this.listAnswerRecordsSettings, this.updateAnswerRecordSettings, this.listLocationsSettings, this.getLocationSettings);
            Builder.initDefaults(this);
        }

        protected Builder(AnswerRecordsStubSettings settings) {
            super((StubSettings)settings);
            this.getAnswerRecordSettings = settings.getAnswerRecordSettings.toBuilder();
            this.listAnswerRecordsSettings = settings.listAnswerRecordsSettings.toBuilder();
            this.updateAnswerRecordSettings = settings.updateAnswerRecordSettings.toBuilder();
            this.listLocationsSettings = settings.listLocationsSettings.toBuilder();
            this.getLocationSettings = settings.getLocationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getAnswerRecordSettings, this.listAnswerRecordsSettings, this.updateAnswerRecordSettings, this.listLocationsSettings, this.getLocationSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(AnswerRecordsStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)AnswerRecordsStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)AnswerRecordsStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(AnswerRecordsStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(AnswerRecordsStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)AnswerRecordsStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)AnswerRecordsStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)AnswerRecordsStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(AnswerRecordsStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(AnswerRecordsStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.getAnswerRecordSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listAnswerRecordsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updateAnswerRecordSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listLocationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getLocationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        @Deprecated
        public UnaryCallSettings.Builder<GetAnswerRecordRequest, AnswerRecord> getAnswerRecordSettings() {
            return this.getAnswerRecordSettings;
        }

        public PagedCallSettings.Builder<ListAnswerRecordsRequest, ListAnswerRecordsResponse, AnswerRecordsClient.ListAnswerRecordsPagedResponse> listAnswerRecordsSettings() {
            return this.listAnswerRecordsSettings;
        }

        public UnaryCallSettings.Builder<UpdateAnswerRecordRequest, AnswerRecord> updateAnswerRecordSettings() {
            return this.updateAnswerRecordSettings;
        }

        public PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, AnswerRecordsClient.ListLocationsPagedResponse> listLocationsSettings() {
            return this.listLocationsSettings;
        }

        public UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings() {
            return this.getLocationSettings;
        }

        public AnswerRecordsStubSettings build() throws IOException {
            return new AnswerRecordsStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

