/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.v2beta1.stub;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dialogflow.v2beta1.CreateEnvironmentRequest;
import com.google.cloud.dialogflow.v2beta1.DeleteEnvironmentRequest;
import com.google.cloud.dialogflow.v2beta1.Environment;
import com.google.cloud.dialogflow.v2beta1.EnvironmentHistory;
import com.google.cloud.dialogflow.v2beta1.EnvironmentsClient;
import com.google.cloud.dialogflow.v2beta1.GetEnvironmentHistoryRequest;
import com.google.cloud.dialogflow.v2beta1.GetEnvironmentRequest;
import com.google.cloud.dialogflow.v2beta1.ListEnvironmentsRequest;
import com.google.cloud.dialogflow.v2beta1.ListEnvironmentsResponse;
import com.google.cloud.dialogflow.v2beta1.UpdateEnvironmentRequest;
import com.google.cloud.dialogflow.v2beta1.stub.EnvironmentsStub;
import com.google.cloud.dialogflow.v2beta1.stub.EnvironmentsStubSettings;
import com.google.cloud.dialogflow.v2beta1.stub.HttpJsonEnvironmentsCallableFactory;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class HttpJsonEnvironmentsStub
extends EnvironmentsStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().build();
    private static final ApiMethodDescriptor<ListEnvironmentsRequest, ListEnvironmentsResponse> listEnvironmentsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.dialogflow.v2beta1.Environments/ListEnvironments").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2beta1/{parent=projects/*/agent}/environments", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setAdditionalPaths(new String[]{"/v2beta1/{parent=projects/*/locations/*/agent}/environments"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListEnvironmentsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetEnvironmentRequest, Environment> getEnvironmentMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.dialogflow.v2beta1.Environments/GetEnvironment").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2beta1/{name=projects/*/agent/environments/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setAdditionalPaths(new String[]{"/v2beta1/{name=projects/*/locations/*/agent/environments/*}"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Environment.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<CreateEnvironmentRequest, Environment> createEnvironmentMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.dialogflow.v2beta1.Environments/CreateEnvironment").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2beta1/{parent=projects/*/agent}/environments", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setAdditionalPaths(new String[]{"/v2beta1/{parent=projects/*/locations/*/agent}/environments"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "environmentId", (Object)request.getEnvironmentId());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("environment", (Message)request.getEnvironment(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Environment.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<UpdateEnvironmentRequest, Environment> updateEnvironmentMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.dialogflow.v2beta1.Environments/UpdateEnvironment").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2beta1/{environment.name=projects/*/agent/environments/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "environment.name", (Object)request.getEnvironment().getName());
        return fields;
    }).setAdditionalPaths(new String[]{"/v2beta1/{environment.name=projects/*/locations/*/agent/environments/*}"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "allowLoadToDraftAndDiscardChanges", (Object)request.getAllowLoadToDraftAndDiscardChanges());
        serializer.putQueryParam(fields, "updateMask", (Object)request.getUpdateMask());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("environment", (Message)request.getEnvironment(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Environment.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<DeleteEnvironmentRequest, Empty> deleteEnvironmentMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.dialogflow.v2beta1.Environments/DeleteEnvironment").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2beta1/{name=projects/*/agent/environments/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setAdditionalPaths(new String[]{"/v2beta1/{name=projects/*/locations/*/agent/environments/*}"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Empty.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetEnvironmentHistoryRequest, EnvironmentHistory> getEnvironmentHistoryMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.dialogflow.v2beta1.Environments/GetEnvironmentHistory").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2beta1/{parent=projects/*/agent/environments/*}/history", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setAdditionalPaths(new String[]{"/v2beta1/{parent=projects/*/locations/*/agent/environments/*}/history"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)EnvironmentHistory.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListLocationsRequest, ListLocationsResponse> listLocationsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.location.Locations/ListLocations").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2beta1/{name=projects/*}/locations", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListLocationsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetLocationRequest, Location> getLocationMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.location.Locations/GetLocation").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2beta1/{name=projects/*/locations/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Location.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<ListEnvironmentsRequest, ListEnvironmentsResponse> listEnvironmentsCallable;
    private final UnaryCallable<ListEnvironmentsRequest, EnvironmentsClient.ListEnvironmentsPagedResponse> listEnvironmentsPagedCallable;
    private final UnaryCallable<GetEnvironmentRequest, Environment> getEnvironmentCallable;
    private final UnaryCallable<CreateEnvironmentRequest, Environment> createEnvironmentCallable;
    private final UnaryCallable<UpdateEnvironmentRequest, Environment> updateEnvironmentCallable;
    private final UnaryCallable<DeleteEnvironmentRequest, Empty> deleteEnvironmentCallable;
    private final UnaryCallable<GetEnvironmentHistoryRequest, EnvironmentHistory> getEnvironmentHistoryCallable;
    private final UnaryCallable<GetEnvironmentHistoryRequest, EnvironmentsClient.GetEnvironmentHistoryPagedResponse> getEnvironmentHistoryPagedCallable;
    private final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable;
    private final UnaryCallable<ListLocationsRequest, EnvironmentsClient.ListLocationsPagedResponse> listLocationsPagedCallable;
    private final UnaryCallable<GetLocationRequest, Location> getLocationCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonEnvironmentsStub create(EnvironmentsStubSettings settings) throws IOException {
        return new HttpJsonEnvironmentsStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonEnvironmentsStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonEnvironmentsStub(EnvironmentsStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonEnvironmentsStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonEnvironmentsStub(EnvironmentsStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonEnvironmentsStub(EnvironmentsStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonEnvironmentsCallableFactory());
    }

    protected HttpJsonEnvironmentsStub(EnvironmentsStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        HttpJsonCallSettings listEnvironmentsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listEnvironmentsMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings getEnvironmentTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getEnvironmentMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings createEnvironmentTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createEnvironmentMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings updateEnvironmentTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateEnvironmentMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings deleteEnvironmentTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteEnvironmentMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings getEnvironmentHistoryTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getEnvironmentHistoryMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings listLocationsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listLocationsMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings getLocationTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getLocationMethodDescriptor).setTypeRegistry(typeRegistry).build();
        this.listEnvironmentsCallable = callableFactory.createUnaryCallable(listEnvironmentsTransportSettings, settings.listEnvironmentsSettings(), clientContext);
        this.listEnvironmentsPagedCallable = callableFactory.createPagedCallable(listEnvironmentsTransportSettings, settings.listEnvironmentsSettings(), clientContext);
        this.getEnvironmentCallable = callableFactory.createUnaryCallable(getEnvironmentTransportSettings, settings.getEnvironmentSettings(), clientContext);
        this.createEnvironmentCallable = callableFactory.createUnaryCallable(createEnvironmentTransportSettings, settings.createEnvironmentSettings(), clientContext);
        this.updateEnvironmentCallable = callableFactory.createUnaryCallable(updateEnvironmentTransportSettings, settings.updateEnvironmentSettings(), clientContext);
        this.deleteEnvironmentCallable = callableFactory.createUnaryCallable(deleteEnvironmentTransportSettings, settings.deleteEnvironmentSettings(), clientContext);
        this.getEnvironmentHistoryCallable = callableFactory.createUnaryCallable(getEnvironmentHistoryTransportSettings, settings.getEnvironmentHistorySettings(), clientContext);
        this.getEnvironmentHistoryPagedCallable = callableFactory.createPagedCallable(getEnvironmentHistoryTransportSettings, settings.getEnvironmentHistorySettings(), clientContext);
        this.listLocationsCallable = callableFactory.createUnaryCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.listLocationsPagedCallable = callableFactory.createPagedCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.getLocationCallable = callableFactory.createUnaryCallable(getLocationTransportSettings, settings.getLocationSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(listEnvironmentsMethodDescriptor);
        methodDescriptors.add(getEnvironmentMethodDescriptor);
        methodDescriptors.add(createEnvironmentMethodDescriptor);
        methodDescriptors.add(updateEnvironmentMethodDescriptor);
        methodDescriptors.add(deleteEnvironmentMethodDescriptor);
        methodDescriptors.add(getEnvironmentHistoryMethodDescriptor);
        methodDescriptors.add(listLocationsMethodDescriptor);
        methodDescriptors.add(getLocationMethodDescriptor);
        return methodDescriptors;
    }

    @Override
    public UnaryCallable<ListEnvironmentsRequest, ListEnvironmentsResponse> listEnvironmentsCallable() {
        return this.listEnvironmentsCallable;
    }

    @Override
    public UnaryCallable<ListEnvironmentsRequest, EnvironmentsClient.ListEnvironmentsPagedResponse> listEnvironmentsPagedCallable() {
        return this.listEnvironmentsPagedCallable;
    }

    @Override
    public UnaryCallable<GetEnvironmentRequest, Environment> getEnvironmentCallable() {
        return this.getEnvironmentCallable;
    }

    @Override
    public UnaryCallable<CreateEnvironmentRequest, Environment> createEnvironmentCallable() {
        return this.createEnvironmentCallable;
    }

    @Override
    public UnaryCallable<UpdateEnvironmentRequest, Environment> updateEnvironmentCallable() {
        return this.updateEnvironmentCallable;
    }

    @Override
    public UnaryCallable<DeleteEnvironmentRequest, Empty> deleteEnvironmentCallable() {
        return this.deleteEnvironmentCallable;
    }

    @Override
    public UnaryCallable<GetEnvironmentHistoryRequest, EnvironmentHistory> getEnvironmentHistoryCallable() {
        return this.getEnvironmentHistoryCallable;
    }

    @Override
    public UnaryCallable<GetEnvironmentHistoryRequest, EnvironmentsClient.GetEnvironmentHistoryPagedResponse> getEnvironmentHistoryPagedCallable() {
        return this.getEnvironmentHistoryPagedCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.listLocationsCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, EnvironmentsClient.ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.listLocationsPagedCallable;
    }

    @Override
    public UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.getLocationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

