/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.v2.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dialogflow.v2.Agent;
import com.google.cloud.dialogflow.v2.AgentsClient;
import com.google.cloud.dialogflow.v2.DeleteAgentRequest;
import com.google.cloud.dialogflow.v2.ExportAgentRequest;
import com.google.cloud.dialogflow.v2.ExportAgentResponse;
import com.google.cloud.dialogflow.v2.GetAgentRequest;
import com.google.cloud.dialogflow.v2.GetValidationResultRequest;
import com.google.cloud.dialogflow.v2.ImportAgentRequest;
import com.google.cloud.dialogflow.v2.RestoreAgentRequest;
import com.google.cloud.dialogflow.v2.SearchAgentsRequest;
import com.google.cloud.dialogflow.v2.SearchAgentsResponse;
import com.google.cloud.dialogflow.v2.SetAgentRequest;
import com.google.cloud.dialogflow.v2.TrainAgentRequest;
import com.google.cloud.dialogflow.v2.ValidationResult;
import com.google.cloud.dialogflow.v2.stub.AgentsStub;
import com.google.cloud.dialogflow.v2.stub.AgentsStubSettings;
import com.google.cloud.dialogflow.v2.stub.GrpcAgentsCallableFactory;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import com.google.protobuf.Struct;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcAgentsStub
extends AgentsStub {
    private static final MethodDescriptor<GetAgentRequest, Agent> getAgentMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.v2.Agents/GetAgent").setRequestMarshaller(ProtoUtils.marshaller((Message)GetAgentRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Agent.getDefaultInstance())).build();
    private static final MethodDescriptor<SetAgentRequest, Agent> setAgentMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.v2.Agents/SetAgent").setRequestMarshaller(ProtoUtils.marshaller((Message)SetAgentRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Agent.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteAgentRequest, Empty> deleteAgentMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.v2.Agents/DeleteAgent").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteAgentRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).build();
    private static final MethodDescriptor<SearchAgentsRequest, SearchAgentsResponse> searchAgentsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.v2.Agents/SearchAgents").setRequestMarshaller(ProtoUtils.marshaller((Message)SearchAgentsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)SearchAgentsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<TrainAgentRequest, Operation> trainAgentMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.v2.Agents/TrainAgent").setRequestMarshaller(ProtoUtils.marshaller((Message)TrainAgentRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<ExportAgentRequest, Operation> exportAgentMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.v2.Agents/ExportAgent").setRequestMarshaller(ProtoUtils.marshaller((Message)ExportAgentRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<ImportAgentRequest, Operation> importAgentMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.v2.Agents/ImportAgent").setRequestMarshaller(ProtoUtils.marshaller((Message)ImportAgentRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<RestoreAgentRequest, Operation> restoreAgentMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.v2.Agents/RestoreAgent").setRequestMarshaller(ProtoUtils.marshaller((Message)RestoreAgentRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<GetValidationResultRequest, ValidationResult> getValidationResultMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.v2.Agents/GetValidationResult").setRequestMarshaller(ProtoUtils.marshaller((Message)GetValidationResultRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ValidationResult.getDefaultInstance())).build();
    private static final MethodDescriptor<ListLocationsRequest, ListLocationsResponse> listLocationsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/ListLocations").setRequestMarshaller(ProtoUtils.marshaller((Message)ListLocationsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListLocationsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetLocationRequest, Location> getLocationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/GetLocation").setRequestMarshaller(ProtoUtils.marshaller((Message)GetLocationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Location.getDefaultInstance())).build();
    private final UnaryCallable<GetAgentRequest, Agent> getAgentCallable;
    private final UnaryCallable<SetAgentRequest, Agent> setAgentCallable;
    private final UnaryCallable<DeleteAgentRequest, Empty> deleteAgentCallable;
    private final UnaryCallable<SearchAgentsRequest, SearchAgentsResponse> searchAgentsCallable;
    private final UnaryCallable<SearchAgentsRequest, AgentsClient.SearchAgentsPagedResponse> searchAgentsPagedCallable;
    private final UnaryCallable<TrainAgentRequest, Operation> trainAgentCallable;
    private final OperationCallable<TrainAgentRequest, Empty, Struct> trainAgentOperationCallable;
    private final UnaryCallable<ExportAgentRequest, Operation> exportAgentCallable;
    private final OperationCallable<ExportAgentRequest, ExportAgentResponse, Struct> exportAgentOperationCallable;
    private final UnaryCallable<ImportAgentRequest, Operation> importAgentCallable;
    private final OperationCallable<ImportAgentRequest, Empty, Struct> importAgentOperationCallable;
    private final UnaryCallable<RestoreAgentRequest, Operation> restoreAgentCallable;
    private final OperationCallable<RestoreAgentRequest, Empty, Struct> restoreAgentOperationCallable;
    private final UnaryCallable<GetValidationResultRequest, ValidationResult> getValidationResultCallable;
    private final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable;
    private final UnaryCallable<ListLocationsRequest, AgentsClient.ListLocationsPagedResponse> listLocationsPagedCallable;
    private final UnaryCallable<GetLocationRequest, Location> getLocationCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcAgentsStub create(AgentsStubSettings settings) throws IOException {
        return new GrpcAgentsStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcAgentsStub create(ClientContext clientContext) throws IOException {
        return new GrpcAgentsStub(AgentsStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcAgentsStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcAgentsStub(AgentsStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcAgentsStub(AgentsStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcAgentsCallableFactory());
    }

    protected GrpcAgentsStub(AgentsStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings getAgentTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getAgentMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings setAgentTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(setAgentMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("agent.parent", String.valueOf(request.getAgent().getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings deleteAgentTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteAgentMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings searchAgentsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(searchAgentsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings trainAgentTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(trainAgentMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings exportAgentTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(exportAgentMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings importAgentTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(importAgentMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings restoreAgentTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(restoreAgentMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings getValidationResultTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getValidationResultMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings listLocationsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listLocationsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings getLocationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getLocationMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        this.getAgentCallable = callableFactory.createUnaryCallable(getAgentTransportSettings, settings.getAgentSettings(), clientContext);
        this.setAgentCallable = callableFactory.createUnaryCallable(setAgentTransportSettings, settings.setAgentSettings(), clientContext);
        this.deleteAgentCallable = callableFactory.createUnaryCallable(deleteAgentTransportSettings, settings.deleteAgentSettings(), clientContext);
        this.searchAgentsCallable = callableFactory.createUnaryCallable(searchAgentsTransportSettings, settings.searchAgentsSettings(), clientContext);
        this.searchAgentsPagedCallable = callableFactory.createPagedCallable(searchAgentsTransportSettings, settings.searchAgentsSettings(), clientContext);
        this.trainAgentCallable = callableFactory.createUnaryCallable(trainAgentTransportSettings, settings.trainAgentSettings(), clientContext);
        this.trainAgentOperationCallable = callableFactory.createOperationCallable(trainAgentTransportSettings, settings.trainAgentOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.exportAgentCallable = callableFactory.createUnaryCallable(exportAgentTransportSettings, settings.exportAgentSettings(), clientContext);
        this.exportAgentOperationCallable = callableFactory.createOperationCallable(exportAgentTransportSettings, settings.exportAgentOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.importAgentCallable = callableFactory.createUnaryCallable(importAgentTransportSettings, settings.importAgentSettings(), clientContext);
        this.importAgentOperationCallable = callableFactory.createOperationCallable(importAgentTransportSettings, settings.importAgentOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.restoreAgentCallable = callableFactory.createUnaryCallable(restoreAgentTransportSettings, settings.restoreAgentSettings(), clientContext);
        this.restoreAgentOperationCallable = callableFactory.createOperationCallable(restoreAgentTransportSettings, settings.restoreAgentOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.getValidationResultCallable = callableFactory.createUnaryCallable(getValidationResultTransportSettings, settings.getValidationResultSettings(), clientContext);
        this.listLocationsCallable = callableFactory.createUnaryCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.listLocationsPagedCallable = callableFactory.createPagedCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.getLocationCallable = callableFactory.createUnaryCallable(getLocationTransportSettings, settings.getLocationSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<GetAgentRequest, Agent> getAgentCallable() {
        return this.getAgentCallable;
    }

    @Override
    public UnaryCallable<SetAgentRequest, Agent> setAgentCallable() {
        return this.setAgentCallable;
    }

    @Override
    public UnaryCallable<DeleteAgentRequest, Empty> deleteAgentCallable() {
        return this.deleteAgentCallable;
    }

    @Override
    public UnaryCallable<SearchAgentsRequest, SearchAgentsResponse> searchAgentsCallable() {
        return this.searchAgentsCallable;
    }

    @Override
    public UnaryCallable<SearchAgentsRequest, AgentsClient.SearchAgentsPagedResponse> searchAgentsPagedCallable() {
        return this.searchAgentsPagedCallable;
    }

    @Override
    public UnaryCallable<TrainAgentRequest, Operation> trainAgentCallable() {
        return this.trainAgentCallable;
    }

    @Override
    public OperationCallable<TrainAgentRequest, Empty, Struct> trainAgentOperationCallable() {
        return this.trainAgentOperationCallable;
    }

    @Override
    public UnaryCallable<ExportAgentRequest, Operation> exportAgentCallable() {
        return this.exportAgentCallable;
    }

    @Override
    public OperationCallable<ExportAgentRequest, ExportAgentResponse, Struct> exportAgentOperationCallable() {
        return this.exportAgentOperationCallable;
    }

    @Override
    public UnaryCallable<ImportAgentRequest, Operation> importAgentCallable() {
        return this.importAgentCallable;
    }

    @Override
    public OperationCallable<ImportAgentRequest, Empty, Struct> importAgentOperationCallable() {
        return this.importAgentOperationCallable;
    }

    @Override
    public UnaryCallable<RestoreAgentRequest, Operation> restoreAgentCallable() {
        return this.restoreAgentCallable;
    }

    @Override
    public OperationCallable<RestoreAgentRequest, Empty, Struct> restoreAgentOperationCallable() {
        return this.restoreAgentOperationCallable;
    }

    @Override
    public UnaryCallable<GetValidationResultRequest, ValidationResult> getValidationResultCallable() {
        return this.getValidationResultCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.listLocationsCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, AgentsClient.ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.listLocationsPagedCallable;
    }

    @Override
    public UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.getLocationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

