/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.discoveryengine.v1alpha.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.discoveryengine.v1alpha.CreateDataStoreMetadata;
import com.google.cloud.discoveryengine.v1alpha.CreateDataStoreRequest;
import com.google.cloud.discoveryengine.v1alpha.DataStore;
import com.google.cloud.discoveryengine.v1alpha.DataStoreServiceClient;
import com.google.cloud.discoveryengine.v1alpha.DeleteDataStoreMetadata;
import com.google.cloud.discoveryengine.v1alpha.DeleteDataStoreRequest;
import com.google.cloud.discoveryengine.v1alpha.GetDataStoreRequest;
import com.google.cloud.discoveryengine.v1alpha.ListDataStoresRequest;
import com.google.cloud.discoveryengine.v1alpha.ListDataStoresResponse;
import com.google.cloud.discoveryengine.v1alpha.UpdateDataStoreRequest;
import com.google.cloud.discoveryengine.v1alpha.stub.DataStoreServiceStub;
import com.google.cloud.discoveryengine.v1alpha.stub.GrpcDataStoreServiceStub;
import com.google.cloud.discoveryengine.v1alpha.stub.HttpJsonDataStoreServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class DataStoreServiceStubSettings
extends StubSettings<DataStoreServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<CreateDataStoreRequest, Operation> createDataStoreSettings;
    private final OperationCallSettings<CreateDataStoreRequest, DataStore, CreateDataStoreMetadata> createDataStoreOperationSettings;
    private final UnaryCallSettings<GetDataStoreRequest, DataStore> getDataStoreSettings;
    private final PagedCallSettings<ListDataStoresRequest, ListDataStoresResponse, DataStoreServiceClient.ListDataStoresPagedResponse> listDataStoresSettings;
    private final UnaryCallSettings<DeleteDataStoreRequest, Operation> deleteDataStoreSettings;
    private final OperationCallSettings<DeleteDataStoreRequest, Empty, DeleteDataStoreMetadata> deleteDataStoreOperationSettings;
    private final UnaryCallSettings<UpdateDataStoreRequest, DataStore> updateDataStoreSettings;
    private static final PagedListDescriptor<ListDataStoresRequest, ListDataStoresResponse, DataStore> LIST_DATA_STORES_PAGE_STR_DESC = new PagedListDescriptor<ListDataStoresRequest, ListDataStoresResponse, DataStore>(){

        public String emptyToken() {
            return "";
        }

        public ListDataStoresRequest injectToken(ListDataStoresRequest payload, String token) {
            return ListDataStoresRequest.newBuilder((ListDataStoresRequest)payload).setPageToken(token).build();
        }

        public ListDataStoresRequest injectPageSize(ListDataStoresRequest payload, int pageSize) {
            return ListDataStoresRequest.newBuilder((ListDataStoresRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListDataStoresRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListDataStoresResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<DataStore> extractResources(ListDataStoresResponse payload) {
            return payload.getDataStoresList() == null ? ImmutableList.of() : payload.getDataStoresList();
        }
    };
    private static final PagedListResponseFactory<ListDataStoresRequest, ListDataStoresResponse, DataStoreServiceClient.ListDataStoresPagedResponse> LIST_DATA_STORES_PAGE_STR_FACT = new PagedListResponseFactory<ListDataStoresRequest, ListDataStoresResponse, DataStoreServiceClient.ListDataStoresPagedResponse>(){

        public ApiFuture<DataStoreServiceClient.ListDataStoresPagedResponse> getFuturePagedResponse(UnaryCallable<ListDataStoresRequest, ListDataStoresResponse> callable, ListDataStoresRequest request, ApiCallContext context, ApiFuture<ListDataStoresResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_DATA_STORES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DataStoreServiceClient.ListDataStoresPagedResponse.createAsync((PageContext<ListDataStoresRequest, ListDataStoresResponse, DataStore>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreateDataStoreRequest, Operation> createDataStoreSettings() {
        return this.createDataStoreSettings;
    }

    public OperationCallSettings<CreateDataStoreRequest, DataStore, CreateDataStoreMetadata> createDataStoreOperationSettings() {
        return this.createDataStoreOperationSettings;
    }

    public UnaryCallSettings<GetDataStoreRequest, DataStore> getDataStoreSettings() {
        return this.getDataStoreSettings;
    }

    public PagedCallSettings<ListDataStoresRequest, ListDataStoresResponse, DataStoreServiceClient.ListDataStoresPagedResponse> listDataStoresSettings() {
        return this.listDataStoresSettings;
    }

    public UnaryCallSettings<DeleteDataStoreRequest, Operation> deleteDataStoreSettings() {
        return this.deleteDataStoreSettings;
    }

    public OperationCallSettings<DeleteDataStoreRequest, Empty, DeleteDataStoreMetadata> deleteDataStoreOperationSettings() {
        return this.deleteDataStoreOperationSettings;
    }

    public UnaryCallSettings<UpdateDataStoreRequest, DataStore> updateDataStoreSettings() {
        return this.updateDataStoreSettings;
    }

    public DataStoreServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcDataStoreServiceStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonDataStoreServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "discoveryengine.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "discoveryengine.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return DataStoreServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(DataStoreServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(DataStoreServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return DataStoreServiceStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected DataStoreServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createDataStoreSettings = settingsBuilder.createDataStoreSettings().build();
        this.createDataStoreOperationSettings = settingsBuilder.createDataStoreOperationSettings().build();
        this.getDataStoreSettings = settingsBuilder.getDataStoreSettings().build();
        this.listDataStoresSettings = settingsBuilder.listDataStoresSettings().build();
        this.deleteDataStoreSettings = settingsBuilder.deleteDataStoreSettings().build();
        this.deleteDataStoreOperationSettings = settingsBuilder.deleteDataStoreOperationSettings().build();
        this.updateDataStoreSettings = settingsBuilder.updateDataStoreSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<DataStoreServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateDataStoreRequest, Operation> createDataStoreSettings;
        private final OperationCallSettings.Builder<CreateDataStoreRequest, DataStore, CreateDataStoreMetadata> createDataStoreOperationSettings;
        private final UnaryCallSettings.Builder<GetDataStoreRequest, DataStore> getDataStoreSettings;
        private final PagedCallSettings.Builder<ListDataStoresRequest, ListDataStoresResponse, DataStoreServiceClient.ListDataStoresPagedResponse> listDataStoresSettings;
        private final UnaryCallSettings.Builder<DeleteDataStoreRequest, Operation> deleteDataStoreSettings;
        private final OperationCallSettings.Builder<DeleteDataStoreRequest, Empty, DeleteDataStoreMetadata> deleteDataStoreOperationSettings;
        private final UnaryCallSettings.Builder<UpdateDataStoreRequest, DataStore> updateDataStoreSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createDataStoreSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createDataStoreOperationSettings = OperationCallSettings.newBuilder();
            this.getDataStoreSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listDataStoresSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_DATA_STORES_PAGE_STR_FACT);
            this.deleteDataStoreSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteDataStoreOperationSettings = OperationCallSettings.newBuilder();
            this.updateDataStoreSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createDataStoreSettings, this.getDataStoreSettings, this.listDataStoresSettings, this.deleteDataStoreSettings, this.updateDataStoreSettings);
            Builder.initDefaults(this);
        }

        protected Builder(DataStoreServiceStubSettings settings) {
            super((StubSettings)settings);
            this.createDataStoreSettings = settings.createDataStoreSettings.toBuilder();
            this.createDataStoreOperationSettings = settings.createDataStoreOperationSettings.toBuilder();
            this.getDataStoreSettings = settings.getDataStoreSettings.toBuilder();
            this.listDataStoresSettings = settings.listDataStoresSettings.toBuilder();
            this.deleteDataStoreSettings = settings.deleteDataStoreSettings.toBuilder();
            this.deleteDataStoreOperationSettings = settings.deleteDataStoreOperationSettings.toBuilder();
            this.updateDataStoreSettings = settings.updateDataStoreSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createDataStoreSettings, this.getDataStoreSettings, this.listDataStoresSettings, this.deleteDataStoreSettings, this.updateDataStoreSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(DataStoreServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)DataStoreServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)DataStoreServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(DataStoreServiceStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(DataStoreServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)DataStoreServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)DataStoreServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)DataStoreServiceStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(DataStoreServiceStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(DataStoreServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createDataStoreSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getDataStoreSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listDataStoresSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.deleteDataStoreSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.updateDataStoreSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createDataStoreOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(DataStore.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(CreateDataStoreMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteDataStoreOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(DeleteDataStoreMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateDataStoreRequest, Operation> createDataStoreSettings() {
            return this.createDataStoreSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<CreateDataStoreRequest, DataStore, CreateDataStoreMetadata> createDataStoreOperationSettings() {
            return this.createDataStoreOperationSettings;
        }

        public UnaryCallSettings.Builder<GetDataStoreRequest, DataStore> getDataStoreSettings() {
            return this.getDataStoreSettings;
        }

        public PagedCallSettings.Builder<ListDataStoresRequest, ListDataStoresResponse, DataStoreServiceClient.ListDataStoresPagedResponse> listDataStoresSettings() {
            return this.listDataStoresSettings;
        }

        public UnaryCallSettings.Builder<DeleteDataStoreRequest, Operation> deleteDataStoreSettings() {
            return this.deleteDataStoreSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<DeleteDataStoreRequest, Empty, DeleteDataStoreMetadata> deleteDataStoreOperationSettings() {
            return this.deleteDataStoreOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateDataStoreRequest, DataStore> updateDataStoreSettings() {
            return this.updateDataStoreSettings;
        }

        public DataStoreServiceStubSettings build() throws IOException {
            return new DataStoreServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

