/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.discoveryengine.v1alpha.stub;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.discoveryengine.v1alpha.CreateSampleQueryRequest;
import com.google.cloud.discoveryengine.v1alpha.DeleteSampleQueryRequest;
import com.google.cloud.discoveryengine.v1alpha.GetSampleQueryRequest;
import com.google.cloud.discoveryengine.v1alpha.ImportSampleQueriesMetadata;
import com.google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest;
import com.google.cloud.discoveryengine.v1alpha.ImportSampleQueriesResponse;
import com.google.cloud.discoveryengine.v1alpha.ListSampleQueriesRequest;
import com.google.cloud.discoveryengine.v1alpha.ListSampleQueriesResponse;
import com.google.cloud.discoveryengine.v1alpha.SampleQuery;
import com.google.cloud.discoveryengine.v1alpha.SampleQueryServiceClient;
import com.google.cloud.discoveryengine.v1alpha.UpdateSampleQueryRequest;
import com.google.cloud.discoveryengine.v1alpha.stub.GrpcSampleQueryServiceCallableFactory;
import com.google.cloud.discoveryengine.v1alpha.stub.SampleQueryServiceStub;
import com.google.cloud.discoveryengine.v1alpha.stub.SampleQueryServiceStubSettings;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class GrpcSampleQueryServiceStub
extends SampleQueryServiceStub {
    private static final MethodDescriptor<GetSampleQueryRequest, SampleQuery> getSampleQueryMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.discoveryengine.v1alpha.SampleQueryService/GetSampleQuery").setRequestMarshaller(ProtoUtils.marshaller((Message)GetSampleQueryRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)SampleQuery.getDefaultInstance())).build();
    private static final MethodDescriptor<ListSampleQueriesRequest, ListSampleQueriesResponse> listSampleQueriesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.discoveryengine.v1alpha.SampleQueryService/ListSampleQueries").setRequestMarshaller(ProtoUtils.marshaller((Message)ListSampleQueriesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListSampleQueriesResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<CreateSampleQueryRequest, SampleQuery> createSampleQueryMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.discoveryengine.v1alpha.SampleQueryService/CreateSampleQuery").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateSampleQueryRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)SampleQuery.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateSampleQueryRequest, SampleQuery> updateSampleQueryMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.discoveryengine.v1alpha.SampleQueryService/UpdateSampleQuery").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateSampleQueryRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)SampleQuery.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteSampleQueryRequest, Empty> deleteSampleQueryMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.discoveryengine.v1alpha.SampleQueryService/DeleteSampleQuery").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteSampleQueryRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).build();
    private static final MethodDescriptor<ImportSampleQueriesRequest, Operation> importSampleQueriesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.discoveryengine.v1alpha.SampleQueryService/ImportSampleQueries").setRequestMarshaller(ProtoUtils.marshaller((Message)ImportSampleQueriesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private final UnaryCallable<GetSampleQueryRequest, SampleQuery> getSampleQueryCallable;
    private final UnaryCallable<ListSampleQueriesRequest, ListSampleQueriesResponse> listSampleQueriesCallable;
    private final UnaryCallable<ListSampleQueriesRequest, SampleQueryServiceClient.ListSampleQueriesPagedResponse> listSampleQueriesPagedCallable;
    private final UnaryCallable<CreateSampleQueryRequest, SampleQuery> createSampleQueryCallable;
    private final UnaryCallable<UpdateSampleQueryRequest, SampleQuery> updateSampleQueryCallable;
    private final UnaryCallable<DeleteSampleQueryRequest, Empty> deleteSampleQueryCallable;
    private final UnaryCallable<ImportSampleQueriesRequest, Operation> importSampleQueriesCallable;
    private final OperationCallable<ImportSampleQueriesRequest, ImportSampleQueriesResponse, ImportSampleQueriesMetadata> importSampleQueriesOperationCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcSampleQueryServiceStub create(SampleQueryServiceStubSettings settings) throws IOException {
        return new GrpcSampleQueryServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcSampleQueryServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcSampleQueryServiceStub(SampleQueryServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcSampleQueryServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcSampleQueryServiceStub(SampleQueryServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcSampleQueryServiceStub(SampleQueryServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcSampleQueryServiceCallableFactory());
    }

    protected GrpcSampleQueryServiceStub(SampleQueryServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings getSampleQueryTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getSampleQueryMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings listSampleQueriesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listSampleQueriesMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings createSampleQueryTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createSampleQueryMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings updateSampleQueryTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateSampleQueryMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("sample_query.name", String.valueOf(request.getSampleQuery().getName()));
            return builder.build();
        }).build();
        GrpcCallSettings deleteSampleQueryTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteSampleQueryMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings importSampleQueriesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(importSampleQueriesMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        this.getSampleQueryCallable = callableFactory.createUnaryCallable(getSampleQueryTransportSettings, settings.getSampleQuerySettings(), clientContext);
        this.listSampleQueriesCallable = callableFactory.createUnaryCallable(listSampleQueriesTransportSettings, settings.listSampleQueriesSettings(), clientContext);
        this.listSampleQueriesPagedCallable = callableFactory.createPagedCallable(listSampleQueriesTransportSettings, settings.listSampleQueriesSettings(), clientContext);
        this.createSampleQueryCallable = callableFactory.createUnaryCallable(createSampleQueryTransportSettings, settings.createSampleQuerySettings(), clientContext);
        this.updateSampleQueryCallable = callableFactory.createUnaryCallable(updateSampleQueryTransportSettings, settings.updateSampleQuerySettings(), clientContext);
        this.deleteSampleQueryCallable = callableFactory.createUnaryCallable(deleteSampleQueryTransportSettings, settings.deleteSampleQuerySettings(), clientContext);
        this.importSampleQueriesCallable = callableFactory.createUnaryCallable(importSampleQueriesTransportSettings, settings.importSampleQueriesSettings(), clientContext);
        this.importSampleQueriesOperationCallable = callableFactory.createOperationCallable(importSampleQueriesTransportSettings, settings.importSampleQueriesOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<GetSampleQueryRequest, SampleQuery> getSampleQueryCallable() {
        return this.getSampleQueryCallable;
    }

    @Override
    public UnaryCallable<ListSampleQueriesRequest, ListSampleQueriesResponse> listSampleQueriesCallable() {
        return this.listSampleQueriesCallable;
    }

    @Override
    public UnaryCallable<ListSampleQueriesRequest, SampleQueryServiceClient.ListSampleQueriesPagedResponse> listSampleQueriesPagedCallable() {
        return this.listSampleQueriesPagedCallable;
    }

    @Override
    public UnaryCallable<CreateSampleQueryRequest, SampleQuery> createSampleQueryCallable() {
        return this.createSampleQueryCallable;
    }

    @Override
    public UnaryCallable<UpdateSampleQueryRequest, SampleQuery> updateSampleQueryCallable() {
        return this.updateSampleQueryCallable;
    }

    @Override
    public UnaryCallable<DeleteSampleQueryRequest, Empty> deleteSampleQueryCallable() {
        return this.deleteSampleQueryCallable;
    }

    @Override
    public UnaryCallable<ImportSampleQueriesRequest, Operation> importSampleQueriesCallable() {
        return this.importSampleQueriesCallable;
    }

    @Override
    public OperationCallable<ImportSampleQueriesRequest, ImportSampleQueriesResponse, ImportSampleQueriesMetadata> importSampleQueriesOperationCallable() {
        return this.importSampleQueriesOperationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

