/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dns;

import com.google.api.client.util.Data;
import com.google.api.services.dns.model.DnsKeySpec;
import com.google.api.services.dns.model.ManagedZone;
import com.google.api.services.dns.model.ManagedZoneDnsSecConfig;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.threeten.bp.Instant;
import org.threeten.bp.ZoneId;
import org.threeten.bp.ZoneOffset;
import org.threeten.bp.format.DateTimeFormatter;
import org.threeten.bp.temporal.TemporalAccessor;

public class ZoneInfo
implements Serializable {
    private static final long serialVersionUID = -5313169712036079818L;
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ISO_DATE_TIME.withZone((ZoneId)ZoneOffset.UTC);
    private final String name;
    private final String generatedId;
    private final Long creationTimeMillis;
    private final String dnsName;
    private final String description;
    private final String nameServerSet;
    private final List<String> nameServers;
    private final DnsSecConfig dnsSecConfig;
    private final Map<String, String> labels;

    ZoneInfo(BuilderImpl builder) {
        this.name = builder.name;
        this.generatedId = builder.generatedId;
        this.creationTimeMillis = builder.creationTimeMillis;
        this.dnsName = builder.dnsName;
        this.description = builder.description;
        this.nameServerSet = builder.nameServerSet;
        this.nameServers = builder.nameServers == null ? null : ImmutableList.copyOf((Collection)builder.nameServers);
        this.dnsSecConfig = builder.dnsSecConfig;
        this.labels = builder.labels;
    }

    public static ZoneInfo of(String name, String dnsName, String description) {
        return new BuilderImpl(name).setDnsName(dnsName).setDescription(description).build();
    }

    public static Builder newBuilder(String name) {
        return new BuilderImpl(name);
    }

    public String getName() {
        return this.name;
    }

    public String getGeneratedId() {
        return this.generatedId;
    }

    public Long getCreationTimeMillis() {
        return this.creationTimeMillis;
    }

    public String getDnsName() {
        return this.dnsName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getNameServerSet() {
        return this.nameServerSet;
    }

    public Map<String, String> getLabels() {
        return this.labels;
    }

    public List<String> getNameServers() {
        return this.nameServers == null ? ImmutableList.of() : this.nameServers;
    }

    public DnsSecConfig getDnsSecConfig() {
        return this.dnsSecConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    ManagedZone toPb() {
        ManagedZone pb = new ManagedZone();
        pb.setDescription(this.getDescription());
        pb.setDnsName(this.getDnsName());
        if (this.getGeneratedId() != null) {
            pb.setId(new BigInteger(this.getGeneratedId()));
        }
        pb.setName(this.getName());
        pb.setNameServers(this.nameServers);
        pb.setNameServerSet(this.getNameServerSet());
        if (this.getCreationTimeMillis() != null) {
            pb.setCreationTime(DATE_TIME_FORMATTER.format((TemporalAccessor)Instant.ofEpochMilli((long)this.getCreationTimeMillis())));
        }
        if (this.dnsSecConfig != null) {
            pb.setDnssecConfig(this.dnsSecConfig.toPb());
        }
        if (this.getLabels() != null) {
            pb.setLabels(this.labels);
        }
        return pb;
    }

    static ZoneInfo fromPb(ManagedZone pb) {
        BuilderImpl builder = new BuilderImpl(pb.getName());
        if (pb.getDescription() != null) {
            ((Builder)builder).setDescription(pb.getDescription());
        }
        if (pb.getDnsName() != null) {
            ((Builder)builder).setDnsName(pb.getDnsName());
        }
        if (pb.getId() != null) {
            ((Builder)builder).setGeneratedId(pb.getId().toString());
        }
        if (pb.getNameServers() != null) {
            ((Builder)builder).setNameServers(pb.getNameServers());
        }
        if (pb.getNameServerSet() != null) {
            ((Builder)builder).setNameServerSet(pb.getNameServerSet());
        }
        if (pb.getCreationTime() != null) {
            ((Builder)builder).setCreationTimeMillis(((Instant)DATE_TIME_FORMATTER.parse((CharSequence)pb.getCreationTime(), Instant.FROM)).toEpochMilli());
        }
        if (pb.getDnssecConfig() != null) {
            ((Builder)builder).setDnsSecConfig(DnsSecConfig.fromPb(pb.getDnssecConfig()));
        }
        if (pb.getLabels() != null) {
            ((Builder)builder).setLabels(pb.getLabels());
        }
        return ((Builder)builder).build();
    }

    public boolean equals(Object obj) {
        return obj == this || obj != null && obj.getClass().equals(ZoneInfo.class) && Objects.equals(this.toPb(), ((ZoneInfo)obj).toPb());
    }

    public int hashCode() {
        return Objects.hash(this.name, this.generatedId, this.creationTimeMillis, this.dnsName, this.description, this.nameServerSet, this.nameServers, this.dnsSecConfig, this.labels);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.getName()).add("generatedId", (Object)this.getGeneratedId()).add("description", (Object)this.getDescription()).add("dnsName", (Object)this.getDnsName()).add("nameServerSet", (Object)this.getNameServerSet()).add("nameServers", this.getNameServers()).add("creationTimeMillis", (Object)this.getCreationTimeMillis()).add("dnsSecConfig", (Object)this.getDnsSecConfig()).add("labels", this.getLabels()).toString();
    }

    static class BuilderImpl
    extends Builder {
        private String name;
        private String generatedId;
        private Long creationTimeMillis;
        private String dnsName;
        private String description;
        private String nameServerSet;
        private List<String> nameServers;
        private DnsSecConfig dnsSecConfig;
        private Map<String, String> labels;

        private BuilderImpl(String name) {
            this.name = (String)Preconditions.checkNotNull((Object)name);
        }

        BuilderImpl(ZoneInfo info) {
            this.name = info.name;
            this.generatedId = info.generatedId;
            this.creationTimeMillis = info.creationTimeMillis;
            this.dnsName = info.dnsName;
            this.description = info.description;
            this.nameServerSet = info.nameServerSet;
            if (info.nameServers != null) {
                this.nameServers = ImmutableList.copyOf((Collection)info.nameServers);
            }
            this.dnsSecConfig = info.dnsSecConfig;
            this.labels = info.labels;
        }

        @Override
        public Builder setName(String name) {
            this.name = (String)Preconditions.checkNotNull((Object)name);
            return this;
        }

        @Override
        Builder setGeneratedId(String generatedId) {
            this.generatedId = generatedId;
            return this;
        }

        @Override
        Builder setCreationTimeMillis(long creationTimeMillis) {
            this.creationTimeMillis = creationTimeMillis;
            return this;
        }

        @Override
        public Builder setDnsName(String dnsName) {
            this.dnsName = (String)Preconditions.checkNotNull((Object)dnsName);
            return this;
        }

        @Override
        public Builder setDescription(String description) {
            this.description = (String)Preconditions.checkNotNull((Object)description);
            return this;
        }

        @Override
        Builder setNameServerSet(String nameServerSet) {
            this.nameServerSet = (String)Preconditions.checkNotNull((Object)nameServerSet);
            return this;
        }

        @Override
        Builder setNameServers(List<String> nameServers) {
            Preconditions.checkNotNull(nameServers);
            this.nameServers = Lists.newLinkedList(nameServers);
            return this;
        }

        @Override
        public Builder setDnsSecConfig(DnsSecConfig dnsSecConfig) {
            this.dnsSecConfig = (DnsSecConfig)Preconditions.checkNotNull((Object)dnsSecConfig);
            return this;
        }

        @Override
        public Builder setLabels(Map<String, String> labels) {
            if (labels != null) {
                this.labels = Maps.transformValues(labels, (Function)new Function<String, String>(){

                    public String apply(String input) {
                        return input == null ? (String)Data.nullOf(String.class) : input;
                    }
                });
            }
            return this;
        }

        @Override
        public ZoneInfo build() {
            return new ZoneInfo(this);
        }
    }

    public static abstract class Builder {
        public abstract Builder setName(String var1);

        abstract Builder setGeneratedId(String var1);

        abstract Builder setCreationTimeMillis(long var1);

        public abstract Builder setDnsName(String var1);

        public abstract Builder setDescription(String var1);

        abstract Builder setNameServerSet(String var1);

        abstract Builder setNameServers(List<String> var1);

        public Builder setDnsSecConfig(DnsSecConfig dnsSecConfig) {
            return this;
        }

        public Builder setLabels(Map<String, String> labels) {
            return this;
        }

        public abstract ZoneInfo build();
    }

    public static class DnsSecConfig {
        private static final Set<String> VALID_STATE_VALUES = ImmutableSet.of((Object)"on", (Object)"off", (Object)"transfer");
        private static final Set<String> VALID_NONEXISTANCE_VALUES = ImmutableSet.of((Object)"nsec", (Object)"nsec3");
        private List<KeySpec> defaultKeySpecs;
        private String nonExistence;
        private String state;

        public Builder toBuilder() {
            return new Builder(this);
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        private DnsSecConfig(Builder builder) {
            this.defaultKeySpecs = builder.defaultKeySpecs;
            this.nonExistence = builder.nonExistence;
            this.state = builder.state;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DnsSecConfig that = (DnsSecConfig)o;
            return Objects.equals(this.defaultKeySpecs, that.defaultKeySpecs) && Objects.equals(this.nonExistence, that.nonExistence) && Objects.equals(this.state, that.state);
        }

        public int hashCode() {
            return Objects.hash(this.defaultKeySpecs, this.nonExistence, this.state);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("defaultKeySpecs", this.getDefaultKeySpecs()).add("nonExistence", (Object)this.getNonExistence()).add("state", (Object)this.getState()).toString();
        }

        ManagedZoneDnsSecConfig toPb() {
            ManagedZoneDnsSecConfig dnsSecConfigPb = new ManagedZoneDnsSecConfig();
            if (this.defaultKeySpecs != null) {
                dnsSecConfigPb.setDefaultKeySpecs(Lists.transform(this.defaultKeySpecs, (Function)new Function<KeySpec, DnsKeySpec>(){

                    public DnsKeySpec apply(KeySpec keySpec) {
                        return keySpec.toPb();
                    }
                }));
            }
            dnsSecConfigPb.setNonExistence(this.nonExistence);
            dnsSecConfigPb.setState(this.state);
            return dnsSecConfigPb;
        }

        static DnsSecConfig fromPb(ManagedZoneDnsSecConfig managedZoneDnsSecConfig) {
            Builder builder = DnsSecConfig.newBuilder();
            if (managedZoneDnsSecConfig.getDefaultKeySpecs() != null) {
                builder.setDefaultKeySpecs(Lists.transform((List)managedZoneDnsSecConfig.getDefaultKeySpecs(), (Function)new Function<DnsKeySpec, KeySpec>(){

                    public KeySpec apply(DnsKeySpec dnsKeySpec) {
                        return KeySpec.fromPb(dnsKeySpec);
                    }
                }));
            }
            builder.setNonExistence(managedZoneDnsSecConfig.getNonExistence());
            builder.setState(managedZoneDnsSecConfig.getState());
            return builder.build();
        }

        public List<KeySpec> getDefaultKeySpecs() {
            return this.defaultKeySpecs;
        }

        public String getNonExistence() {
            return this.nonExistence;
        }

        public String getState() {
            return this.state;
        }

        private static void validateValue(String value, Set<String> validValues) {
            if (!validValues.contains(value)) {
                throw new IllegalArgumentException("Invalid value, Use one of the value from acceptable values " + validValues);
            }
        }

        public static class Builder {
            private List<KeySpec> defaultKeySpecs;
            private String nonExistence;
            private String state;

            private Builder() {
            }

            private Builder(DnsSecConfig dnsSecConfig) {
                this.defaultKeySpecs = dnsSecConfig.defaultKeySpecs;
                this.nonExistence = dnsSecConfig.nonExistence;
                this.state = dnsSecConfig.state;
            }

            public Builder setDefaultKeySpecs(List<KeySpec> defaultKeySpecs) {
                this.defaultKeySpecs = defaultKeySpecs;
                return this;
            }

            public Builder setNonExistence(String nonExistence) {
                DnsSecConfig.validateValue(nonExistence, VALID_NONEXISTANCE_VALUES);
                this.nonExistence = nonExistence;
                return this;
            }

            public Builder setState(String state) {
                DnsSecConfig.validateValue(state, VALID_STATE_VALUES);
                this.state = state;
                return this;
            }

            public DnsSecConfig build() {
                return new DnsSecConfig(this);
            }
        }
    }

    public static class KeySpec {
        private String algorithm;
        private Long keyLength;
        private String keyType;

        public static Builder newBuilder() {
            return new Builder();
        }

        private KeySpec(Builder builder) {
            this.algorithm = builder.algorithm;
            this.keyLength = builder.keyLength;
            this.keyType = builder.keyType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            KeySpec keySpec = (KeySpec)o;
            return Objects.equals(this.algorithm, keySpec.algorithm) && Objects.equals(this.keyLength, keySpec.keyLength) && Objects.equals(this.keyType, keySpec.keyType);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("algorithm", (Object)this.getAlgorithm()).add("keyLength", (Object)this.getKeyLength()).add("keyType", (Object)this.getKeyType()).toString();
        }

        public int hashCode() {
            return Objects.hash(this.algorithm, this.keyLength, this.keyType);
        }

        DnsKeySpec toPb() {
            DnsKeySpec dnsKeySpecPb = new DnsKeySpec();
            dnsKeySpecPb.setAlgorithm(this.algorithm);
            dnsKeySpecPb.setKeyLength(this.keyLength);
            dnsKeySpecPb.setKeyType(this.keyType);
            return dnsKeySpecPb;
        }

        static KeySpec fromPb(DnsKeySpec dnsKeySpec) {
            Builder builder = KeySpec.newBuilder();
            builder.setAlgorithm(dnsKeySpec.getAlgorithm() == null ? null : dnsKeySpec.getAlgorithm());
            builder.setKeyLength(dnsKeySpec.getKeyLength() == null ? null : dnsKeySpec.getKeyLength());
            builder.setKeyType(dnsKeySpec.getKeyType() == null ? null : dnsKeySpec.getKeyType());
            return builder.build();
        }

        public String getAlgorithm() {
            return this.algorithm;
        }

        public Long getKeyLength() {
            return this.keyLength;
        }

        public String getKeyType() {
            return this.keyType;
        }

        public static class Builder {
            private String algorithm;
            private Long keyLength;
            private String keyType;

            private Builder() {
            }

            private Builder(KeySpec keySpec) {
                this.algorithm = keySpec.algorithm;
                this.keyLength = keySpec.keyLength;
                this.keyType = keySpec.getKeyType();
            }

            public Builder setAlgorithm(String algorithm) {
                this.algorithm = algorithm;
                return this;
            }

            public Builder setKeyLength(Long keyLength) {
                this.keyLength = keyLength;
                return this;
            }

            public Builder setKeyType(String keyType) {
                this.keyType = keyType;
                return this;
            }

            public KeySpec build() {
                return new KeySpec(this);
            }
        }
    }
}

