/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.api.core.ApiFuture;
import com.google.api.core.InternalExtensionOnly;
import com.google.api.core.SettableApiFuture;
import com.google.api.gax.rpc.ResponseObserver;
import com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.api.gax.rpc.StreamController;
import com.google.cloud.Timestamp;
import com.google.cloud.firestore.AggregateField;
import com.google.cloud.firestore.AggregateQuerySnapshot;
import com.google.cloud.firestore.Firestore;
import com.google.cloud.firestore.Query;
import com.google.cloud.firestore.v1.FirestoreSettings;
import com.google.firestore.v1.RunAggregationQueryRequest;
import com.google.firestore.v1.RunAggregationQueryResponse;
import com.google.firestore.v1.RunQueryRequest;
import com.google.firestore.v1.StructuredAggregationQuery;
import com.google.firestore.v1.StructuredQuery;
import com.google.firestore.v1.Value;
import com.google.protobuf.ByteString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalExtensionOnly
public class AggregateQuery {
    @Nonnull
    private final Query query;
    @Nonnull
    private List<AggregateField> aggregateFieldList;
    @Nonnull
    private Map<String, String> aliasMap;

    AggregateQuery(@Nonnull Query query, @Nonnull List<AggregateField> aggregateFields) {
        this.query = query;
        this.aggregateFieldList = aggregateFields;
        this.aliasMap = new HashMap<String, String>();
    }

    @Nonnull
    public Query getQuery() {
        return this.query;
    }

    @Nonnull
    public ApiFuture<AggregateQuerySnapshot> get() {
        return this.get(null);
    }

    @Nonnull
    ApiFuture<AggregateQuerySnapshot> get(@Nullable ByteString transactionId) {
        AggregateQueryResponseDeliverer responseDeliverer = new AggregateQueryResponseDeliverer(transactionId, this.query.rpcContext.getClock().nanoTime());
        this.runQuery(responseDeliverer);
        return responseDeliverer.getFuture();
    }

    private void runQuery(AggregateQueryResponseDeliverer responseDeliverer) {
        RunAggregationQueryRequest request = this.toProto(responseDeliverer.getTransactionId());
        AggregateQueryResponseObserver responseObserver = new AggregateQueryResponseObserver(responseDeliverer);
        ServerStreamingCallable<RunAggregationQueryRequest, RunAggregationQueryResponse> callable = this.query.rpcContext.getClient().runAggregationQueryCallable();
        this.query.rpcContext.streamRequest(request, responseObserver, callable);
    }

    @Nonnull
    public RunAggregationQueryRequest toProto() {
        return this.toProto(null);
    }

    @Nonnull
    RunAggregationQueryRequest toProto(@Nullable ByteString transactionId) {
        RunQueryRequest runQueryRequest = this.query.toProto();
        RunAggregationQueryRequest.Builder request = RunAggregationQueryRequest.newBuilder();
        request.setParent(runQueryRequest.getParent());
        if (transactionId != null) {
            request.setTransaction(transactionId);
        }
        StructuredAggregationQuery.Builder structuredAggregationQuery = request.getStructuredAggregationQueryBuilder();
        structuredAggregationQuery.setStructuredQuery(runQueryRequest.getStructuredQuery());
        HashSet<String> uniqueAggregates = new HashSet<String>();
        ArrayList<StructuredAggregationQuery.Aggregation> aggregations = new ArrayList<StructuredAggregationQuery.Aggregation>();
        int aggregationNum = 0;
        for (AggregateField aggregateField : this.aggregateFieldList) {
            boolean isNewAggregateField = uniqueAggregates.add(aggregateField.getAlias());
            if (!isNewAggregateField) continue;
            StructuredQuery.FieldReference field = null;
            if (!aggregateField.getFieldPath().isEmpty()) {
                field = StructuredQuery.FieldReference.newBuilder().setFieldPath(aggregateField.getFieldPath()).build();
            }
            StructuredAggregationQuery.Aggregation.Builder aggregation = StructuredAggregationQuery.Aggregation.newBuilder();
            if (aggregateField instanceof AggregateField.CountAggregateField) {
                aggregation.setCount(StructuredAggregationQuery.Aggregation.Count.getDefaultInstance());
            } else if (aggregateField instanceof AggregateField.SumAggregateField) {
                aggregation.setSum(StructuredAggregationQuery.Aggregation.Sum.newBuilder().setField(field).build());
            } else if (aggregateField instanceof AggregateField.AverageAggregateField) {
                aggregation.setAvg(StructuredAggregationQuery.Aggregation.Avg.newBuilder().setField(field).build());
            } else {
                throw new RuntimeException("Unsupported aggregation");
            }
            String serverAlias = "aggregate_" + aggregationNum++;
            this.aliasMap.put(serverAlias, aggregateField.getAlias());
            aggregation.setAlias(serverAlias);
            aggregations.add(aggregation.build());
        }
        structuredAggregationQuery.addAllAggregations(aggregations);
        return request.build();
    }

    @Nonnull
    public static AggregateQuery fromProto(Firestore firestore, RunAggregationQueryRequest proto) {
        RunQueryRequest runQueryRequest = RunQueryRequest.newBuilder().setParent(proto.getParent()).setStructuredQuery(proto.getStructuredAggregationQuery().getStructuredQuery()).build();
        Query query = Query.fromProto(firestore, runQueryRequest);
        ArrayList<AggregateField> aggregateFields = new ArrayList<AggregateField>();
        List aggregations = proto.getStructuredAggregationQuery().getAggregationsList();
        aggregations.forEach(aggregation -> {
            if (aggregation.hasCount()) {
                aggregateFields.add(AggregateField.count());
            } else if (aggregation.hasAvg()) {
                aggregateFields.add(AggregateField.average(aggregation.getAvg().getField().getFieldPath()));
            } else if (aggregation.hasSum()) {
                aggregateFields.add(AggregateField.sum(aggregation.getSum().getField().getFieldPath()));
            } else {
                throw new RuntimeException("Unsupported aggregation.");
            }
        });
        return new AggregateQuery(query, aggregateFields);
    }

    public int hashCode() {
        return Objects.hash(this.query, this.aggregateFieldList);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof AggregateQuery)) {
            return false;
        }
        AggregateQuery other = (AggregateQuery)object;
        return this.query.equals(other.query) && this.aggregateFieldList.equals(other.aggregateFieldList);
    }

    private final class AggregateQueryResponseDeliverer {
        @Nullable
        private final ByteString transactionId;
        private final long startTimeNanos;
        private final SettableApiFuture<AggregateQuerySnapshot> future = SettableApiFuture.create();
        private final AtomicBoolean isFutureCompleted = new AtomicBoolean(false);

        AggregateQueryResponseDeliverer(ByteString transactionId, long startTimeNanos) {
            this.transactionId = transactionId;
            this.startTimeNanos = startTimeNanos;
        }

        ApiFuture<AggregateQuerySnapshot> getFuture() {
            return this.future;
        }

        @Nullable
        ByteString getTransactionId() {
            return this.transactionId;
        }

        long getStartTimeNanos() {
            return this.startTimeNanos;
        }

        void deliverResult(@Nonnull Map<String, Value> data, Timestamp readTime) {
            if (this.isFutureCompleted.compareAndSet(false, true)) {
                HashMap<String, Value> mappedData = new HashMap<String, Value>();
                data.forEach((serverAlias, value) -> mappedData.put((String)AggregateQuery.this.aliasMap.get(serverAlias), (Value)value));
                this.future.set((Object)new AggregateQuerySnapshot(AggregateQuery.this, readTime, mappedData));
            }
        }

        void deliverError(Throwable throwable) {
            if (this.isFutureCompleted.compareAndSet(false, true)) {
                this.future.setException(throwable);
            }
        }
    }

    private final class AggregateQueryResponseObserver
    implements ResponseObserver<RunAggregationQueryResponse> {
        private final AggregateQueryResponseDeliverer responseDeliverer;
        private StreamController streamController;

        AggregateQueryResponseObserver(AggregateQueryResponseDeliverer responseDeliverer) {
            this.responseDeliverer = responseDeliverer;
        }

        public void onStart(StreamController streamController) {
            this.streamController = streamController;
        }

        public void onResponse(RunAggregationQueryResponse response) {
            this.streamController.cancel();
            Timestamp readTime = Timestamp.fromProto((com.google.protobuf.Timestamp)response.getReadTime());
            this.responseDeliverer.deliverResult(response.getResult().getAggregateFieldsMap(), readTime);
        }

        public void onError(Throwable throwable) {
            if (this.shouldRetry(throwable)) {
                AggregateQuery.this.runQuery(this.responseDeliverer);
            } else {
                this.responseDeliverer.deliverError(throwable);
            }
        }

        private boolean shouldRetry(Throwable throwable) {
            Set retryableCodes = FirestoreSettings.newBuilder().runAggregationQuerySettings().getRetryableCodes();
            return AggregateQuery.this.query.shouldRetryQuery(throwable, this.responseDeliverer.getTransactionId(), this.responseDeliverer.getStartTimeNanos(), retryableCodes);
        }

        public void onComplete() {
        }
    }
}

