/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutureCallback;
import com.google.api.core.ApiFutures;
import com.google.api.core.CurrentMillisClock;
import com.google.api.core.SettableApiFuture;
import com.google.api.gax.retrying.ExponentialRetryAlgorithm;
import com.google.api.gax.retrying.TimedAttemptSettings;
import com.google.api.gax.rpc.ApiException;
import com.google.cloud.firestore.FirestoreException;
import com.google.cloud.firestore.FirestoreImpl;
import com.google.cloud.firestore.ServerSideTransaction;
import com.google.cloud.firestore.TraceUtil;
import com.google.cloud.firestore.Transaction;
import com.google.cloud.firestore.TransactionOptions;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.MoreExecutors;
import io.grpc.Context;
import io.opencensus.trace.AttributeValue;
import io.opencensus.trace.Span;
import io.opencensus.trace.Status;
import io.opencensus.trace.Tracer;
import io.opencensus.trace.Tracing;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

final class ServerSideTransactionRunner<T> {
    private static final Tracer tracer = Tracing.getTracer();
    private static final Status TOO_MANY_RETRIES_STATUS = Status.ABORTED.withDescription("too many retries");
    private static final Status USER_CALLBACK_FAILED = Status.ABORTED.withDescription("user callback failed");
    private final Transaction.AsyncFunction<T> userCallback;
    private final Span span;
    private final FirestoreImpl firestore;
    private final ScheduledExecutorService firestoreExecutor;
    private final Executor userCallbackExecutor;
    private final ExponentialRetryAlgorithm backoffAlgorithm;
    private final TransactionOptions transactionOptions;
    private TimedAttemptSettings nextBackoffAttempt;
    private ServerSideTransaction transaction;
    private int attemptsRemaining;

    ServerSideTransactionRunner(FirestoreImpl firestore, Transaction.AsyncFunction<T> userCallback, TransactionOptions transactionOptions) {
        this.transactionOptions = transactionOptions;
        this.span = tracer.spanBuilder("CloudFirestore.Transaction").startSpan();
        this.firestore = firestore;
        this.firestoreExecutor = firestore.getClient().getExecutor();
        this.userCallback = userCallback;
        this.attemptsRemaining = transactionOptions.getNumberOfAttempts();
        this.userCallbackExecutor = Context.currentContextExecutor((Executor)(transactionOptions.getExecutor() != null ? transactionOptions.getExecutor() : this.firestore.getClient().getExecutor()));
        this.backoffAlgorithm = new ExponentialRetryAlgorithm(firestore.getOptions().getRetrySettings(), CurrentMillisClock.getDefaultClock());
        this.nextBackoffAttempt = this.backoffAlgorithm.createFirstAttempt();
    }

    ApiFuture<T> run() {
        --this.attemptsRemaining;
        this.span.addAnnotation("Start runTransaction", (Map)ImmutableMap.of((Object)"attemptsRemaining", (Object)AttributeValue.longAttributeValue((long)this.attemptsRemaining)));
        return ApiFutures.catchingAsync((ApiFuture)ApiFutures.transformAsync(this.maybeRollback(), this::rollbackCallback, (Executor)MoreExecutors.directExecutor()), Throwable.class, this::restartTransactionCallback, (Executor)MoreExecutors.directExecutor());
    }

    ApiFuture<ServerSideTransaction> begin() {
        ServerSideTransaction previousTransaction = this.transaction;
        this.transaction = null;
        return ServerSideTransaction.begin(this.firestore, this.transactionOptions, previousTransaction);
    }

    private ApiFuture<Void> maybeRollback() {
        return this.hasTransaction() ? this.transaction.rollback() : ApiFutures.immediateFuture(null);
    }

    private boolean hasTransaction() {
        return this.transaction != null;
    }

    private ApiFuture<T> rollbackCallback(Void input) {
        SettableApiFuture backoff = SettableApiFuture.create();
        this.firestoreExecutor.schedule(() -> backoff.set(null), this.nextBackoffAttempt.getRandomizedRetryDelay().toMillis(), TimeUnit.MILLISECONDS);
        this.nextBackoffAttempt = this.backoffAlgorithm.createNextAttempt(this.nextBackoffAttempt);
        return ApiFutures.transformAsync((ApiFuture)backoff, this::backoffCallback, (Executor)MoreExecutors.directExecutor());
    }

    private SettableApiFuture<T> invokeUserCallback() {
        final SettableApiFuture returnedResult = SettableApiFuture.create();
        this.userCallbackExecutor.execute(() -> {
            ApiFuture<T> userCallbackResult;
            try {
                userCallbackResult = this.userCallback.updateCallback(this.transaction);
            }
            catch (Exception e) {
                userCallbackResult = ApiFutures.immediateFailedFuture((Throwable)e);
            }
            ApiFutures.addCallback(userCallbackResult, (ApiFutureCallback)new ApiFutureCallback<T>(){

                public void onFailure(Throwable t) {
                    returnedResult.setException(t);
                }

                public void onSuccess(T result) {
                    returnedResult.set(result);
                }
            }, (Executor)this.firestoreExecutor);
        });
        return returnedResult;
    }

    private ApiFuture<T> backoffCallback(Void input) {
        return ApiFutures.transformAsync(this.begin(), this::beginTransactionCallback, (Executor)MoreExecutors.directExecutor());
    }

    private ApiFuture<T> beginTransactionCallback(ServerSideTransaction serverSideTransaction) {
        this.transaction = serverSideTransaction;
        return ApiFutures.transformAsync(this.invokeUserCallback(), this::userFunctionCallback, (Executor)MoreExecutors.directExecutor());
    }

    private ApiFuture<T> userFunctionCallback(T userFunctionResult) {
        return ApiFutures.transform(this.transaction.commit(), input -> {
            this.span.setStatus(Status.OK);
            this.span.end();
            return userFunctionResult;
        }, (Executor)MoreExecutors.directExecutor());
    }

    private ApiFuture<T> restartTransactionCallback(Throwable throwable) {
        if (!(throwable instanceof ApiException)) {
            this.span.setStatus(USER_CALLBACK_FAILED);
            return this.rollbackAndReject(throwable);
        }
        ApiException apiException = (ApiException)throwable;
        if (ServerSideTransactionRunner.isRetryableTransactionError(apiException)) {
            if (this.attemptsRemaining > 0) {
                this.span.addAnnotation("retrying");
                return this.run();
            }
            this.span.setStatus(TOO_MANY_RETRIES_STATUS);
            FirestoreException firestoreException = FirestoreException.forApiException(apiException, "Transaction was cancelled because of too many retries.");
            return this.rollbackAndReject((Throwable)((Object)firestoreException));
        }
        this.span.setStatus(TraceUtil.statusFromApiException(apiException));
        FirestoreException firestoreException = FirestoreException.forApiException(apiException, "Transaction failed with non-retryable error");
        return this.rollbackAndReject((Throwable)((Object)firestoreException));
    }

    private static boolean isRetryableTransactionError(ApiException exception) {
        switch (exception.getStatusCode().getCode()) {
            case ABORTED: 
            case CANCELLED: 
            case UNKNOWN: 
            case DEADLINE_EXCEEDED: 
            case INTERNAL: 
            case UNAVAILABLE: 
            case UNAUTHENTICATED: 
            case RESOURCE_EXHAUSTED: {
                return true;
            }
            case INVALID_ARGUMENT: {
                return exception.getMessage().contains("transaction has expired");
            }
        }
        return false;
    }

    private ApiFuture<T> rollbackAndReject(Throwable throwable) {
        SettableApiFuture failedTransaction = SettableApiFuture.create();
        if (this.hasTransaction()) {
            this.transaction.rollback().addListener(() -> failedTransaction.setException(throwable), MoreExecutors.directExecutor());
        } else {
            failedTransaction.setException(throwable);
        }
        this.span.end();
        return failedTransaction;
    }
}

