/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.InternalExtensionOnly;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.ApiExceptions;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.firestore.DocumentReference;
import com.google.cloud.firestore.FirestoreException;
import com.google.cloud.firestore.FirestoreImpl;
import com.google.cloud.firestore.FirestoreOptions;
import com.google.cloud.firestore.FirestoreRpcContext;
import com.google.cloud.firestore.Query;
import com.google.cloud.firestore.ResourcePath;
import com.google.cloud.firestore.WriteResult;
import com.google.cloud.firestore.encoding.CustomClassMapper;
import com.google.cloud.firestore.spi.v1.FirestoreRpc;
import com.google.cloud.firestore.telemetry.TraceUtil;
import com.google.cloud.firestore.v1.FirestoreClient;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.firestore.v1.Document;
import com.google.firestore.v1.DocumentMask;
import com.google.firestore.v1.ListDocumentsRequest;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalExtensionOnly
public class CollectionReference
extends Query {
    CollectionReference(FirestoreRpcContext<?> rpcContext, ResourcePath collectionPath) {
        super(rpcContext, collectionPath);
    }

    @Nonnull
    public String getId() {
        return this.options.getCollectionId();
    }

    @Nullable
    public DocumentReference getParent() {
        ResourcePath parent = this.options.getParentPath();
        return parent.isDocument() ? new DocumentReference(this.rpcContext, parent) : null;
    }

    @Nonnull
    public String getPath() {
        return this.getResourcePath().getPath();
    }

    @Nonnull
    public DocumentReference document() {
        return this.document(FirestoreImpl.autoId());
    }

    @Nonnull
    public DocumentReference document(@Nonnull String childPath) {
        ResourcePath documentPath = (ResourcePath)this.getResourcePath().append(childPath);
        Preconditions.checkArgument((boolean)documentPath.isDocument(), (String)"Path should point to a Document Reference: %s", (Object)this.getPath());
        return new DocumentReference(this.rpcContext, documentPath);
    }

    @Nonnull
    public Iterable<DocumentReference> listDocuments() {
        TraceUtil.Span span = ((FirestoreOptions)this.rpcContext.getFirestore().getOptions()).getTraceUtil().startSpan("CollectionReference.ListDocuments");
        TraceUtil.Scope ignored = span.makeCurrent();
        try {
            ListDocumentsRequest.Builder request = ListDocumentsRequest.newBuilder();
            request.setParent(this.options.getParentPath().toString());
            request.setCollectionId(this.options.getCollectionId());
            request.setMask(DocumentMask.getDefaultInstance());
            request.setShowMissing(true);
            FirestoreRpc client = this.rpcContext.getClient();
            UnaryCallable<ListDocumentsRequest, FirestoreClient.ListDocumentsPagedResponse> callable = client.listDocumentsPagedCallable();
            ListDocumentsRequest build = request.build();
            ApiFuture<FirestoreClient.ListDocumentsPagedResponse> future = this.rpcContext.sendRequest(build, callable);
            final FirestoreClient.ListDocumentsPagedResponse response = (FirestoreClient.ListDocumentsPagedResponse)((Object)ApiExceptions.callAndTranslateApiException(future));
            Iterable<DocumentReference> result = new Iterable<DocumentReference>(){

                @Override
                @Nonnull
                public Iterator<DocumentReference> iterator() {
                    final Iterator iterator = response.iterateAll().iterator();
                    return new Iterator<DocumentReference>(){

                        @Override
                        public boolean hasNext() {
                            return iterator.hasNext();
                        }

                        @Override
                        public DocumentReference next() {
                            ResourcePath path = ResourcePath.create(((Document)iterator.next()).getName());
                            return CollectionReference.this.document(path.getId());
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException("remove");
                        }
                    };
                }
            };
            span.end();
            Iterable<DocumentReference> iterable = result;
            if (ignored != null) {
                ignored.close();
            }
            return iterable;
        }
        catch (Throwable throwable) {
            try {
                if (ignored != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (ApiException exception) {
                span.end(exception);
                throw FirestoreException.forApiException(exception);
            }
            catch (Throwable throwable3) {
                span.end(throwable3);
                throw throwable3;
            }
        }
    }

    @Nonnull
    public ApiFuture<DocumentReference> add(@Nonnull Map<String, Object> fields) {
        TraceUtil.Span span = ((FirestoreOptions)this.rpcContext.getFirestore().getOptions()).getTraceUtil().startSpan("CollectionReference.Add");
        TraceUtil.Scope ignored = span.makeCurrent();
        try {
            DocumentReference documentReference = this.document();
            ApiFuture<WriteResult> createFuture = documentReference.create(fields);
            ApiFuture result = ApiFutures.transform(createFuture, writeResult -> documentReference, (Executor)MoreExecutors.directExecutor());
            span.endAtFuture(result);
            ApiFuture apiFuture = result;
            if (ignored != null) {
                ignored.close();
            }
            return apiFuture;
        }
        catch (Throwable throwable) {
            try {
                if (ignored != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Exception error) {
                span.end(error);
                throw error;
            }
        }
    }

    public ApiFuture<DocumentReference> add(Object pojo) {
        Object converted = CustomClassMapper.convertToPlainJavaTypes(pojo);
        if (!(converted instanceof Map)) {
            throw FirestoreException.forInvalidArgument("Can't set a document's data to an array or primitive", new Object[0]);
        }
        return this.add((Map)converted);
    }

    ResourcePath getResourcePath() {
        return (ResourcePath)this.options.getParentPath().append(this.options.getCollectionId());
    }
}

