/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore.telemetry;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.cloud.firestore.FirestoreOptions;
import com.google.cloud.firestore.telemetry.DisabledTraceUtil;
import com.google.cloud.firestore.telemetry.EnabledTraceUtil;
import io.grpc.ManagedChannelBuilder;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface TraceUtil {
    public static final String ATTRIBUTE_SERVICE_PREFIX = "gcp.firestore.";
    public static final String SPAN_NAME_DOC_REF_CREATE = "DocumentReference.Create";
    public static final String SPAN_NAME_DOC_REF_SET = "DocumentReference.Set";
    public static final String SPAN_NAME_DOC_REF_UPDATE = "DocumentReference.Update";
    public static final String SPAN_NAME_DOC_REF_DELETE = "DocumentReference.Delete";
    public static final String SPAN_NAME_DOC_REF_GET = "DocumentReference.Get";
    public static final String SPAN_NAME_DOC_REF_LIST_COLLECTIONS = "DocumentReference.ListCollections";
    public static final String SPAN_NAME_COL_REF_ADD = "CollectionReference.Add";
    public static final String SPAN_NAME_COL_REF_LIST_DOCUMENTS = "CollectionReference.ListDocuments";
    public static final String SPAN_NAME_QUERY_GET = "Query.Get";
    public static final String SPAN_NAME_AGGREGATION_QUERY_GET = "AggregationQuery.Get";
    public static final String SPAN_NAME_RUN_QUERY = "RunQuery";
    public static final String SPAN_NAME_RUN_AGGREGATION_QUERY = "RunAggregationQuery";
    public static final String SPAN_NAME_BATCH_GET_DOCUMENTS = "BatchGetDocuments";
    public static final String SPAN_NAME_TRANSACTION_RUN = "Transaction.Run";
    public static final String SPAN_NAME_TRANSACTION_BEGIN = "Transaction.Begin";
    public static final String SPAN_NAME_TRANSACTION_GET_QUERY = "Transaction.Get.Query";
    public static final String SPAN_NAME_TRANSACTION_GET_AGGREGATION_QUERY = "Transaction.Get.AggregationQuery";
    public static final String SPAN_NAME_TRANSACTION_GET_DOCUMENT = "Transaction.Get.Document";
    public static final String SPAN_NAME_TRANSACTION_GET_DOCUMENTS = "Transaction.Get.Documents";
    public static final String SPAN_NAME_TRANSACTION_ROLLBACK = "Transaction.Rollback";
    public static final String SPAN_NAME_BATCH_COMMIT = "Batch.Commit";
    public static final String SPAN_NAME_TRANSACTION_COMMIT = "Transaction.Commit";
    public static final String SPAN_NAME_PARTITION_QUERY = "PartitionQuery";
    public static final String SPAN_NAME_BULK_WRITER_COMMIT = "BulkWriter.Commit";
    public static final String ATTRIBUTE_KEY_ATTEMPT = "attempt";
    public static final String ATTRIBUTE_KEY_DOC_COUNT = "doc_count";
    public static final String ATTRIBUTE_KEY_IS_TRANSACTIONAL = "transactional";
    public static final String ATTRIBUTE_KEY_NUM_RESPONSES = "response_count";
    public static final String ATTRIBUTE_KEY_IS_RETRY_WITH_CURSOR = "retry_query_with_cursor";
    public static final String ATTRIBUTE_KEY_TRANSACTION_TYPE = "transaction_type";
    public static final String ATTRIBUTE_KEY_ATTEMPTS_ALLOWED = "attempts_allowed";
    public static final String ATTRIBUTE_KEY_ATTEMPTS_REMAINING = "attempts_remaining";
    public static final String ENABLE_TRACING_ENV_VAR = "FIRESTORE_ENABLE_TRACING";
    public static final String LIBRARY_NAME = "com.google.cloud.firestore";

    public static TraceUtil getInstance(@Nonnull FirestoreOptions firestoreOptions) {
        boolean createEnabledInstance = firestoreOptions.getOpenTelemetryOptions().isTracingEnabled();
        String enableTracingEnvVar = System.getenv(ENABLE_TRACING_ENV_VAR);
        if (enableTracingEnvVar != null) {
            if (enableTracingEnvVar.equalsIgnoreCase("true") || enableTracingEnvVar.equalsIgnoreCase("on")) {
                createEnabledInstance = true;
            }
            if (enableTracingEnvVar.equalsIgnoreCase("false") || enableTracingEnvVar.equalsIgnoreCase("off")) {
                createEnabledInstance = false;
            }
        }
        if (createEnabledInstance) {
            return new EnabledTraceUtil(firestoreOptions);
        }
        return new DisabledTraceUtil();
    }

    @Nullable
    public ApiFunction<ManagedChannelBuilder, ManagedChannelBuilder> getChannelConfigurator();

    public Span startSpan(String var1);

    public Span startSpan(String var1, Context var2);

    @Nonnull
    public Span currentSpan();

    @Nonnull
    public Context currentContext();

    public static interface Scope
    extends AutoCloseable {
        @Override
        public void close();
    }

    public static interface Context {
        public Scope makeCurrent();
    }

    public static interface Span {
        public Span addEvent(String var1);

        public Span addEvent(String var1, Map<String, Object> var2);

        public Span setAttribute(String var1, int var2);

        public Span setAttribute(String var1, String var2);

        public Span setAttribute(String var1, boolean var2);

        public Scope makeCurrent();

        public void end();

        public void end(Throwable var1);

        public <T> void endAtFuture(ApiFuture<T> var1);
    }
}

