/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.api.core.BetaApi;
import io.opentelemetry.api.OpenTelemetry;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@BetaApi
public class FirestoreOpenTelemetryOptions {
    private final boolean tracingEnabled;
    @Nullable
    private final OpenTelemetry openTelemetry;

    FirestoreOpenTelemetryOptions(Builder builder) {
        this.tracingEnabled = builder.tracingEnabled;
        this.openTelemetry = builder.openTelemetry;
    }

    @Deprecated
    public boolean isTracingEnabled() {
        return this.tracingEnabled;
    }

    public OpenTelemetry getOpenTelemetry() {
        return this.openTelemetry;
    }

    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private boolean tracingEnabled;
        @Nullable
        private OpenTelemetry openTelemetry;

        private Builder() {
            this.tracingEnabled = false;
            this.openTelemetry = null;
        }

        private Builder(FirestoreOpenTelemetryOptions options) {
            this.tracingEnabled = options.tracingEnabled;
            this.openTelemetry = options.openTelemetry;
        }

        @Nonnull
        public FirestoreOpenTelemetryOptions build() {
            return new FirestoreOpenTelemetryOptions(this);
        }

        @Deprecated
        @Nonnull
        public Builder setTracingEnabled(boolean tracingEnabled) {
            this.tracingEnabled = tracingEnabled;
            return this;
        }

        @Nonnull
        public Builder setOpenTelemetry(@Nonnull OpenTelemetry openTelemetry) {
            this.openTelemetry = openTelemetry;
            return this;
        }
    }
}

