/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.gaming.v1beta.stub;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonOperationSnapshot;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.httpjson.longrunning.stub.HttpJsonOperationsStub;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.gaming.v1beta.CreateGameServerConfigRequest;
import com.google.cloud.gaming.v1beta.DeleteGameServerConfigRequest;
import com.google.cloud.gaming.v1beta.GameServerConfig;
import com.google.cloud.gaming.v1beta.GameServerConfigsServiceClient;
import com.google.cloud.gaming.v1beta.GetGameServerConfigRequest;
import com.google.cloud.gaming.v1beta.ListGameServerConfigsRequest;
import com.google.cloud.gaming.v1beta.ListGameServerConfigsResponse;
import com.google.cloud.gaming.v1beta.OperationMetadata;
import com.google.cloud.gaming.v1beta.stub.GameServerConfigsServiceStub;
import com.google.cloud.gaming.v1beta.stub.GameServerConfigsServiceStubSettings;
import com.google.cloud.gaming.v1beta.stub.HttpJsonGameServerConfigsServiceCallableFactory;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class HttpJsonGameServerConfigsServiceStub
extends GameServerConfigsServiceStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().add(Empty.getDescriptor()).add(GameServerConfig.getDescriptor()).add(OperationMetadata.getDescriptor()).build();
    private static final ApiMethodDescriptor<ListGameServerConfigsRequest, ListGameServerConfigsResponse> listGameServerConfigsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.gaming.v1beta.GameServerConfigsService/ListGameServerConfigs").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1beta/{parent=projects/*/locations/*/gameServerDeployments/*}/configs", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        serializer.putQueryParam(fields, "orderBy", (Object)request.getOrderBy());
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListGameServerConfigsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetGameServerConfigRequest, GameServerConfig> getGameServerConfigMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.gaming.v1beta.GameServerConfigsService/GetGameServerConfig").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1beta/{name=projects/*/locations/*/gameServerDeployments/*/configs/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)GameServerConfig.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<CreateGameServerConfigRequest, Operation> createGameServerConfigMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.gaming.v1beta.GameServerConfigsService/CreateGameServerConfig").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1beta/{parent=projects/*/locations/*/gameServerDeployments/*}/configs", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "configId", (Object)request.getConfigId());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("gameServerConfig", (Message)request.getGameServerConfig(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<DeleteGameServerConfigRequest, Operation> deleteGameServerConfigMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.gaming.v1beta.GameServerConfigsService/DeleteGameServerConfig").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1beta/{name=projects/*/locations/*/gameServerDeployments/*/configs/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private final UnaryCallable<ListGameServerConfigsRequest, ListGameServerConfigsResponse> listGameServerConfigsCallable;
    private final UnaryCallable<ListGameServerConfigsRequest, GameServerConfigsServiceClient.ListGameServerConfigsPagedResponse> listGameServerConfigsPagedCallable;
    private final UnaryCallable<GetGameServerConfigRequest, GameServerConfig> getGameServerConfigCallable;
    private final UnaryCallable<CreateGameServerConfigRequest, Operation> createGameServerConfigCallable;
    private final OperationCallable<CreateGameServerConfigRequest, GameServerConfig, OperationMetadata> createGameServerConfigOperationCallable;
    private final UnaryCallable<DeleteGameServerConfigRequest, Operation> deleteGameServerConfigCallable;
    private final OperationCallable<DeleteGameServerConfigRequest, Empty, OperationMetadata> deleteGameServerConfigOperationCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonOperationsStub httpJsonOperationsStub;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonGameServerConfigsServiceStub create(GameServerConfigsServiceStubSettings settings) throws IOException {
        return new HttpJsonGameServerConfigsServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonGameServerConfigsServiceStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonGameServerConfigsServiceStub(GameServerConfigsServiceStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonGameServerConfigsServiceStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonGameServerConfigsServiceStub(GameServerConfigsServiceStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonGameServerConfigsServiceStub(GameServerConfigsServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonGameServerConfigsServiceCallableFactory());
    }

    protected HttpJsonGameServerConfigsServiceStub(GameServerConfigsServiceStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.httpJsonOperationsStub = HttpJsonOperationsStub.create((ClientContext)clientContext, (HttpJsonStubCallableFactory)callableFactory, (TypeRegistry)typeRegistry);
        HttpJsonCallSettings listGameServerConfigsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listGameServerConfigsMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings getGameServerConfigTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getGameServerConfigMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings createGameServerConfigTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createGameServerConfigMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings deleteGameServerConfigTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteGameServerConfigMethodDescriptor).setTypeRegistry(typeRegistry).build();
        this.listGameServerConfigsCallable = callableFactory.createUnaryCallable(listGameServerConfigsTransportSettings, settings.listGameServerConfigsSettings(), clientContext);
        this.listGameServerConfigsPagedCallable = callableFactory.createPagedCallable(listGameServerConfigsTransportSettings, settings.listGameServerConfigsSettings(), clientContext);
        this.getGameServerConfigCallable = callableFactory.createUnaryCallable(getGameServerConfigTransportSettings, settings.getGameServerConfigSettings(), clientContext);
        this.createGameServerConfigCallable = callableFactory.createUnaryCallable(createGameServerConfigTransportSettings, settings.createGameServerConfigSettings(), clientContext);
        this.createGameServerConfigOperationCallable = callableFactory.createOperationCallable(createGameServerConfigTransportSettings, settings.createGameServerConfigOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.deleteGameServerConfigCallable = callableFactory.createUnaryCallable(deleteGameServerConfigTransportSettings, settings.deleteGameServerConfigSettings(), clientContext);
        this.deleteGameServerConfigOperationCallable = callableFactory.createOperationCallable(deleteGameServerConfigTransportSettings, settings.deleteGameServerConfigOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(listGameServerConfigsMethodDescriptor);
        methodDescriptors.add(getGameServerConfigMethodDescriptor);
        methodDescriptors.add(createGameServerConfigMethodDescriptor);
        methodDescriptors.add(deleteGameServerConfigMethodDescriptor);
        return methodDescriptors;
    }

    public HttpJsonOperationsStub getHttpJsonOperationsStub() {
        return this.httpJsonOperationsStub;
    }

    @Override
    public UnaryCallable<ListGameServerConfigsRequest, ListGameServerConfigsResponse> listGameServerConfigsCallable() {
        return this.listGameServerConfigsCallable;
    }

    @Override
    public UnaryCallable<ListGameServerConfigsRequest, GameServerConfigsServiceClient.ListGameServerConfigsPagedResponse> listGameServerConfigsPagedCallable() {
        return this.listGameServerConfigsPagedCallable;
    }

    @Override
    public UnaryCallable<GetGameServerConfigRequest, GameServerConfig> getGameServerConfigCallable() {
        return this.getGameServerConfigCallable;
    }

    @Override
    public UnaryCallable<CreateGameServerConfigRequest, Operation> createGameServerConfigCallable() {
        return this.createGameServerConfigCallable;
    }

    @Override
    public OperationCallable<CreateGameServerConfigRequest, GameServerConfig, OperationMetadata> createGameServerConfigOperationCallable() {
        return this.createGameServerConfigOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteGameServerConfigRequest, Operation> deleteGameServerConfigCallable() {
        return this.deleteGameServerConfigCallable;
    }

    @Override
    public OperationCallable<DeleteGameServerConfigRequest, Empty, OperationMetadata> deleteGameServerConfigOperationCallable() {
        return this.deleteGameServerConfigOperationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

