/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.migrationcenter.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.cloud.migrationcenter.v1.AddAssetsToGroupRequest;
import com.google.cloud.migrationcenter.v1.AggregateAssetsValuesRequest;
import com.google.cloud.migrationcenter.v1.AggregateAssetsValuesResponse;
import com.google.cloud.migrationcenter.v1.Asset;
import com.google.cloud.migrationcenter.v1.AssetName;
import com.google.cloud.migrationcenter.v1.BatchDeleteAssetsRequest;
import com.google.cloud.migrationcenter.v1.BatchUpdateAssetsRequest;
import com.google.cloud.migrationcenter.v1.BatchUpdateAssetsResponse;
import com.google.cloud.migrationcenter.v1.CreateGroupRequest;
import com.google.cloud.migrationcenter.v1.CreateImportDataFileRequest;
import com.google.cloud.migrationcenter.v1.CreateImportJobRequest;
import com.google.cloud.migrationcenter.v1.CreatePreferenceSetRequest;
import com.google.cloud.migrationcenter.v1.CreateReportConfigRequest;
import com.google.cloud.migrationcenter.v1.CreateReportRequest;
import com.google.cloud.migrationcenter.v1.CreateSourceRequest;
import com.google.cloud.migrationcenter.v1.DeleteAssetRequest;
import com.google.cloud.migrationcenter.v1.DeleteGroupRequest;
import com.google.cloud.migrationcenter.v1.DeleteImportDataFileRequest;
import com.google.cloud.migrationcenter.v1.DeleteImportJobRequest;
import com.google.cloud.migrationcenter.v1.DeletePreferenceSetRequest;
import com.google.cloud.migrationcenter.v1.DeleteReportConfigRequest;
import com.google.cloud.migrationcenter.v1.DeleteReportRequest;
import com.google.cloud.migrationcenter.v1.DeleteSourceRequest;
import com.google.cloud.migrationcenter.v1.ErrorFrame;
import com.google.cloud.migrationcenter.v1.ErrorFrameName;
import com.google.cloud.migrationcenter.v1.GetAssetRequest;
import com.google.cloud.migrationcenter.v1.GetErrorFrameRequest;
import com.google.cloud.migrationcenter.v1.GetGroupRequest;
import com.google.cloud.migrationcenter.v1.GetImportDataFileRequest;
import com.google.cloud.migrationcenter.v1.GetImportJobRequest;
import com.google.cloud.migrationcenter.v1.GetPreferenceSetRequest;
import com.google.cloud.migrationcenter.v1.GetReportConfigRequest;
import com.google.cloud.migrationcenter.v1.GetReportRequest;
import com.google.cloud.migrationcenter.v1.GetSettingsRequest;
import com.google.cloud.migrationcenter.v1.GetSourceRequest;
import com.google.cloud.migrationcenter.v1.Group;
import com.google.cloud.migrationcenter.v1.GroupName;
import com.google.cloud.migrationcenter.v1.ImportDataFile;
import com.google.cloud.migrationcenter.v1.ImportDataFileName;
import com.google.cloud.migrationcenter.v1.ImportJob;
import com.google.cloud.migrationcenter.v1.ImportJobName;
import com.google.cloud.migrationcenter.v1.ListAssetsRequest;
import com.google.cloud.migrationcenter.v1.ListAssetsResponse;
import com.google.cloud.migrationcenter.v1.ListErrorFramesRequest;
import com.google.cloud.migrationcenter.v1.ListErrorFramesResponse;
import com.google.cloud.migrationcenter.v1.ListGroupsRequest;
import com.google.cloud.migrationcenter.v1.ListGroupsResponse;
import com.google.cloud.migrationcenter.v1.ListImportDataFilesRequest;
import com.google.cloud.migrationcenter.v1.ListImportDataFilesResponse;
import com.google.cloud.migrationcenter.v1.ListImportJobsRequest;
import com.google.cloud.migrationcenter.v1.ListImportJobsResponse;
import com.google.cloud.migrationcenter.v1.ListPreferenceSetsRequest;
import com.google.cloud.migrationcenter.v1.ListPreferenceSetsResponse;
import com.google.cloud.migrationcenter.v1.ListReportConfigsRequest;
import com.google.cloud.migrationcenter.v1.ListReportConfigsResponse;
import com.google.cloud.migrationcenter.v1.ListReportsRequest;
import com.google.cloud.migrationcenter.v1.ListReportsResponse;
import com.google.cloud.migrationcenter.v1.ListSourcesRequest;
import com.google.cloud.migrationcenter.v1.ListSourcesResponse;
import com.google.cloud.migrationcenter.v1.LocationName;
import com.google.cloud.migrationcenter.v1.MigrationCenterSettings;
import com.google.cloud.migrationcenter.v1.OperationMetadata;
import com.google.cloud.migrationcenter.v1.PreferenceSet;
import com.google.cloud.migrationcenter.v1.PreferenceSetName;
import com.google.cloud.migrationcenter.v1.RemoveAssetsFromGroupRequest;
import com.google.cloud.migrationcenter.v1.Report;
import com.google.cloud.migrationcenter.v1.ReportAssetFramesRequest;
import com.google.cloud.migrationcenter.v1.ReportAssetFramesResponse;
import com.google.cloud.migrationcenter.v1.ReportConfig;
import com.google.cloud.migrationcenter.v1.ReportConfigName;
import com.google.cloud.migrationcenter.v1.ReportName;
import com.google.cloud.migrationcenter.v1.RunImportJobRequest;
import com.google.cloud.migrationcenter.v1.Settings;
import com.google.cloud.migrationcenter.v1.SettingsName;
import com.google.cloud.migrationcenter.v1.Source;
import com.google.cloud.migrationcenter.v1.SourceName;
import com.google.cloud.migrationcenter.v1.UpdateAssetRequest;
import com.google.cloud.migrationcenter.v1.UpdateGroupRequest;
import com.google.cloud.migrationcenter.v1.UpdateImportJobRequest;
import com.google.cloud.migrationcenter.v1.UpdatePreferenceSetRequest;
import com.google.cloud.migrationcenter.v1.UpdateSettingsRequest;
import com.google.cloud.migrationcenter.v1.UpdateSourceRequest;
import com.google.cloud.migrationcenter.v1.ValidateImportJobRequest;
import com.google.cloud.migrationcenter.v1.stub.MigrationCenterStub;
import com.google.cloud.migrationcenter.v1.stub.MigrationCenterStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class MigrationCenterClient
implements BackgroundResource {
    private final MigrationCenterSettings settings;
    private final MigrationCenterStub stub;
    private final com.google.api.gax.httpjson.longrunning.OperationsClient httpJsonOperationsClient;
    private final OperationsClient operationsClient;

    public static final MigrationCenterClient create() throws IOException {
        return MigrationCenterClient.create(MigrationCenterSettings.newBuilder().build());
    }

    public static final MigrationCenterClient create(MigrationCenterSettings settings) throws IOException {
        return new MigrationCenterClient(settings);
    }

    public static final MigrationCenterClient create(MigrationCenterStub stub) {
        return new MigrationCenterClient(stub);
    }

    protected MigrationCenterClient(MigrationCenterSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((MigrationCenterStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected MigrationCenterClient(MigrationCenterStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final MigrationCenterSettings getSettings() {
        return this.settings;
    }

    public MigrationCenterStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final com.google.api.gax.httpjson.longrunning.OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final ListAssetsPagedResponse listAssets(LocationName parent) {
        ListAssetsRequest request = ListAssetsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listAssets(request);
    }

    public final ListAssetsPagedResponse listAssets(String parent) {
        ListAssetsRequest request = ListAssetsRequest.newBuilder().setParent(parent).build();
        return this.listAssets(request);
    }

    public final ListAssetsPagedResponse listAssets(ListAssetsRequest request) {
        return (ListAssetsPagedResponse)((Object)this.listAssetsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListAssetsRequest, ListAssetsPagedResponse> listAssetsPagedCallable() {
        return this.stub.listAssetsPagedCallable();
    }

    public final UnaryCallable<ListAssetsRequest, ListAssetsResponse> listAssetsCallable() {
        return this.stub.listAssetsCallable();
    }

    public final Asset getAsset(AssetName name) {
        GetAssetRequest request = GetAssetRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getAsset(request);
    }

    public final Asset getAsset(String name) {
        GetAssetRequest request = GetAssetRequest.newBuilder().setName(name).build();
        return this.getAsset(request);
    }

    public final Asset getAsset(GetAssetRequest request) {
        return (Asset)this.getAssetCallable().call((Object)request);
    }

    public final UnaryCallable<GetAssetRequest, Asset> getAssetCallable() {
        return this.stub.getAssetCallable();
    }

    public final Asset updateAsset(Asset asset, FieldMask updateMask) {
        UpdateAssetRequest request = UpdateAssetRequest.newBuilder().setAsset(asset).setUpdateMask(updateMask).build();
        return this.updateAsset(request);
    }

    public final Asset updateAsset(UpdateAssetRequest request) {
        return (Asset)this.updateAssetCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateAssetRequest, Asset> updateAssetCallable() {
        return this.stub.updateAssetCallable();
    }

    public final BatchUpdateAssetsResponse batchUpdateAssets(LocationName parent, List<UpdateAssetRequest> requests) {
        BatchUpdateAssetsRequest request = BatchUpdateAssetsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).addAllRequests(requests).build();
        return this.batchUpdateAssets(request);
    }

    public final BatchUpdateAssetsResponse batchUpdateAssets(String parent, List<UpdateAssetRequest> requests) {
        BatchUpdateAssetsRequest request = BatchUpdateAssetsRequest.newBuilder().setParent(parent).addAllRequests(requests).build();
        return this.batchUpdateAssets(request);
    }

    public final BatchUpdateAssetsResponse batchUpdateAssets(BatchUpdateAssetsRequest request) {
        return (BatchUpdateAssetsResponse)this.batchUpdateAssetsCallable().call((Object)request);
    }

    public final UnaryCallable<BatchUpdateAssetsRequest, BatchUpdateAssetsResponse> batchUpdateAssetsCallable() {
        return this.stub.batchUpdateAssetsCallable();
    }

    public final void deleteAsset(AssetName name) {
        DeleteAssetRequest request = DeleteAssetRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteAsset(request);
    }

    public final void deleteAsset(String name) {
        DeleteAssetRequest request = DeleteAssetRequest.newBuilder().setName(name).build();
        this.deleteAsset(request);
    }

    public final void deleteAsset(DeleteAssetRequest request) {
        this.deleteAssetCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteAssetRequest, Empty> deleteAssetCallable() {
        return this.stub.deleteAssetCallable();
    }

    public final void batchDeleteAssets(LocationName parent, List<String> names) {
        BatchDeleteAssetsRequest request = BatchDeleteAssetsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).addAllNames(names).build();
        this.batchDeleteAssets(request);
    }

    public final void batchDeleteAssets(String parent, List<String> names) {
        BatchDeleteAssetsRequest request = BatchDeleteAssetsRequest.newBuilder().setParent(parent).addAllNames(names).build();
        this.batchDeleteAssets(request);
    }

    public final void batchDeleteAssets(BatchDeleteAssetsRequest request) {
        this.batchDeleteAssetsCallable().call((Object)request);
    }

    public final UnaryCallable<BatchDeleteAssetsRequest, Empty> batchDeleteAssetsCallable() {
        return this.stub.batchDeleteAssetsCallable();
    }

    public final ReportAssetFramesResponse reportAssetFrames(ReportAssetFramesRequest request) {
        return (ReportAssetFramesResponse)this.reportAssetFramesCallable().call((Object)request);
    }

    public final UnaryCallable<ReportAssetFramesRequest, ReportAssetFramesResponse> reportAssetFramesCallable() {
        return this.stub.reportAssetFramesCallable();
    }

    public final AggregateAssetsValuesResponse aggregateAssetsValues(AggregateAssetsValuesRequest request) {
        return (AggregateAssetsValuesResponse)this.aggregateAssetsValuesCallable().call((Object)request);
    }

    public final UnaryCallable<AggregateAssetsValuesRequest, AggregateAssetsValuesResponse> aggregateAssetsValuesCallable() {
        return this.stub.aggregateAssetsValuesCallable();
    }

    public final OperationFuture<ImportJob, OperationMetadata> createImportJobAsync(LocationName parent, ImportJob importJob, String importJobId) {
        CreateImportJobRequest request = CreateImportJobRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setImportJob(importJob).setImportJobId(importJobId).build();
        return this.createImportJobAsync(request);
    }

    public final OperationFuture<ImportJob, OperationMetadata> createImportJobAsync(String parent, ImportJob importJob, String importJobId) {
        CreateImportJobRequest request = CreateImportJobRequest.newBuilder().setParent(parent).setImportJob(importJob).setImportJobId(importJobId).build();
        return this.createImportJobAsync(request);
    }

    public final OperationFuture<ImportJob, OperationMetadata> createImportJobAsync(CreateImportJobRequest request) {
        return this.createImportJobOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateImportJobRequest, ImportJob, OperationMetadata> createImportJobOperationCallable() {
        return this.stub.createImportJobOperationCallable();
    }

    public final UnaryCallable<CreateImportJobRequest, Operation> createImportJobCallable() {
        return this.stub.createImportJobCallable();
    }

    public final ListImportJobsPagedResponse listImportJobs(LocationName parent) {
        ListImportJobsRequest request = ListImportJobsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listImportJobs(request);
    }

    public final ListImportJobsPagedResponse listImportJobs(String parent) {
        ListImportJobsRequest request = ListImportJobsRequest.newBuilder().setParent(parent).build();
        return this.listImportJobs(request);
    }

    public final ListImportJobsPagedResponse listImportJobs(ListImportJobsRequest request) {
        return (ListImportJobsPagedResponse)((Object)this.listImportJobsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListImportJobsRequest, ListImportJobsPagedResponse> listImportJobsPagedCallable() {
        return this.stub.listImportJobsPagedCallable();
    }

    public final UnaryCallable<ListImportJobsRequest, ListImportJobsResponse> listImportJobsCallable() {
        return this.stub.listImportJobsCallable();
    }

    public final ImportJob getImportJob(ImportJobName name) {
        GetImportJobRequest request = GetImportJobRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getImportJob(request);
    }

    public final ImportJob getImportJob(String name) {
        GetImportJobRequest request = GetImportJobRequest.newBuilder().setName(name).build();
        return this.getImportJob(request);
    }

    public final ImportJob getImportJob(GetImportJobRequest request) {
        return (ImportJob)this.getImportJobCallable().call((Object)request);
    }

    public final UnaryCallable<GetImportJobRequest, ImportJob> getImportJobCallable() {
        return this.stub.getImportJobCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteImportJobAsync(ImportJobName name) {
        DeleteImportJobRequest request = DeleteImportJobRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteImportJobAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteImportJobAsync(String name) {
        DeleteImportJobRequest request = DeleteImportJobRequest.newBuilder().setName(name).build();
        return this.deleteImportJobAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteImportJobAsync(DeleteImportJobRequest request) {
        return this.deleteImportJobOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteImportJobRequest, Empty, OperationMetadata> deleteImportJobOperationCallable() {
        return this.stub.deleteImportJobOperationCallable();
    }

    public final UnaryCallable<DeleteImportJobRequest, Operation> deleteImportJobCallable() {
        return this.stub.deleteImportJobCallable();
    }

    public final OperationFuture<ImportJob, OperationMetadata> updateImportJobAsync(ImportJob importJob, FieldMask updateMask) {
        UpdateImportJobRequest request = UpdateImportJobRequest.newBuilder().setImportJob(importJob).setUpdateMask(updateMask).build();
        return this.updateImportJobAsync(request);
    }

    public final OperationFuture<ImportJob, OperationMetadata> updateImportJobAsync(UpdateImportJobRequest request) {
        return this.updateImportJobOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateImportJobRequest, ImportJob, OperationMetadata> updateImportJobOperationCallable() {
        return this.stub.updateImportJobOperationCallable();
    }

    public final UnaryCallable<UpdateImportJobRequest, Operation> updateImportJobCallable() {
        return this.stub.updateImportJobCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> validateImportJobAsync(ImportJobName name) {
        ValidateImportJobRequest request = ValidateImportJobRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.validateImportJobAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> validateImportJobAsync(String name) {
        ValidateImportJobRequest request = ValidateImportJobRequest.newBuilder().setName(name).build();
        return this.validateImportJobAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> validateImportJobAsync(ValidateImportJobRequest request) {
        return this.validateImportJobOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<ValidateImportJobRequest, Empty, OperationMetadata> validateImportJobOperationCallable() {
        return this.stub.validateImportJobOperationCallable();
    }

    public final UnaryCallable<ValidateImportJobRequest, Operation> validateImportJobCallable() {
        return this.stub.validateImportJobCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> runImportJobAsync(ImportJobName name) {
        RunImportJobRequest request = RunImportJobRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.runImportJobAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> runImportJobAsync(String name) {
        RunImportJobRequest request = RunImportJobRequest.newBuilder().setName(name).build();
        return this.runImportJobAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> runImportJobAsync(RunImportJobRequest request) {
        return this.runImportJobOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<RunImportJobRequest, Empty, OperationMetadata> runImportJobOperationCallable() {
        return this.stub.runImportJobOperationCallable();
    }

    public final UnaryCallable<RunImportJobRequest, Operation> runImportJobCallable() {
        return this.stub.runImportJobCallable();
    }

    public final ImportDataFile getImportDataFile(ImportDataFileName name) {
        GetImportDataFileRequest request = GetImportDataFileRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getImportDataFile(request);
    }

    public final ImportDataFile getImportDataFile(String name) {
        GetImportDataFileRequest request = GetImportDataFileRequest.newBuilder().setName(name).build();
        return this.getImportDataFile(request);
    }

    public final ImportDataFile getImportDataFile(GetImportDataFileRequest request) {
        return (ImportDataFile)this.getImportDataFileCallable().call((Object)request);
    }

    public final UnaryCallable<GetImportDataFileRequest, ImportDataFile> getImportDataFileCallable() {
        return this.stub.getImportDataFileCallable();
    }

    public final ListImportDataFilesPagedResponse listImportDataFiles(ImportJobName parent) {
        ListImportDataFilesRequest request = ListImportDataFilesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listImportDataFiles(request);
    }

    public final ListImportDataFilesPagedResponse listImportDataFiles(String parent) {
        ListImportDataFilesRequest request = ListImportDataFilesRequest.newBuilder().setParent(parent).build();
        return this.listImportDataFiles(request);
    }

    public final ListImportDataFilesPagedResponse listImportDataFiles(ListImportDataFilesRequest request) {
        return (ListImportDataFilesPagedResponse)((Object)this.listImportDataFilesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListImportDataFilesRequest, ListImportDataFilesPagedResponse> listImportDataFilesPagedCallable() {
        return this.stub.listImportDataFilesPagedCallable();
    }

    public final UnaryCallable<ListImportDataFilesRequest, ListImportDataFilesResponse> listImportDataFilesCallable() {
        return this.stub.listImportDataFilesCallable();
    }

    public final OperationFuture<ImportDataFile, OperationMetadata> createImportDataFileAsync(ImportJobName parent, ImportDataFile importDataFile, String importDataFileId) {
        CreateImportDataFileRequest request = CreateImportDataFileRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setImportDataFile(importDataFile).setImportDataFileId(importDataFileId).build();
        return this.createImportDataFileAsync(request);
    }

    public final OperationFuture<ImportDataFile, OperationMetadata> createImportDataFileAsync(String parent, ImportDataFile importDataFile, String importDataFileId) {
        CreateImportDataFileRequest request = CreateImportDataFileRequest.newBuilder().setParent(parent).setImportDataFile(importDataFile).setImportDataFileId(importDataFileId).build();
        return this.createImportDataFileAsync(request);
    }

    public final OperationFuture<ImportDataFile, OperationMetadata> createImportDataFileAsync(CreateImportDataFileRequest request) {
        return this.createImportDataFileOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateImportDataFileRequest, ImportDataFile, OperationMetadata> createImportDataFileOperationCallable() {
        return this.stub.createImportDataFileOperationCallable();
    }

    public final UnaryCallable<CreateImportDataFileRequest, Operation> createImportDataFileCallable() {
        return this.stub.createImportDataFileCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteImportDataFileAsync(ImportDataFileName name) {
        DeleteImportDataFileRequest request = DeleteImportDataFileRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteImportDataFileAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteImportDataFileAsync(String name) {
        DeleteImportDataFileRequest request = DeleteImportDataFileRequest.newBuilder().setName(name).build();
        return this.deleteImportDataFileAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteImportDataFileAsync(DeleteImportDataFileRequest request) {
        return this.deleteImportDataFileOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteImportDataFileRequest, Empty, OperationMetadata> deleteImportDataFileOperationCallable() {
        return this.stub.deleteImportDataFileOperationCallable();
    }

    public final UnaryCallable<DeleteImportDataFileRequest, Operation> deleteImportDataFileCallable() {
        return this.stub.deleteImportDataFileCallable();
    }

    public final ListGroupsPagedResponse listGroups(LocationName parent) {
        ListGroupsRequest request = ListGroupsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listGroups(request);
    }

    public final ListGroupsPagedResponse listGroups(String parent) {
        ListGroupsRequest request = ListGroupsRequest.newBuilder().setParent(parent).build();
        return this.listGroups(request);
    }

    public final ListGroupsPagedResponse listGroups(ListGroupsRequest request) {
        return (ListGroupsPagedResponse)((Object)this.listGroupsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListGroupsRequest, ListGroupsPagedResponse> listGroupsPagedCallable() {
        return this.stub.listGroupsPagedCallable();
    }

    public final UnaryCallable<ListGroupsRequest, ListGroupsResponse> listGroupsCallable() {
        return this.stub.listGroupsCallable();
    }

    public final Group getGroup(GroupName name) {
        GetGroupRequest request = GetGroupRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getGroup(request);
    }

    public final Group getGroup(String name) {
        GetGroupRequest request = GetGroupRequest.newBuilder().setName(name).build();
        return this.getGroup(request);
    }

    public final Group getGroup(GetGroupRequest request) {
        return (Group)this.getGroupCallable().call((Object)request);
    }

    public final UnaryCallable<GetGroupRequest, Group> getGroupCallable() {
        return this.stub.getGroupCallable();
    }

    public final OperationFuture<Group, OperationMetadata> createGroupAsync(LocationName parent, Group group, String groupId) {
        CreateGroupRequest request = CreateGroupRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setGroup(group).setGroupId(groupId).build();
        return this.createGroupAsync(request);
    }

    public final OperationFuture<Group, OperationMetadata> createGroupAsync(String parent, Group group, String groupId) {
        CreateGroupRequest request = CreateGroupRequest.newBuilder().setParent(parent).setGroup(group).setGroupId(groupId).build();
        return this.createGroupAsync(request);
    }

    public final OperationFuture<Group, OperationMetadata> createGroupAsync(CreateGroupRequest request) {
        return this.createGroupOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateGroupRequest, Group, OperationMetadata> createGroupOperationCallable() {
        return this.stub.createGroupOperationCallable();
    }

    public final UnaryCallable<CreateGroupRequest, Operation> createGroupCallable() {
        return this.stub.createGroupCallable();
    }

    public final OperationFuture<Group, OperationMetadata> updateGroupAsync(Group group, FieldMask updateMask) {
        UpdateGroupRequest request = UpdateGroupRequest.newBuilder().setGroup(group).setUpdateMask(updateMask).build();
        return this.updateGroupAsync(request);
    }

    public final OperationFuture<Group, OperationMetadata> updateGroupAsync(UpdateGroupRequest request) {
        return this.updateGroupOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateGroupRequest, Group, OperationMetadata> updateGroupOperationCallable() {
        return this.stub.updateGroupOperationCallable();
    }

    public final UnaryCallable<UpdateGroupRequest, Operation> updateGroupCallable() {
        return this.stub.updateGroupCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteGroupAsync(GroupName name) {
        DeleteGroupRequest request = DeleteGroupRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteGroupAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteGroupAsync(String name) {
        DeleteGroupRequest request = DeleteGroupRequest.newBuilder().setName(name).build();
        return this.deleteGroupAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteGroupAsync(DeleteGroupRequest request) {
        return this.deleteGroupOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteGroupRequest, Empty, OperationMetadata> deleteGroupOperationCallable() {
        return this.stub.deleteGroupOperationCallable();
    }

    public final UnaryCallable<DeleteGroupRequest, Operation> deleteGroupCallable() {
        return this.stub.deleteGroupCallable();
    }

    public final OperationFuture<Group, OperationMetadata> addAssetsToGroupAsync(GroupName group) {
        AddAssetsToGroupRequest request = AddAssetsToGroupRequest.newBuilder().setGroup(group == null ? null : group.toString()).build();
        return this.addAssetsToGroupAsync(request);
    }

    public final OperationFuture<Group, OperationMetadata> addAssetsToGroupAsync(String group) {
        AddAssetsToGroupRequest request = AddAssetsToGroupRequest.newBuilder().setGroup(group).build();
        return this.addAssetsToGroupAsync(request);
    }

    public final OperationFuture<Group, OperationMetadata> addAssetsToGroupAsync(AddAssetsToGroupRequest request) {
        return this.addAssetsToGroupOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<AddAssetsToGroupRequest, Group, OperationMetadata> addAssetsToGroupOperationCallable() {
        return this.stub.addAssetsToGroupOperationCallable();
    }

    public final UnaryCallable<AddAssetsToGroupRequest, Operation> addAssetsToGroupCallable() {
        return this.stub.addAssetsToGroupCallable();
    }

    public final OperationFuture<Group, OperationMetadata> removeAssetsFromGroupAsync(GroupName group) {
        RemoveAssetsFromGroupRequest request = RemoveAssetsFromGroupRequest.newBuilder().setGroup(group == null ? null : group.toString()).build();
        return this.removeAssetsFromGroupAsync(request);
    }

    public final OperationFuture<Group, OperationMetadata> removeAssetsFromGroupAsync(String group) {
        RemoveAssetsFromGroupRequest request = RemoveAssetsFromGroupRequest.newBuilder().setGroup(group).build();
        return this.removeAssetsFromGroupAsync(request);
    }

    public final OperationFuture<Group, OperationMetadata> removeAssetsFromGroupAsync(RemoveAssetsFromGroupRequest request) {
        return this.removeAssetsFromGroupOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<RemoveAssetsFromGroupRequest, Group, OperationMetadata> removeAssetsFromGroupOperationCallable() {
        return this.stub.removeAssetsFromGroupOperationCallable();
    }

    public final UnaryCallable<RemoveAssetsFromGroupRequest, Operation> removeAssetsFromGroupCallable() {
        return this.stub.removeAssetsFromGroupCallable();
    }

    public final ListErrorFramesPagedResponse listErrorFrames(SourceName parent) {
        ListErrorFramesRequest request = ListErrorFramesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listErrorFrames(request);
    }

    public final ListErrorFramesPagedResponse listErrorFrames(String parent) {
        ListErrorFramesRequest request = ListErrorFramesRequest.newBuilder().setParent(parent).build();
        return this.listErrorFrames(request);
    }

    public final ListErrorFramesPagedResponse listErrorFrames(ListErrorFramesRequest request) {
        return (ListErrorFramesPagedResponse)((Object)this.listErrorFramesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListErrorFramesRequest, ListErrorFramesPagedResponse> listErrorFramesPagedCallable() {
        return this.stub.listErrorFramesPagedCallable();
    }

    public final UnaryCallable<ListErrorFramesRequest, ListErrorFramesResponse> listErrorFramesCallable() {
        return this.stub.listErrorFramesCallable();
    }

    public final ErrorFrame getErrorFrame(ErrorFrameName name) {
        GetErrorFrameRequest request = GetErrorFrameRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getErrorFrame(request);
    }

    public final ErrorFrame getErrorFrame(String name) {
        GetErrorFrameRequest request = GetErrorFrameRequest.newBuilder().setName(name).build();
        return this.getErrorFrame(request);
    }

    public final ErrorFrame getErrorFrame(GetErrorFrameRequest request) {
        return (ErrorFrame)this.getErrorFrameCallable().call((Object)request);
    }

    public final UnaryCallable<GetErrorFrameRequest, ErrorFrame> getErrorFrameCallable() {
        return this.stub.getErrorFrameCallable();
    }

    public final ListSourcesPagedResponse listSources(LocationName parent) {
        ListSourcesRequest request = ListSourcesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listSources(request);
    }

    public final ListSourcesPagedResponse listSources(String parent) {
        ListSourcesRequest request = ListSourcesRequest.newBuilder().setParent(parent).build();
        return this.listSources(request);
    }

    public final ListSourcesPagedResponse listSources(ListSourcesRequest request) {
        return (ListSourcesPagedResponse)((Object)this.listSourcesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListSourcesRequest, ListSourcesPagedResponse> listSourcesPagedCallable() {
        return this.stub.listSourcesPagedCallable();
    }

    public final UnaryCallable<ListSourcesRequest, ListSourcesResponse> listSourcesCallable() {
        return this.stub.listSourcesCallable();
    }

    public final Source getSource(SourceName name) {
        GetSourceRequest request = GetSourceRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getSource(request);
    }

    public final Source getSource(String name) {
        GetSourceRequest request = GetSourceRequest.newBuilder().setName(name).build();
        return this.getSource(request);
    }

    public final Source getSource(GetSourceRequest request) {
        return (Source)this.getSourceCallable().call((Object)request);
    }

    public final UnaryCallable<GetSourceRequest, Source> getSourceCallable() {
        return this.stub.getSourceCallable();
    }

    public final OperationFuture<Source, OperationMetadata> createSourceAsync(LocationName parent, Source source, String sourceId) {
        CreateSourceRequest request = CreateSourceRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setSource(source).setSourceId(sourceId).build();
        return this.createSourceAsync(request);
    }

    public final OperationFuture<Source, OperationMetadata> createSourceAsync(String parent, Source source, String sourceId) {
        CreateSourceRequest request = CreateSourceRequest.newBuilder().setParent(parent).setSource(source).setSourceId(sourceId).build();
        return this.createSourceAsync(request);
    }

    public final OperationFuture<Source, OperationMetadata> createSourceAsync(CreateSourceRequest request) {
        return this.createSourceOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateSourceRequest, Source, OperationMetadata> createSourceOperationCallable() {
        return this.stub.createSourceOperationCallable();
    }

    public final UnaryCallable<CreateSourceRequest, Operation> createSourceCallable() {
        return this.stub.createSourceCallable();
    }

    public final OperationFuture<Source, OperationMetadata> updateSourceAsync(Source source, FieldMask updateMask) {
        UpdateSourceRequest request = UpdateSourceRequest.newBuilder().setSource(source).setUpdateMask(updateMask).build();
        return this.updateSourceAsync(request);
    }

    public final OperationFuture<Source, OperationMetadata> updateSourceAsync(UpdateSourceRequest request) {
        return this.updateSourceOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateSourceRequest, Source, OperationMetadata> updateSourceOperationCallable() {
        return this.stub.updateSourceOperationCallable();
    }

    public final UnaryCallable<UpdateSourceRequest, Operation> updateSourceCallable() {
        return this.stub.updateSourceCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteSourceAsync(SourceName name) {
        DeleteSourceRequest request = DeleteSourceRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteSourceAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteSourceAsync(String name) {
        DeleteSourceRequest request = DeleteSourceRequest.newBuilder().setName(name).build();
        return this.deleteSourceAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteSourceAsync(DeleteSourceRequest request) {
        return this.deleteSourceOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteSourceRequest, Empty, OperationMetadata> deleteSourceOperationCallable() {
        return this.stub.deleteSourceOperationCallable();
    }

    public final UnaryCallable<DeleteSourceRequest, Operation> deleteSourceCallable() {
        return this.stub.deleteSourceCallable();
    }

    public final ListPreferenceSetsPagedResponse listPreferenceSets(LocationName parent) {
        ListPreferenceSetsRequest request = ListPreferenceSetsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listPreferenceSets(request);
    }

    public final ListPreferenceSetsPagedResponse listPreferenceSets(String parent) {
        ListPreferenceSetsRequest request = ListPreferenceSetsRequest.newBuilder().setParent(parent).build();
        return this.listPreferenceSets(request);
    }

    public final ListPreferenceSetsPagedResponse listPreferenceSets(ListPreferenceSetsRequest request) {
        return (ListPreferenceSetsPagedResponse)((Object)this.listPreferenceSetsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListPreferenceSetsRequest, ListPreferenceSetsPagedResponse> listPreferenceSetsPagedCallable() {
        return this.stub.listPreferenceSetsPagedCallable();
    }

    public final UnaryCallable<ListPreferenceSetsRequest, ListPreferenceSetsResponse> listPreferenceSetsCallable() {
        return this.stub.listPreferenceSetsCallable();
    }

    public final PreferenceSet getPreferenceSet(PreferenceSetName name) {
        GetPreferenceSetRequest request = GetPreferenceSetRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getPreferenceSet(request);
    }

    public final PreferenceSet getPreferenceSet(String name) {
        GetPreferenceSetRequest request = GetPreferenceSetRequest.newBuilder().setName(name).build();
        return this.getPreferenceSet(request);
    }

    public final PreferenceSet getPreferenceSet(GetPreferenceSetRequest request) {
        return (PreferenceSet)this.getPreferenceSetCallable().call((Object)request);
    }

    public final UnaryCallable<GetPreferenceSetRequest, PreferenceSet> getPreferenceSetCallable() {
        return this.stub.getPreferenceSetCallable();
    }

    public final OperationFuture<PreferenceSet, OperationMetadata> createPreferenceSetAsync(LocationName parent, PreferenceSet preferenceSet, String preferenceSetId) {
        CreatePreferenceSetRequest request = CreatePreferenceSetRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setPreferenceSet(preferenceSet).setPreferenceSetId(preferenceSetId).build();
        return this.createPreferenceSetAsync(request);
    }

    public final OperationFuture<PreferenceSet, OperationMetadata> createPreferenceSetAsync(String parent, PreferenceSet preferenceSet, String preferenceSetId) {
        CreatePreferenceSetRequest request = CreatePreferenceSetRequest.newBuilder().setParent(parent).setPreferenceSet(preferenceSet).setPreferenceSetId(preferenceSetId).build();
        return this.createPreferenceSetAsync(request);
    }

    public final OperationFuture<PreferenceSet, OperationMetadata> createPreferenceSetAsync(CreatePreferenceSetRequest request) {
        return this.createPreferenceSetOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreatePreferenceSetRequest, PreferenceSet, OperationMetadata> createPreferenceSetOperationCallable() {
        return this.stub.createPreferenceSetOperationCallable();
    }

    public final UnaryCallable<CreatePreferenceSetRequest, Operation> createPreferenceSetCallable() {
        return this.stub.createPreferenceSetCallable();
    }

    public final OperationFuture<PreferenceSet, OperationMetadata> updatePreferenceSetAsync(PreferenceSet preferenceSet, FieldMask updateMask) {
        UpdatePreferenceSetRequest request = UpdatePreferenceSetRequest.newBuilder().setPreferenceSet(preferenceSet).setUpdateMask(updateMask).build();
        return this.updatePreferenceSetAsync(request);
    }

    public final OperationFuture<PreferenceSet, OperationMetadata> updatePreferenceSetAsync(UpdatePreferenceSetRequest request) {
        return this.updatePreferenceSetOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdatePreferenceSetRequest, PreferenceSet, OperationMetadata> updatePreferenceSetOperationCallable() {
        return this.stub.updatePreferenceSetOperationCallable();
    }

    public final UnaryCallable<UpdatePreferenceSetRequest, Operation> updatePreferenceSetCallable() {
        return this.stub.updatePreferenceSetCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deletePreferenceSetAsync(PreferenceSetName name) {
        DeletePreferenceSetRequest request = DeletePreferenceSetRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deletePreferenceSetAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deletePreferenceSetAsync(String name) {
        DeletePreferenceSetRequest request = DeletePreferenceSetRequest.newBuilder().setName(name).build();
        return this.deletePreferenceSetAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deletePreferenceSetAsync(DeletePreferenceSetRequest request) {
        return this.deletePreferenceSetOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeletePreferenceSetRequest, Empty, OperationMetadata> deletePreferenceSetOperationCallable() {
        return this.stub.deletePreferenceSetOperationCallable();
    }

    public final UnaryCallable<DeletePreferenceSetRequest, Operation> deletePreferenceSetCallable() {
        return this.stub.deletePreferenceSetCallable();
    }

    public final Settings getSettings(SettingsName name) {
        GetSettingsRequest request = GetSettingsRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getSettings(request);
    }

    public final Settings getSettings(String name) {
        GetSettingsRequest request = GetSettingsRequest.newBuilder().setName(name).build();
        return this.getSettings(request);
    }

    public final Settings getSettings(GetSettingsRequest request) {
        return (Settings)this.getSettingsCallable().call((Object)request);
    }

    public final UnaryCallable<GetSettingsRequest, Settings> getSettingsCallable() {
        return this.stub.getSettingsCallable();
    }

    public final OperationFuture<Settings, OperationMetadata> updateSettingsAsync(Settings settings, FieldMask updateMask) {
        UpdateSettingsRequest request = UpdateSettingsRequest.newBuilder().setSettings(settings).setUpdateMask(updateMask).build();
        return this.updateSettingsAsync(request);
    }

    public final OperationFuture<Settings, OperationMetadata> updateSettingsAsync(UpdateSettingsRequest request) {
        return this.updateSettingsOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateSettingsRequest, Settings, OperationMetadata> updateSettingsOperationCallable() {
        return this.stub.updateSettingsOperationCallable();
    }

    public final UnaryCallable<UpdateSettingsRequest, Operation> updateSettingsCallable() {
        return this.stub.updateSettingsCallable();
    }

    public final OperationFuture<ReportConfig, OperationMetadata> createReportConfigAsync(LocationName parent, ReportConfig reportConfig, String reportConfigId) {
        CreateReportConfigRequest request = CreateReportConfigRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setReportConfig(reportConfig).setReportConfigId(reportConfigId).build();
        return this.createReportConfigAsync(request);
    }

    public final OperationFuture<ReportConfig, OperationMetadata> createReportConfigAsync(String parent, ReportConfig reportConfig, String reportConfigId) {
        CreateReportConfigRequest request = CreateReportConfigRequest.newBuilder().setParent(parent).setReportConfig(reportConfig).setReportConfigId(reportConfigId).build();
        return this.createReportConfigAsync(request);
    }

    public final OperationFuture<ReportConfig, OperationMetadata> createReportConfigAsync(CreateReportConfigRequest request) {
        return this.createReportConfigOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateReportConfigRequest, ReportConfig, OperationMetadata> createReportConfigOperationCallable() {
        return this.stub.createReportConfigOperationCallable();
    }

    public final UnaryCallable<CreateReportConfigRequest, Operation> createReportConfigCallable() {
        return this.stub.createReportConfigCallable();
    }

    public final ReportConfig getReportConfig(ReportConfigName name) {
        GetReportConfigRequest request = GetReportConfigRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getReportConfig(request);
    }

    public final ReportConfig getReportConfig(String name) {
        GetReportConfigRequest request = GetReportConfigRequest.newBuilder().setName(name).build();
        return this.getReportConfig(request);
    }

    public final ReportConfig getReportConfig(GetReportConfigRequest request) {
        return (ReportConfig)this.getReportConfigCallable().call((Object)request);
    }

    public final UnaryCallable<GetReportConfigRequest, ReportConfig> getReportConfigCallable() {
        return this.stub.getReportConfigCallable();
    }

    public final ListReportConfigsPagedResponse listReportConfigs(LocationName parent) {
        ListReportConfigsRequest request = ListReportConfigsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listReportConfigs(request);
    }

    public final ListReportConfigsPagedResponse listReportConfigs(String parent) {
        ListReportConfigsRequest request = ListReportConfigsRequest.newBuilder().setParent(parent).build();
        return this.listReportConfigs(request);
    }

    public final ListReportConfigsPagedResponse listReportConfigs(ListReportConfigsRequest request) {
        return (ListReportConfigsPagedResponse)((Object)this.listReportConfigsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListReportConfigsRequest, ListReportConfigsPagedResponse> listReportConfigsPagedCallable() {
        return this.stub.listReportConfigsPagedCallable();
    }

    public final UnaryCallable<ListReportConfigsRequest, ListReportConfigsResponse> listReportConfigsCallable() {
        return this.stub.listReportConfigsCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteReportConfigAsync(ReportConfigName name) {
        DeleteReportConfigRequest request = DeleteReportConfigRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteReportConfigAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteReportConfigAsync(String name) {
        DeleteReportConfigRequest request = DeleteReportConfigRequest.newBuilder().setName(name).build();
        return this.deleteReportConfigAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteReportConfigAsync(DeleteReportConfigRequest request) {
        return this.deleteReportConfigOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteReportConfigRequest, Empty, OperationMetadata> deleteReportConfigOperationCallable() {
        return this.stub.deleteReportConfigOperationCallable();
    }

    public final UnaryCallable<DeleteReportConfigRequest, Operation> deleteReportConfigCallable() {
        return this.stub.deleteReportConfigCallable();
    }

    public final OperationFuture<Report, OperationMetadata> createReportAsync(ReportConfigName parent, Report report, String reportId) {
        CreateReportRequest request = CreateReportRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setReport(report).setReportId(reportId).build();
        return this.createReportAsync(request);
    }

    public final OperationFuture<Report, OperationMetadata> createReportAsync(String parent, Report report, String reportId) {
        CreateReportRequest request = CreateReportRequest.newBuilder().setParent(parent).setReport(report).setReportId(reportId).build();
        return this.createReportAsync(request);
    }

    public final OperationFuture<Report, OperationMetadata> createReportAsync(CreateReportRequest request) {
        return this.createReportOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateReportRequest, Report, OperationMetadata> createReportOperationCallable() {
        return this.stub.createReportOperationCallable();
    }

    public final UnaryCallable<CreateReportRequest, Operation> createReportCallable() {
        return this.stub.createReportCallable();
    }

    public final Report getReport(ReportName name) {
        GetReportRequest request = GetReportRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getReport(request);
    }

    public final Report getReport(String name) {
        GetReportRequest request = GetReportRequest.newBuilder().setName(name).build();
        return this.getReport(request);
    }

    public final Report getReport(GetReportRequest request) {
        return (Report)this.getReportCallable().call((Object)request);
    }

    public final UnaryCallable<GetReportRequest, Report> getReportCallable() {
        return this.stub.getReportCallable();
    }

    public final ListReportsPagedResponse listReports(ReportConfigName parent) {
        ListReportsRequest request = ListReportsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listReports(request);
    }

    public final ListReportsPagedResponse listReports(String parent) {
        ListReportsRequest request = ListReportsRequest.newBuilder().setParent(parent).build();
        return this.listReports(request);
    }

    public final ListReportsPagedResponse listReports(ListReportsRequest request) {
        return (ListReportsPagedResponse)((Object)this.listReportsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListReportsRequest, ListReportsPagedResponse> listReportsPagedCallable() {
        return this.stub.listReportsPagedCallable();
    }

    public final UnaryCallable<ListReportsRequest, ListReportsResponse> listReportsCallable() {
        return this.stub.listReportsCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteReportAsync(ReportName name) {
        DeleteReportRequest request = DeleteReportRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteReportAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteReportAsync(String name) {
        DeleteReportRequest request = DeleteReportRequest.newBuilder().setName(name).build();
        return this.deleteReportAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteReportAsync(DeleteReportRequest request) {
        return this.deleteReportOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteReportRequest, Empty, OperationMetadata> deleteReportOperationCallable() {
        return this.stub.deleteReportOperationCallable();
    }

    public final UnaryCallable<DeleteReportRequest, Operation> deleteReportCallable() {
        return this.stub.deleteReportCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListReportsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListReportsRequest, ListReportsResponse, Report, ListReportsPage, ListReportsFixedSizeCollection> {
        private ListReportsFixedSizeCollection(List<ListReportsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListReportsFixedSizeCollection createEmptyCollection() {
            return new ListReportsFixedSizeCollection(null, 0);
        }

        protected ListReportsFixedSizeCollection createCollection(List<ListReportsPage> pages, int collectionSize) {
            return new ListReportsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListReportsPage
    extends AbstractPage<ListReportsRequest, ListReportsResponse, Report, ListReportsPage> {
        private ListReportsPage(PageContext<ListReportsRequest, ListReportsResponse, Report> context, ListReportsResponse response) {
            super(context, (Object)response);
        }

        private static ListReportsPage createEmptyPage() {
            return new ListReportsPage(null, null);
        }

        protected ListReportsPage createPage(PageContext<ListReportsRequest, ListReportsResponse, Report> context, ListReportsResponse response) {
            return new ListReportsPage(context, response);
        }

        public ApiFuture<ListReportsPage> createPageAsync(PageContext<ListReportsRequest, ListReportsResponse, Report> context, ApiFuture<ListReportsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListReportsPagedResponse
    extends AbstractPagedListResponse<ListReportsRequest, ListReportsResponse, Report, ListReportsPage, ListReportsFixedSizeCollection> {
        public static ApiFuture<ListReportsPagedResponse> createAsync(PageContext<ListReportsRequest, ListReportsResponse, Report> context, ApiFuture<ListReportsResponse> futureResponse) {
            ApiFuture<ListReportsPage> futurePage = ListReportsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListReportsPagedResponse((ListReportsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListReportsPagedResponse(ListReportsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListReportsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListReportConfigsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListReportConfigsRequest, ListReportConfigsResponse, ReportConfig, ListReportConfigsPage, ListReportConfigsFixedSizeCollection> {
        private ListReportConfigsFixedSizeCollection(List<ListReportConfigsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListReportConfigsFixedSizeCollection createEmptyCollection() {
            return new ListReportConfigsFixedSizeCollection(null, 0);
        }

        protected ListReportConfigsFixedSizeCollection createCollection(List<ListReportConfigsPage> pages, int collectionSize) {
            return new ListReportConfigsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListReportConfigsPage
    extends AbstractPage<ListReportConfigsRequest, ListReportConfigsResponse, ReportConfig, ListReportConfigsPage> {
        private ListReportConfigsPage(PageContext<ListReportConfigsRequest, ListReportConfigsResponse, ReportConfig> context, ListReportConfigsResponse response) {
            super(context, (Object)response);
        }

        private static ListReportConfigsPage createEmptyPage() {
            return new ListReportConfigsPage(null, null);
        }

        protected ListReportConfigsPage createPage(PageContext<ListReportConfigsRequest, ListReportConfigsResponse, ReportConfig> context, ListReportConfigsResponse response) {
            return new ListReportConfigsPage(context, response);
        }

        public ApiFuture<ListReportConfigsPage> createPageAsync(PageContext<ListReportConfigsRequest, ListReportConfigsResponse, ReportConfig> context, ApiFuture<ListReportConfigsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListReportConfigsPagedResponse
    extends AbstractPagedListResponse<ListReportConfigsRequest, ListReportConfigsResponse, ReportConfig, ListReportConfigsPage, ListReportConfigsFixedSizeCollection> {
        public static ApiFuture<ListReportConfigsPagedResponse> createAsync(PageContext<ListReportConfigsRequest, ListReportConfigsResponse, ReportConfig> context, ApiFuture<ListReportConfigsResponse> futureResponse) {
            ApiFuture<ListReportConfigsPage> futurePage = ListReportConfigsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListReportConfigsPagedResponse((ListReportConfigsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListReportConfigsPagedResponse(ListReportConfigsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListReportConfigsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListPreferenceSetsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListPreferenceSetsRequest, ListPreferenceSetsResponse, PreferenceSet, ListPreferenceSetsPage, ListPreferenceSetsFixedSizeCollection> {
        private ListPreferenceSetsFixedSizeCollection(List<ListPreferenceSetsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListPreferenceSetsFixedSizeCollection createEmptyCollection() {
            return new ListPreferenceSetsFixedSizeCollection(null, 0);
        }

        protected ListPreferenceSetsFixedSizeCollection createCollection(List<ListPreferenceSetsPage> pages, int collectionSize) {
            return new ListPreferenceSetsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPreferenceSetsPage
    extends AbstractPage<ListPreferenceSetsRequest, ListPreferenceSetsResponse, PreferenceSet, ListPreferenceSetsPage> {
        private ListPreferenceSetsPage(PageContext<ListPreferenceSetsRequest, ListPreferenceSetsResponse, PreferenceSet> context, ListPreferenceSetsResponse response) {
            super(context, (Object)response);
        }

        private static ListPreferenceSetsPage createEmptyPage() {
            return new ListPreferenceSetsPage(null, null);
        }

        protected ListPreferenceSetsPage createPage(PageContext<ListPreferenceSetsRequest, ListPreferenceSetsResponse, PreferenceSet> context, ListPreferenceSetsResponse response) {
            return new ListPreferenceSetsPage(context, response);
        }

        public ApiFuture<ListPreferenceSetsPage> createPageAsync(PageContext<ListPreferenceSetsRequest, ListPreferenceSetsResponse, PreferenceSet> context, ApiFuture<ListPreferenceSetsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPreferenceSetsPagedResponse
    extends AbstractPagedListResponse<ListPreferenceSetsRequest, ListPreferenceSetsResponse, PreferenceSet, ListPreferenceSetsPage, ListPreferenceSetsFixedSizeCollection> {
        public static ApiFuture<ListPreferenceSetsPagedResponse> createAsync(PageContext<ListPreferenceSetsRequest, ListPreferenceSetsResponse, PreferenceSet> context, ApiFuture<ListPreferenceSetsResponse> futureResponse) {
            ApiFuture<ListPreferenceSetsPage> futurePage = ListPreferenceSetsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPreferenceSetsPagedResponse((ListPreferenceSetsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPreferenceSetsPagedResponse(ListPreferenceSetsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListPreferenceSetsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListSourcesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListSourcesRequest, ListSourcesResponse, Source, ListSourcesPage, ListSourcesFixedSizeCollection> {
        private ListSourcesFixedSizeCollection(List<ListSourcesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListSourcesFixedSizeCollection createEmptyCollection() {
            return new ListSourcesFixedSizeCollection(null, 0);
        }

        protected ListSourcesFixedSizeCollection createCollection(List<ListSourcesPage> pages, int collectionSize) {
            return new ListSourcesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListSourcesPage
    extends AbstractPage<ListSourcesRequest, ListSourcesResponse, Source, ListSourcesPage> {
        private ListSourcesPage(PageContext<ListSourcesRequest, ListSourcesResponse, Source> context, ListSourcesResponse response) {
            super(context, (Object)response);
        }

        private static ListSourcesPage createEmptyPage() {
            return new ListSourcesPage(null, null);
        }

        protected ListSourcesPage createPage(PageContext<ListSourcesRequest, ListSourcesResponse, Source> context, ListSourcesResponse response) {
            return new ListSourcesPage(context, response);
        }

        public ApiFuture<ListSourcesPage> createPageAsync(PageContext<ListSourcesRequest, ListSourcesResponse, Source> context, ApiFuture<ListSourcesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListSourcesPagedResponse
    extends AbstractPagedListResponse<ListSourcesRequest, ListSourcesResponse, Source, ListSourcesPage, ListSourcesFixedSizeCollection> {
        public static ApiFuture<ListSourcesPagedResponse> createAsync(PageContext<ListSourcesRequest, ListSourcesResponse, Source> context, ApiFuture<ListSourcesResponse> futureResponse) {
            ApiFuture<ListSourcesPage> futurePage = ListSourcesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListSourcesPagedResponse((ListSourcesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListSourcesPagedResponse(ListSourcesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListSourcesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListErrorFramesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListErrorFramesRequest, ListErrorFramesResponse, ErrorFrame, ListErrorFramesPage, ListErrorFramesFixedSizeCollection> {
        private ListErrorFramesFixedSizeCollection(List<ListErrorFramesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListErrorFramesFixedSizeCollection createEmptyCollection() {
            return new ListErrorFramesFixedSizeCollection(null, 0);
        }

        protected ListErrorFramesFixedSizeCollection createCollection(List<ListErrorFramesPage> pages, int collectionSize) {
            return new ListErrorFramesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListErrorFramesPage
    extends AbstractPage<ListErrorFramesRequest, ListErrorFramesResponse, ErrorFrame, ListErrorFramesPage> {
        private ListErrorFramesPage(PageContext<ListErrorFramesRequest, ListErrorFramesResponse, ErrorFrame> context, ListErrorFramesResponse response) {
            super(context, (Object)response);
        }

        private static ListErrorFramesPage createEmptyPage() {
            return new ListErrorFramesPage(null, null);
        }

        protected ListErrorFramesPage createPage(PageContext<ListErrorFramesRequest, ListErrorFramesResponse, ErrorFrame> context, ListErrorFramesResponse response) {
            return new ListErrorFramesPage(context, response);
        }

        public ApiFuture<ListErrorFramesPage> createPageAsync(PageContext<ListErrorFramesRequest, ListErrorFramesResponse, ErrorFrame> context, ApiFuture<ListErrorFramesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListErrorFramesPagedResponse
    extends AbstractPagedListResponse<ListErrorFramesRequest, ListErrorFramesResponse, ErrorFrame, ListErrorFramesPage, ListErrorFramesFixedSizeCollection> {
        public static ApiFuture<ListErrorFramesPagedResponse> createAsync(PageContext<ListErrorFramesRequest, ListErrorFramesResponse, ErrorFrame> context, ApiFuture<ListErrorFramesResponse> futureResponse) {
            ApiFuture<ListErrorFramesPage> futurePage = ListErrorFramesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListErrorFramesPagedResponse((ListErrorFramesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListErrorFramesPagedResponse(ListErrorFramesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListErrorFramesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListGroupsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListGroupsRequest, ListGroupsResponse, Group, ListGroupsPage, ListGroupsFixedSizeCollection> {
        private ListGroupsFixedSizeCollection(List<ListGroupsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListGroupsFixedSizeCollection createEmptyCollection() {
            return new ListGroupsFixedSizeCollection(null, 0);
        }

        protected ListGroupsFixedSizeCollection createCollection(List<ListGroupsPage> pages, int collectionSize) {
            return new ListGroupsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListGroupsPage
    extends AbstractPage<ListGroupsRequest, ListGroupsResponse, Group, ListGroupsPage> {
        private ListGroupsPage(PageContext<ListGroupsRequest, ListGroupsResponse, Group> context, ListGroupsResponse response) {
            super(context, (Object)response);
        }

        private static ListGroupsPage createEmptyPage() {
            return new ListGroupsPage(null, null);
        }

        protected ListGroupsPage createPage(PageContext<ListGroupsRequest, ListGroupsResponse, Group> context, ListGroupsResponse response) {
            return new ListGroupsPage(context, response);
        }

        public ApiFuture<ListGroupsPage> createPageAsync(PageContext<ListGroupsRequest, ListGroupsResponse, Group> context, ApiFuture<ListGroupsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListGroupsPagedResponse
    extends AbstractPagedListResponse<ListGroupsRequest, ListGroupsResponse, Group, ListGroupsPage, ListGroupsFixedSizeCollection> {
        public static ApiFuture<ListGroupsPagedResponse> createAsync(PageContext<ListGroupsRequest, ListGroupsResponse, Group> context, ApiFuture<ListGroupsResponse> futureResponse) {
            ApiFuture<ListGroupsPage> futurePage = ListGroupsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListGroupsPagedResponse((ListGroupsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListGroupsPagedResponse(ListGroupsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListGroupsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListImportDataFilesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListImportDataFilesRequest, ListImportDataFilesResponse, ImportDataFile, ListImportDataFilesPage, ListImportDataFilesFixedSizeCollection> {
        private ListImportDataFilesFixedSizeCollection(List<ListImportDataFilesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListImportDataFilesFixedSizeCollection createEmptyCollection() {
            return new ListImportDataFilesFixedSizeCollection(null, 0);
        }

        protected ListImportDataFilesFixedSizeCollection createCollection(List<ListImportDataFilesPage> pages, int collectionSize) {
            return new ListImportDataFilesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListImportDataFilesPage
    extends AbstractPage<ListImportDataFilesRequest, ListImportDataFilesResponse, ImportDataFile, ListImportDataFilesPage> {
        private ListImportDataFilesPage(PageContext<ListImportDataFilesRequest, ListImportDataFilesResponse, ImportDataFile> context, ListImportDataFilesResponse response) {
            super(context, (Object)response);
        }

        private static ListImportDataFilesPage createEmptyPage() {
            return new ListImportDataFilesPage(null, null);
        }

        protected ListImportDataFilesPage createPage(PageContext<ListImportDataFilesRequest, ListImportDataFilesResponse, ImportDataFile> context, ListImportDataFilesResponse response) {
            return new ListImportDataFilesPage(context, response);
        }

        public ApiFuture<ListImportDataFilesPage> createPageAsync(PageContext<ListImportDataFilesRequest, ListImportDataFilesResponse, ImportDataFile> context, ApiFuture<ListImportDataFilesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListImportDataFilesPagedResponse
    extends AbstractPagedListResponse<ListImportDataFilesRequest, ListImportDataFilesResponse, ImportDataFile, ListImportDataFilesPage, ListImportDataFilesFixedSizeCollection> {
        public static ApiFuture<ListImportDataFilesPagedResponse> createAsync(PageContext<ListImportDataFilesRequest, ListImportDataFilesResponse, ImportDataFile> context, ApiFuture<ListImportDataFilesResponse> futureResponse) {
            ApiFuture<ListImportDataFilesPage> futurePage = ListImportDataFilesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListImportDataFilesPagedResponse((ListImportDataFilesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListImportDataFilesPagedResponse(ListImportDataFilesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListImportDataFilesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListImportJobsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListImportJobsRequest, ListImportJobsResponse, ImportJob, ListImportJobsPage, ListImportJobsFixedSizeCollection> {
        private ListImportJobsFixedSizeCollection(List<ListImportJobsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListImportJobsFixedSizeCollection createEmptyCollection() {
            return new ListImportJobsFixedSizeCollection(null, 0);
        }

        protected ListImportJobsFixedSizeCollection createCollection(List<ListImportJobsPage> pages, int collectionSize) {
            return new ListImportJobsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListImportJobsPage
    extends AbstractPage<ListImportJobsRequest, ListImportJobsResponse, ImportJob, ListImportJobsPage> {
        private ListImportJobsPage(PageContext<ListImportJobsRequest, ListImportJobsResponse, ImportJob> context, ListImportJobsResponse response) {
            super(context, (Object)response);
        }

        private static ListImportJobsPage createEmptyPage() {
            return new ListImportJobsPage(null, null);
        }

        protected ListImportJobsPage createPage(PageContext<ListImportJobsRequest, ListImportJobsResponse, ImportJob> context, ListImportJobsResponse response) {
            return new ListImportJobsPage(context, response);
        }

        public ApiFuture<ListImportJobsPage> createPageAsync(PageContext<ListImportJobsRequest, ListImportJobsResponse, ImportJob> context, ApiFuture<ListImportJobsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListImportJobsPagedResponse
    extends AbstractPagedListResponse<ListImportJobsRequest, ListImportJobsResponse, ImportJob, ListImportJobsPage, ListImportJobsFixedSizeCollection> {
        public static ApiFuture<ListImportJobsPagedResponse> createAsync(PageContext<ListImportJobsRequest, ListImportJobsResponse, ImportJob> context, ApiFuture<ListImportJobsResponse> futureResponse) {
            ApiFuture<ListImportJobsPage> futurePage = ListImportJobsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListImportJobsPagedResponse((ListImportJobsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListImportJobsPagedResponse(ListImportJobsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListImportJobsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListAssetsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListAssetsRequest, ListAssetsResponse, Asset, ListAssetsPage, ListAssetsFixedSizeCollection> {
        private ListAssetsFixedSizeCollection(List<ListAssetsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListAssetsFixedSizeCollection createEmptyCollection() {
            return new ListAssetsFixedSizeCollection(null, 0);
        }

        protected ListAssetsFixedSizeCollection createCollection(List<ListAssetsPage> pages, int collectionSize) {
            return new ListAssetsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListAssetsPage
    extends AbstractPage<ListAssetsRequest, ListAssetsResponse, Asset, ListAssetsPage> {
        private ListAssetsPage(PageContext<ListAssetsRequest, ListAssetsResponse, Asset> context, ListAssetsResponse response) {
            super(context, (Object)response);
        }

        private static ListAssetsPage createEmptyPage() {
            return new ListAssetsPage(null, null);
        }

        protected ListAssetsPage createPage(PageContext<ListAssetsRequest, ListAssetsResponse, Asset> context, ListAssetsResponse response) {
            return new ListAssetsPage(context, response);
        }

        public ApiFuture<ListAssetsPage> createPageAsync(PageContext<ListAssetsRequest, ListAssetsResponse, Asset> context, ApiFuture<ListAssetsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListAssetsPagedResponse
    extends AbstractPagedListResponse<ListAssetsRequest, ListAssetsResponse, Asset, ListAssetsPage, ListAssetsFixedSizeCollection> {
        public static ApiFuture<ListAssetsPagedResponse> createAsync(PageContext<ListAssetsRequest, ListAssetsResponse, Asset> context, ApiFuture<ListAssetsResponse> futureResponse) {
            ApiFuture<ListAssetsPage> futurePage = ListAssetsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListAssetsPagedResponse((ListAssetsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListAssetsPagedResponse(ListAssetsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListAssetsFixedSizeCollection.createEmptyCollection());
        }
    }
}

