/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.monitoring.v3.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.monitoring.v3.SnoozeServiceClient;
import com.google.cloud.monitoring.v3.stub.GrpcSnoozeServiceStub;
import com.google.cloud.monitoring.v3.stub.SnoozeServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.monitoring.v3.CreateSnoozeRequest;
import com.google.monitoring.v3.GetSnoozeRequest;
import com.google.monitoring.v3.ListSnoozesRequest;
import com.google.monitoring.v3.ListSnoozesResponse;
import com.google.monitoring.v3.Snooze;
import com.google.monitoring.v3.UpdateSnoozeRequest;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class SnoozeServiceStubSettings
extends StubSettings<SnoozeServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/monitoring").add((Object)"https://www.googleapis.com/auth/monitoring.read").build();
    private final UnaryCallSettings<CreateSnoozeRequest, Snooze> createSnoozeSettings;
    private final PagedCallSettings<ListSnoozesRequest, ListSnoozesResponse, SnoozeServiceClient.ListSnoozesPagedResponse> listSnoozesSettings;
    private final UnaryCallSettings<GetSnoozeRequest, Snooze> getSnoozeSettings;
    private final UnaryCallSettings<UpdateSnoozeRequest, Snooze> updateSnoozeSettings;
    private static final PagedListDescriptor<ListSnoozesRequest, ListSnoozesResponse, Snooze> LIST_SNOOZES_PAGE_STR_DESC = new PagedListDescriptor<ListSnoozesRequest, ListSnoozesResponse, Snooze>(){

        public String emptyToken() {
            return "";
        }

        public ListSnoozesRequest injectToken(ListSnoozesRequest payload, String token) {
            return ListSnoozesRequest.newBuilder((ListSnoozesRequest)payload).setPageToken(token).build();
        }

        public ListSnoozesRequest injectPageSize(ListSnoozesRequest payload, int pageSize) {
            return ListSnoozesRequest.newBuilder((ListSnoozesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListSnoozesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListSnoozesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Snooze> extractResources(ListSnoozesResponse payload) {
            return payload.getSnoozesList() == null ? ImmutableList.of() : payload.getSnoozesList();
        }
    };
    private static final PagedListResponseFactory<ListSnoozesRequest, ListSnoozesResponse, SnoozeServiceClient.ListSnoozesPagedResponse> LIST_SNOOZES_PAGE_STR_FACT = new PagedListResponseFactory<ListSnoozesRequest, ListSnoozesResponse, SnoozeServiceClient.ListSnoozesPagedResponse>(){

        public ApiFuture<SnoozeServiceClient.ListSnoozesPagedResponse> getFuturePagedResponse(UnaryCallable<ListSnoozesRequest, ListSnoozesResponse> callable, ListSnoozesRequest request, ApiCallContext context, ApiFuture<ListSnoozesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_SNOOZES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return SnoozeServiceClient.ListSnoozesPagedResponse.createAsync((PageContext<ListSnoozesRequest, ListSnoozesResponse, Snooze>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreateSnoozeRequest, Snooze> createSnoozeSettings() {
        return this.createSnoozeSettings;
    }

    public PagedCallSettings<ListSnoozesRequest, ListSnoozesResponse, SnoozeServiceClient.ListSnoozesPagedResponse> listSnoozesSettings() {
        return this.listSnoozesSettings;
    }

    public UnaryCallSettings<GetSnoozeRequest, Snooze> getSnoozeSettings() {
        return this.getSnoozeSettings;
    }

    public UnaryCallSettings<UpdateSnoozeRequest, Snooze> updateSnoozeSettings() {
        return this.updateSnoozeSettings;
    }

    public SnoozeServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcSnoozeServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "monitoring";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "monitoring.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "monitoring.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return SnoozeServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(SnoozeServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected SnoozeServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createSnoozeSettings = settingsBuilder.createSnoozeSettings().build();
        this.listSnoozesSettings = settingsBuilder.listSnoozesSettings().build();
        this.getSnoozeSettings = settingsBuilder.getSnoozeSettings().build();
        this.updateSnoozeSettings = settingsBuilder.updateSnoozeSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<SnoozeServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateSnoozeRequest, Snooze> createSnoozeSettings;
        private final PagedCallSettings.Builder<ListSnoozesRequest, ListSnoozesResponse, SnoozeServiceClient.ListSnoozesPagedResponse> listSnoozesSettings;
        private final UnaryCallSettings.Builder<GetSnoozeRequest, Snooze> getSnoozeSettings;
        private final UnaryCallSettings.Builder<UpdateSnoozeRequest, Snooze> updateSnoozeSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createSnoozeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listSnoozesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_SNOOZES_PAGE_STR_FACT);
            this.getSnoozeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateSnoozeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createSnoozeSettings, this.listSnoozesSettings, this.getSnoozeSettings, this.updateSnoozeSettings);
            Builder.initDefaults(this);
        }

        protected Builder(SnoozeServiceStubSettings settings) {
            super((StubSettings)settings);
            this.createSnoozeSettings = settings.createSnoozeSettings.toBuilder();
            this.listSnoozesSettings = settings.listSnoozesSettings.toBuilder();
            this.getSnoozeSettings = settings.getSnoozeSettings.toBuilder();
            this.updateSnoozeSettings = settings.updateSnoozeSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createSnoozeSettings, this.listSnoozesSettings, this.getSnoozeSettings, this.updateSnoozeSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(SnoozeServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)SnoozeServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)SnoozeServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(SnoozeServiceStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(SnoozeServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createSnoozeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_15_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_15_params"));
            builder.listSnoozesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_14_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_14_params"));
            builder.getSnoozeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_14_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_14_params"));
            builder.updateSnoozeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_15_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_15_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateSnoozeRequest, Snooze> createSnoozeSettings() {
            return this.createSnoozeSettings;
        }

        public PagedCallSettings.Builder<ListSnoozesRequest, ListSnoozesResponse, SnoozeServiceClient.ListSnoozesPagedResponse> listSnoozesSettings() {
            return this.listSnoozesSettings;
        }

        public UnaryCallSettings.Builder<GetSnoozeRequest, Snooze> getSnoozeSettings() {
            return this.getSnoozeSettings;
        }

        public UnaryCallSettings.Builder<UpdateSnoozeRequest, Snooze> updateSnoozeSettings() {
            return this.updateSnoozeSettings;
        }

        public SnoozeServiceStubSettings build() throws IOException {
            return new SnoozeServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_15_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"retry_policy_14_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)30000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)30000L)).setTotalTimeout(Duration.ofMillis((long)30000L)).build();
            definitions.put((Object)"no_retry_15_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)30000L)).setInitialRpcTimeout(Duration.ofMillis((long)30000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)30000L)).setTotalTimeout(Duration.ofMillis((long)30000L)).build();
            definitions.put((Object)"retry_policy_14_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

