/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.networkconnectivity.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.networkconnectivity.v1.CreatePolicyBasedRouteRequest;
import com.google.cloud.networkconnectivity.v1.DeletePolicyBasedRouteRequest;
import com.google.cloud.networkconnectivity.v1.GetPolicyBasedRouteRequest;
import com.google.cloud.networkconnectivity.v1.ListPolicyBasedRoutesRequest;
import com.google.cloud.networkconnectivity.v1.ListPolicyBasedRoutesResponse;
import com.google.cloud.networkconnectivity.v1.LocationName;
import com.google.cloud.networkconnectivity.v1.OperationMetadata;
import com.google.cloud.networkconnectivity.v1.PolicyBasedRoute;
import com.google.cloud.networkconnectivity.v1.PolicyBasedRouteName;
import com.google.cloud.networkconnectivity.v1.PolicyBasedRoutingServiceSettings;
import com.google.cloud.networkconnectivity.v1.stub.PolicyBasedRoutingServiceStub;
import com.google.cloud.networkconnectivity.v1.stub.PolicyBasedRoutingServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class PolicyBasedRoutingServiceClient
implements BackgroundResource {
    private final PolicyBasedRoutingServiceSettings settings;
    private final PolicyBasedRoutingServiceStub stub;
    private final OperationsClient operationsClient;

    public static final PolicyBasedRoutingServiceClient create() throws IOException {
        return PolicyBasedRoutingServiceClient.create(PolicyBasedRoutingServiceSettings.newBuilder().build());
    }

    public static final PolicyBasedRoutingServiceClient create(PolicyBasedRoutingServiceSettings settings) throws IOException {
        return new PolicyBasedRoutingServiceClient(settings);
    }

    public static final PolicyBasedRoutingServiceClient create(PolicyBasedRoutingServiceStub stub) {
        return new PolicyBasedRoutingServiceClient(stub);
    }

    protected PolicyBasedRoutingServiceClient(PolicyBasedRoutingServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((PolicyBasedRoutingServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    protected PolicyBasedRoutingServiceClient(PolicyBasedRoutingServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    public final PolicyBasedRoutingServiceSettings getSettings() {
        return this.settings;
    }

    public PolicyBasedRoutingServiceStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final ListPolicyBasedRoutesPagedResponse listPolicyBasedRoutes(LocationName parent) {
        ListPolicyBasedRoutesRequest request = ListPolicyBasedRoutesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listPolicyBasedRoutes(request);
    }

    public final ListPolicyBasedRoutesPagedResponse listPolicyBasedRoutes(String parent) {
        ListPolicyBasedRoutesRequest request = ListPolicyBasedRoutesRequest.newBuilder().setParent(parent).build();
        return this.listPolicyBasedRoutes(request);
    }

    public final ListPolicyBasedRoutesPagedResponse listPolicyBasedRoutes(ListPolicyBasedRoutesRequest request) {
        return (ListPolicyBasedRoutesPagedResponse)((Object)this.listPolicyBasedRoutesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListPolicyBasedRoutesRequest, ListPolicyBasedRoutesPagedResponse> listPolicyBasedRoutesPagedCallable() {
        return this.stub.listPolicyBasedRoutesPagedCallable();
    }

    public final UnaryCallable<ListPolicyBasedRoutesRequest, ListPolicyBasedRoutesResponse> listPolicyBasedRoutesCallable() {
        return this.stub.listPolicyBasedRoutesCallable();
    }

    public final PolicyBasedRoute getPolicyBasedRoute(PolicyBasedRouteName name) {
        GetPolicyBasedRouteRequest request = GetPolicyBasedRouteRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getPolicyBasedRoute(request);
    }

    public final PolicyBasedRoute getPolicyBasedRoute(String name) {
        GetPolicyBasedRouteRequest request = GetPolicyBasedRouteRequest.newBuilder().setName(name).build();
        return this.getPolicyBasedRoute(request);
    }

    public final PolicyBasedRoute getPolicyBasedRoute(GetPolicyBasedRouteRequest request) {
        return (PolicyBasedRoute)this.getPolicyBasedRouteCallable().call((Object)request);
    }

    public final UnaryCallable<GetPolicyBasedRouteRequest, PolicyBasedRoute> getPolicyBasedRouteCallable() {
        return this.stub.getPolicyBasedRouteCallable();
    }

    public final OperationFuture<PolicyBasedRoute, OperationMetadata> createPolicyBasedRouteAsync(LocationName parent, PolicyBasedRoute policyBasedRoute, String policyBasedRouteId) {
        CreatePolicyBasedRouteRequest request = CreatePolicyBasedRouteRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setPolicyBasedRoute(policyBasedRoute).setPolicyBasedRouteId(policyBasedRouteId).build();
        return this.createPolicyBasedRouteAsync(request);
    }

    public final OperationFuture<PolicyBasedRoute, OperationMetadata> createPolicyBasedRouteAsync(String parent, PolicyBasedRoute policyBasedRoute, String policyBasedRouteId) {
        CreatePolicyBasedRouteRequest request = CreatePolicyBasedRouteRequest.newBuilder().setParent(parent).setPolicyBasedRoute(policyBasedRoute).setPolicyBasedRouteId(policyBasedRouteId).build();
        return this.createPolicyBasedRouteAsync(request);
    }

    public final OperationFuture<PolicyBasedRoute, OperationMetadata> createPolicyBasedRouteAsync(CreatePolicyBasedRouteRequest request) {
        return this.createPolicyBasedRouteOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreatePolicyBasedRouteRequest, PolicyBasedRoute, OperationMetadata> createPolicyBasedRouteOperationCallable() {
        return this.stub.createPolicyBasedRouteOperationCallable();
    }

    public final UnaryCallable<CreatePolicyBasedRouteRequest, Operation> createPolicyBasedRouteCallable() {
        return this.stub.createPolicyBasedRouteCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deletePolicyBasedRouteAsync(PolicyBasedRouteName name) {
        DeletePolicyBasedRouteRequest request = DeletePolicyBasedRouteRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deletePolicyBasedRouteAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deletePolicyBasedRouteAsync(String name) {
        DeletePolicyBasedRouteRequest request = DeletePolicyBasedRouteRequest.newBuilder().setName(name).build();
        return this.deletePolicyBasedRouteAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deletePolicyBasedRouteAsync(DeletePolicyBasedRouteRequest request) {
        return this.deletePolicyBasedRouteOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeletePolicyBasedRouteRequest, Empty, OperationMetadata> deletePolicyBasedRouteOperationCallable() {
        return this.stub.deletePolicyBasedRouteOperationCallable();
    }

    public final UnaryCallable<DeletePolicyBasedRouteRequest, Operation> deletePolicyBasedRouteCallable() {
        return this.stub.deletePolicyBasedRouteCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListPolicyBasedRoutesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListPolicyBasedRoutesRequest, ListPolicyBasedRoutesResponse, PolicyBasedRoute, ListPolicyBasedRoutesPage, ListPolicyBasedRoutesFixedSizeCollection> {
        private ListPolicyBasedRoutesFixedSizeCollection(List<ListPolicyBasedRoutesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListPolicyBasedRoutesFixedSizeCollection createEmptyCollection() {
            return new ListPolicyBasedRoutesFixedSizeCollection(null, 0);
        }

        protected ListPolicyBasedRoutesFixedSizeCollection createCollection(List<ListPolicyBasedRoutesPage> pages, int collectionSize) {
            return new ListPolicyBasedRoutesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPolicyBasedRoutesPage
    extends AbstractPage<ListPolicyBasedRoutesRequest, ListPolicyBasedRoutesResponse, PolicyBasedRoute, ListPolicyBasedRoutesPage> {
        private ListPolicyBasedRoutesPage(PageContext<ListPolicyBasedRoutesRequest, ListPolicyBasedRoutesResponse, PolicyBasedRoute> context, ListPolicyBasedRoutesResponse response) {
            super(context, (Object)response);
        }

        private static ListPolicyBasedRoutesPage createEmptyPage() {
            return new ListPolicyBasedRoutesPage(null, null);
        }

        protected ListPolicyBasedRoutesPage createPage(PageContext<ListPolicyBasedRoutesRequest, ListPolicyBasedRoutesResponse, PolicyBasedRoute> context, ListPolicyBasedRoutesResponse response) {
            return new ListPolicyBasedRoutesPage(context, response);
        }

        public ApiFuture<ListPolicyBasedRoutesPage> createPageAsync(PageContext<ListPolicyBasedRoutesRequest, ListPolicyBasedRoutesResponse, PolicyBasedRoute> context, ApiFuture<ListPolicyBasedRoutesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPolicyBasedRoutesPagedResponse
    extends AbstractPagedListResponse<ListPolicyBasedRoutesRequest, ListPolicyBasedRoutesResponse, PolicyBasedRoute, ListPolicyBasedRoutesPage, ListPolicyBasedRoutesFixedSizeCollection> {
        public static ApiFuture<ListPolicyBasedRoutesPagedResponse> createAsync(PageContext<ListPolicyBasedRoutesRequest, ListPolicyBasedRoutesResponse, PolicyBasedRoute> context, ApiFuture<ListPolicyBasedRoutesResponse> futureResponse) {
            ApiFuture<ListPolicyBasedRoutesPage> futurePage = ListPolicyBasedRoutesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPolicyBasedRoutesPagedResponse((ListPolicyBasedRoutesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPolicyBasedRoutesPagedResponse(ListPolicyBasedRoutesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListPolicyBasedRoutesFixedSizeCollection.createEmptyCollection());
        }
    }
}

