/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.networkconnectivity.v1alpha1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.networkconnectivity.v1alpha1.CreateHubRequest;
import com.google.cloud.networkconnectivity.v1alpha1.CreateSpokeRequest;
import com.google.cloud.networkconnectivity.v1alpha1.DeleteHubRequest;
import com.google.cloud.networkconnectivity.v1alpha1.DeleteSpokeRequest;
import com.google.cloud.networkconnectivity.v1alpha1.GetHubRequest;
import com.google.cloud.networkconnectivity.v1alpha1.GetSpokeRequest;
import com.google.cloud.networkconnectivity.v1alpha1.Hub;
import com.google.cloud.networkconnectivity.v1alpha1.HubName;
import com.google.cloud.networkconnectivity.v1alpha1.HubServiceSettings;
import com.google.cloud.networkconnectivity.v1alpha1.ListHubsRequest;
import com.google.cloud.networkconnectivity.v1alpha1.ListHubsResponse;
import com.google.cloud.networkconnectivity.v1alpha1.ListSpokesRequest;
import com.google.cloud.networkconnectivity.v1alpha1.ListSpokesResponse;
import com.google.cloud.networkconnectivity.v1alpha1.LocationName;
import com.google.cloud.networkconnectivity.v1alpha1.OperationMetadata;
import com.google.cloud.networkconnectivity.v1alpha1.Spoke;
import com.google.cloud.networkconnectivity.v1alpha1.SpokeName;
import com.google.cloud.networkconnectivity.v1alpha1.UpdateHubRequest;
import com.google.cloud.networkconnectivity.v1alpha1.UpdateSpokeRequest;
import com.google.cloud.networkconnectivity.v1alpha1.stub.HubServiceStub;
import com.google.cloud.networkconnectivity.v1alpha1.stub.HubServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class HubServiceClient
implements BackgroundResource {
    private final HubServiceSettings settings;
    private final HubServiceStub stub;
    private final OperationsClient operationsClient;

    public static final HubServiceClient create() throws IOException {
        return HubServiceClient.create(HubServiceSettings.newBuilder().build());
    }

    public static final HubServiceClient create(HubServiceSettings settings) throws IOException {
        return new HubServiceClient(settings);
    }

    public static final HubServiceClient create(HubServiceStub stub) {
        return new HubServiceClient(stub);
    }

    protected HubServiceClient(HubServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((HubServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    protected HubServiceClient(HubServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    public final HubServiceSettings getSettings() {
        return this.settings;
    }

    public HubServiceStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final ListHubsPagedResponse listHubs(LocationName parent) {
        ListHubsRequest request = ListHubsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listHubs(request);
    }

    public final ListHubsPagedResponse listHubs(String parent) {
        ListHubsRequest request = ListHubsRequest.newBuilder().setParent(parent).build();
        return this.listHubs(request);
    }

    public final ListHubsPagedResponse listHubs(ListHubsRequest request) {
        return (ListHubsPagedResponse)((Object)this.listHubsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListHubsRequest, ListHubsPagedResponse> listHubsPagedCallable() {
        return this.stub.listHubsPagedCallable();
    }

    public final UnaryCallable<ListHubsRequest, ListHubsResponse> listHubsCallable() {
        return this.stub.listHubsCallable();
    }

    public final Hub getHub(HubName name) {
        GetHubRequest request = GetHubRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getHub(request);
    }

    public final Hub getHub(String name) {
        GetHubRequest request = GetHubRequest.newBuilder().setName(name).build();
        return this.getHub(request);
    }

    public final Hub getHub(GetHubRequest request) {
        return (Hub)this.getHubCallable().call((Object)request);
    }

    public final UnaryCallable<GetHubRequest, Hub> getHubCallable() {
        return this.stub.getHubCallable();
    }

    public final OperationFuture<Hub, OperationMetadata> createHubAsync(LocationName parent, Hub hub, String hubId) {
        CreateHubRequest request = CreateHubRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setHub(hub).setHubId(hubId).build();
        return this.createHubAsync(request);
    }

    public final OperationFuture<Hub, OperationMetadata> createHubAsync(String parent, Hub hub, String hubId) {
        CreateHubRequest request = CreateHubRequest.newBuilder().setParent(parent).setHub(hub).setHubId(hubId).build();
        return this.createHubAsync(request);
    }

    public final OperationFuture<Hub, OperationMetadata> createHubAsync(CreateHubRequest request) {
        return this.createHubOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateHubRequest, Hub, OperationMetadata> createHubOperationCallable() {
        return this.stub.createHubOperationCallable();
    }

    public final UnaryCallable<CreateHubRequest, Operation> createHubCallable() {
        return this.stub.createHubCallable();
    }

    public final OperationFuture<Hub, OperationMetadata> updateHubAsync(Hub hub, FieldMask updateMask) {
        UpdateHubRequest request = UpdateHubRequest.newBuilder().setHub(hub).setUpdateMask(updateMask).build();
        return this.updateHubAsync(request);
    }

    public final OperationFuture<Hub, OperationMetadata> updateHubAsync(UpdateHubRequest request) {
        return this.updateHubOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateHubRequest, Hub, OperationMetadata> updateHubOperationCallable() {
        return this.stub.updateHubOperationCallable();
    }

    public final UnaryCallable<UpdateHubRequest, Operation> updateHubCallable() {
        return this.stub.updateHubCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteHubAsync(HubName name) {
        DeleteHubRequest request = DeleteHubRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteHubAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteHubAsync(String name) {
        DeleteHubRequest request = DeleteHubRequest.newBuilder().setName(name).build();
        return this.deleteHubAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteHubAsync(DeleteHubRequest request) {
        return this.deleteHubOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteHubRequest, Empty, OperationMetadata> deleteHubOperationCallable() {
        return this.stub.deleteHubOperationCallable();
    }

    public final UnaryCallable<DeleteHubRequest, Operation> deleteHubCallable() {
        return this.stub.deleteHubCallable();
    }

    public final ListSpokesPagedResponse listSpokes(LocationName parent) {
        ListSpokesRequest request = ListSpokesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listSpokes(request);
    }

    public final ListSpokesPagedResponse listSpokes(String parent) {
        ListSpokesRequest request = ListSpokesRequest.newBuilder().setParent(parent).build();
        return this.listSpokes(request);
    }

    public final ListSpokesPagedResponse listSpokes(ListSpokesRequest request) {
        return (ListSpokesPagedResponse)((Object)this.listSpokesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListSpokesRequest, ListSpokesPagedResponse> listSpokesPagedCallable() {
        return this.stub.listSpokesPagedCallable();
    }

    public final UnaryCallable<ListSpokesRequest, ListSpokesResponse> listSpokesCallable() {
        return this.stub.listSpokesCallable();
    }

    public final Spoke getSpoke(SpokeName name) {
        GetSpokeRequest request = GetSpokeRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getSpoke(request);
    }

    public final Spoke getSpoke(String name) {
        GetSpokeRequest request = GetSpokeRequest.newBuilder().setName(name).build();
        return this.getSpoke(request);
    }

    public final Spoke getSpoke(GetSpokeRequest request) {
        return (Spoke)this.getSpokeCallable().call((Object)request);
    }

    public final UnaryCallable<GetSpokeRequest, Spoke> getSpokeCallable() {
        return this.stub.getSpokeCallable();
    }

    public final OperationFuture<Spoke, OperationMetadata> createSpokeAsync(LocationName parent, Spoke spoke, String spokeId) {
        CreateSpokeRequest request = CreateSpokeRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setSpoke(spoke).setSpokeId(spokeId).build();
        return this.createSpokeAsync(request);
    }

    public final OperationFuture<Spoke, OperationMetadata> createSpokeAsync(String parent, Spoke spoke, String spokeId) {
        CreateSpokeRequest request = CreateSpokeRequest.newBuilder().setParent(parent).setSpoke(spoke).setSpokeId(spokeId).build();
        return this.createSpokeAsync(request);
    }

    public final OperationFuture<Spoke, OperationMetadata> createSpokeAsync(CreateSpokeRequest request) {
        return this.createSpokeOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateSpokeRequest, Spoke, OperationMetadata> createSpokeOperationCallable() {
        return this.stub.createSpokeOperationCallable();
    }

    public final UnaryCallable<CreateSpokeRequest, Operation> createSpokeCallable() {
        return this.stub.createSpokeCallable();
    }

    public final OperationFuture<Spoke, OperationMetadata> updateSpokeAsync(Spoke spoke, FieldMask updateMask) {
        UpdateSpokeRequest request = UpdateSpokeRequest.newBuilder().setSpoke(spoke).setUpdateMask(updateMask).build();
        return this.updateSpokeAsync(request);
    }

    public final OperationFuture<Spoke, OperationMetadata> updateSpokeAsync(UpdateSpokeRequest request) {
        return this.updateSpokeOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateSpokeRequest, Spoke, OperationMetadata> updateSpokeOperationCallable() {
        return this.stub.updateSpokeOperationCallable();
    }

    public final UnaryCallable<UpdateSpokeRequest, Operation> updateSpokeCallable() {
        return this.stub.updateSpokeCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteSpokeAsync(SpokeName name) {
        DeleteSpokeRequest request = DeleteSpokeRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteSpokeAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteSpokeAsync(String name) {
        DeleteSpokeRequest request = DeleteSpokeRequest.newBuilder().setName(name).build();
        return this.deleteSpokeAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteSpokeAsync(DeleteSpokeRequest request) {
        return this.deleteSpokeOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteSpokeRequest, Empty, OperationMetadata> deleteSpokeOperationCallable() {
        return this.stub.deleteSpokeOperationCallable();
    }

    public final UnaryCallable<DeleteSpokeRequest, Operation> deleteSpokeCallable() {
        return this.stub.deleteSpokeCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListSpokesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListSpokesRequest, ListSpokesResponse, Spoke, ListSpokesPage, ListSpokesFixedSizeCollection> {
        private ListSpokesFixedSizeCollection(List<ListSpokesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListSpokesFixedSizeCollection createEmptyCollection() {
            return new ListSpokesFixedSizeCollection(null, 0);
        }

        protected ListSpokesFixedSizeCollection createCollection(List<ListSpokesPage> pages, int collectionSize) {
            return new ListSpokesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListSpokesPage
    extends AbstractPage<ListSpokesRequest, ListSpokesResponse, Spoke, ListSpokesPage> {
        private ListSpokesPage(PageContext<ListSpokesRequest, ListSpokesResponse, Spoke> context, ListSpokesResponse response) {
            super(context, (Object)response);
        }

        private static ListSpokesPage createEmptyPage() {
            return new ListSpokesPage(null, null);
        }

        protected ListSpokesPage createPage(PageContext<ListSpokesRequest, ListSpokesResponse, Spoke> context, ListSpokesResponse response) {
            return new ListSpokesPage(context, response);
        }

        public ApiFuture<ListSpokesPage> createPageAsync(PageContext<ListSpokesRequest, ListSpokesResponse, Spoke> context, ApiFuture<ListSpokesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListSpokesPagedResponse
    extends AbstractPagedListResponse<ListSpokesRequest, ListSpokesResponse, Spoke, ListSpokesPage, ListSpokesFixedSizeCollection> {
        public static ApiFuture<ListSpokesPagedResponse> createAsync(PageContext<ListSpokesRequest, ListSpokesResponse, Spoke> context, ApiFuture<ListSpokesResponse> futureResponse) {
            ApiFuture<ListSpokesPage> futurePage = ListSpokesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListSpokesPagedResponse((ListSpokesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListSpokesPagedResponse(ListSpokesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListSpokesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListHubsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListHubsRequest, ListHubsResponse, Hub, ListHubsPage, ListHubsFixedSizeCollection> {
        private ListHubsFixedSizeCollection(List<ListHubsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListHubsFixedSizeCollection createEmptyCollection() {
            return new ListHubsFixedSizeCollection(null, 0);
        }

        protected ListHubsFixedSizeCollection createCollection(List<ListHubsPage> pages, int collectionSize) {
            return new ListHubsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListHubsPage
    extends AbstractPage<ListHubsRequest, ListHubsResponse, Hub, ListHubsPage> {
        private ListHubsPage(PageContext<ListHubsRequest, ListHubsResponse, Hub> context, ListHubsResponse response) {
            super(context, (Object)response);
        }

        private static ListHubsPage createEmptyPage() {
            return new ListHubsPage(null, null);
        }

        protected ListHubsPage createPage(PageContext<ListHubsRequest, ListHubsResponse, Hub> context, ListHubsResponse response) {
            return new ListHubsPage(context, response);
        }

        public ApiFuture<ListHubsPage> createPageAsync(PageContext<ListHubsRequest, ListHubsResponse, Hub> context, ApiFuture<ListHubsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListHubsPagedResponse
    extends AbstractPagedListResponse<ListHubsRequest, ListHubsResponse, Hub, ListHubsPage, ListHubsFixedSizeCollection> {
        public static ApiFuture<ListHubsPagedResponse> createAsync(PageContext<ListHubsRequest, ListHubsResponse, Hub> context, ApiFuture<ListHubsResponse> futureResponse) {
            ApiFuture<ListHubsPage> futurePage = ListHubsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListHubsPagedResponse((ListHubsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListHubsPagedResponse(ListHubsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListHubsFixedSizeCollection.createEmptyCollection());
        }
    }
}

