/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.internal.wire;

import com.google.cloud.pubsublite.internal.CheckedApiException;
import com.google.cloud.pubsublite.internal.wire.TokenCounter;
import com.google.cloud.pubsublite.proto.FlowControlRequest;
import com.google.cloud.pubsublite.proto.SequencedMessage;
import java.util.Collection;
import java.util.Optional;

class FlowControlBatcher {
    private static double EXPEDITE_BATCH_REQUEST_RATIO = 0.5;
    private final TokenCounter clientTokens = new TokenCounter();
    private final TokenCounter pendingTokens = new TokenCounter();

    FlowControlBatcher() {
    }

    void onClientFlowRequest(FlowControlRequest request) throws CheckedApiException {
        this.clientTokens.add(request.getAllowedBytes(), request.getAllowedMessages());
        this.pendingTokens.add(request.getAllowedBytes(), request.getAllowedMessages());
    }

    void onMessages(Collection<SequencedMessage> received) throws CheckedApiException {
        long byteSize = received.stream().mapToLong(SequencedMessage::getSizeBytes).sum();
        this.clientTokens.sub(byteSize, received.size());
    }

    Optional<FlowControlRequest> requestForRestart() {
        this.pendingTokens.reset();
        return this.clientTokens.toFlowControlRequest();
    }

    Optional<FlowControlRequest> releasePendingRequest() {
        Optional<FlowControlRequest> request = this.pendingTokens.toFlowControlRequest();
        this.pendingTokens.reset();
        return request;
    }

    boolean shouldExpediteBatchRequest() {
        if (this.exceedsExpediteRatio(this.pendingTokens.bytes(), this.clientTokens.bytes())) {
            return true;
        }
        return this.exceedsExpediteRatio(this.pendingTokens.messages(), this.clientTokens.messages());
    }

    private boolean exceedsExpediteRatio(long pending, long client) {
        return client > 0L && (double)pending / (double)client >= EXPEDITE_BATCH_REQUEST_RATIO;
    }
}

