/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.pubsublite.proto.CreateReservationRequest;
import com.google.cloud.pubsublite.proto.CreateSubscriptionRequest;
import com.google.cloud.pubsublite.proto.CreateTopicRequest;
import com.google.cloud.pubsublite.proto.DeleteReservationRequest;
import com.google.cloud.pubsublite.proto.DeleteSubscriptionRequest;
import com.google.cloud.pubsublite.proto.DeleteTopicRequest;
import com.google.cloud.pubsublite.proto.GetReservationRequest;
import com.google.cloud.pubsublite.proto.GetSubscriptionRequest;
import com.google.cloud.pubsublite.proto.GetTopicPartitionsRequest;
import com.google.cloud.pubsublite.proto.GetTopicRequest;
import com.google.cloud.pubsublite.proto.ListReservationTopicsRequest;
import com.google.cloud.pubsublite.proto.ListReservationTopicsResponse;
import com.google.cloud.pubsublite.proto.ListReservationsRequest;
import com.google.cloud.pubsublite.proto.ListReservationsResponse;
import com.google.cloud.pubsublite.proto.ListSubscriptionsRequest;
import com.google.cloud.pubsublite.proto.ListSubscriptionsResponse;
import com.google.cloud.pubsublite.proto.ListTopicSubscriptionsRequest;
import com.google.cloud.pubsublite.proto.ListTopicSubscriptionsResponse;
import com.google.cloud.pubsublite.proto.ListTopicsRequest;
import com.google.cloud.pubsublite.proto.ListTopicsResponse;
import com.google.cloud.pubsublite.proto.OperationMetadata;
import com.google.cloud.pubsublite.proto.Reservation;
import com.google.cloud.pubsublite.proto.SeekSubscriptionRequest;
import com.google.cloud.pubsublite.proto.SeekSubscriptionResponse;
import com.google.cloud.pubsublite.proto.Subscription;
import com.google.cloud.pubsublite.proto.Topic;
import com.google.cloud.pubsublite.proto.TopicPartitions;
import com.google.cloud.pubsublite.proto.UpdateReservationRequest;
import com.google.cloud.pubsublite.proto.UpdateSubscriptionRequest;
import com.google.cloud.pubsublite.proto.UpdateTopicRequest;
import com.google.cloud.pubsublite.v1.AdminServiceClient;
import com.google.cloud.pubsublite.v1.stub.AdminServiceStub;
import com.google.cloud.pubsublite.v1.stub.GrpcAdminServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class AdminServiceStubSettings
extends StubSettings<AdminServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<CreateTopicRequest, Topic> createTopicSettings;
    private final UnaryCallSettings<GetTopicRequest, Topic> getTopicSettings;
    private final UnaryCallSettings<GetTopicPartitionsRequest, TopicPartitions> getTopicPartitionsSettings;
    private final PagedCallSettings<ListTopicsRequest, ListTopicsResponse, AdminServiceClient.ListTopicsPagedResponse> listTopicsSettings;
    private final UnaryCallSettings<UpdateTopicRequest, Topic> updateTopicSettings;
    private final UnaryCallSettings<DeleteTopicRequest, Empty> deleteTopicSettings;
    private final PagedCallSettings<ListTopicSubscriptionsRequest, ListTopicSubscriptionsResponse, AdminServiceClient.ListTopicSubscriptionsPagedResponse> listTopicSubscriptionsSettings;
    private final UnaryCallSettings<CreateSubscriptionRequest, Subscription> createSubscriptionSettings;
    private final UnaryCallSettings<GetSubscriptionRequest, Subscription> getSubscriptionSettings;
    private final PagedCallSettings<ListSubscriptionsRequest, ListSubscriptionsResponse, AdminServiceClient.ListSubscriptionsPagedResponse> listSubscriptionsSettings;
    private final UnaryCallSettings<UpdateSubscriptionRequest, Subscription> updateSubscriptionSettings;
    private final UnaryCallSettings<DeleteSubscriptionRequest, Empty> deleteSubscriptionSettings;
    private final UnaryCallSettings<SeekSubscriptionRequest, Operation> seekSubscriptionSettings;
    private final OperationCallSettings<SeekSubscriptionRequest, SeekSubscriptionResponse, OperationMetadata> seekSubscriptionOperationSettings;
    private final UnaryCallSettings<CreateReservationRequest, Reservation> createReservationSettings;
    private final UnaryCallSettings<GetReservationRequest, Reservation> getReservationSettings;
    private final PagedCallSettings<ListReservationsRequest, ListReservationsResponse, AdminServiceClient.ListReservationsPagedResponse> listReservationsSettings;
    private final UnaryCallSettings<UpdateReservationRequest, Reservation> updateReservationSettings;
    private final UnaryCallSettings<DeleteReservationRequest, Empty> deleteReservationSettings;
    private final PagedCallSettings<ListReservationTopicsRequest, ListReservationTopicsResponse, AdminServiceClient.ListReservationTopicsPagedResponse> listReservationTopicsSettings;
    private static final PagedListDescriptor<ListTopicsRequest, ListTopicsResponse, Topic> LIST_TOPICS_PAGE_STR_DESC = new PagedListDescriptor<ListTopicsRequest, ListTopicsResponse, Topic>(){

        public String emptyToken() {
            return "";
        }

        public ListTopicsRequest injectToken(ListTopicsRequest payload, String token) {
            return ListTopicsRequest.newBuilder((ListTopicsRequest)payload).setPageToken(token).build();
        }

        public ListTopicsRequest injectPageSize(ListTopicsRequest payload, int pageSize) {
            return ListTopicsRequest.newBuilder((ListTopicsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListTopicsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListTopicsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Topic> extractResources(ListTopicsResponse payload) {
            return payload.getTopicsList() == null ? ImmutableList.of() : payload.getTopicsList();
        }
    };
    private static final PagedListDescriptor<ListTopicSubscriptionsRequest, ListTopicSubscriptionsResponse, String> LIST_TOPIC_SUBSCRIPTIONS_PAGE_STR_DESC = new PagedListDescriptor<ListTopicSubscriptionsRequest, ListTopicSubscriptionsResponse, String>(){

        public String emptyToken() {
            return "";
        }

        public ListTopicSubscriptionsRequest injectToken(ListTopicSubscriptionsRequest payload, String token) {
            return ListTopicSubscriptionsRequest.newBuilder((ListTopicSubscriptionsRequest)payload).setPageToken(token).build();
        }

        public ListTopicSubscriptionsRequest injectPageSize(ListTopicSubscriptionsRequest payload, int pageSize) {
            return ListTopicSubscriptionsRequest.newBuilder((ListTopicSubscriptionsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListTopicSubscriptionsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListTopicSubscriptionsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<String> extractResources(ListTopicSubscriptionsResponse payload) {
            return payload.getSubscriptionsList() == null ? ImmutableList.of() : payload.getSubscriptionsList();
        }
    };
    private static final PagedListDescriptor<ListSubscriptionsRequest, ListSubscriptionsResponse, Subscription> LIST_SUBSCRIPTIONS_PAGE_STR_DESC = new PagedListDescriptor<ListSubscriptionsRequest, ListSubscriptionsResponse, Subscription>(){

        public String emptyToken() {
            return "";
        }

        public ListSubscriptionsRequest injectToken(ListSubscriptionsRequest payload, String token) {
            return ListSubscriptionsRequest.newBuilder((ListSubscriptionsRequest)payload).setPageToken(token).build();
        }

        public ListSubscriptionsRequest injectPageSize(ListSubscriptionsRequest payload, int pageSize) {
            return ListSubscriptionsRequest.newBuilder((ListSubscriptionsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListSubscriptionsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListSubscriptionsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Subscription> extractResources(ListSubscriptionsResponse payload) {
            return payload.getSubscriptionsList() == null ? ImmutableList.of() : payload.getSubscriptionsList();
        }
    };
    private static final PagedListDescriptor<ListReservationsRequest, ListReservationsResponse, Reservation> LIST_RESERVATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListReservationsRequest, ListReservationsResponse, Reservation>(){

        public String emptyToken() {
            return "";
        }

        public ListReservationsRequest injectToken(ListReservationsRequest payload, String token) {
            return ListReservationsRequest.newBuilder((ListReservationsRequest)payload).setPageToken(token).build();
        }

        public ListReservationsRequest injectPageSize(ListReservationsRequest payload, int pageSize) {
            return ListReservationsRequest.newBuilder((ListReservationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListReservationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListReservationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Reservation> extractResources(ListReservationsResponse payload) {
            return payload.getReservationsList() == null ? ImmutableList.of() : payload.getReservationsList();
        }
    };
    private static final PagedListDescriptor<ListReservationTopicsRequest, ListReservationTopicsResponse, String> LIST_RESERVATION_TOPICS_PAGE_STR_DESC = new PagedListDescriptor<ListReservationTopicsRequest, ListReservationTopicsResponse, String>(){

        public String emptyToken() {
            return "";
        }

        public ListReservationTopicsRequest injectToken(ListReservationTopicsRequest payload, String token) {
            return ListReservationTopicsRequest.newBuilder((ListReservationTopicsRequest)payload).setPageToken(token).build();
        }

        public ListReservationTopicsRequest injectPageSize(ListReservationTopicsRequest payload, int pageSize) {
            return ListReservationTopicsRequest.newBuilder((ListReservationTopicsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListReservationTopicsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListReservationTopicsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<String> extractResources(ListReservationTopicsResponse payload) {
            return payload.getTopicsList() == null ? ImmutableList.of() : payload.getTopicsList();
        }
    };
    private static final PagedListResponseFactory<ListTopicsRequest, ListTopicsResponse, AdminServiceClient.ListTopicsPagedResponse> LIST_TOPICS_PAGE_STR_FACT = new PagedListResponseFactory<ListTopicsRequest, ListTopicsResponse, AdminServiceClient.ListTopicsPagedResponse>(){

        public ApiFuture<AdminServiceClient.ListTopicsPagedResponse> getFuturePagedResponse(UnaryCallable<ListTopicsRequest, ListTopicsResponse> callable, ListTopicsRequest request, ApiCallContext context, ApiFuture<ListTopicsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_TOPICS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return AdminServiceClient.ListTopicsPagedResponse.createAsync((PageContext<ListTopicsRequest, ListTopicsResponse, Topic>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListTopicSubscriptionsRequest, ListTopicSubscriptionsResponse, AdminServiceClient.ListTopicSubscriptionsPagedResponse> LIST_TOPIC_SUBSCRIPTIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListTopicSubscriptionsRequest, ListTopicSubscriptionsResponse, AdminServiceClient.ListTopicSubscriptionsPagedResponse>(){

        public ApiFuture<AdminServiceClient.ListTopicSubscriptionsPagedResponse> getFuturePagedResponse(UnaryCallable<ListTopicSubscriptionsRequest, ListTopicSubscriptionsResponse> callable, ListTopicSubscriptionsRequest request, ApiCallContext context, ApiFuture<ListTopicSubscriptionsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_TOPIC_SUBSCRIPTIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return AdminServiceClient.ListTopicSubscriptionsPagedResponse.createAsync((PageContext<ListTopicSubscriptionsRequest, ListTopicSubscriptionsResponse, String>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListSubscriptionsRequest, ListSubscriptionsResponse, AdminServiceClient.ListSubscriptionsPagedResponse> LIST_SUBSCRIPTIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListSubscriptionsRequest, ListSubscriptionsResponse, AdminServiceClient.ListSubscriptionsPagedResponse>(){

        public ApiFuture<AdminServiceClient.ListSubscriptionsPagedResponse> getFuturePagedResponse(UnaryCallable<ListSubscriptionsRequest, ListSubscriptionsResponse> callable, ListSubscriptionsRequest request, ApiCallContext context, ApiFuture<ListSubscriptionsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_SUBSCRIPTIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return AdminServiceClient.ListSubscriptionsPagedResponse.createAsync((PageContext<ListSubscriptionsRequest, ListSubscriptionsResponse, Subscription>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListReservationsRequest, ListReservationsResponse, AdminServiceClient.ListReservationsPagedResponse> LIST_RESERVATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListReservationsRequest, ListReservationsResponse, AdminServiceClient.ListReservationsPagedResponse>(){

        public ApiFuture<AdminServiceClient.ListReservationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListReservationsRequest, ListReservationsResponse> callable, ListReservationsRequest request, ApiCallContext context, ApiFuture<ListReservationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_RESERVATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return AdminServiceClient.ListReservationsPagedResponse.createAsync((PageContext<ListReservationsRequest, ListReservationsResponse, Reservation>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListReservationTopicsRequest, ListReservationTopicsResponse, AdminServiceClient.ListReservationTopicsPagedResponse> LIST_RESERVATION_TOPICS_PAGE_STR_FACT = new PagedListResponseFactory<ListReservationTopicsRequest, ListReservationTopicsResponse, AdminServiceClient.ListReservationTopicsPagedResponse>(){

        public ApiFuture<AdminServiceClient.ListReservationTopicsPagedResponse> getFuturePagedResponse(UnaryCallable<ListReservationTopicsRequest, ListReservationTopicsResponse> callable, ListReservationTopicsRequest request, ApiCallContext context, ApiFuture<ListReservationTopicsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_RESERVATION_TOPICS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return AdminServiceClient.ListReservationTopicsPagedResponse.createAsync((PageContext<ListReservationTopicsRequest, ListReservationTopicsResponse, String>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreateTopicRequest, Topic> createTopicSettings() {
        return this.createTopicSettings;
    }

    public UnaryCallSettings<GetTopicRequest, Topic> getTopicSettings() {
        return this.getTopicSettings;
    }

    public UnaryCallSettings<GetTopicPartitionsRequest, TopicPartitions> getTopicPartitionsSettings() {
        return this.getTopicPartitionsSettings;
    }

    public PagedCallSettings<ListTopicsRequest, ListTopicsResponse, AdminServiceClient.ListTopicsPagedResponse> listTopicsSettings() {
        return this.listTopicsSettings;
    }

    public UnaryCallSettings<UpdateTopicRequest, Topic> updateTopicSettings() {
        return this.updateTopicSettings;
    }

    public UnaryCallSettings<DeleteTopicRequest, Empty> deleteTopicSettings() {
        return this.deleteTopicSettings;
    }

    public PagedCallSettings<ListTopicSubscriptionsRequest, ListTopicSubscriptionsResponse, AdminServiceClient.ListTopicSubscriptionsPagedResponse> listTopicSubscriptionsSettings() {
        return this.listTopicSubscriptionsSettings;
    }

    public UnaryCallSettings<CreateSubscriptionRequest, Subscription> createSubscriptionSettings() {
        return this.createSubscriptionSettings;
    }

    public UnaryCallSettings<GetSubscriptionRequest, Subscription> getSubscriptionSettings() {
        return this.getSubscriptionSettings;
    }

    public PagedCallSettings<ListSubscriptionsRequest, ListSubscriptionsResponse, AdminServiceClient.ListSubscriptionsPagedResponse> listSubscriptionsSettings() {
        return this.listSubscriptionsSettings;
    }

    public UnaryCallSettings<UpdateSubscriptionRequest, Subscription> updateSubscriptionSettings() {
        return this.updateSubscriptionSettings;
    }

    public UnaryCallSettings<DeleteSubscriptionRequest, Empty> deleteSubscriptionSettings() {
        return this.deleteSubscriptionSettings;
    }

    public UnaryCallSettings<SeekSubscriptionRequest, Operation> seekSubscriptionSettings() {
        return this.seekSubscriptionSettings;
    }

    public OperationCallSettings<SeekSubscriptionRequest, SeekSubscriptionResponse, OperationMetadata> seekSubscriptionOperationSettings() {
        return this.seekSubscriptionOperationSettings;
    }

    public UnaryCallSettings<CreateReservationRequest, Reservation> createReservationSettings() {
        return this.createReservationSettings;
    }

    public UnaryCallSettings<GetReservationRequest, Reservation> getReservationSettings() {
        return this.getReservationSettings;
    }

    public PagedCallSettings<ListReservationsRequest, ListReservationsResponse, AdminServiceClient.ListReservationsPagedResponse> listReservationsSettings() {
        return this.listReservationsSettings;
    }

    public UnaryCallSettings<UpdateReservationRequest, Reservation> updateReservationSettings() {
        return this.updateReservationSettings;
    }

    public UnaryCallSettings<DeleteReservationRequest, Empty> deleteReservationSettings() {
        return this.deleteReservationSettings;
    }

    public PagedCallSettings<ListReservationTopicsRequest, ListReservationTopicsResponse, AdminServiceClient.ListReservationTopicsPagedResponse> listReservationTopicsSettings() {
        return this.listReservationTopicsSettings;
    }

    public AdminServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcAdminServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "pubsublite";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "pubsublite.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "pubsublite.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return AdminServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(AdminServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected AdminServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createTopicSettings = settingsBuilder.createTopicSettings().build();
        this.getTopicSettings = settingsBuilder.getTopicSettings().build();
        this.getTopicPartitionsSettings = settingsBuilder.getTopicPartitionsSettings().build();
        this.listTopicsSettings = settingsBuilder.listTopicsSettings().build();
        this.updateTopicSettings = settingsBuilder.updateTopicSettings().build();
        this.deleteTopicSettings = settingsBuilder.deleteTopicSettings().build();
        this.listTopicSubscriptionsSettings = settingsBuilder.listTopicSubscriptionsSettings().build();
        this.createSubscriptionSettings = settingsBuilder.createSubscriptionSettings().build();
        this.getSubscriptionSettings = settingsBuilder.getSubscriptionSettings().build();
        this.listSubscriptionsSettings = settingsBuilder.listSubscriptionsSettings().build();
        this.updateSubscriptionSettings = settingsBuilder.updateSubscriptionSettings().build();
        this.deleteSubscriptionSettings = settingsBuilder.deleteSubscriptionSettings().build();
        this.seekSubscriptionSettings = settingsBuilder.seekSubscriptionSettings().build();
        this.seekSubscriptionOperationSettings = settingsBuilder.seekSubscriptionOperationSettings().build();
        this.createReservationSettings = settingsBuilder.createReservationSettings().build();
        this.getReservationSettings = settingsBuilder.getReservationSettings().build();
        this.listReservationsSettings = settingsBuilder.listReservationsSettings().build();
        this.updateReservationSettings = settingsBuilder.updateReservationSettings().build();
        this.deleteReservationSettings = settingsBuilder.deleteReservationSettings().build();
        this.listReservationTopicsSettings = settingsBuilder.listReservationTopicsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<AdminServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateTopicRequest, Topic> createTopicSettings;
        private final UnaryCallSettings.Builder<GetTopicRequest, Topic> getTopicSettings;
        private final UnaryCallSettings.Builder<GetTopicPartitionsRequest, TopicPartitions> getTopicPartitionsSettings;
        private final PagedCallSettings.Builder<ListTopicsRequest, ListTopicsResponse, AdminServiceClient.ListTopicsPagedResponse> listTopicsSettings;
        private final UnaryCallSettings.Builder<UpdateTopicRequest, Topic> updateTopicSettings;
        private final UnaryCallSettings.Builder<DeleteTopicRequest, Empty> deleteTopicSettings;
        private final PagedCallSettings.Builder<ListTopicSubscriptionsRequest, ListTopicSubscriptionsResponse, AdminServiceClient.ListTopicSubscriptionsPagedResponse> listTopicSubscriptionsSettings;
        private final UnaryCallSettings.Builder<CreateSubscriptionRequest, Subscription> createSubscriptionSettings;
        private final UnaryCallSettings.Builder<GetSubscriptionRequest, Subscription> getSubscriptionSettings;
        private final PagedCallSettings.Builder<ListSubscriptionsRequest, ListSubscriptionsResponse, AdminServiceClient.ListSubscriptionsPagedResponse> listSubscriptionsSettings;
        private final UnaryCallSettings.Builder<UpdateSubscriptionRequest, Subscription> updateSubscriptionSettings;
        private final UnaryCallSettings.Builder<DeleteSubscriptionRequest, Empty> deleteSubscriptionSettings;
        private final UnaryCallSettings.Builder<SeekSubscriptionRequest, Operation> seekSubscriptionSettings;
        private final OperationCallSettings.Builder<SeekSubscriptionRequest, SeekSubscriptionResponse, OperationMetadata> seekSubscriptionOperationSettings;
        private final UnaryCallSettings.Builder<CreateReservationRequest, Reservation> createReservationSettings;
        private final UnaryCallSettings.Builder<GetReservationRequest, Reservation> getReservationSettings;
        private final PagedCallSettings.Builder<ListReservationsRequest, ListReservationsResponse, AdminServiceClient.ListReservationsPagedResponse> listReservationsSettings;
        private final UnaryCallSettings.Builder<UpdateReservationRequest, Reservation> updateReservationSettings;
        private final UnaryCallSettings.Builder<DeleteReservationRequest, Empty> deleteReservationSettings;
        private final PagedCallSettings.Builder<ListReservationTopicsRequest, ListReservationTopicsResponse, AdminServiceClient.ListReservationTopicsPagedResponse> listReservationTopicsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createTopicSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getTopicSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getTopicPartitionsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listTopicsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_TOPICS_PAGE_STR_FACT);
            this.updateTopicSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteTopicSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listTopicSubscriptionsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_TOPIC_SUBSCRIPTIONS_PAGE_STR_FACT);
            this.createSubscriptionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getSubscriptionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listSubscriptionsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_SUBSCRIPTIONS_PAGE_STR_FACT);
            this.updateSubscriptionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteSubscriptionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.seekSubscriptionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.seekSubscriptionOperationSettings = OperationCallSettings.newBuilder();
            this.createReservationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getReservationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listReservationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_RESERVATIONS_PAGE_STR_FACT);
            this.updateReservationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteReservationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listReservationTopicsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_RESERVATION_TOPICS_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createTopicSettings, this.getTopicSettings, this.getTopicPartitionsSettings, this.listTopicsSettings, this.updateTopicSettings, this.deleteTopicSettings, this.listTopicSubscriptionsSettings, this.createSubscriptionSettings, this.getSubscriptionSettings, this.listSubscriptionsSettings, this.updateSubscriptionSettings, this.deleteSubscriptionSettings, (Object[])new UnaryCallSettings.Builder[]{this.seekSubscriptionSettings, this.createReservationSettings, this.getReservationSettings, this.listReservationsSettings, this.updateReservationSettings, this.deleteReservationSettings, this.listReservationTopicsSettings});
            Builder.initDefaults(this);
        }

        protected Builder(AdminServiceStubSettings settings) {
            super((StubSettings)settings);
            this.createTopicSettings = settings.createTopicSettings.toBuilder();
            this.getTopicSettings = settings.getTopicSettings.toBuilder();
            this.getTopicPartitionsSettings = settings.getTopicPartitionsSettings.toBuilder();
            this.listTopicsSettings = settings.listTopicsSettings.toBuilder();
            this.updateTopicSettings = settings.updateTopicSettings.toBuilder();
            this.deleteTopicSettings = settings.deleteTopicSettings.toBuilder();
            this.listTopicSubscriptionsSettings = settings.listTopicSubscriptionsSettings.toBuilder();
            this.createSubscriptionSettings = settings.createSubscriptionSettings.toBuilder();
            this.getSubscriptionSettings = settings.getSubscriptionSettings.toBuilder();
            this.listSubscriptionsSettings = settings.listSubscriptionsSettings.toBuilder();
            this.updateSubscriptionSettings = settings.updateSubscriptionSettings.toBuilder();
            this.deleteSubscriptionSettings = settings.deleteSubscriptionSettings.toBuilder();
            this.seekSubscriptionSettings = settings.seekSubscriptionSettings.toBuilder();
            this.seekSubscriptionOperationSettings = settings.seekSubscriptionOperationSettings.toBuilder();
            this.createReservationSettings = settings.createReservationSettings.toBuilder();
            this.getReservationSettings = settings.getReservationSettings.toBuilder();
            this.listReservationsSettings = settings.listReservationsSettings.toBuilder();
            this.updateReservationSettings = settings.updateReservationSettings.toBuilder();
            this.deleteReservationSettings = settings.deleteReservationSettings.toBuilder();
            this.listReservationTopicsSettings = settings.listReservationTopicsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createTopicSettings, this.getTopicSettings, this.getTopicPartitionsSettings, this.listTopicsSettings, this.updateTopicSettings, this.deleteTopicSettings, this.listTopicSubscriptionsSettings, this.createSubscriptionSettings, this.getSubscriptionSettings, this.listSubscriptionsSettings, this.updateSubscriptionSettings, this.deleteSubscriptionSettings, (Object[])new UnaryCallSettings.Builder[]{this.seekSubscriptionSettings, this.createReservationSettings, this.getReservationSettings, this.listReservationsSettings, this.updateReservationSettings, this.deleteReservationSettings, this.listReservationTopicsSettings});
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(AdminServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)AdminServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)AdminServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(AdminServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createTopicSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getTopicSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getTopicPartitionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listTopicsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updateTopicSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deleteTopicSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listTopicSubscriptionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createSubscriptionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getSubscriptionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listSubscriptionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updateSubscriptionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deleteSubscriptionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.seekSubscriptionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createReservationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getReservationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listReservationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updateReservationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deleteReservationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listReservationTopicsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.seekSubscriptionOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(SeekSubscriptionResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateTopicRequest, Topic> createTopicSettings() {
            return this.createTopicSettings;
        }

        public UnaryCallSettings.Builder<GetTopicRequest, Topic> getTopicSettings() {
            return this.getTopicSettings;
        }

        public UnaryCallSettings.Builder<GetTopicPartitionsRequest, TopicPartitions> getTopicPartitionsSettings() {
            return this.getTopicPartitionsSettings;
        }

        public PagedCallSettings.Builder<ListTopicsRequest, ListTopicsResponse, AdminServiceClient.ListTopicsPagedResponse> listTopicsSettings() {
            return this.listTopicsSettings;
        }

        public UnaryCallSettings.Builder<UpdateTopicRequest, Topic> updateTopicSettings() {
            return this.updateTopicSettings;
        }

        public UnaryCallSettings.Builder<DeleteTopicRequest, Empty> deleteTopicSettings() {
            return this.deleteTopicSettings;
        }

        public PagedCallSettings.Builder<ListTopicSubscriptionsRequest, ListTopicSubscriptionsResponse, AdminServiceClient.ListTopicSubscriptionsPagedResponse> listTopicSubscriptionsSettings() {
            return this.listTopicSubscriptionsSettings;
        }

        public UnaryCallSettings.Builder<CreateSubscriptionRequest, Subscription> createSubscriptionSettings() {
            return this.createSubscriptionSettings;
        }

        public UnaryCallSettings.Builder<GetSubscriptionRequest, Subscription> getSubscriptionSettings() {
            return this.getSubscriptionSettings;
        }

        public PagedCallSettings.Builder<ListSubscriptionsRequest, ListSubscriptionsResponse, AdminServiceClient.ListSubscriptionsPagedResponse> listSubscriptionsSettings() {
            return this.listSubscriptionsSettings;
        }

        public UnaryCallSettings.Builder<UpdateSubscriptionRequest, Subscription> updateSubscriptionSettings() {
            return this.updateSubscriptionSettings;
        }

        public UnaryCallSettings.Builder<DeleteSubscriptionRequest, Empty> deleteSubscriptionSettings() {
            return this.deleteSubscriptionSettings;
        }

        public UnaryCallSettings.Builder<SeekSubscriptionRequest, Operation> seekSubscriptionSettings() {
            return this.seekSubscriptionSettings;
        }

        public OperationCallSettings.Builder<SeekSubscriptionRequest, SeekSubscriptionResponse, OperationMetadata> seekSubscriptionOperationSettings() {
            return this.seekSubscriptionOperationSettings;
        }

        public UnaryCallSettings.Builder<CreateReservationRequest, Reservation> createReservationSettings() {
            return this.createReservationSettings;
        }

        public UnaryCallSettings.Builder<GetReservationRequest, Reservation> getReservationSettings() {
            return this.getReservationSettings;
        }

        public PagedCallSettings.Builder<ListReservationsRequest, ListReservationsResponse, AdminServiceClient.ListReservationsPagedResponse> listReservationsSettings() {
            return this.listReservationsSettings;
        }

        public UnaryCallSettings.Builder<UpdateReservationRequest, Reservation> updateReservationSettings() {
            return this.updateReservationSettings;
        }

        public UnaryCallSettings.Builder<DeleteReservationRequest, Empty> deleteReservationSettings() {
            return this.deleteReservationSettings;
        }

        public PagedCallSettings.Builder<ListReservationTopicsRequest, ListReservationTopicsResponse, AdminServiceClient.ListReservationTopicsPagedResponse> listReservationTopicsSettings() {
            return this.listReservationTopicsSettings;
        }

        public AdminServiceStubSettings build() throws IOException {
            return new AdminServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE, StatusCode.Code.ABORTED, StatusCode.Code.INTERNAL, StatusCode.Code.UNKNOWN})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)600000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

