/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.jdbc;

import com.google.cloud.ByteArray;
import com.google.cloud.spanner.ResultSets;
import com.google.cloud.spanner.Struct;
import com.google.cloud.spanner.Type;
import com.google.cloud.spanner.Value;
import com.google.cloud.spanner.ValueBinder;
import com.google.cloud.spanner.jdbc.JdbcDataType;
import com.google.cloud.spanner.jdbc.JdbcPreconditions;
import com.google.cloud.spanner.jdbc.JdbcResultSet;
import com.google.cloud.spanner.jdbc.JdbcSqlExceptionFactory;
import com.google.cloud.spanner.jdbc.JdbcTypeConverter;
import com.google.common.collect.ImmutableList;
import com.google.rpc.Code;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

class JdbcArray
implements java.sql.Array {
    private static final String FREE_EXCEPTION = "free() has been called, array is no longer available";
    private final JdbcDataType type;
    private Object data;
    private boolean freed = false;
    private static final String RESULTSET_WITH_TYPE_MAPPING_NOT_SUPPORTED = "Getting a ResultSet with a custom type mapping from an array is not supported";

    static JdbcArray createArray(String typeName, Object[] elements) throws SQLException {
        for (JdbcDataType type : JdbcDataType.values()) {
            if (!type.getTypeName().equalsIgnoreCase(typeName)) continue;
            return new JdbcArray(type, elements);
        }
        throw JdbcSqlExceptionFactory.of("Data type " + typeName + " is unknown", Code.INVALID_ARGUMENT);
    }

    static JdbcArray createArray(JdbcDataType type, List<?> elements) {
        return new JdbcArray(type, elements);
    }

    private JdbcArray(JdbcDataType type, Object[] elements) throws SQLException {
        this.type = type;
        if (elements != null) {
            this.data = Array.newInstance(type.getJavaClass(), elements.length);
            try {
                System.arraycopy(elements, 0, this.data, 0, elements.length);
            }
            catch (Exception e) {
                throw JdbcSqlExceptionFactory.of("Could not copy array elements. Make sure the supplied array only contains elements of class " + type.getJavaClass().getName(), Code.UNKNOWN, e);
            }
        }
    }

    private JdbcArray(JdbcDataType type, List<?> elements) {
        this.type = type;
        if (elements != null) {
            this.data = Array.newInstance(type.getJavaClass(), elements.size());
            elements.toArray((Object[])this.data);
        }
    }

    private void checkFree() throws SQLException {
        if (this.freed) {
            throw JdbcSqlExceptionFactory.of(FREE_EXCEPTION, Code.FAILED_PRECONDITION);
        }
    }

    @Override
    public String getBaseTypeName() throws SQLException {
        this.checkFree();
        return this.type.getTypeName();
    }

    @Override
    public int getBaseType() throws SQLException {
        this.checkFree();
        return this.type.getSqlType();
    }

    @Override
    public Object getArray() throws SQLException {
        this.checkFree();
        return this.data;
    }

    @Override
    public Object getArray(Map<String, Class<?>> map) throws SQLException {
        this.checkFree();
        return this.data;
    }

    @Override
    public Object getArray(long index, int count) throws SQLException {
        this.checkFree();
        return this.getArray(index, count, null);
    }

    @Override
    public Object getArray(long index, int count, Map<String, Class<?>> map) throws SQLException {
        this.checkFree();
        if (this.data != null) {
            Object res = Array.newInstance(this.type.getJavaClass(), count);
            System.arraycopy(this.data, (int)index - 1, res, 0, count);
            return res;
        }
        return null;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return this.getResultSet(1L, Integer.MAX_VALUE);
    }

    @Override
    public ResultSet getResultSet(Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException(RESULTSET_WITH_TYPE_MAPPING_NOT_SUPPORTED);
    }

    @Override
    public ResultSet getResultSet(long startIndex, int count) throws SQLException {
        JdbcPreconditions.checkArgument(startIndex + (long)count - 1L <= Integer.MAX_VALUE, String.format("End index cannot exceed %d", Integer.MAX_VALUE));
        JdbcPreconditions.checkArgument(startIndex >= 1L, "Start index must be >= 1");
        JdbcPreconditions.checkArgument(count >= 0, "Count must be >= 0");
        this.checkFree();
        ImmutableList.Builder rows = ImmutableList.builder();
        int added = 0;
        if (this.data != null) {
            for (int index = (int)startIndex; added < count && index <= ((Object[])this.data).length; ++index) {
                Struct.Builder builder;
                Object value = ((Object[])this.data)[index - 1];
                ValueBinder binder = ((Struct.Builder)Struct.newBuilder().set("INDEX").to((long)index)).set("VALUE");
                switch (this.type.getCode()) {
                    case BOOL: {
                        builder = (Struct.Builder)binder.to((Boolean)value);
                        break;
                    }
                    case BYTES: {
                        builder = (Struct.Builder)binder.to(ByteArray.copyFrom((byte[])((byte[])value)));
                        break;
                    }
                    case DATE: {
                        builder = (Struct.Builder)binder.to(JdbcTypeConverter.toGoogleDate((Date)value));
                        break;
                    }
                    case FLOAT64: {
                        builder = (Struct.Builder)binder.to((Double)value);
                        break;
                    }
                    case INT64: {
                        builder = (Struct.Builder)binder.to((Long)value);
                        break;
                    }
                    case NUMERIC: {
                        builder = (Struct.Builder)binder.to((BigDecimal)value);
                        break;
                    }
                    case STRING: {
                        builder = (Struct.Builder)binder.to((String)value);
                        break;
                    }
                    case JSON: {
                        builder = (Struct.Builder)binder.to(Value.json((String)((String)value)));
                        break;
                    }
                    case PG_JSONB: {
                        builder = (Struct.Builder)binder.to(Value.pgJsonb((String)((String)value)));
                        break;
                    }
                    case TIMESTAMP: {
                        builder = (Struct.Builder)binder.to(JdbcTypeConverter.toGoogleTimestamp((Timestamp)value));
                        break;
                    }
                    default: {
                        throw new SQLFeatureNotSupportedException(String.format("Array of type %s cannot be converted to a ResultSet", this.type.getCode().name()));
                    }
                }
                rows.add((Object)builder.build());
                if (++added == count) break;
            }
        }
        return JdbcResultSet.of(ResultSets.forRows((Type)Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"INDEX", (Type)Type.int64()), Type.StructField.of((String)"VALUE", (Type)this.type.getSpannerType())}), (Iterable)rows.build()));
    }

    @Override
    public ResultSet getResultSet(long index, int count, Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException(RESULTSET_WITH_TYPE_MAPPING_NOT_SUPPORTED);
    }

    @Override
    public void free() {
        this.freed = true;
        this.data = null;
    }

    public String toString() {
        if (this.data == null) {
            return "null";
        }
        boolean first = true;
        StringBuilder builder = new StringBuilder("{");
        for (Object o : (Object[])this.data) {
            if (!first) {
                builder.append(",");
            }
            first = false;
            if (o == null) {
                builder.append("null");
                continue;
            }
            builder.append(o);
        }
        builder.append("}");
        return builder.toString();
    }

    public boolean equals(Object other) {
        if (!(other instanceof JdbcArray)) {
            return false;
        }
        JdbcArray array = (JdbcArray)other;
        return this.type == array.type && Arrays.deepEquals((Object[])this.data, (Object[])array.data);
    }

    public int hashCode() {
        return this.type.hashCode() ^ Arrays.deepHashCode((Object[])this.data);
    }
}

