/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.cloud.ByteArray;
import com.google.cloud.Date;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.Struct;
import com.google.cloud.spanner.Type;
import com.google.cloud.spanner.Value;
import com.google.common.base.Preconditions;
import com.google.spanner.v1.ResultSetMetadata;
import com.google.spanner.v1.ResultSetStats;
import java.math.BigDecimal;
import java.util.List;

class DirectExecuteResultSet
implements ResultSet {
    private static final String MISSING_NEXT_CALL = "Must be preceded by a next() call";
    private final ResultSet delegate;
    private boolean nextCalledByClient = false;
    private final boolean initialNextResult;
    private boolean nextHasReturnedFalse = false;

    static DirectExecuteResultSet ofResultSet(ResultSet delegate) {
        return new DirectExecuteResultSet(delegate);
    }

    DirectExecuteResultSet(ResultSet delegate) {
        Preconditions.checkNotNull((Object)delegate);
        this.delegate = delegate;
        this.initialNextResult = delegate.next();
    }

    @Override
    public boolean next() throws SpannerException {
        if (this.nextCalledByClient) {
            boolean res = this.delegate.next();
            this.nextHasReturnedFalse = !res;
            return res;
        }
        this.nextCalledByClient = true;
        this.nextHasReturnedFalse = !this.initialNextResult;
        return this.initialNextResult;
    }

    @Override
    public Struct getCurrentRowAsStruct() {
        Preconditions.checkState((boolean)this.nextCalledByClient, (Object)MISSING_NEXT_CALL);
        return this.delegate.getCurrentRowAsStruct();
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    @Override
    public ResultSetStats getStats() {
        if (this.nextHasReturnedFalse) {
            return this.delegate.getStats();
        }
        return null;
    }

    @Override
    public ResultSetMetadata getMetadata() {
        return this.delegate.getMetadata();
    }

    @Override
    public Type getType() {
        return this.delegate.getType();
    }

    @Override
    public int getColumnCount() {
        return this.delegate.getColumnCount();
    }

    @Override
    public int getColumnIndex(String columnName) {
        return this.delegate.getColumnIndex(columnName);
    }

    @Override
    public Type getColumnType(int columnIndex) {
        return this.delegate.getColumnType(columnIndex);
    }

    @Override
    public Type getColumnType(String columnName) {
        return this.delegate.getColumnType(columnName);
    }

    @Override
    public boolean isNull(int columnIndex) {
        Preconditions.checkState((boolean)this.nextCalledByClient, (Object)MISSING_NEXT_CALL);
        return this.delegate.isNull(columnIndex);
    }

    @Override
    public boolean isNull(String columnName) {
        Preconditions.checkState((boolean)this.nextCalledByClient, (Object)MISSING_NEXT_CALL);
        return this.delegate.isNull(columnName);
    }

    @Override
    public boolean getBoolean(int columnIndex) {
        Preconditions.checkState((boolean)this.nextCalledByClient, (Object)MISSING_NEXT_CALL);
        return this.delegate.getBoolean(columnIndex);
    }

    @Override
    public boolean getBoolean(String columnName) {
        Preconditions.checkState((boolean)this.nextCalledByClient, (Object)MISSING_NEXT_CALL);
        return this.delegate.getBoolean(columnName);
    }

    @Override
    public long getLong(int columnIndex) {
        Preconditions.checkState((boolean)this.nextCalledByClient, (Object)MISSING_NEXT_CALL);
        return this.delegate.getLong(columnIndex);
    }

    @Override
    public long getLong(String columnName) {
        Preconditions.checkState((boolean)this.nextCalledByClient, (Object)MISSING_NEXT_CALL);
        return this.delegate.getLong(columnName);
    }

    @Override
    public double getDouble(int columnIndex) {
        Preconditions.checkState((boolean)this.nextCalledByClient, (Object)MISSING_NEXT_CALL);
        return this.delegate.getDouble(columnIndex);
    }

    @Override
    public BigDecimal getBigDecimal(String columnName) {
        Preconditions.checkState((boolean)this.nextCalledByClient, (Object)MISSING_NEXT_CALL);
        return this.delegate.getBigDecimal(columnName);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) {
        Preconditions.checkState((boolean)this.nextCalledByClient, (Object)MISSING_NEXT_CALL);
        return this.delegate.getBigDecimal(columnIndex);
    }

    @Override
    public double getDouble(String columnName) {
        Preconditions.checkState((boolean)this.nextCalledByClient, (Object)MISSING_NEXT_CALL);
        return this.delegate.getDouble(columnName);
    }

    @Override
    public String getString(int columnIndex) {
        Preconditions.checkState((boolean)this.nextCalledByClient, (Object)MISSING_NEXT_CALL);
        return this.delegate.getString(columnIndex);
    }

    @Override
    public String getString(String columnName) {
        Preconditions.checkState((boolean)this.nextCalledByClient, (Object)MISSING_NEXT_CALL);
        return this.delegate.getString(columnName);
    }

    @Override
    public String getJson(int columnIndex) {
        Preconditions.checkState((boolean)this.nextCalledByClient, (Object)MISSING_NEXT_CALL);
        return this.delegate.getJson(columnIndex);
    }

    @Override
    public String getJson(String columnName) {
        Preconditions.checkState((boolean)this.nextCalledByClient, (Object)MISSING_NEXT_CALL);
        return this.delegate.getJson(columnName);
    }

    @Override
    public String getPgJsonb(int columnIndex) {
        Preconditions.checkState((boolean)this.nextCalledByClient, (Object)MISSING_NEXT_CALL);
        return this.delegate.getPgJsonb(columnIndex);
    }

    @Override
    public String getPgJsonb(String columnName) {
        Preconditions.checkState((boolean)this.nextCalledByClient, (Object)MISSING_NEXT_CALL);
        return this.delegate.getPgJsonb(columnName);
    }

    @Override
    public ByteArray getBytes(int columnIndex) {
        Preconditions.checkState((boolean)this.nextCalledByClient, (Object)MISSING_NEXT_CALL);
        return this.delegate.getBytes(columnIndex);
    }

    @Override
    public ByteArray getBytes(String columnName) {
        Preconditions.checkState((boolean)this.nextCalledByClient, (Object)MISSING_NEXT_CALL);
        return this.delegate.getBytes(columnName);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) {
        Preconditions.checkState((boolean)this.nextCalledByClient, (Object)MISSING_NEXT_CALL);
        return this.delegate.getTimestamp(columnIndex);
    }

    @Override
    public Timestamp getTimestamp(String columnName) {
        Preconditions.checkState((boolean)this.nextCalledByClient, (Object)MISSING_NEXT_CALL);
        return this.delegate.getTimestamp(columnName);
    }

    @Override
    public Date getDate(int columnIndex) {
        Preconditions.checkState((boolean)this.nextCalledByClient, (Object)MISSING_NEXT_CALL);
        return this.delegate.getDate(columnIndex);
    }

    @Override
    public Date getDate(String columnName) {
        Preconditions.checkState((boolean)this.nextCalledByClient, (Object)MISSING_NEXT_CALL);
        return this.delegate.getDate(columnName);
    }

    @Override
    public Value getValue(int columnIndex) {
        Preconditions.checkState((boolean)this.nextCalledByClient, (Object)MISSING_NEXT_CALL);
        return this.delegate.getValue(columnIndex);
    }

    @Override
    public Value getValue(String columnName) {
        Preconditions.checkState((boolean)this.nextCalledByClient, (Object)MISSING_NEXT_CALL);
        return this.delegate.getValue(columnName);
    }

    @Override
    public boolean[] getBooleanArray(int columnIndex) {
        Preconditions.checkState((boolean)this.nextCalledByClient, (Object)MISSING_NEXT_CALL);
        return this.delegate.getBooleanArray(columnIndex);
    }

    @Override
    public boolean[] getBooleanArray(String columnName) {
        Preconditions.checkState((boolean)this.nextCalledByClient, (Object)MISSING_NEXT_CALL);
        return this.delegate.getBooleanArray(columnName);
    }

    @Override
    public List<Boolean> getBooleanList(int columnIndex) {
        Preconditions.checkState((boolean)this.nextCalledByClient, (Object)MISSING_NEXT_CALL);
        return this.delegate.getBooleanList(columnIndex);
    }

    @Override
    public List<Boolean> getBooleanList(String columnName) {
        Preconditions.checkState((boolean)this.nextCalledByClient, (Object)MISSING_NEXT_CALL);
        return this.delegate.getBooleanList(columnName);
    }

    @Override
    public long[] getLongArray(int columnIndex) {
        Preconditions.checkState((boolean)this.nextCalledByClient, (Object)MISSING_NEXT_CALL);
        return this.delegate.getLongArray(columnIndex);
    }

    @Override
    public long[] getLongArray(String columnName) {
        Preconditions.checkState((boolean)this.nextCalledByClient, (Object)MISSING_NEXT_CALL);
        return this.delegate.getLongArray(columnName);
    }

    @Override
    public List<Long> getLongList(int columnIndex) {
        Preconditions.checkState((boolean)this.nextCalledByClient, (Object)MISSING_NEXT_CALL);
        return this.delegate.getLongList(columnIndex);
    }

    @Override
    public List<Long> getLongList(String columnName) {
        Preconditions.checkState((boolean)this.nextCalledByClient, (Object)MISSING_NEXT_CALL);
        return this.delegate.getLongList(columnName);
    }

    @Override
    public double[] getDoubleArray(int columnIndex) {
        Preconditions.checkState((boolean)this.nextCalledByClient, (Object)MISSING_NEXT_CALL);
        return this.delegate.getDoubleArray(columnIndex);
    }

    @Override
    public double[] getDoubleArray(String columnName) {
        Preconditions.checkState((boolean)this.nextCalledByClient, (Object)MISSING_NEXT_CALL);
        return this.delegate.getDoubleArray(columnName);
    }

    @Override
    public List<Double> getDoubleList(int columnIndex) {
        Preconditions.checkState((boolean)this.nextCalledByClient, (Object)MISSING_NEXT_CALL);
        return this.delegate.getDoubleList(columnIndex);
    }

    @Override
    public List<Double> getDoubleList(String columnName) {
        Preconditions.checkState((boolean)this.nextCalledByClient, (Object)MISSING_NEXT_CALL);
        return this.delegate.getDoubleList(columnName);
    }

    @Override
    public List<BigDecimal> getBigDecimalList(int columnIndex) {
        Preconditions.checkState((boolean)this.nextCalledByClient, (Object)MISSING_NEXT_CALL);
        return this.delegate.getBigDecimalList(columnIndex);
    }

    @Override
    public List<BigDecimal> getBigDecimalList(String columnName) {
        Preconditions.checkState((boolean)this.nextCalledByClient, (Object)MISSING_NEXT_CALL);
        return this.delegate.getBigDecimalList(columnName);
    }

    @Override
    public List<String> getStringList(int columnIndex) {
        Preconditions.checkState((boolean)this.nextCalledByClient, (Object)MISSING_NEXT_CALL);
        return this.delegate.getStringList(columnIndex);
    }

    @Override
    public List<String> getStringList(String columnName) {
        Preconditions.checkState((boolean)this.nextCalledByClient, (Object)MISSING_NEXT_CALL);
        return this.delegate.getStringList(columnName);
    }

    @Override
    public List<String> getJsonList(int columnIndex) {
        Preconditions.checkState((boolean)this.nextCalledByClient, (Object)MISSING_NEXT_CALL);
        return this.delegate.getJsonList(columnIndex);
    }

    @Override
    public List<String> getJsonList(String columnName) {
        Preconditions.checkState((boolean)this.nextCalledByClient, (Object)MISSING_NEXT_CALL);
        return this.delegate.getJsonList(columnName);
    }

    @Override
    public List<String> getPgJsonbList(int columnIndex) {
        Preconditions.checkState((boolean)this.nextCalledByClient, (Object)MISSING_NEXT_CALL);
        return this.delegate.getPgJsonbList(columnIndex);
    }

    @Override
    public List<String> getPgJsonbList(String columnName) {
        Preconditions.checkState((boolean)this.nextCalledByClient, (Object)MISSING_NEXT_CALL);
        return this.delegate.getPgJsonbList(columnName);
    }

    @Override
    public List<ByteArray> getBytesList(int columnIndex) {
        Preconditions.checkState((boolean)this.nextCalledByClient, (Object)MISSING_NEXT_CALL);
        return this.delegate.getBytesList(columnIndex);
    }

    @Override
    public List<ByteArray> getBytesList(String columnName) {
        Preconditions.checkState((boolean)this.nextCalledByClient, (Object)MISSING_NEXT_CALL);
        return this.delegate.getBytesList(columnName);
    }

    @Override
    public List<Timestamp> getTimestampList(int columnIndex) {
        Preconditions.checkState((boolean)this.nextCalledByClient, (Object)MISSING_NEXT_CALL);
        return this.delegate.getTimestampList(columnIndex);
    }

    @Override
    public List<Timestamp> getTimestampList(String columnName) {
        Preconditions.checkState((boolean)this.nextCalledByClient, (Object)MISSING_NEXT_CALL);
        return this.delegate.getTimestampList(columnName);
    }

    @Override
    public List<Date> getDateList(int columnIndex) {
        Preconditions.checkState((boolean)this.nextCalledByClient, (Object)MISSING_NEXT_CALL);
        return this.delegate.getDateList(columnIndex);
    }

    @Override
    public List<Date> getDateList(String columnName) {
        Preconditions.checkState((boolean)this.nextCalledByClient, (Object)MISSING_NEXT_CALL);
        return this.delegate.getDateList(columnName);
    }

    @Override
    public List<Struct> getStructList(int columnIndex) {
        Preconditions.checkState((boolean)this.nextCalledByClient, (Object)MISSING_NEXT_CALL);
        return this.delegate.getStructList(columnIndex);
    }

    @Override
    public List<Struct> getStructList(String columnName) {
        Preconditions.checkState((boolean)this.nextCalledByClient, (Object)MISSING_NEXT_CALL);
        return this.delegate.getStructList(columnName);
    }

    public boolean equals(Object o) {
        if (!(o instanceof DirectExecuteResultSet)) {
            return false;
        }
        return ((DirectExecuteResultSet)o).delegate.equals(this.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }
}

