/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.Page;
import com.google.cloud.Policy;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.BackupId;
import com.google.cloud.spanner.BackupInfo;
import com.google.cloud.spanner.Database;
import com.google.cloud.spanner.DatabaseAdminClient;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.encryption.EncryptionInfo;
import com.google.common.base.Preconditions;
import com.google.longrunning.Operation;
import com.google.spanner.admin.database.v1.Backup;
import com.google.spanner.admin.database.v1.CreateBackupMetadata;
import com.google.spanner.admin.database.v1.RestoreDatabaseMetadata;
import java.util.List;

public class Backup
extends BackupInfo {
    private static final String FILTER_BACKUP_OPERATIONS_TEMPLATE = "name:backups/%s";
    private final DatabaseAdminClient dbClient;

    Backup(Builder builder) {
        super(builder);
        this.dbClient = (DatabaseAdminClient)com.google.api.client.util.Preconditions.checkNotNull((Object)builder.dbClient);
    }

    public OperationFuture<Backup, CreateBackupMetadata> create() {
        return this.dbClient.createBackup(this);
    }

    public boolean exists() {
        try {
            this.dbClient.getBackup(this.instance(), this.backup());
        }
        catch (SpannerException e) {
            if (e.getErrorCode() == ErrorCode.NOT_FOUND) {
                return false;
            }
            throw e;
        }
        return true;
    }

    public boolean isReady() {
        return this.reload().getState() == BackupInfo.State.READY;
    }

    public Backup reload() throws SpannerException {
        return this.dbClient.getBackup(this.instance(), this.backup());
    }

    public void delete() throws SpannerException {
        this.dbClient.deleteBackup(this.instance(), this.backup());
    }

    public void updateExpireTime() {
        com.google.api.client.util.Preconditions.checkState((this.getExpireTime() != null ? 1 : 0) != 0, (Object)"This backup has no expire time");
        this.dbClient.updateBackup(this.instance(), this.backup(), this.getExpireTime());
    }

    public OperationFuture<Database, RestoreDatabaseMetadata> restore(DatabaseId database) {
        com.google.api.client.util.Preconditions.checkNotNull((Object)database);
        return this.dbClient.restoreDatabase(this.instance(), this.backup(), database.getInstanceId().getInstance(), database.getDatabase());
    }

    public Page<Operation> listBackupOperations() {
        return this.dbClient.listBackupOperations(this.instance(), Options.filter(String.format(FILTER_BACKUP_OPERATIONS_TEMPLATE, this.backup())));
    }

    public Policy getIAMPolicy() {
        return this.dbClient.getBackupIAMPolicy(this.instance(), this.backup());
    }

    public Policy setIAMPolicy(Policy policy) {
        return this.dbClient.setBackupIAMPolicy(this.instance(), this.backup(), policy);
    }

    public Iterable<String> testIAMPermissions(Iterable<String> permissions) {
        return this.dbClient.testBackupIAMPermissions(this.instance(), this.backup(), permissions);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private String instance() {
        return this.getInstanceId().getInstance();
    }

    private String backup() {
        return this.getId().getBackup();
    }

    private String sourceDatabase() {
        return this.getDatabase().getDatabase();
    }

    static Backup fromProto(com.google.spanner.admin.database.v1.Backup proto, DatabaseAdminClient client) {
        Preconditions.checkArgument((!proto.getName().isEmpty() ? 1 : 0) != 0, (Object)"Missing expected 'name' field");
        Preconditions.checkArgument((!proto.getDatabase().isEmpty() ? 1 : 0) != 0, (Object)"Missing expected 'database' field");
        return new Builder(client, BackupId.of(proto.getName())).setState(Backup.fromProtoState(proto.getState())).setSize(proto.getSizeBytes()).setExpireTime(Timestamp.fromProto((com.google.protobuf.Timestamp)proto.getExpireTime())).setVersionTime(Timestamp.fromProto((com.google.protobuf.Timestamp)proto.getVersionTime())).setDatabase(DatabaseId.of(proto.getDatabase())).setEncryptionInfo(EncryptionInfo.fromProtoOrNull(proto.getEncryptionInfo())).setProto(proto).setMaxExpireTime(Timestamp.fromProto((com.google.protobuf.Timestamp)proto.getMaxExpireTime())).addAllReferencingBackups((List<String>)proto.getReferencingBackupsList()).build();
    }

    static BackupInfo.State fromProtoState(Backup.State protoState) {
        switch (protoState) {
            case STATE_UNSPECIFIED: {
                return BackupInfo.State.UNSPECIFIED;
            }
            case CREATING: {
                return BackupInfo.State.CREATING;
            }
            case READY: {
                return BackupInfo.State.READY;
            }
        }
        throw new IllegalArgumentException("Unrecognized state " + protoState);
    }

    public static class Builder
    extends BackupInfo.BuilderImpl {
        private final DatabaseAdminClient dbClient;

        Builder(DatabaseAdminClient dbClient, BackupId backupId) {
            super(backupId);
            this.dbClient = (DatabaseAdminClient)com.google.api.client.util.Preconditions.checkNotNull((Object)dbClient);
        }

        private Builder(Backup backup) {
            super(backup);
            this.dbClient = backup.dbClient;
        }

        @Override
        public Backup build() {
            return new Backup(this);
        }
    }
}

