/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.gax.rpc.ServerStream;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.AsyncRunner;
import com.google.cloud.spanner.AsyncTransactionManager;
import com.google.cloud.spanner.CommitResponse;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.Dialect;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.MutationGroup;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ReadContext;
import com.google.cloud.spanner.ReadOnlyTransaction;
import com.google.cloud.spanner.Session;
import com.google.cloud.spanner.SessionNotFoundException;
import com.google.cloud.spanner.SessionPool;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerImpl;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.TimestampBound;
import com.google.cloud.spanner.TraceUtil;
import com.google.cloud.spanner.TransactionManager;
import com.google.cloud.spanner.TransactionRunner;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.spanner.v1.BatchWriteResponse;
import io.opencensus.common.Scope;
import io.opencensus.trace.Span;
import io.opencensus.trace.Tracer;
import io.opencensus.trace.Tracing;
import javax.annotation.Nullable;

class DatabaseClientImpl
implements DatabaseClient {
    private static final String READ_WRITE_TRANSACTION = "CloudSpanner.ReadWriteTransaction";
    private static final String READ_ONLY_TRANSACTION = "CloudSpanner.ReadOnlyTransaction";
    private static final String PARTITION_DML_TRANSACTION = "CloudSpanner.PartitionDMLTransaction";
    private static final Tracer tracer = Tracing.getTracer();
    @VisibleForTesting
    final String clientId;
    @VisibleForTesting
    final SessionPool pool;

    @VisibleForTesting
    DatabaseClientImpl(SessionPool pool) {
        this("", pool);
    }

    DatabaseClientImpl(String clientId, SessionPool pool) {
        this.clientId = clientId;
        this.pool = pool;
    }

    @VisibleForTesting
    SessionPool.PooledSessionFuture getSession() {
        return this.pool.getSession();
    }

    @Override
    public Dialect getDialect() {
        return this.pool.getDialect();
    }

    @Override
    @Nullable
    public String getDatabaseRole() {
        return this.pool.getDatabaseRole();
    }

    @Override
    public Timestamp write(Iterable<Mutation> mutations) throws SpannerException {
        return this.writeWithOptions(mutations, new Options.TransactionOption[0]).getCommitTimestamp();
    }

    @Override
    public CommitResponse writeWithOptions(Iterable<Mutation> mutations, Options.TransactionOption ... options) throws SpannerException {
        Span span = tracer.spanBuilder(READ_WRITE_TRANSACTION).startSpan();
        try {
            CommitResponse commitResponse;
            block11: {
                Scope s = tracer.withSpan(span);
                try {
                    commitResponse = (CommitResponse)this.runWithSessionRetry(session -> session.writeWithOptions(mutations, options));
                    if (s == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (s != null) {
                            try {
                                s.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (RuntimeException e) {
                        TraceUtil.setWithFailure(span, e);
                        throw e;
                    }
                }
                s.close();
            }
            return commitResponse;
        }
        finally {
            span.end(TraceUtil.END_SPAN_OPTIONS);
        }
    }

    @Override
    public Timestamp writeAtLeastOnce(Iterable<Mutation> mutations) throws SpannerException {
        return this.writeAtLeastOnceWithOptions(mutations, new Options.TransactionOption[0]).getCommitTimestamp();
    }

    @Override
    public CommitResponse writeAtLeastOnceWithOptions(Iterable<Mutation> mutations, Options.TransactionOption ... options) throws SpannerException {
        Span span = tracer.spanBuilder(READ_WRITE_TRANSACTION).startSpan();
        try {
            CommitResponse commitResponse;
            block11: {
                Scope s = tracer.withSpan(span);
                try {
                    commitResponse = (CommitResponse)this.runWithSessionRetry(session -> session.writeAtLeastOnceWithOptions(mutations, options));
                    if (s == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (s != null) {
                            try {
                                s.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (RuntimeException e) {
                        TraceUtil.setWithFailure(span, e);
                        throw e;
                    }
                }
                s.close();
            }
            return commitResponse;
        }
        finally {
            span.end(TraceUtil.END_SPAN_OPTIONS);
        }
    }

    @Override
    public ServerStream<BatchWriteResponse> batchWriteAtLeastOnce(Iterable<MutationGroup> mutationGroups, Options.TransactionOption ... options) throws SpannerException {
        Span span = tracer.spanBuilder(READ_WRITE_TRANSACTION).startSpan();
        try {
            ServerStream serverStream;
            block11: {
                Scope s = tracer.withSpan(span);
                try {
                    serverStream = (ServerStream)this.runWithSessionRetry(session -> session.batchWriteAtLeastOnce(mutationGroups, options));
                    if (s == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (s != null) {
                            try {
                                s.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (RuntimeException e) {
                        TraceUtil.setWithFailure(span, e);
                        throw e;
                    }
                }
                s.close();
            }
            return serverStream;
        }
        finally {
            span.end(TraceUtil.END_SPAN_OPTIONS);
        }
    }

    @Override
    public ReadContext singleUse() {
        ReadContext readContext;
        block8: {
            Span span = tracer.spanBuilder(READ_ONLY_TRANSACTION).startSpan();
            Scope s = tracer.withSpan(span);
            try {
                readContext = this.getSession().singleUse();
                if (s == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (s != null) {
                        try {
                            s.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (RuntimeException e) {
                    TraceUtil.endSpanWithFailure(span, e);
                    throw e;
                }
            }
            s.close();
        }
        return readContext;
    }

    @Override
    public ReadContext singleUse(TimestampBound bound) {
        ReadContext readContext;
        block8: {
            Span span = tracer.spanBuilder(READ_ONLY_TRANSACTION).startSpan();
            Scope s = tracer.withSpan(span);
            try {
                readContext = this.getSession().singleUse(bound);
                if (s == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (s != null) {
                        try {
                            s.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (RuntimeException e) {
                    TraceUtil.endSpanWithFailure(span, e);
                    throw e;
                }
            }
            s.close();
        }
        return readContext;
    }

    @Override
    public ReadOnlyTransaction singleUseReadOnlyTransaction() {
        ReadOnlyTransaction readOnlyTransaction;
        block8: {
            Span span = tracer.spanBuilder(READ_ONLY_TRANSACTION).startSpan();
            Scope s = tracer.withSpan(span);
            try {
                readOnlyTransaction = this.getSession().singleUseReadOnlyTransaction();
                if (s == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (s != null) {
                        try {
                            s.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (RuntimeException e) {
                    TraceUtil.endSpanWithFailure(span, e);
                    throw e;
                }
            }
            s.close();
        }
        return readOnlyTransaction;
    }

    @Override
    public ReadOnlyTransaction singleUseReadOnlyTransaction(TimestampBound bound) {
        ReadOnlyTransaction readOnlyTransaction;
        block8: {
            Span span = tracer.spanBuilder(READ_ONLY_TRANSACTION).startSpan();
            Scope s = tracer.withSpan(span);
            try {
                readOnlyTransaction = this.getSession().singleUseReadOnlyTransaction(bound);
                if (s == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (s != null) {
                        try {
                            s.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (RuntimeException e) {
                    TraceUtil.endSpanWithFailure(span, e);
                    throw e;
                }
            }
            s.close();
        }
        return readOnlyTransaction;
    }

    @Override
    public ReadOnlyTransaction readOnlyTransaction() {
        ReadOnlyTransaction readOnlyTransaction;
        block8: {
            Span span = tracer.spanBuilder(READ_ONLY_TRANSACTION).startSpan();
            Scope s = tracer.withSpan(span);
            try {
                readOnlyTransaction = this.getSession().readOnlyTransaction();
                if (s == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (s != null) {
                        try {
                            s.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (RuntimeException e) {
                    TraceUtil.endSpanWithFailure(span, e);
                    throw e;
                }
            }
            s.close();
        }
        return readOnlyTransaction;
    }

    @Override
    public ReadOnlyTransaction readOnlyTransaction(TimestampBound bound) {
        ReadOnlyTransaction readOnlyTransaction;
        block8: {
            Span span = tracer.spanBuilder(READ_ONLY_TRANSACTION).startSpan();
            Scope s = tracer.withSpan(span);
            try {
                readOnlyTransaction = this.getSession().readOnlyTransaction(bound);
                if (s == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (s != null) {
                        try {
                            s.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (RuntimeException e) {
                    TraceUtil.endSpanWithFailure(span, e);
                    throw e;
                }
            }
            s.close();
        }
        return readOnlyTransaction;
    }

    @Override
    public TransactionRunner readWriteTransaction(Options.TransactionOption ... options) {
        Span span = tracer.spanBuilder(READ_WRITE_TRANSACTION).startSpan();
        try {
            TransactionRunner transactionRunner;
            block11: {
                Scope s = tracer.withSpan(span);
                try {
                    transactionRunner = this.getSession().readWriteTransaction(options);
                    if (s == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (s != null) {
                            try {
                                s.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (RuntimeException e) {
                        TraceUtil.endSpanWithFailure(span, e);
                        throw e;
                    }
                }
                s.close();
            }
            return transactionRunner;
        }
        finally {
            span.end(TraceUtil.END_SPAN_OPTIONS);
        }
    }

    @Override
    public TransactionManager transactionManager(Options.TransactionOption ... options) {
        TransactionManager transactionManager;
        block8: {
            Span span = tracer.spanBuilder(READ_WRITE_TRANSACTION).startSpan();
            Scope s = tracer.withSpan(span);
            try {
                transactionManager = this.getSession().transactionManager(options);
                if (s == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (s != null) {
                        try {
                            s.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (RuntimeException e) {
                    TraceUtil.endSpanWithFailure(span, e);
                    throw e;
                }
            }
            s.close();
        }
        return transactionManager;
    }

    @Override
    public AsyncRunner runAsync(Options.TransactionOption ... options) {
        AsyncRunner asyncRunner;
        block8: {
            Span span = tracer.spanBuilder(READ_WRITE_TRANSACTION).startSpan();
            Scope s = tracer.withSpan(span);
            try {
                asyncRunner = this.getSession().runAsync(options);
                if (s == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (s != null) {
                        try {
                            s.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (RuntimeException e) {
                    TraceUtil.endSpanWithFailure(span, e);
                    throw e;
                }
            }
            s.close();
        }
        return asyncRunner;
    }

    @Override
    public AsyncTransactionManager transactionManagerAsync(Options.TransactionOption ... options) {
        AsyncTransactionManager asyncTransactionManager;
        block8: {
            Span span = tracer.spanBuilder(READ_WRITE_TRANSACTION).startSpan();
            Scope s = tracer.withSpan(span);
            try {
                asyncTransactionManager = this.getSession().transactionManagerAsync(options);
                if (s == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (s != null) {
                        try {
                            s.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (RuntimeException e) {
                    TraceUtil.endSpanWithFailure(span, e);
                    throw e;
                }
            }
            s.close();
        }
        return asyncTransactionManager;
    }

    @Override
    public long executePartitionedUpdate(Statement stmt, Options.UpdateOption ... options) {
        long l;
        block8: {
            Span span = tracer.spanBuilder(PARTITION_DML_TRANSACTION).startSpan();
            Scope s = tracer.withSpan(span);
            try {
                l = (Long)this.runWithSessionRetry(session -> session.executePartitionedUpdate(stmt, options));
                if (s == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (s != null) {
                        try {
                            s.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (RuntimeException e) {
                    TraceUtil.endSpanWithFailure(span, e);
                    throw e;
                }
            }
            s.close();
        }
        return l;
    }

    private <T> T runWithSessionRetry(Function<Session, T> callable) {
        SessionPool.PooledSessionFuture session = this.getSession();
        while (true) {
            try {
                return (T)callable.apply((Object)session);
            }
            catch (SessionNotFoundException e) {
                session = this.pool.replaceSession(e, session);
                continue;
            }
            break;
        }
    }

    ListenableFuture<Void> closeAsync(SpannerImpl.ClosedException closedException) {
        return this.pool.closeAsync(closedException);
    }
}

