/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.common.annotations.VisibleForTesting;
import com.google.spanner.admin.instance.v1.ReplicaInfo;
import java.util.Objects;

public class ReplicaInfo {
    private final String location;
    private final ReplicaType type;
    private final boolean defaultLeaderLocation;
    private final com.google.spanner.admin.instance.v1.ReplicaInfo proto;

    public static ReplicaInfo fromProto(com.google.spanner.admin.instance.v1.ReplicaInfo proto) {
        return ReplicaInfo.newBuilder().setLocation(proto.getLocation()).setType(ReplicaType.fromProto(proto.getType())).setDefaultLeaderLocation(proto.getDefaultLeaderLocation()).setProto(proto).build();
    }

    static Builder newBuilder() {
        return new BuilderImpl();
    }

    @VisibleForTesting
    ReplicaInfo(String location, ReplicaType type, boolean defaultLeaderLocation, com.google.spanner.admin.instance.v1.ReplicaInfo proto) {
        this.location = location;
        this.type = type;
        this.defaultLeaderLocation = defaultLeaderLocation;
        this.proto = proto;
    }

    ReplicaInfo(BuilderImpl builder) {
        this.location = builder.location;
        this.type = builder.type;
        this.defaultLeaderLocation = builder.defaultLeaderLocation;
        this.proto = builder.proto;
    }

    public String getLocation() {
        return this.location;
    }

    public ReplicaType getType() {
        return this.type;
    }

    public boolean isDefaultLeaderLocation() {
        return this.defaultLeaderLocation;
    }

    public com.google.spanner.admin.instance.v1.ReplicaInfo getProto() {
        return this.proto;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ReplicaInfo)) {
            return false;
        }
        ReplicaInfo that = (ReplicaInfo)o;
        return this.defaultLeaderLocation == that.defaultLeaderLocation && Objects.equals(this.location, that.location) && this.type == that.type;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.location, this.type, this.defaultLeaderLocation});
    }

    public String toString() {
        return "ReplicaInfo{location='" + this.location + '\'' + ", type=" + (Object)((Object)this.type) + ", defaultLeaderLocation=" + this.defaultLeaderLocation + '}';
    }

    static abstract class Builder {
        Builder() {
        }

        abstract Builder setLocation(String var1);

        abstract Builder setType(ReplicaType var1);

        abstract Builder setDefaultLeaderLocation(boolean var1);

        abstract Builder setProto(com.google.spanner.admin.instance.v1.ReplicaInfo var1);

        public abstract ReplicaInfo build();
    }

    public static enum ReplicaType {
        TYPE_UNSPECIFIED,
        READ_WRITE,
        READ_ONLY,
        WITNESS;


        public static ReplicaType fromProto(ReplicaInfo.ReplicaType proto) {
            switch (proto) {
                case TYPE_UNSPECIFIED: {
                    return TYPE_UNSPECIFIED;
                }
                case READ_WRITE: {
                    return READ_WRITE;
                }
                case READ_ONLY: {
                    return READ_ONLY;
                }
                case WITNESS: {
                    return WITNESS;
                }
            }
            throw new IllegalArgumentException("Unrecognized replica type " + proto);
        }
    }

    public static class BuilderImpl
    extends Builder {
        private String location;
        private ReplicaType type;
        private boolean defaultLeaderLocation;
        private com.google.spanner.admin.instance.v1.ReplicaInfo proto;

        @Override
        Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        @Override
        Builder setType(ReplicaType type) {
            this.type = type;
            return this;
        }

        @Override
        Builder setDefaultLeaderLocation(boolean defaultLeaderLocation) {
            this.defaultLeaderLocation = defaultLeaderLocation;
            return this;
        }

        @Override
        Builder setProto(com.google.spanner.admin.instance.v1.ReplicaInfo proto) {
            this.proto = proto;
            return this;
        }

        @Override
        public ReplicaInfo build() {
            return new ReplicaInfo(this);
        }
    }
}

