/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.core.ApiFuture;
import com.google.api.core.SettableApiFuture;
import com.google.api.gax.rpc.ServerStream;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.AbstractReadContext;
import com.google.cloud.spanner.AsyncRunner;
import com.google.cloud.spanner.AsyncRunnerImpl;
import com.google.cloud.spanner.AsyncTransactionManagerImpl;
import com.google.cloud.spanner.Clock;
import com.google.cloud.spanner.CommitResponse;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.MutationGroup;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.PartitionedDmlTransaction;
import com.google.cloud.spanner.ReadContext;
import com.google.cloud.spanner.ReadOnlyTransaction;
import com.google.cloud.spanner.Session;
import com.google.cloud.spanner.SessionClient;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.SpannerImpl;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.SpannerRetryHelper;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.TimestampBound;
import com.google.cloud.spanner.TraceUtil;
import com.google.cloud.spanner.TransactionManager;
import com.google.cloud.spanner.TransactionManagerImpl;
import com.google.cloud.spanner.TransactionRunner;
import com.google.cloud.spanner.TransactionRunnerImpl;
import com.google.cloud.spanner.spi.v1.SpannerRpc;
import com.google.common.base.Preconditions;
import com.google.common.base.Ticker;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.ByteString;
import com.google.protobuf.Empty;
import com.google.spanner.v1.BatchWriteRequest;
import com.google.spanner.v1.BatchWriteResponse;
import com.google.spanner.v1.BeginTransactionRequest;
import com.google.spanner.v1.CommitRequest;
import com.google.spanner.v1.RequestOptions;
import com.google.spanner.v1.Transaction;
import com.google.spanner.v1.TransactionOptions;
import io.opencensus.common.Scope;
import io.opencensus.trace.Span;
import io.opencensus.trace.Tracer;
import io.opencensus.trace.Tracing;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;
import org.threeten.bp.Instant;

class SessionImpl
implements Session {
    private static final Tracer tracer = Tracing.getTracer();
    static final ThreadLocal<Boolean> hasPendingTransaction = ThreadLocal.withInitial(() -> false);
    private final SpannerImpl spanner;
    private final String name;
    private final DatabaseId databaseId;
    private SessionTransaction activeTransaction;
    ByteString readyTransactionId;
    private final Map<SpannerRpc.Option, ?> options;
    private Span currentSpan;
    private volatile Instant lastUseTime;

    static void throwIfTransactionsPending() {
        if (hasPendingTransaction.get() == Boolean.TRUE) {
            throw SpannerExceptionFactory.newSpannerException(ErrorCode.INTERNAL, "Nested transactions are not supported");
        }
    }

    static TransactionOptions createReadWriteTransactionOptions(Options options) {
        TransactionOptions.ReadWrite.Builder readWrite = TransactionOptions.ReadWrite.newBuilder();
        if (options.withOptimisticLock() == Boolean.TRUE) {
            readWrite.setReadLockMode(TransactionOptions.ReadWrite.ReadLockMode.OPTIMISTIC);
        }
        return TransactionOptions.newBuilder().setReadWrite(readWrite).build();
    }

    SessionImpl(SpannerImpl spanner, String name, Map<SpannerRpc.Option, ?> options) {
        this.spanner = spanner;
        this.options = options;
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.databaseId = SessionClient.SessionId.of(name).getDatabaseId();
        this.lastUseTime = Instant.now();
    }

    @Override
    public String getName() {
        return this.name;
    }

    Map<SpannerRpc.Option, ?> getOptions() {
        return this.options;
    }

    void setCurrentSpan(Span span) {
        this.currentSpan = span;
    }

    Span getCurrentSpan() {
        return this.currentSpan;
    }

    Instant getLastUseTime() {
        return this.lastUseTime;
    }

    void markUsed(Instant instant) {
        this.lastUseTime = instant;
    }

    @Override
    public long executePartitionedUpdate(Statement stmt, Options.UpdateOption ... options) {
        this.setActive(null);
        PartitionedDmlTransaction txn = new PartitionedDmlTransaction(this, this.spanner.getRpc(), Ticker.systemTicker());
        return txn.executeStreamingPartitionedUpdate(stmt, ((SpannerOptions)this.spanner.getOptions()).getPartitionedDmlTimeout(), options);
    }

    @Override
    public Timestamp write(Iterable<Mutation> mutations) throws SpannerException {
        return this.writeWithOptions(mutations, new Options.TransactionOption[0]).getCommitTimestamp();
    }

    @Override
    public CommitResponse writeWithOptions(Iterable<Mutation> mutations, Options.TransactionOption ... options) throws SpannerException {
        TransactionRunner runner = this.readWriteTransaction(options);
        Collection finalMutations = mutations instanceof Collection ? (Collection)mutations : Lists.newArrayList(mutations);
        runner.run(ctx -> {
            ctx.buffer(finalMutations);
            return null;
        });
        return runner.getCommitResponse();
    }

    @Override
    public Timestamp writeAtLeastOnce(Iterable<Mutation> mutations) throws SpannerException {
        return this.writeAtLeastOnceWithOptions(mutations, new Options.TransactionOption[0]).getCommitTimestamp();
    }

    @Override
    public CommitResponse writeAtLeastOnceWithOptions(Iterable<Mutation> mutations, Options.TransactionOption ... transactionOptions) throws SpannerException {
        this.setActive(null);
        ArrayList<com.google.spanner.v1.Mutation> mutationsProto = new ArrayList<com.google.spanner.v1.Mutation>();
        Mutation.toProto(mutations, mutationsProto);
        CommitRequest.Builder requestBuilder = CommitRequest.newBuilder().setSession(this.name).setReturnCommitStats(Options.fromTransactionOptions(transactionOptions).withCommitStats()).addAllMutations(mutationsProto).setSingleUseTransaction(TransactionOptions.newBuilder().setReadWrite(TransactionOptions.ReadWrite.getDefaultInstance()));
        RequestOptions commitRequestOptions = this.getRequestOptions(transactionOptions);
        if (commitRequestOptions != null) {
            requestBuilder.setRequestOptions(commitRequestOptions);
        }
        CommitRequest request = requestBuilder.build();
        Span span = tracer.spanBuilder("CloudSpannerOperation.Commit").startSpan();
        try {
            CommitResponse commitResponse;
            block12: {
                Scope s = tracer.withSpan(span);
                try {
                    commitResponse = SpannerRetryHelper.runTxWithRetriesOnAborted(() -> new CommitResponse(this.spanner.getRpc().commit(request, this.options)));
                    if (s == null) break block12;
                }
                catch (Throwable throwable) {
                    try {
                        if (s != null) {
                            try {
                                s.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (RuntimeException e) {
                        TraceUtil.setWithFailure(span, e);
                        throw e;
                    }
                }
                s.close();
            }
            return commitResponse;
        }
        finally {
            span.end(TraceUtil.END_SPAN_OPTIONS);
        }
    }

    private RequestOptions getRequestOptions(Options.TransactionOption ... transactionOptions) {
        Options requestOptions = Options.fromTransactionOptions(transactionOptions);
        if (requestOptions.hasPriority() || requestOptions.hasTag()) {
            RequestOptions.Builder requestOptionsBuilder = RequestOptions.newBuilder();
            if (requestOptions.hasPriority()) {
                requestOptionsBuilder.setPriority(requestOptions.priority());
            }
            if (requestOptions.hasTag()) {
                requestOptionsBuilder.setTransactionTag(requestOptions.tag());
            }
            return requestOptionsBuilder.build();
        }
        return null;
    }

    @Override
    public ServerStream<BatchWriteResponse> batchWriteAtLeastOnce(Iterable<MutationGroup> mutationGroups, Options.TransactionOption ... transactionOptions) throws SpannerException {
        this.setActive(null);
        List<BatchWriteRequest.MutationGroup> mutationGroupsProto = MutationGroup.toListProto(mutationGroups);
        BatchWriteRequest.Builder requestBuilder = BatchWriteRequest.newBuilder().setSession(this.name).addAllMutationGroups(mutationGroupsProto);
        RequestOptions batchWriteRequestOptions = this.getRequestOptions(transactionOptions);
        if (batchWriteRequestOptions != null) {
            requestBuilder.setRequestOptions(batchWriteRequestOptions);
        }
        Span span = tracer.spanBuilder("CloudSpannerOperation.BatchWrite").startSpan();
        try {
            ServerStream<BatchWriteResponse> serverStream;
            block12: {
                Scope s = tracer.withSpan(span);
                try {
                    serverStream = this.spanner.getRpc().batchWriteAtLeastOnce(requestBuilder.build(), this.options);
                    if (s == null) break block12;
                }
                catch (Throwable throwable) {
                    try {
                        if (s != null) {
                            try {
                                s.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable e) {
                        TraceUtil.setWithFailure(span, e);
                        throw SpannerExceptionFactory.newSpannerException(e);
                    }
                }
                s.close();
            }
            return serverStream;
        }
        finally {
            span.end(TraceUtil.END_SPAN_OPTIONS);
        }
    }

    @Override
    public ReadContext singleUse() {
        return this.singleUse(TimestampBound.strong());
    }

    @Override
    public ReadContext singleUse(TimestampBound bound) {
        return this.setActive(((AbstractReadContext.SingleReadContext.Builder)((AbstractReadContext.SingleReadContext.Builder)((AbstractReadContext.SingleReadContext.Builder)((AbstractReadContext.SingleReadContext.Builder)((AbstractReadContext.SingleReadContext.Builder)((AbstractReadContext.SingleReadContext.Builder)AbstractReadContext.SingleReadContext.newBuilder().setSession(this)).setTimestampBound(bound).setRpc(this.spanner.getRpc())).setDefaultQueryOptions(this.spanner.getDefaultQueryOptions(this.databaseId))).setDefaultPrefetchChunks(this.spanner.getDefaultPrefetchChunks())).setSpan(this.currentSpan)).setExecutorProvider(this.spanner.getAsyncExecutorProvider())).build());
    }

    @Override
    public ReadOnlyTransaction singleUseReadOnlyTransaction() {
        return this.singleUseReadOnlyTransaction(TimestampBound.strong());
    }

    @Override
    public ReadOnlyTransaction singleUseReadOnlyTransaction(TimestampBound bound) {
        return this.setActive(((AbstractReadContext.SingleReadContext.Builder)((AbstractReadContext.SingleReadContext.Builder)((AbstractReadContext.SingleReadContext.Builder)((AbstractReadContext.SingleReadContext.Builder)((AbstractReadContext.SingleReadContext.Builder)((AbstractReadContext.SingleReadContext.Builder)AbstractReadContext.SingleUseReadOnlyTransaction.newBuilder().setSession(this)).setTimestampBound(bound).setRpc(this.spanner.getRpc())).setDefaultQueryOptions(this.spanner.getDefaultQueryOptions(this.databaseId))).setDefaultPrefetchChunks(this.spanner.getDefaultPrefetchChunks())).setSpan(this.currentSpan)).setExecutorProvider(this.spanner.getAsyncExecutorProvider())).buildSingleUseReadOnlyTransaction());
    }

    @Override
    public ReadOnlyTransaction readOnlyTransaction() {
        return this.readOnlyTransaction(TimestampBound.strong());
    }

    @Override
    public ReadOnlyTransaction readOnlyTransaction(TimestampBound bound) {
        return this.setActive(((AbstractReadContext.MultiUseReadOnlyTransaction.Builder)((AbstractReadContext.MultiUseReadOnlyTransaction.Builder)((AbstractReadContext.MultiUseReadOnlyTransaction.Builder)((AbstractReadContext.MultiUseReadOnlyTransaction.Builder)((AbstractReadContext.MultiUseReadOnlyTransaction.Builder)((AbstractReadContext.MultiUseReadOnlyTransaction.Builder)AbstractReadContext.MultiUseReadOnlyTransaction.newBuilder().setSession(this)).setTimestampBound(bound).setRpc(this.spanner.getRpc())).setDefaultQueryOptions(this.spanner.getDefaultQueryOptions(this.databaseId))).setDefaultPrefetchChunks(this.spanner.getDefaultPrefetchChunks())).setSpan(this.currentSpan)).setExecutorProvider(this.spanner.getAsyncExecutorProvider())).build());
    }

    @Override
    public TransactionRunner readWriteTransaction(Options.TransactionOption ... options) {
        return this.setActive(new TransactionRunnerImpl(this, options));
    }

    @Override
    public AsyncRunner runAsync(Options.TransactionOption ... options) {
        return new AsyncRunnerImpl(this.setActive(new TransactionRunnerImpl(this, options)));
    }

    @Override
    public TransactionManager transactionManager(Options.TransactionOption ... options) {
        return new TransactionManagerImpl(this, this.currentSpan, options);
    }

    @Override
    public AsyncTransactionManagerImpl transactionManagerAsync(Options.TransactionOption ... options) {
        return new AsyncTransactionManagerImpl(this, this.currentSpan, options);
    }

    @Override
    public void prepareReadWriteTransaction() {
        this.setActive(null);
        this.readyTransactionId = this.beginTransaction(true);
    }

    @Override
    public ApiFuture<Empty> asyncClose() {
        return this.spanner.getRpc().asyncDeleteSession(this.name, this.options);
    }

    @Override
    public void close() {
        Span span = tracer.spanBuilder("CloudSpannerOperation.DeleteSession").startSpan();
        try (Scope s = tracer.withSpan(span);){
            this.spanner.getRpc().deleteSession(this.name, this.options);
        }
        catch (RuntimeException e) {
            TraceUtil.setWithFailure(span, e);
            throw e;
        }
        finally {
            span.end(TraceUtil.END_SPAN_OPTIONS);
        }
    }

    ByteString beginTransaction(boolean routeToLeader) {
        try {
            return (ByteString)this.beginTransactionAsync(routeToLeader).get();
        }
        catch (ExecutionException e) {
            throw SpannerExceptionFactory.newSpannerException(e.getCause() == null ? e : e.getCause());
        }
        catch (InterruptedException e) {
            throw SpannerExceptionFactory.propagateInterrupt(e);
        }
    }

    ApiFuture<ByteString> beginTransactionAsync(boolean routeToLeader) {
        return this.beginTransactionAsync(Options.fromTransactionOptions(new Options.TransactionOption[0]), routeToLeader);
    }

    ApiFuture<ByteString> beginTransactionAsync(Options transactionOptions, boolean routeToLeader) {
        SettableApiFuture res = SettableApiFuture.create();
        Span span = tracer.spanBuilder("CloudSpannerOperation.BeginTransaction").startSpan();
        BeginTransactionRequest request = BeginTransactionRequest.newBuilder().setSession(this.name).setOptions(SessionImpl.createReadWriteTransactionOptions(transactionOptions)).build();
        ApiFuture<Transaction> requestFuture = this.spanner.getRpc().beginTransactionAsync(request, this.options, routeToLeader);
        requestFuture.addListener(tracer.withSpan(span, () -> {
            try {
                Transaction txn = (Transaction)requestFuture.get();
                if (txn.getId().isEmpty()) {
                    throw SpannerExceptionFactory.newSpannerException(ErrorCode.INTERNAL, "Missing id in transaction\n" + this.getName());
                }
                span.end(TraceUtil.END_SPAN_OPTIONS);
                res.set((Object)txn.getId());
            }
            catch (ExecutionException e) {
                TraceUtil.endSpanWithFailure(span, e);
                res.setException((Throwable)((Object)SpannerExceptionFactory.newSpannerException(e.getCause() == null ? e : e.getCause())));
            }
            catch (InterruptedException e) {
                TraceUtil.endSpanWithFailure(span, e);
                res.setException((Throwable)((Object)SpannerExceptionFactory.propagateInterrupt(e)));
            }
            catch (Exception e) {
                TraceUtil.endSpanWithFailure(span, e);
                res.setException((Throwable)e);
            }
        }), MoreExecutors.directExecutor());
        return res;
    }

    TransactionRunnerImpl.TransactionContextImpl newTransaction(Options options) {
        Clock poolMaintainerClock = ((SpannerOptions)this.spanner.getOptions()).getSessionPoolOptions().getPoolMaintainerClock();
        return ((TransactionRunnerImpl.TransactionContextImpl.Builder)((TransactionRunnerImpl.TransactionContextImpl.Builder)((TransactionRunnerImpl.TransactionContextImpl.Builder)((TransactionRunnerImpl.TransactionContextImpl.Builder)((TransactionRunnerImpl.TransactionContextImpl.Builder)((TransactionRunnerImpl.TransactionContextImpl.Builder)TransactionRunnerImpl.TransactionContextImpl.newBuilder().setSession(this)).setOptions(options).setTransactionId(this.readyTransactionId).setOptions(options).setTrackTransactionStarter(((SpannerOptions)this.spanner.getOptions()).isTrackTransactionStarter()).setRpc(this.spanner.getRpc())).setDefaultQueryOptions(this.spanner.getDefaultQueryOptions(this.databaseId))).setDefaultPrefetchChunks(this.spanner.getDefaultPrefetchChunks())).setSpan(this.currentSpan)).setExecutorProvider(this.spanner.getAsyncExecutorProvider())).setClock(poolMaintainerClock == null ? new Clock() : poolMaintainerClock).build();
    }

    <T extends SessionTransaction> T setActive(@Nullable T ctx) {
        SessionImpl.throwIfTransactionsPending();
        if (this.activeTransaction != null) {
            this.activeTransaction.invalidate();
        }
        this.activeTransaction = ctx;
        this.readyTransactionId = null;
        if (this.activeTransaction != null) {
            this.activeTransaction.setSpan(this.currentSpan);
        }
        return ctx;
    }

    boolean hasReadyTransaction() {
        return this.readyTransactionId != null;
    }

    static interface SessionTransaction {
        public void invalidate();

        public void setSpan(Span var1);
    }
}

