/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.Page;
import com.google.cloud.Policy;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.Backup;
import com.google.cloud.spanner.Database;
import com.google.cloud.spanner.DatabaseAdminClient;
import com.google.cloud.spanner.InstanceAdminClient;
import com.google.cloud.spanner.InstanceConfigId;
import com.google.cloud.spanner.InstanceId;
import com.google.cloud.spanner.InstanceInfo;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.SpannerException;
import com.google.longrunning.Operation;
import com.google.spanner.admin.database.v1.CreateDatabaseMetadata;
import com.google.spanner.admin.instance.v1.AutoscalingConfig;
import com.google.spanner.admin.instance.v1.UpdateInstanceMetadata;
import java.util.Map;

public class Instance
extends InstanceInfo {
    private final InstanceAdminClient instanceClient;
    private final DatabaseAdminClient dbClient;

    Instance(Builder builder) {
        super(builder.infoBuilder);
        this.instanceClient = builder.instanceClient;
        this.dbClient = builder.dbClient;
    }

    public Instance reload() {
        return this.instanceClient.getInstance(this.instanceId());
    }

    public void delete() {
        this.instanceClient.deleteInstance(this.instanceId());
    }

    public OperationFuture<Instance, UpdateInstanceMetadata> update(InstanceInfo.InstanceField ... fieldsToUpdate) {
        return this.instanceClient.updateInstance(this, fieldsToUpdate);
    }

    public Page<Database> listDatabases(Options.ListOption ... options) {
        return this.dbClient.listDatabases(this.instanceId(), options);
    }

    public Database getDatabase(String databaseId) {
        return this.dbClient.getDatabase(this.instanceId(), databaseId);
    }

    public OperationFuture<Database, CreateDatabaseMetadata> createDatabase(String databaseId, Iterable<String> statements) throws SpannerException {
        return this.dbClient.createDatabase(this.instanceId(), databaseId, statements);
    }

    public Page<Backup> listBackups(Options.ListOption ... options) {
        return this.dbClient.listBackups(this.instanceId(), options);
    }

    public Backup getBackup(String backupId) {
        return this.dbClient.getBackup(this.instanceId(), backupId);
    }

    public Page<Operation> listDatabaseOperations(Options.ListOption ... options) {
        return this.dbClient.listDatabaseOperations(this.instanceId(), options);
    }

    public Page<Operation> listBackupOperations(Options.ListOption ... options) {
        return this.dbClient.listBackupOperations(this.instanceId(), options);
    }

    public Policy getIAMPolicy() {
        return this.instanceClient.getInstanceIAMPolicy(this.instanceId());
    }

    public Policy setIAMPolicy(Policy policy) {
        return this.instanceClient.setInstanceIAMPolicy(this.instanceId(), policy);
    }

    public Iterable<String> testIAMPermissions(Iterable<String> permissions) {
        return this.instanceClient.testInstanceIAMPermissions(this.instanceId(), permissions);
    }

    private String instanceId() {
        return this.getId().getInstance();
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this);
    }

    static Instance fromProto(com.google.spanner.admin.instance.v1.Instance proto, InstanceAdminClient instanceClient, DatabaseAdminClient dbClient) {
        InstanceInfo.State state;
        InstanceId id = InstanceId.of(proto.getName());
        Builder builder = new Builder(instanceClient, dbClient, id).setInstanceConfigId(InstanceConfigId.of(proto.getConfig())).setDisplayName(proto.getDisplayName()).setNodeCount(proto.getNodeCount()).setCreateTime(Timestamp.fromProto((com.google.protobuf.Timestamp)proto.getCreateTime())).setUpdateTime(Timestamp.fromProto((com.google.protobuf.Timestamp)proto.getUpdateTime())).setAutoscalingConfig(proto.getAutoscalingConfig()).setProcessingUnits(proto.getProcessingUnits());
        switch (proto.getState()) {
            case STATE_UNSPECIFIED: {
                state = InstanceInfo.State.UNSPECIFIED;
                break;
            }
            case CREATING: {
                state = InstanceInfo.State.CREATING;
                break;
            }
            case READY: {
                state = InstanceInfo.State.READY;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown state:" + proto.getState());
            }
        }
        builder.setState(state);
        builder.putAllLabels(proto.getLabelsMap());
        return builder.build();
    }

    public static class Builder
    extends InstanceInfo.Builder {
        private final InstanceAdminClient instanceClient;
        private final DatabaseAdminClient dbClient;
        private final InstanceInfo.BuilderImpl infoBuilder;

        Builder(Instance instance) {
            this.instanceClient = instance.instanceClient;
            this.dbClient = instance.dbClient;
            this.infoBuilder = new InstanceInfo.BuilderImpl(instance);
        }

        Builder(InstanceAdminClient instanceClient, DatabaseAdminClient dbClient, InstanceId id) {
            this.instanceClient = instanceClient;
            this.dbClient = dbClient;
            this.infoBuilder = new InstanceInfo.BuilderImpl(id);
        }

        @Override
        public Builder setInstanceConfigId(InstanceConfigId instanceConfigId) {
            this.infoBuilder.setInstanceConfigId(instanceConfigId);
            return this;
        }

        @Override
        public Builder setDisplayName(String displayName) {
            this.infoBuilder.setDisplayName(displayName);
            return this;
        }

        @Override
        Builder setUpdateTime(Timestamp updateTime) {
            this.infoBuilder.setUpdateTime(updateTime);
            return this;
        }

        @Override
        Builder setCreateTime(Timestamp createTime) {
            this.infoBuilder.setCreateTime(createTime);
            return this;
        }

        @Override
        public Builder setNodeCount(int nodeCount) {
            this.infoBuilder.setNodeCount(nodeCount);
            return this;
        }

        @Override
        public Builder setProcessingUnits(int processingUnits) {
            this.infoBuilder.setProcessingUnits(processingUnits);
            return this;
        }

        @Override
        public Builder setAutoscalingConfig(AutoscalingConfig autoscalingConfig) {
            this.infoBuilder.setAutoscalingConfig(autoscalingConfig);
            return this;
        }

        @Override
        public Builder setState(InstanceInfo.State state) {
            this.infoBuilder.setState(state);
            return this;
        }

        @Override
        public Builder addLabel(String key, String value) {
            this.infoBuilder.addLabel(key, value);
            return this;
        }

        @Override
        public Builder putAllLabels(Map<String, String> labels) {
            this.infoBuilder.putAllLabels((Map)labels);
            return this;
        }

        @Override
        public Instance build() {
            return new Instance(this);
        }
    }
}

