/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.cloud.ByteArray;
import com.google.cloud.Date;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.AbstractResultSet;
import com.google.cloud.spanner.DecodeMode;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.Struct;
import com.google.cloud.spanner.Type;
import com.google.cloud.spanner.Value;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.io.CharSource;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.ListValue;
import com.google.protobuf.NullValue;
import com.google.protobuf.ProtocolMessageEnum;
import com.google.protobuf.Value;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.BitSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

class GrpcStruct
extends Struct
implements Serializable {
    private static final com.google.protobuf.Value NULL_VALUE = com.google.protobuf.Value.newBuilder().setNullValue(NullValue.NULL_VALUE).build();
    private final Type type;
    private final List<Object> rowData;
    private final DecodeMode decodeMode;
    private final BitSet colDecoded;
    private boolean rowDecoded;

    private Object writeReplace() {
        Struct.Builder builder = Struct.newBuilder();
        List<Type.StructField> structFields = this.getType().getStructFields();
        block35: for (int i = 0; i < structFields.size(); ++i) {
            Type.StructField field = structFields.get(i);
            String fieldName = field.getName();
            this.ensureDecoded(i);
            Object value = this.rowData.get(i);
            Type fieldType = field.getType();
            switch (fieldType.getCode()) {
                case BOOL: {
                    builder.set(fieldName).to((Boolean)value);
                    continue block35;
                }
                case INT64: {
                    builder.set(fieldName).to((Long)value);
                    continue block35;
                }
                case FLOAT64: {
                    builder.set(fieldName).to((Double)value);
                    continue block35;
                }
                case FLOAT32: {
                    builder.set(fieldName).to((Float)value);
                    continue block35;
                }
                case NUMERIC: {
                    builder.set(fieldName).to((BigDecimal)value);
                    continue block35;
                }
                case PG_NUMERIC: {
                    builder.set(fieldName).to((String)value);
                    continue block35;
                }
                case STRING: {
                    builder.set(fieldName).to((String)value);
                    continue block35;
                }
                case JSON: {
                    builder.set(fieldName).to(Value.json((String)value));
                    continue block35;
                }
                case PROTO: {
                    builder.set(fieldName).to(Value.protoMessage(value == null ? null : ((AbstractResultSet.LazyByteArray)value).getByteArray(), fieldType.getProtoTypeFqn()));
                    continue block35;
                }
                case ENUM: {
                    builder.set(fieldName).to(Value.protoEnum((Long)value, fieldType.getProtoTypeFqn()));
                    continue block35;
                }
                case PG_JSONB: {
                    builder.set(fieldName).to(Value.pgJsonb((String)value));
                    continue block35;
                }
                case PG_OID: {
                    builder.set(fieldName).to(Value.pgOid((Long)value));
                    continue block35;
                }
                case BYTES: {
                    builder.set(fieldName).to(Value.bytesFromBase64(value == null ? null : ((AbstractResultSet.LazyByteArray)value).getBase64String()));
                    continue block35;
                }
                case TIMESTAMP: {
                    builder.set(fieldName).to((Timestamp)value);
                    continue block35;
                }
                case DATE: {
                    builder.set(fieldName).to((Date)value);
                    continue block35;
                }
                case ARRAY: {
                    Type elementType = fieldType.getArrayElementType();
                    switch (elementType.getCode()) {
                        case BOOL: {
                            builder.set(fieldName).toBoolArray((Iterable)value);
                            continue block35;
                        }
                        case INT64: 
                        case ENUM: {
                            builder.set(fieldName).toInt64Array((Iterable)value);
                            continue block35;
                        }
                        case FLOAT64: {
                            builder.set(fieldName).toFloat64Array((Iterable)value);
                            continue block35;
                        }
                        case FLOAT32: {
                            builder.set(fieldName).toFloat32Array((Iterable)value);
                            continue block35;
                        }
                        case NUMERIC: {
                            builder.set(fieldName).toNumericArray((Iterable)value);
                            continue block35;
                        }
                        case PG_NUMERIC: {
                            builder.set(fieldName).toPgNumericArray((Iterable)value);
                            continue block35;
                        }
                        case STRING: {
                            builder.set(fieldName).toStringArray((Iterable)value);
                            continue block35;
                        }
                        case JSON: {
                            builder.set(fieldName).toJsonArray((Iterable)value);
                            continue block35;
                        }
                        case PG_JSONB: {
                            builder.set(fieldName).toPgJsonbArray((Iterable)value);
                            continue block35;
                        }
                        case PG_OID: {
                            builder.set(fieldName).toPgOidArray((Iterable)value);
                            continue block35;
                        }
                        case BYTES: 
                        case PROTO: {
                            builder.set(fieldName).toBytesArrayFromBase64(value == null ? null : (Iterable)((List)value).stream().map(element -> element == null ? null : element.getBase64String()).collect(Collectors.toList()));
                            continue block35;
                        }
                        case TIMESTAMP: {
                            builder.set(fieldName).toTimestampArray((Iterable)value);
                            continue block35;
                        }
                        case DATE: {
                            builder.set(fieldName).toDateArray((Iterable)value);
                            continue block35;
                        }
                        case STRUCT: {
                            builder.set(fieldName).toStructArray(elementType, (Iterable)value);
                            continue block35;
                        }
                    }
                    throw new AssertionError((Object)("Unhandled array type code: " + elementType));
                }
                case STRUCT: {
                    if (value == null) {
                        builder.set(fieldName).to(fieldType, null);
                        continue block35;
                    }
                    builder.set(fieldName).to((Struct)value);
                    continue block35;
                }
                default: {
                    throw new AssertionError((Object)("Unhandled type code: " + (Object)((Object)fieldType.getCode())));
                }
            }
        }
        return builder.build();
    }

    GrpcStruct(Type type, List<Object> rowData, DecodeMode decodeMode) {
        this(type, rowData, decodeMode, false, decodeMode == DecodeMode.LAZY_PER_COL ? new BitSet(type.getStructFields().size()) : null);
    }

    private GrpcStruct(Type type, List<Object> rowData, DecodeMode decodeMode, boolean rowDecoded, BitSet colDecoded) {
        this.type = type;
        this.rowData = rowData;
        this.decodeMode = decodeMode;
        this.rowDecoded = rowDecoded;
        this.colDecoded = colDecoded;
    }

    public String toString() {
        return this.rowData.toString();
    }

    boolean consumeRow(Iterator<com.google.protobuf.Value> iterator) {
        this.rowData.clear();
        if (this.decodeMode == DecodeMode.LAZY_PER_ROW) {
            this.rowDecoded = false;
        } else if (this.decodeMode == DecodeMode.LAZY_PER_COL) {
            this.colDecoded.clear();
        }
        if (!iterator.hasNext()) {
            return false;
        }
        for (Type.StructField fieldType : this.getType().getStructFields()) {
            if (!iterator.hasNext()) {
                throw SpannerExceptionFactory.newSpannerException(ErrorCode.INTERNAL, "Invalid value stream: end of stream reached before row is complete");
            }
            com.google.protobuf.Value value = iterator.next();
            if (this.decodeMode == DecodeMode.DIRECT) {
                this.rowData.add(GrpcStruct.decodeValue(fieldType.getType(), value));
                continue;
            }
            this.rowData.add(value);
        }
        return true;
    }

    private static Object decodeValue(Type fieldType, com.google.protobuf.Value proto) {
        if (proto.getKindCase() == Value.KindCase.NULL_VALUE) {
            return null;
        }
        switch (fieldType.getCode()) {
            case BOOL: {
                GrpcStruct.checkType(fieldType, proto, Value.KindCase.BOOL_VALUE);
                return proto.getBoolValue();
            }
            case INT64: 
            case ENUM: 
            case PG_OID: {
                GrpcStruct.checkType(fieldType, proto, Value.KindCase.STRING_VALUE);
                return Long.parseLong(proto.getStringValue());
            }
            case FLOAT64: {
                return AbstractResultSet.valueProtoToFloat64(proto);
            }
            case FLOAT32: {
                return Float.valueOf(AbstractResultSet.valueProtoToFloat32(proto));
            }
            case NUMERIC: {
                GrpcStruct.checkType(fieldType, proto, Value.KindCase.STRING_VALUE);
                return new BigDecimal(proto.getStringValue());
            }
            case PG_NUMERIC: 
            case STRING: 
            case JSON: 
            case PG_JSONB: {
                GrpcStruct.checkType(fieldType, proto, Value.KindCase.STRING_VALUE);
                return proto.getStringValue();
            }
            case BYTES: 
            case PROTO: {
                GrpcStruct.checkType(fieldType, proto, Value.KindCase.STRING_VALUE);
                return new AbstractResultSet.LazyByteArray(proto.getStringValue());
            }
            case TIMESTAMP: {
                GrpcStruct.checkType(fieldType, proto, Value.KindCase.STRING_VALUE);
                return Timestamp.parseTimestamp((String)proto.getStringValue());
            }
            case DATE: {
                GrpcStruct.checkType(fieldType, proto, Value.KindCase.STRING_VALUE);
                return Date.parseDate((String)proto.getStringValue());
            }
            case ARRAY: {
                GrpcStruct.checkType(fieldType, proto, Value.KindCase.LIST_VALUE);
                ListValue listValue = proto.getListValue();
                return GrpcStruct.decodeArrayValue(fieldType.getArrayElementType(), listValue);
            }
            case STRUCT: {
                GrpcStruct.checkType(fieldType, proto, Value.KindCase.LIST_VALUE);
                ListValue structValue = proto.getListValue();
                return GrpcStruct.decodeStructValue(fieldType, structValue);
            }
            case UNRECOGNIZED: {
                return proto;
            }
        }
        throw new AssertionError((Object)("Unhandled type code: " + (Object)((Object)fieldType.getCode())));
    }

    private static Struct decodeStructValue(Type structType, ListValue structValue) {
        List<Type.StructField> fieldTypes = structType.getStructFields();
        Preconditions.checkArgument((structValue.getValuesCount() == fieldTypes.size() ? 1 : 0) != 0, (Object)"Size mismatch between type descriptor and actual values.");
        ArrayList<Object> fields = new ArrayList<Object>(fieldTypes.size());
        List fieldValues = structValue.getValuesList();
        for (int i = 0; i < fieldTypes.size(); ++i) {
            fields.add(GrpcStruct.decodeValue(fieldTypes.get(i).getType(), (com.google.protobuf.Value)fieldValues.get(i)));
        }
        return new GrpcStruct(structType, fields, DecodeMode.DIRECT);
    }

    static Object decodeArrayValue(Type elementType, ListValue listValue) {
        switch (elementType.getCode()) {
            case INT64: 
            case ENUM: 
            case PG_OID: {
                return new AbstractResultSet.Int64Array(listValue);
            }
            case FLOAT64: {
                return new AbstractResultSet.Float64Array(listValue);
            }
            case FLOAT32: {
                return new AbstractResultSet.Float32Array(listValue);
            }
            case BOOL: 
            case NUMERIC: 
            case PG_NUMERIC: 
            case STRING: 
            case JSON: 
            case PG_JSONB: 
            case BYTES: 
            case PROTO: 
            case TIMESTAMP: 
            case DATE: 
            case STRUCT: {
                return Lists.transform((List)listValue.getValuesList(), input -> GrpcStruct.decodeValue(elementType, input));
            }
        }
        throw new AssertionError((Object)("Unhandled type code: " + (Object)((Object)elementType.getCode())));
    }

    private static void checkType(Type fieldType, com.google.protobuf.Value proto, Value.KindCase expected) {
        if (proto.getKindCase() != expected) {
            throw SpannerExceptionFactory.newSpannerException(ErrorCode.INTERNAL, "Invalid value for column type " + fieldType + " expected " + expected + " but was " + proto.getKindCase());
        }
    }

    Struct immutableCopy() {
        return new GrpcStruct(this.type, new ArrayList<Object>(this.rowData), this.decodeMode, this.rowDecoded, this.colDecoded == null ? null : (BitSet)this.colDecoded.clone());
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public boolean isNull(int columnIndex) {
        if (this.decodeMode == DecodeMode.LAZY_PER_ROW && !this.rowDecoded || this.decodeMode == DecodeMode.LAZY_PER_COL && !this.colDecoded.get(columnIndex)) {
            return ((com.google.protobuf.Value)this.rowData.get(columnIndex)).hasNullValue();
        }
        return this.rowData.get(columnIndex) == null;
    }

    @Override
    protected <T extends AbstractMessage> T getProtoMessageInternal(int columnIndex, T message) {
        Preconditions.checkNotNull(message, (Object)"Proto message may not be null. Use MyProtoClass.getDefaultInstance() as a parameter value.");
        this.ensureDecoded(columnIndex);
        try {
            return (T)((AbstractMessage)message.toBuilder().mergeFrom(Base64.getDecoder().wrap(CharSource.wrap((CharSequence)((AbstractResultSet.LazyByteArray)this.rowData.get(columnIndex)).getBase64String()).asByteSource(StandardCharsets.UTF_8).openStream())).build());
        }
        catch (IOException ioException) {
            throw SpannerExceptionFactory.asSpannerException(ioException);
        }
    }

    @Override
    protected <T extends ProtocolMessageEnum> T getProtoEnumInternal(int columnIndex, Function<Integer, ProtocolMessageEnum> method) {
        Preconditions.checkNotNull(method, (Object)"Method may not be null. Use 'MyProtoEnum::forNumber' as a parameter value.");
        return (T)method.apply((int)this.getLongInternal(columnIndex));
    }

    @Override
    protected boolean getBooleanInternal(int columnIndex) {
        this.ensureDecoded(columnIndex);
        return (Boolean)this.rowData.get(columnIndex);
    }

    @Override
    protected long getLongInternal(int columnIndex) {
        this.ensureDecoded(columnIndex);
        return (Long)this.rowData.get(columnIndex);
    }

    @Override
    protected double getDoubleInternal(int columnIndex) {
        this.ensureDecoded(columnIndex);
        return (Double)this.rowData.get(columnIndex);
    }

    @Override
    protected float getFloatInternal(int columnIndex) {
        this.ensureDecoded(columnIndex);
        return ((Float)this.rowData.get(columnIndex)).floatValue();
    }

    @Override
    protected BigDecimal getBigDecimalInternal(int columnIndex) {
        this.ensureDecoded(columnIndex);
        return (BigDecimal)this.rowData.get(columnIndex);
    }

    @Override
    protected String getStringInternal(int columnIndex) {
        this.ensureDecoded(columnIndex);
        return (String)this.rowData.get(columnIndex);
    }

    @Override
    protected String getJsonInternal(int columnIndex) {
        this.ensureDecoded(columnIndex);
        return (String)this.rowData.get(columnIndex);
    }

    @Override
    protected String getPgJsonbInternal(int columnIndex) {
        this.ensureDecoded(columnIndex);
        return (String)this.rowData.get(columnIndex);
    }

    @Override
    protected ByteArray getBytesInternal(int columnIndex) {
        this.ensureDecoded(columnIndex);
        return this.getLazyBytesInternal(columnIndex).getByteArray();
    }

    AbstractResultSet.LazyByteArray getLazyBytesInternal(int columnIndex) {
        this.ensureDecoded(columnIndex);
        return (AbstractResultSet.LazyByteArray)this.rowData.get(columnIndex);
    }

    @Override
    protected Timestamp getTimestampInternal(int columnIndex) {
        this.ensureDecoded(columnIndex);
        return (Timestamp)this.rowData.get(columnIndex);
    }

    @Override
    protected Date getDateInternal(int columnIndex) {
        this.ensureDecoded(columnIndex);
        return (Date)this.rowData.get(columnIndex);
    }

    private boolean isUnrecognizedType(int columnIndex) {
        return this.type.getStructFields().get(columnIndex).getType().getCode() == Type.Code.UNRECOGNIZED;
    }

    boolean canGetProtoValue(int columnIndex) {
        return this.isUnrecognizedType(columnIndex) || this.decodeMode == DecodeMode.LAZY_PER_ROW && !this.rowDecoded || this.decodeMode == DecodeMode.LAZY_PER_COL && !this.colDecoded.get(columnIndex);
    }

    protected com.google.protobuf.Value getProtoValueInternal(int columnIndex) {
        this.checkProtoValueSupported(columnIndex);
        return (com.google.protobuf.Value)this.rowData.get(columnIndex);
    }

    private void checkProtoValueSupported(int columnIndex) {
        if (this.isUnrecognizedType(columnIndex)) {
            return;
        }
        Preconditions.checkState((this.decodeMode != DecodeMode.DIRECT ? 1 : 0) != 0, (Object)"Getting proto value is not supported when DecodeMode#DIRECT is used.");
        Preconditions.checkState((this.decodeMode != DecodeMode.LAZY_PER_ROW || !this.rowDecoded ? 1 : 0) != 0, (Object)"Getting proto value after the row has been decoded is not supported.");
        Preconditions.checkState((this.decodeMode != DecodeMode.LAZY_PER_COL || !this.colDecoded.get(columnIndex) ? 1 : 0) != 0, (Object)"Getting proto value after the column has been decoded is not supported.");
    }

    private void ensureDecoded(int columnIndex) {
        if (this.decodeMode == DecodeMode.LAZY_PER_ROW && !this.rowDecoded) {
            for (int i = 0; i < this.rowData.size(); ++i) {
                this.rowData.set(i, GrpcStruct.decodeValue(this.type.getStructFields().get(i).getType(), (com.google.protobuf.Value)this.rowData.get(i)));
            }
            this.rowDecoded = true;
        } else if (this.decodeMode == DecodeMode.LAZY_PER_COL && !this.colDecoded.get(columnIndex)) {
            this.rowData.set(columnIndex, GrpcStruct.decodeValue(this.type.getStructFields().get(columnIndex).getType(), (com.google.protobuf.Value)this.rowData.get(columnIndex)));
            this.colDecoded.set(columnIndex);
        }
    }

    @Override
    protected Value getValueInternal(int columnIndex) {
        this.ensureDecoded(columnIndex);
        List<Type.StructField> structFields = this.getType().getStructFields();
        Type.StructField structField = structFields.get(columnIndex);
        Type columnType = structField.getType();
        boolean isNull = this.rowData.get(columnIndex) == null;
        switch (columnType.getCode()) {
            case BOOL: {
                return Value.bool(isNull ? null : Boolean.valueOf(this.getBooleanInternal(columnIndex)));
            }
            case INT64: {
                return Value.int64(isNull ? null : Long.valueOf(this.getLongInternal(columnIndex)));
            }
            case ENUM: {
                return Value.protoEnum(isNull ? null : Long.valueOf(this.getLongInternal(columnIndex)), columnType.getProtoTypeFqn());
            }
            case NUMERIC: {
                return Value.numeric(isNull ? null : this.getBigDecimalInternal(columnIndex));
            }
            case PG_NUMERIC: {
                return Value.pgNumeric(isNull ? null : this.getStringInternal(columnIndex));
            }
            case FLOAT64: {
                return Value.float64(isNull ? null : Double.valueOf(this.getDoubleInternal(columnIndex)));
            }
            case FLOAT32: {
                return Value.float32(isNull ? null : Float.valueOf(this.getFloatInternal(columnIndex)));
            }
            case STRING: {
                return Value.string(isNull ? null : this.getStringInternal(columnIndex));
            }
            case JSON: {
                return Value.json(isNull ? null : this.getJsonInternal(columnIndex));
            }
            case PG_JSONB: {
                return Value.pgJsonb(isNull ? null : this.getPgJsonbInternal(columnIndex));
            }
            case PG_OID: {
                return Value.pgOid(isNull ? null : Long.valueOf(this.getLongInternal(columnIndex)));
            }
            case BYTES: {
                return Value.internalBytes(isNull ? null : this.getLazyBytesInternal(columnIndex));
            }
            case PROTO: {
                return Value.protoMessage(isNull ? null : this.getBytesInternal(columnIndex), columnType.getProtoTypeFqn());
            }
            case TIMESTAMP: {
                return Value.timestamp(isNull ? null : this.getTimestampInternal(columnIndex));
            }
            case DATE: {
                return Value.date(isNull ? null : this.getDateInternal(columnIndex));
            }
            case STRUCT: {
                return Value.struct(isNull ? null : this.getStructInternal(columnIndex));
            }
            case UNRECOGNIZED: {
                return Value.unrecognized(isNull ? NULL_VALUE : this.getProtoValueInternal(columnIndex), columnType);
            }
            case ARRAY: {
                Type elementType = columnType.getArrayElementType();
                switch (elementType.getCode()) {
                    case BOOL: {
                        return Value.boolArray(isNull ? null : this.getBooleanListInternal(columnIndex));
                    }
                    case INT64: {
                        return Value.int64Array(isNull ? null : this.getLongListInternal(columnIndex));
                    }
                    case NUMERIC: {
                        return Value.numericArray(isNull ? null : this.getBigDecimalListInternal(columnIndex));
                    }
                    case PG_NUMERIC: {
                        return Value.pgNumericArray(isNull ? null : this.getStringListInternal(columnIndex));
                    }
                    case FLOAT64: {
                        return Value.float64Array(isNull ? null : this.getDoubleListInternal(columnIndex));
                    }
                    case FLOAT32: {
                        return Value.float32Array(isNull ? null : this.getFloatListInternal(columnIndex));
                    }
                    case STRING: {
                        return Value.stringArray(isNull ? null : this.getStringListInternal(columnIndex));
                    }
                    case JSON: {
                        return Value.jsonArray(isNull ? null : this.getJsonListInternal(columnIndex));
                    }
                    case PG_JSONB: {
                        return Value.pgJsonbArray(isNull ? null : this.getPgJsonbListInternal(columnIndex));
                    }
                    case PG_OID: {
                        return Value.pgOidArray(isNull ? null : this.getLongListInternal(columnIndex));
                    }
                    case BYTES: {
                        return Value.bytesArray(isNull ? null : this.getBytesListInternal(columnIndex));
                    }
                    case PROTO: {
                        return Value.protoMessageArray(isNull ? null : this.getBytesListInternal(columnIndex), elementType.getProtoTypeFqn());
                    }
                    case ENUM: {
                        return Value.protoEnumArray(isNull ? null : this.getLongListInternal(columnIndex), elementType.getProtoTypeFqn());
                    }
                    case TIMESTAMP: {
                        return Value.timestampArray(isNull ? null : this.getTimestampListInternal(columnIndex));
                    }
                    case DATE: {
                        return Value.dateArray(isNull ? null : this.getDateListInternal(columnIndex));
                    }
                    case STRUCT: {
                        return Value.structArray(elementType, isNull ? null : this.getStructListInternal(columnIndex));
                    }
                }
                throw new IllegalArgumentException("Invalid array value type " + this.type.getArrayElementType());
            }
        }
        throw new IllegalArgumentException("Invalid value type " + this.type);
    }

    @Override
    protected Struct getStructInternal(int columnIndex) {
        this.ensureDecoded(columnIndex);
        return (Struct)this.rowData.get(columnIndex);
    }

    @Override
    protected boolean[] getBooleanArrayInternal(int columnIndex) {
        this.ensureDecoded(columnIndex);
        List values = (List)this.rowData.get(columnIndex);
        boolean[] r = new boolean[values.size()];
        for (int i = 0; i < values.size(); ++i) {
            if (values.get(i) == null) {
                throw AbstractResultSet.throwNotNull(columnIndex);
            }
            r[i] = (Boolean)values.get(i);
        }
        return r;
    }

    @Override
    protected List<Boolean> getBooleanListInternal(int columnIndex) {
        this.ensureDecoded(columnIndex);
        return Collections.unmodifiableList((List)this.rowData.get(columnIndex));
    }

    @Override
    protected long[] getLongArrayInternal(int columnIndex) {
        this.ensureDecoded(columnIndex);
        return (long[])this.getLongListInternal(columnIndex).toPrimitiveArray(columnIndex);
    }

    protected AbstractResultSet.Int64Array getLongListInternal(int columnIndex) {
        this.ensureDecoded(columnIndex);
        return (AbstractResultSet.Int64Array)this.rowData.get(columnIndex);
    }

    @Override
    protected double[] getDoubleArrayInternal(int columnIndex) {
        this.ensureDecoded(columnIndex);
        return (double[])this.getDoubleListInternal(columnIndex).toPrimitiveArray(columnIndex);
    }

    protected AbstractResultSet.Float64Array getDoubleListInternal(int columnIndex) {
        this.ensureDecoded(columnIndex);
        return (AbstractResultSet.Float64Array)this.rowData.get(columnIndex);
    }

    @Override
    protected float[] getFloatArrayInternal(int columnIndex) {
        this.ensureDecoded(columnIndex);
        return (float[])this.getFloatListInternal(columnIndex).toPrimitiveArray(columnIndex);
    }

    protected AbstractResultSet.Float32Array getFloatListInternal(int columnIndex) {
        this.ensureDecoded(columnIndex);
        return (AbstractResultSet.Float32Array)this.rowData.get(columnIndex);
    }

    @Override
    protected List<BigDecimal> getBigDecimalListInternal(int columnIndex) {
        this.ensureDecoded(columnIndex);
        return (List)this.rowData.get(columnIndex);
    }

    @Override
    protected List<String> getStringListInternal(int columnIndex) {
        this.ensureDecoded(columnIndex);
        return Collections.unmodifiableList((List)this.rowData.get(columnIndex));
    }

    @Override
    protected List<String> getJsonListInternal(int columnIndex) {
        this.ensureDecoded(columnIndex);
        return Collections.unmodifiableList((List)this.rowData.get(columnIndex));
    }

    @Override
    protected <T extends AbstractMessage> List<T> getProtoMessageListInternal(int columnIndex, T message) {
        Preconditions.checkNotNull(message, (Object)"Proto message may not be null. Use MyProtoClass.getDefaultInstance() as a parameter value.");
        this.ensureDecoded(columnIndex);
        List bytesArray = (List)this.rowData.get(columnIndex);
        try {
            ArrayList<AbstractMessage> protoMessagesList = new ArrayList<AbstractMessage>(bytesArray.size());
            for (AbstractResultSet.LazyByteArray protoMessageBytes : bytesArray) {
                if (protoMessageBytes == null) {
                    protoMessagesList.add(null);
                    continue;
                }
                protoMessagesList.add((AbstractMessage)message.toBuilder().mergeFrom(Base64.getDecoder().wrap(CharSource.wrap((CharSequence)protoMessageBytes.getBase64String()).asByteSource(StandardCharsets.UTF_8).openStream())).build());
            }
            return protoMessagesList;
        }
        catch (IOException ioException) {
            throw SpannerExceptionFactory.asSpannerException(ioException);
        }
    }

    @Override
    protected <T extends ProtocolMessageEnum> List<T> getProtoEnumListInternal(int columnIndex, Function<Integer, ProtocolMessageEnum> method) {
        Preconditions.checkNotNull(method, (Object)"Method may not be null. Use 'MyProtoEnum::forNumber' as a parameter value.");
        this.ensureDecoded(columnIndex);
        List enumIntArray = (List)this.rowData.get(columnIndex);
        ArrayList<ProtocolMessageEnum> protoEnumList = new ArrayList<ProtocolMessageEnum>(enumIntArray.size());
        for (Long enumIntValue : enumIntArray) {
            if (enumIntValue == null) {
                protoEnumList.add(null);
                continue;
            }
            protoEnumList.add(method.apply(enumIntValue.intValue()));
        }
        return protoEnumList;
    }

    @Override
    protected List<String> getPgJsonbListInternal(int columnIndex) {
        this.ensureDecoded(columnIndex);
        return Collections.unmodifiableList((List)this.rowData.get(columnIndex));
    }

    @Override
    protected List<ByteArray> getBytesListInternal(int columnIndex) {
        this.ensureDecoded(columnIndex);
        return Lists.transform((List)((List)this.rowData.get(columnIndex)), l -> l == null ? null : l.getByteArray());
    }

    @Override
    protected List<Timestamp> getTimestampListInternal(int columnIndex) {
        this.ensureDecoded(columnIndex);
        return Collections.unmodifiableList((List)this.rowData.get(columnIndex));
    }

    @Override
    protected List<Date> getDateListInternal(int columnIndex) {
        this.ensureDecoded(columnIndex);
        return Collections.unmodifiableList((List)this.rowData.get(columnIndex));
    }

    @Override
    protected List<Struct> getStructListInternal(int columnIndex) {
        this.ensureDecoded(columnIndex);
        return Collections.unmodifiableList((List)this.rowData.get(columnIndex));
    }
}

