/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.cloud.spanner.Mutation;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.spanner.v1.BatchWriteRequest;
import java.util.ArrayList;
import java.util.List;

public class MutationGroup {
    private final ImmutableList<Mutation> mutations;

    private MutationGroup(ImmutableList<Mutation> mutations) {
        this.mutations = mutations;
    }

    public static MutationGroup of(Mutation ... mutations) {
        Preconditions.checkArgument((mutations.length > 0 ? 1 : 0) != 0, (Object)"Should pass in at least one mutation.");
        return new MutationGroup((ImmutableList<Mutation>)ImmutableList.copyOf((Object[])mutations));
    }

    public static MutationGroup of(Iterable<Mutation> mutations) {
        return new MutationGroup((ImmutableList<Mutation>)ImmutableList.copyOf(mutations));
    }

    public ImmutableList<Mutation> getMutations() {
        return this.mutations;
    }

    static BatchWriteRequest.MutationGroup toProto(MutationGroup mutationGroup) {
        ArrayList<com.google.spanner.v1.Mutation> mutationsProto = new ArrayList<com.google.spanner.v1.Mutation>();
        Mutation.toProto(mutationGroup.getMutations(), mutationsProto);
        return BatchWriteRequest.MutationGroup.newBuilder().addAllMutations(mutationsProto).build();
    }

    static List<BatchWriteRequest.MutationGroup> toListProto(Iterable<MutationGroup> mutationGroups) {
        ArrayList<BatchWriteRequest.MutationGroup> mutationGroupsProto = new ArrayList<BatchWriteRequest.MutationGroup>();
        for (MutationGroup group : mutationGroups) {
            mutationGroupsProto.add(MutationGroup.toProto(group));
        }
        return mutationGroupsProto;
    }
}

