/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.api.core.ApiFuture;
import com.google.cloud.spanner.Dialect;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ReadContext;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.connection.AbstractBaseUnitOfWork;
import com.google.cloud.spanner.connection.AbstractStatementParser;
import com.google.cloud.spanner.connection.AnalyzeMode;
import com.google.cloud.spanner.connection.DirectExecuteResultSet;
import com.google.cloud.spanner.connection.SavepointSupport;
import com.google.cloud.spanner.connection.UnitOfWork;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.spanner.v1.SpannerGrpc;
import java.util.LinkedList;
import java.util.Objects;
import javax.annotation.Nonnull;

abstract class AbstractMultiUseTransaction
extends AbstractBaseUnitOfWork {
    private final LinkedList<Savepoint> savepoints = new LinkedList();

    AbstractMultiUseTransaction(AbstractBaseUnitOfWork.Builder<?, ? extends AbstractMultiUseTransaction> builder) {
        super(builder);
    }

    @Override
    public UnitOfWork.Type getType() {
        return UnitOfWork.Type.TRANSACTION;
    }

    @Override
    public boolean isActive() {
        return this.getState().isActive();
    }

    abstract void checkAborted();

    abstract void checkOrCreateValidTransaction(AbstractStatementParser.ParsedStatement var1, UnitOfWork.CallType var2);

    abstract ReadContext getReadContext();

    @Override
    public ApiFuture<ResultSet> executeQueryAsync(UnitOfWork.CallType callType, AbstractStatementParser.ParsedStatement statement, AnalyzeMode analyzeMode, Options.QueryOption ... options) {
        Preconditions.checkArgument((boolean)statement.isQuery(), (Object)"Statement is not a query");
        this.checkOrCreateValidTransaction(statement, callType);
        return this.executeStatementAsync(callType, statement, () -> {
            this.checkAborted();
            return DirectExecuteResultSet.ofResultSet(this.internalExecuteQuery(statement, analyzeMode, options));
        }, SpannerGrpc.getExecuteStreamingSqlMethod());
    }

    ResultSet internalExecuteQuery(AbstractStatementParser.ParsedStatement statement, AnalyzeMode analyzeMode, Options.QueryOption ... options) {
        if (analyzeMode == AnalyzeMode.NONE) {
            return this.getReadContext().executeQuery(statement.getStatement(), options);
        }
        return this.getReadContext().analyzeQuery(statement.getStatement(), analyzeMode.getQueryAnalyzeMode());
    }

    @Override
    public ApiFuture<long[]> runBatchAsync(UnitOfWork.CallType callType) {
        throw SpannerExceptionFactory.newSpannerException(ErrorCode.FAILED_PRECONDITION, "Run batch is not supported for transactions");
    }

    @Override
    public void abortBatch() {
        throw SpannerExceptionFactory.newSpannerException(ErrorCode.FAILED_PRECONDITION, "Run batch is not supported for transactions");
    }

    abstract Savepoint savepoint(String var1);

    abstract void rollbackToSavepoint(Savepoint var1);

    @VisibleForTesting
    ImmutableList<Savepoint> getSavepoints() {
        return ImmutableList.copyOf(this.savepoints);
    }

    @Override
    public void savepoint(@Nonnull String name, @Nonnull Dialect dialect) {
        if (dialect != Dialect.POSTGRESQL && this.savepoints.stream().anyMatch(savepoint -> ((Savepoint)savepoint).name.equals(name))) {
            throw SpannerExceptionFactory.newSpannerException(ErrorCode.INVALID_ARGUMENT, "Savepoint with name " + name + " already exists");
        }
        this.savepoints.add(this.savepoint(name));
    }

    @Override
    public void releaseSavepoint(@Nonnull String name) {
        this.savepoints.subList(this.getSavepointIndex(name), this.savepoints.size()).clear();
    }

    @Override
    public void rollbackToSavepoint(@Nonnull String name, @Nonnull SavepointSupport savepointSupport) {
        int index = this.getSavepointIndex(name);
        this.rollbackToSavepoint(this.savepoints.get(index));
        if (index < this.savepoints.size() - 1) {
            this.savepoints.subList(index + 1, this.savepoints.size()).clear();
        }
    }

    private int getSavepointIndex(String name) {
        int index = this.savepoints.lastIndexOf(this.savepoint(name));
        if (index == -1) {
            throw SpannerExceptionFactory.newSpannerException(ErrorCode.INVALID_ARGUMENT, "Savepoint with name " + name + " does not exist");
        }
        return index;
    }

    static class Savepoint {
        private final String name;
        private final boolean autoSavepoint;

        static Savepoint of(String name) {
            return new Savepoint(name, false);
        }

        Savepoint(String name, boolean autoSavepoint) {
            this.name = name;
            this.autoSavepoint = autoSavepoint;
        }

        int getStatementPosition() {
            return -1;
        }

        int getMutationPosition() {
            return -1;
        }

        boolean isAutoSavepoint() {
            return this.autoSavepoint;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Savepoint)) {
                return false;
            }
            Savepoint other = (Savepoint)o;
            return Objects.equals(other.name, this.name) && Objects.equals(other.autoSavepoint, this.autoSavepoint);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.autoSavepoint);
        }

        public String toString() {
            return this.name;
        }
    }
}

