/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.api.core.InternalApi;
import com.google.cloud.spanner.Dialect;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.connection.AbstractStatementParser;
import com.google.cloud.spanner.connection.ClientSideStatementImpl;
import com.google.cloud.spanner.connection.ClientSideStatements;
import com.google.cloud.spanner.connection.SimpleParser;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;

@InternalApi
public class PostgreSQLStatementParser
extends AbstractStatementParser {
    private static final Pattern RETURNING_PATTERN = Pattern.compile("returning[ '(\"*]");
    private static final Pattern AS_RETURNING_PATTERN = Pattern.compile("[ ')\"]as returning[ '(\"]");
    private static final String RETURNING_STRING = "returning";

    PostgreSQLStatementParser() throws ClientSideStatementImpl.CompileException {
        super(Collections.unmodifiableSet(ClientSideStatements.getInstance(Dialect.POSTGRESQL).getCompiledStatements()));
    }

    @Override
    Dialect getDialect() {
        return Dialect.POSTGRESQL;
    }

    @Override
    protected boolean supportsExplain() {
        return false;
    }

    @Override
    boolean supportsNestedComments() {
        return true;
    }

    @Override
    boolean supportsDollarQuotedStrings() {
        return true;
    }

    @Override
    boolean supportsBacktickQuote() {
        return false;
    }

    @Override
    boolean supportsTripleQuotedStrings() {
        return false;
    }

    @Override
    boolean supportsEscapeQuoteWithQuote() {
        return true;
    }

    @Override
    boolean supportsBackslashEscape() {
        return false;
    }

    @Override
    boolean supportsHashSingleLineComments() {
        return false;
    }

    @Override
    boolean supportsLineFeedInQuotedString() {
        return true;
    }

    @Override
    String getQueryParameterPrefix() {
        return "$";
    }

    @Override
    @InternalApi
    String removeCommentsAndTrimInternal(String sql) {
        Preconditions.checkNotNull((Object)sql);
        boolean isInSingleLineComment = false;
        int multiLineCommentLevel = 0;
        boolean whitespaceBeforeOrAfterMultiLineComment = false;
        int multiLineCommentStartIdx = -1;
        StringBuilder res = new StringBuilder(sql.length());
        int index = 0;
        while (index < sql.length()) {
            block11: {
                char c;
                block12: {
                    block13: {
                        block10: {
                            c = sql.charAt(index);
                            if (!isInSingleLineComment) break block10;
                            if (c == '\n') {
                                isInSingleLineComment = false;
                                res.append(c);
                            }
                            break block11;
                        }
                        if (multiLineCommentLevel <= 0) break block12;
                        if (sql.length() <= index + 1 || c != '*' || sql.charAt(index + 1) != '/') break block13;
                        if (--multiLineCommentLevel == 0) {
                            if (!whitespaceBeforeOrAfterMultiLineComment && sql.length() > index + 2) {
                                whitespaceBeforeOrAfterMultiLineComment = Character.isWhitespace(sql.charAt(index + 2));
                            }
                            if (!whitespaceBeforeOrAfterMultiLineComment && multiLineCommentStartIdx != 0 && index != sql.length() - 2) {
                                res.append(' ');
                            }
                        }
                        ++index;
                        break block11;
                    }
                    if (sql.length() <= index + 1 || c != '/' || sql.charAt(index + 1) != '*') break block11;
                    ++multiLineCommentLevel;
                    ++index;
                    break block11;
                }
                if (sql.length() > index + 1 && c == '-' && sql.charAt(index + 1) == '-') {
                    isInSingleLineComment = true;
                    index += 2;
                    continue;
                }
                if (sql.length() > index + 1 && c == '/' && sql.charAt(index + 1) == '*') {
                    ++multiLineCommentLevel;
                    if (index >= 1) {
                        whitespaceBeforeOrAfterMultiLineComment = Character.isWhitespace(sql.charAt(index - 1));
                    }
                    multiLineCommentStartIdx = index;
                    index += 2;
                    continue;
                }
                index = this.skip(sql, index, res);
                continue;
            }
            ++index;
        }
        if (multiLineCommentLevel > 0) {
            throw SpannerExceptionFactory.newSpannerException(ErrorCode.INVALID_ARGUMENT, "SQL statement contains an unterminated block comment: " + sql);
        }
        if (res.length() > 0 && res.charAt(res.length() - 1) == ';') {
            res.deleteCharAt(res.length() - 1);
        }
        return res.toString().trim();
    }

    @Override
    String removeStatementHint(String sql) {
        return sql;
    }

    @InternalApi
    public Set<String> getQueryParameters(String sql) {
        Preconditions.checkNotNull((Object)sql);
        int maxCount = PostgreSQLStatementParser.countOccurrencesOf('$', sql);
        HashSet<String> parameters = new HashSet<String>(maxCount);
        int currentIndex = 0;
        while (currentIndex < sql.length() - 1) {
            char c = sql.charAt(currentIndex);
            if (c == '$' && Character.isDigit(sql.charAt(currentIndex + 1))) {
                int endIndex;
                for (endIndex = currentIndex + 2; endIndex < sql.length() && Character.isDigit(sql.charAt(endIndex)); ++endIndex) {
                }
                parameters.add(sql.substring(currentIndex, endIndex));
                currentIndex = endIndex;
                continue;
            }
            currentIndex = this.skip(sql, currentIndex, null);
        }
        return parameters;
    }

    private boolean checkCharPrecedingReturning(char ch) {
        return ch == ' ' || ch == '\'' || ch == ')' || ch == '\"' || ch == '$';
    }

    private boolean checkCharPrecedingSubstrWithReturning(char ch) {
        return ch == ' ' || ch == '\'' || ch == ')' || ch == '\"' || ch == ',';
    }

    private boolean isReturning(String sql, int index) {
        if (index >= 1 && index + 10 <= sql.length() && RETURNING_PATTERN.matcher(sql.substring(index, index + 10)).matches() && (index < 4 || !AS_RETURNING_PATTERN.matcher(sql.substring(index - 4, index + 10)).matches())) {
            int ind;
            if (this.checkCharPrecedingReturning(sql.charAt(index - 1))) {
                return true;
            }
            for (ind = index - 1; ind >= 0 && !this.checkCharPrecedingSubstrWithReturning(sql.charAt(ind)); --ind) {
            }
            return !SimpleParser.isValidIdentifierFirstChar(sql.charAt(ind + 1));
        }
        return false;
    }

    @Override
    @InternalApi
    protected boolean checkReturningClauseInternal(String rawSql) {
        Preconditions.checkNotNull((Object)rawSql);
        String sql = rawSql.toLowerCase();
        if (!sql.contains(RETURNING_STRING)) {
            return false;
        }
        sql = sql.replaceAll("\\s+", " ");
        int index = 0;
        while (index < sql.length()) {
            if (this.isReturning(sql, index)) {
                return true;
            }
            index = this.skip(sql, index, null);
        }
        return false;
    }
}

