/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.auth.Credentials;
import com.google.cloud.opentelemetry.detection.DetectedPlatform;
import com.google.cloud.opentelemetry.detection.GCPPlatformDetector;
import com.google.cloud.spanner.BuiltInMetricsConstant;
import com.google.cloud.spanner.BuiltInMetricsView;
import com.google.cloud.spanner.SpannerCloudMonitoringExporter;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.metrics.SdkMeterProvider;
import io.opentelemetry.sdk.metrics.SdkMeterProviderBuilder;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

final class BuiltInMetricsProvider {
    static BuiltInMetricsProvider INSTANCE = new BuiltInMetricsProvider();
    private static final Logger logger = Logger.getLogger(BuiltInMetricsProvider.class.getName());
    private static String taskId;
    private OpenTelemetry openTelemetry;

    private BuiltInMetricsProvider() {
    }

    OpenTelemetry getOrCreateOpenTelemetry(String projectId, @Nullable Credentials credentials, @Nullable String monitoringHost) {
        try {
            if (this.openTelemetry == null) {
                SdkMeterProviderBuilder sdkMeterProviderBuilder = SdkMeterProvider.builder();
                BuiltInMetricsView.registerBuiltinMetrics(SpannerCloudMonitoringExporter.create(projectId, credentials, monitoringHost), sdkMeterProviderBuilder);
                SdkMeterProvider sdkMeterProvider = sdkMeterProviderBuilder.build();
                this.openTelemetry = OpenTelemetrySdk.builder().setMeterProvider(sdkMeterProvider).build();
                Runtime.getRuntime().addShutdownHook(new Thread(() -> ((SdkMeterProvider)sdkMeterProvider).close()));
            }
            return this.openTelemetry;
        }
        catch (IOException ex) {
            logger.log(Level.WARNING, "Unable to get OpenTelemetry object for client side metrics, will skip exporting client side metrics", ex);
            return null;
        }
    }

    Map<String, String> createClientAttributes(String projectId, String client_name) {
        HashMap<String, String> clientAttributes = new HashMap<String, String>();
        clientAttributes.put(BuiltInMetricsConstant.LOCATION_ID_KEY.getKey(), BuiltInMetricsProvider.detectClientLocation());
        clientAttributes.put(BuiltInMetricsConstant.PROJECT_ID_KEY.getKey(), projectId);
        clientAttributes.put(BuiltInMetricsConstant.INSTANCE_CONFIG_ID_KEY.getKey(), "unknown");
        clientAttributes.put(BuiltInMetricsConstant.CLIENT_NAME_KEY.getKey(), client_name);
        String clientUid = BuiltInMetricsProvider.getDefaultTaskValue();
        clientAttributes.put(BuiltInMetricsConstant.CLIENT_UID_KEY.getKey(), clientUid);
        clientAttributes.put(BuiltInMetricsConstant.CLIENT_HASH_KEY.getKey(), BuiltInMetricsProvider.generateClientHash(clientUid));
        return clientAttributes;
    }

    static String generateClientHash(String clientUid) {
        if (clientUid == null) {
            return "000000";
        }
        HashFunction hashFunction = Hashing.goodFastHash((int)64);
        Long hash = hashFunction.hashBytes(clientUid.getBytes()).asLong();
        int kPrefixLength = 10;
        long shiftedValue = hash >>> 64 - kPrefixLength;
        return String.format("%06x", shiftedValue);
    }

    static String detectClientLocation() {
        GCPPlatformDetector detector = GCPPlatformDetector.DEFAULT_INSTANCE;
        DetectedPlatform detectedPlatform = detector.detectPlatform();
        String region = (String)detectedPlatform.getAttributes().get("cloud_region");
        if (detectedPlatform.getSupportedPlatform() == GCPPlatformDetector.SupportedPlatform.GOOGLE_KUBERNETES_ENGINE) {
            region = (String)detectedPlatform.getAttributes().get("gke_cluster_location");
        }
        return region == null ? "global" : region;
    }

    private static String getDefaultTaskValue() {
        if (taskId == null) {
            String identifier = UUID.randomUUID().toString();
            String pid = BuiltInMetricsProvider.getProcessId();
            try {
                String hostname = InetAddress.getLocalHost().getHostName();
                taskId = identifier + "@" + pid + "@" + hostname;
            }
            catch (UnknownHostException e) {
                logger.log(Level.INFO, "Unable to get the hostname.", e);
                taskId = identifier + "@" + pid + "@localhost";
            }
        }
        return taskId;
    }

    private static String getProcessId() {
        try {
            Class<?> processHandleClass = Class.forName("java.lang.ProcessHandle");
            Method currentMethod = processHandleClass.getMethod("current", new Class[0]);
            Object processHandleInstance = currentMethod.invoke(null, new Object[0]);
            Method pidMethod = processHandleClass.getMethod("pid", new Class[0]);
            long pid = (Long)pidMethod.invoke(processHandleInstance, new Object[0]);
            return Long.toString(pid);
        }
        catch (Exception e) {
            String jvmName = ManagementFactory.getRuntimeMXBean().getName();
            if (jvmName != null && jvmName.contains("@")) {
                return jvmName.split("@")[0];
            }
            return "unknown";
        }
    }
}

