/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.gax.rpc.InternalException;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;

public class IsRetryableInternalError
implements Predicate<Throwable> {
    public static final IsRetryableInternalError INSTANCE = new IsRetryableInternalError();
    private static final ImmutableList<String> RETRYABLE_ERROR_MESSAGES = ImmutableList.of((Object)"HTTP/2 error code: INTERNAL_ERROR", (Object)"Connection closed with unknown cause", (Object)"Received unexpected EOS on DATA frame from server", (Object)"stream terminated by RST_STREAM", (Object)"Authentication backend internal server error. Please retry.");

    public boolean isRetryableInternalError(Status status) {
        return status.getCode() == Status.Code.INTERNAL && status.getDescription() != null && this.isRetryableErrorMessage(status.getDescription());
    }

    public boolean apply(Throwable cause) {
        return this.isInternalError(cause) && this.isRetryableErrorMessage(cause.getMessage());
    }

    private boolean isRetryableErrorMessage(String errorMessage) {
        return RETRYABLE_ERROR_MESSAGES.stream().anyMatch(errorMessage::contains);
    }

    private boolean isInternalError(Throwable cause) {
        return cause instanceof InternalException || cause instanceof StatusRuntimeException && ((StatusRuntimeException)cause).getStatus().getCode() == Status.Code.INTERNAL;
    }
}

