/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.SettableApiFuture;
import com.google.api.gax.rpc.ServerStream;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.AbstractLazyInitializer;
import com.google.cloud.spanner.AbstractMultiplexedSessionDatabaseClient;
import com.google.cloud.spanner.AsyncRunner;
import com.google.cloud.spanner.AsyncTransactionManager;
import com.google.cloud.spanner.CommitResponse;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.DatabaseNotFoundException;
import com.google.cloud.spanner.DelayedMultiplexedSessionTransaction;
import com.google.cloud.spanner.Dialect;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.ISpan;
import com.google.cloud.spanner.InstanceNotFoundException;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.MutationGroup;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ReadContext;
import com.google.cloud.spanner.ReadOnlyTransaction;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.SessionClient;
import com.google.cloud.spanner.SessionImpl;
import com.google.cloud.spanner.SessionNotFoundException;
import com.google.cloud.spanner.SessionPool;
import com.google.cloud.spanner.SessionPoolOptions;
import com.google.cloud.spanner.SessionReference;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.SpannerImpl;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.ThreadFactoryUtil;
import com.google.cloud.spanner.TimestampBound;
import com.google.cloud.spanner.TraceWrapper;
import com.google.cloud.spanner.TransactionManager;
import com.google.cloud.spanner.TransactionRunner;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.spanner.v1.BatchWriteResponse;
import com.google.spanner.v1.BeginTransactionRequest;
import com.google.spanner.v1.RequestOptions;
import com.google.spanner.v1.Transaction;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

final class MultiplexedSessionDatabaseClient
extends AbstractMultiplexedSessionDatabaseClient {
    private static final Map<SpannerImpl, BitSet> CHANNEL_USAGE = new HashMap<SpannerImpl, BitSet>();
    private final BitSet channelUsage;
    private final int numChannels;
    private final AtomicInteger numCurrentSingleUseTransactions = new AtomicInteger();
    private boolean isClosed;
    private final Duration sessionExpirationDuration;
    private final SessionClient sessionClient;
    private final TraceWrapper tracer;
    private final AtomicReference<ApiFuture<SessionReference>> multiplexedSessionReference;
    private final SettableApiFuture<Transaction> readWriteBeginTransactionReferenceFuture;
    private final AtomicReference<Instant> expirationDate;
    private final MultiplexedSessionMaintainer maintainer;
    private final AtomicReference<SpannerException.ResourceNotFoundException> resourceNotFoundException = new AtomicReference();
    private final AtomicLong numSessionsAcquired = new AtomicLong();
    private final AtomicLong numSessionsReleased = new AtomicLong();
    private final AtomicBoolean unimplemented = new AtomicBoolean(false);
    @VisibleForTesting
    final AtomicBoolean unimplementedForRW = new AtomicBoolean(false);
    @VisibleForTesting
    final AtomicBoolean unimplementedForPartitionedOps = new AtomicBoolean(false);
    private final AbstractLazyInitializer<Dialect> dialectSupplier = new AbstractLazyInitializer<Dialect>(){

        @Override
        protected Dialect initialize() {
            try (ResultSet dialectResultSet = MultiplexedSessionDatabaseClient.this.singleUse().executeQuery(SessionPool.DETERMINE_DIALECT_STATEMENT, new Options.QueryOption[0]);){
                if (dialectResultSet.next()) {
                    Dialect dialect = Dialect.fromName(dialectResultSet.getString(0));
                    return dialect;
                }
            }
            return Dialect.GOOGLE_STANDARD_SQL;
        }
    };
    private static final ScheduledExecutorService MAINTAINER_SERVICE = Executors.newScheduledThreadPool(1, ThreadFactoryUtil.createVirtualOrPlatformDaemonThreadFactory("multiplexed-session-maintainer", false));

    MultiplexedSessionDatabaseClient(SessionClient sessionClient) {
        this(sessionClient, Clock.systemUTC());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    MultiplexedSessionDatabaseClient(final SessionClient sessionClient, Clock clock) {
        this.numChannels = ((SpannerOptions)sessionClient.getSpanner().getOptions()).getNumChannels();
        Map<SpannerImpl, BitSet> map = CHANNEL_USAGE;
        synchronized (map) {
            CHANNEL_USAGE.putIfAbsent(sessionClient.getSpanner(), new BitSet(this.numChannels));
            this.channelUsage = CHANNEL_USAGE.get(sessionClient.getSpanner());
        }
        this.sessionExpirationDuration = Duration.ofMillis(((SpannerOptions)sessionClient.getSpanner().getOptions()).getSessionPoolOptions().getMultiplexedSessionMaintenanceDuration().toMillis());
        this.expirationDate = new AtomicReference<Instant>(Instant.now().plus(this.sessionExpirationDuration));
        this.sessionClient = sessionClient;
        this.maintainer = new MultiplexedSessionMaintainer(clock);
        this.tracer = sessionClient.getSpanner().getTracer();
        final SettableApiFuture initialSessionReferenceFuture = SettableApiFuture.create();
        this.readWriteBeginTransactionReferenceFuture = SettableApiFuture.create();
        this.multiplexedSessionReference = new AtomicReference<SettableApiFuture>(initialSessionReferenceFuture);
        this.sessionClient.asyncCreateMultiplexedSession(new SessionClient.SessionConsumer(){

            @Override
            public void onSessionReady(SessionImpl session) {
                initialSessionReferenceFuture.set((Object)session.getSessionReference());
                MultiplexedSessionDatabaseClient.this.maintainer.start();
                if (((SpannerOptions)sessionClient.getSpanner().getOptions()).getSessionPoolOptions().getUseMultiplexedSessionForRW() && !((SpannerOptions)sessionClient.getSpanner().getOptions()).getSessionPoolOptions().getSkipVerifyBeginTransactionForMuxRW()) {
                    MultiplexedSessionDatabaseClient.this.verifyBeginTransactionWithRWOnMultiplexedSessionAsync(session.getName());
                }
                if (((SpannerOptions)sessionClient.getSpanner().getOptions()).getSessionPoolOptions().isAutoDetectDialect()) {
                    MAINTAINER_SERVICE.submit(() -> MultiplexedSessionDatabaseClient.this.getDialect());
                }
            }

            @Override
            public void onSessionCreateFailure(Throwable t, int createFailureForSessionCount) {
                MultiplexedSessionDatabaseClient.this.maybeMarkUnimplemented(t);
                initialSessionReferenceFuture.setException(t);
            }
        });
        MultiplexedSessionDatabaseClient.maybeWaitForSessionCreation(((SpannerOptions)sessionClient.getSpanner().getOptions()).getSessionPoolOptions(), (ApiFuture<SessionReference>)initialSessionReferenceFuture);
    }

    private static void maybeWaitForSessionCreation(SessionPoolOptions sessionPoolOptions, ApiFuture<SessionReference> future) {
        Duration waitDuration = sessionPoolOptions.getWaitForMinSessions();
        if (waitDuration != null && !waitDuration.isZero()) {
            long timeoutMillis = waitDuration.toMillis();
            try {
                future.get(timeoutMillis, TimeUnit.MILLISECONDS);
            }
            catch (ExecutionException executionException) {
                throw SpannerExceptionFactory.asSpannerException(executionException.getCause());
            }
            catch (InterruptedException interruptedException) {
                throw SpannerExceptionFactory.propagateInterrupt(interruptedException);
            }
            catch (TimeoutException timeoutException) {
                throw SpannerExceptionFactory.newSpannerException(ErrorCode.DEADLINE_EXCEEDED, "Timed out after waiting " + timeoutMillis + "ms for multiplexed session creation");
            }
        }
    }

    private void maybeMarkUnimplemented(Throwable t) {
        SpannerException spannerException = SpannerExceptionFactory.asSpannerException(t);
        if (spannerException.getErrorCode() == ErrorCode.UNIMPLEMENTED) {
            this.unimplemented.set(true);
        }
    }

    private void maybeMarkUnimplementedForRW(SpannerException spannerException) {
        if (spannerException.getErrorCode() == ErrorCode.UNIMPLEMENTED && MultiplexedSessionDatabaseClient.verifyErrorMessage(spannerException, "Transaction type read_write not supported with multiplexed sessions")) {
            this.unimplementedForRW.set(true);
        }
    }

    boolean maybeMarkUnimplementedForPartitionedOps(SpannerException spannerException) {
        if (spannerException.getErrorCode() == ErrorCode.UNIMPLEMENTED && MultiplexedSessionDatabaseClient.verifyErrorMessage(spannerException, "Transaction type partitioned_dml not supported with multiplexed sessions")) {
            this.unimplementedForPartitionedOps.set(true);
            return true;
        }
        return false;
    }

    static boolean verifyErrorMessage(SpannerException spannerException, String message) {
        if (spannerException.getCause() == null) {
            return false;
        }
        if (spannerException.getCause().getMessage() == null) {
            return false;
        }
        return spannerException.getCause().getMessage().contains(message);
    }

    private void verifyBeginTransactionWithRWOnMultiplexedSessionAsync(String sessionName) {
        BeginTransactionRequest.Builder requestBuilder = BeginTransactionRequest.newBuilder().setSession(sessionName).setOptions(SessionImpl.createReadWriteTransactionOptions(Options.fromTransactionOptions(new Options.TransactionOption[0]), null)).setRequestOptions(RequestOptions.newBuilder().setTransactionTag("multiplexed-rw-background-begin-txn").build());
        BeginTransactionRequest request = requestBuilder.build();
        ApiFuture<Transaction> requestFuture = this.sessionClient.getSpanner().getRpc().beginTransactionAsync(request, null, true);
        requestFuture.addListener(() -> {
            try {
                Transaction txn = (Transaction)requestFuture.get();
                if (txn.getId().isEmpty()) {
                    throw SpannerExceptionFactory.newSpannerException(ErrorCode.INTERNAL, "Missing id in transaction\n" + sessionName);
                }
                this.readWriteBeginTransactionReferenceFuture.set((Object)txn);
            }
            catch (Exception e) {
                SpannerException spannerException = SpannerExceptionFactory.newSpannerException(e);
                this.maybeMarkUnimplementedForRW(spannerException);
                this.readWriteBeginTransactionReferenceFuture.setException((Throwable)e);
            }
        }, MoreExecutors.directExecutor());
    }

    boolean isValid() {
        return this.resourceNotFoundException.get() == null;
    }

    AtomicLong getNumSessionsAcquired() {
        return this.numSessionsAcquired;
    }

    AtomicLong getNumSessionsReleased() {
        return this.numSessionsReleased;
    }

    boolean isMultiplexedSessionsSupported() {
        return !this.unimplemented.get();
    }

    boolean isMultiplexedSessionsForRWSupported() {
        return !this.unimplementedForRW.get();
    }

    boolean isMultiplexedSessionsForPartitionedOpsSupported() {
        return !this.unimplementedForPartitionedOps.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() {
        MultiplexedSessionDatabaseClient multiplexedSessionDatabaseClient = this;
        synchronized (multiplexedSessionDatabaseClient) {
            if (!this.isClosed) {
                this.isClosed = true;
                this.maintainer.stop();
            }
        }
    }

    @VisibleForTesting
    MultiplexedSessionMaintainer getMaintainer() {
        return this.maintainer;
    }

    @VisibleForTesting
    SessionReference getCurrentSessionReference() {
        try {
            return (SessionReference)this.multiplexedSessionReference.get().get();
        }
        catch (ExecutionException executionException) {
            throw SpannerExceptionFactory.asSpannerException(executionException.getCause());
        }
        catch (InterruptedException interruptedException) {
            throw SpannerExceptionFactory.propagateInterrupt(interruptedException);
        }
    }

    @VisibleForTesting
    Transaction getReadWriteBeginTransactionReference() {
        try {
            return (Transaction)this.readWriteBeginTransactionReferenceFuture.get();
        }
        catch (ExecutionException executionException) {
            throw SpannerExceptionFactory.asSpannerException(executionException.getCause());
        }
        catch (InterruptedException interruptedException) {
            throw SpannerExceptionFactory.propagateInterrupt(interruptedException);
        }
    }

    private boolean isMultiplexedSessionCreated() {
        return this.multiplexedSessionReference.get().isDone();
    }

    private DatabaseClient createMultiplexedSessionTransaction(boolean singleUse) {
        Preconditions.checkState((!this.isClosed ? 1 : 0) != 0, (Object)"This client has been closed");
        return this.isMultiplexedSessionCreated() ? this.createDirectMultiplexedSessionTransaction(singleUse) : this.createDelayedMultiplexSessionTransaction();
    }

    private MultiplexedSessionTransaction createDirectMultiplexedSessionTransaction(boolean singleUse) {
        try {
            return new MultiplexedSessionTransaction(this, this.tracer.getCurrentSpan(), (SessionReference)this.multiplexedSessionReference.get().get(), singleUse ? this.getSingleUseChannelHint() : -1, singleUse);
        }
        catch (ExecutionException executionException) {
            throw SpannerExceptionFactory.asSpannerException(executionException.getCause());
        }
        catch (InterruptedException interruptedException) {
            throw SpannerExceptionFactory.propagateInterrupt(interruptedException);
        }
    }

    private DelayedMultiplexedSessionTransaction createDelayedMultiplexSessionTransaction() {
        return new DelayedMultiplexedSessionTransaction(this, this.tracer.getCurrentSpan(), this.multiplexedSessionReference.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getSingleUseChannelHint() {
        if (this.numCurrentSingleUseTransactions.incrementAndGet() > this.numChannels) {
            return -1;
        }
        BitSet bitSet = this.channelUsage;
        synchronized (bitSet) {
            int channel = this.channelUsage.nextClearBit(0);
            if (channel == this.numChannels) {
                return -1;
            }
            this.channelUsage.set(channel);
            return channel;
        }
    }

    @Override
    public Dialect getDialect() {
        try {
            return this.dialectSupplier.get();
        }
        catch (Exception exception) {
            throw SpannerExceptionFactory.asSpannerException(exception);
        }
    }

    @Override
    public Timestamp write(Iterable<Mutation> mutations) throws SpannerException {
        return this.createMultiplexedSessionTransaction(false).write(mutations);
    }

    @Override
    public CommitResponse writeWithOptions(Iterable<Mutation> mutations, Options.TransactionOption ... options) throws SpannerException {
        return this.createMultiplexedSessionTransaction(false).writeWithOptions(mutations, options);
    }

    @Override
    public CommitResponse writeAtLeastOnceWithOptions(Iterable<Mutation> mutations, Options.TransactionOption ... options) throws SpannerException {
        return this.createMultiplexedSessionTransaction(true).writeAtLeastOnceWithOptions(mutations, options);
    }

    @Override
    public ServerStream<BatchWriteResponse> batchWriteAtLeastOnce(Iterable<MutationGroup> mutationGroups, Options.TransactionOption ... options) throws SpannerException {
        return this.createMultiplexedSessionTransaction(true).batchWriteAtLeastOnce(mutationGroups, options);
    }

    @Override
    public ReadContext singleUse() {
        return this.createMultiplexedSessionTransaction(true).singleUse();
    }

    @Override
    public ReadContext singleUse(TimestampBound bound) {
        return this.createMultiplexedSessionTransaction(true).singleUse(bound);
    }

    @Override
    public ReadOnlyTransaction singleUseReadOnlyTransaction() {
        return this.createMultiplexedSessionTransaction(true).singleUseReadOnlyTransaction();
    }

    @Override
    public ReadOnlyTransaction singleUseReadOnlyTransaction(TimestampBound bound) {
        return this.createMultiplexedSessionTransaction(true).singleUseReadOnlyTransaction(bound);
    }

    @Override
    public ReadOnlyTransaction readOnlyTransaction() {
        return this.createMultiplexedSessionTransaction(false).readOnlyTransaction();
    }

    @Override
    public ReadOnlyTransaction readOnlyTransaction(TimestampBound bound) {
        return this.createMultiplexedSessionTransaction(false).readOnlyTransaction(bound);
    }

    @Override
    public TransactionRunner readWriteTransaction(Options.TransactionOption ... options) {
        return this.createMultiplexedSessionTransaction(false).readWriteTransaction(options);
    }

    @Override
    public TransactionManager transactionManager(Options.TransactionOption ... options) {
        return this.createMultiplexedSessionTransaction(false).transactionManager(options);
    }

    @Override
    public AsyncRunner runAsync(Options.TransactionOption ... options) {
        return this.createMultiplexedSessionTransaction(false).runAsync(options);
    }

    @Override
    public AsyncTransactionManager transactionManagerAsync(Options.TransactionOption ... options) {
        return this.createMultiplexedSessionTransaction(false).transactionManagerAsync(options);
    }

    @Override
    public long executePartitionedUpdate(Statement stmt, Options.UpdateOption ... options) {
        return this.createMultiplexedSessionTransaction(true).executePartitionedUpdate(stmt, options);
    }

    final class MultiplexedSessionMaintainer {
        private final Clock clock;
        private ScheduledFuture<?> scheduledFuture;

        MultiplexedSessionMaintainer(Clock clock) {
            this.clock = clock;
        }

        void start() {
            long loopFrequencyMillis = ((SpannerOptions)MultiplexedSessionDatabaseClient.this.sessionClient.getSpanner().getOptions()).getSessionPoolOptions().getMultiplexedSessionMaintenanceLoopFrequency().toMillis();
            this.scheduledFuture = MAINTAINER_SERVICE.scheduleAtFixedRate(this::maintain, loopFrequencyMillis, loopFrequencyMillis, TimeUnit.MILLISECONDS);
        }

        void stop() {
            if (this.scheduledFuture != null) {
                this.scheduledFuture.cancel(false);
            }
        }

        void maintain() {
            if (this.clock.instant().isAfter((Instant)MultiplexedSessionDatabaseClient.this.expirationDate.get())) {
                MultiplexedSessionDatabaseClient.this.sessionClient.asyncCreateMultiplexedSession(new SessionClient.SessionConsumer(){

                    @Override
                    public void onSessionReady(SessionImpl session) {
                        MultiplexedSessionDatabaseClient.this.multiplexedSessionReference.set(ApiFutures.immediateFuture((Object)session.getSessionReference()));
                        MultiplexedSessionDatabaseClient.this.expirationDate.set(MultiplexedSessionMaintainer.this.clock.instant().plus(MultiplexedSessionDatabaseClient.this.sessionExpirationDuration));
                    }

                    @Override
                    public void onSessionCreateFailure(Throwable t, int createFailureForSessionCount) {
                        MultiplexedSessionDatabaseClient.this.maybeMarkUnimplemented(t);
                    }
                });
            }
        }
    }

    static class MultiplexedSessionTransaction
    extends SessionImpl {
        private final MultiplexedSessionDatabaseClient client;
        private final boolean singleUse;
        private final int singleUseChannelHint;
        private boolean done;

        MultiplexedSessionTransaction(MultiplexedSessionDatabaseClient client, ISpan span, SessionReference sessionReference, int singleUseChannelHint, boolean singleUse) {
            super(client.sessionClient.getSpanner(), sessionReference, singleUseChannelHint);
            this.client = client;
            this.singleUse = singleUse;
            this.singleUseChannelHint = singleUseChannelHint;
            this.client.numSessionsAcquired.incrementAndGet();
            this.setCurrentSpan(span);
        }

        @Override
        void onError(SpannerException spannerException) {
            if (this.client.resourceNotFoundException.get() == null && (spannerException instanceof DatabaseNotFoundException || spannerException instanceof InstanceNotFoundException || spannerException instanceof SessionNotFoundException)) {
                this.client.resourceNotFoundException.set((SpannerException.ResourceNotFoundException)spannerException);
            }
            this.client.maybeMarkUnimplementedForRW(spannerException);
            this.client.maybeMarkUnimplementedForPartitionedOps(spannerException);
        }

        @Override
        void onReadDone() {
            if (this.singleUse && this.getActiveTransaction() != null) {
                this.getActiveTransaction().close();
                this.setActive(null);
                if (this.singleUseChannelHint != -1) {
                    this.client.channelUsage.clear(this.singleUseChannelHint);
                }
                this.client.numCurrentSingleUseTransactions.decrementAndGet();
            }
        }

        @Override
        public CommitResponse writeAtLeastOnceWithOptions(Iterable<Mutation> mutations, Options.TransactionOption ... options) throws SpannerException {
            CommitResponse response = super.writeAtLeastOnceWithOptions(mutations, options);
            this.onTransactionDone();
            return response;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void onTransactionDone() {
            boolean markedDone = false;
            MultiplexedSessionTransaction multiplexedSessionTransaction = this;
            synchronized (multiplexedSessionTransaction) {
                if (!this.done) {
                    this.done = true;
                    markedDone = true;
                }
            }
            if (markedDone) {
                this.client.numSessionsReleased.incrementAndGet();
            }
        }

        @Override
        public void close() {
        }
    }
}

