/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.ISpan;
import com.google.cloud.spanner.SpannerException;
import com.google.common.collect.ImmutableMap;
import io.opencensus.contrib.grpc.util.StatusConverter;
import io.opencensus.trace.AttributeValue;
import io.opencensus.trace.EndSpanOptions;
import io.opencensus.trace.Span;
import io.opencensus.trace.Status;
import java.util.HashMap;
import java.util.Map;

public class OpenCensusSpan
implements ISpan {
    static final EndSpanOptions END_SPAN_OPTIONS = EndSpanOptions.builder().setSampleToLocalSpanStore(true).build();
    private final Span openCensusSpan;

    public OpenCensusSpan(Span openCensusSpan) {
        this.openCensusSpan = openCensusSpan;
    }

    Span getOpenCensusSpan() {
        return this.openCensusSpan;
    }

    private ImmutableMap<String, AttributeValue> getOpenCensusExceptionAnnotations(Throwable e) {
        if (e instanceof SpannerException) {
            return ImmutableMap.of((Object)"Status", (Object)AttributeValue.stringAttributeValue((String)((SpannerException)((Object)e)).getErrorCode().toString()));
        }
        return ImmutableMap.of();
    }

    @Override
    public void addAnnotation(String message, Map<String, Object> attributes) {
        HashMap<String, AttributeValue> ocAttributeValues = new HashMap<String, AttributeValue>();
        for (Map.Entry<String, Object> entry : attributes.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof String) {
                ocAttributeValues.put(key, AttributeValue.stringAttributeValue((String)((String)value)));
                continue;
            }
            if (!(value instanceof Long)) continue;
            ocAttributeValues.put(key, AttributeValue.longAttributeValue((long)((Long)value)));
        }
        if (ocAttributeValues.size() > 0) {
            this.openCensusSpan.addAnnotation(message, ocAttributeValues);
        }
    }

    @Override
    public void addAnnotation(String message) {
        this.openCensusSpan.addAnnotation(message);
    }

    @Override
    public void addAnnotation(String message, String key, String value) {
        this.openCensusSpan.addAnnotation(message, (Map)ImmutableMap.of((Object)key, (Object)AttributeValue.stringAttributeValue((String)value)));
    }

    @Override
    public void addAnnotation(String message, String key, long value) {
        this.openCensusSpan.addAnnotation(message, (Map)ImmutableMap.of((Object)key, (Object)AttributeValue.longAttributeValue((long)value)));
    }

    @Override
    public void addAnnotation(String message, Throwable e) {
        this.openCensusSpan.addAnnotation(message, this.getOpenCensusExceptionAnnotations(e));
    }

    @Override
    public void setStatus(Throwable e) {
        if (e instanceof SpannerException) {
            this.openCensusSpan.setStatus(StatusConverter.fromGrpcStatus((io.grpc.Status)((SpannerException)((Object)e)).getErrorCode().getGrpcStatus()).withDescription(e.getMessage()));
        } else {
            this.openCensusSpan.setStatus(Status.INTERNAL.withDescription(e.getMessage()));
        }
    }

    @Override
    public void setStatus(ErrorCode errorCode) {
        this.openCensusSpan.setStatus(StatusConverter.fromGrpcStatus((io.grpc.Status)errorCode.getGrpcStatus()));
    }

    @Override
    public void end() {
        this.openCensusSpan.end(END_SPAN_OPTIONS);
    }
}

