/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.gax.core.GaxProperties;
import com.google.cloud.spanner.BuiltInMetricsProvider;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.IScope;
import com.google.cloud.spanner.ISpan;
import com.google.cloud.spanner.OpenCensusScope;
import com.google.cloud.spanner.OpenCensusSpan;
import com.google.cloud.spanner.OpenTelemetryContextKeys;
import com.google.cloud.spanner.OpenTelemetryScope;
import com.google.cloud.spanner.OpenTelemetrySpan;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.Statement;
import com.google.common.base.MoreObjects;
import io.opencensus.trace.BlankSpan;
import io.opencensus.trace.Tracer;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

class TraceWrapper {
    private static final AttributeKey<String> TRANSACTION_TAG_KEY = AttributeKey.stringKey((String)"transaction.tag");
    private static final AttributeKey<String> STATEMENT_TAG_KEY = AttributeKey.stringKey((String)"statement.tag");
    private static final AttributeKey<String> INSTANCE_NAME_KEY = AttributeKey.stringKey((String)"instance.name");
    private static final AttributeKey<String> DB_NAME_KEY = AttributeKey.stringKey((String)"db.name");
    private static final AttributeKey<String> DB_STATEMENT_KEY = AttributeKey.stringKey((String)"db.statement");
    private static final AttributeKey<List<String>> DB_STATEMENT_ARRAY_KEY = AttributeKey.stringArrayKey((String)"db.statement");
    private static final AttributeKey<String> DB_TABLE_NAME_KEY = AttributeKey.stringKey((String)"db.table");
    private static final AttributeKey<String> CLOUD_REGION_KEY = AttributeKey.stringKey((String)"cloud.region");
    private static final AttributeKey<String> GCP_CLIENT_SERVICE_KEY = AttributeKey.stringKey((String)"gcp.client.service");
    private static final AttributeKey<String> GCP_CLIENT_VERSION_KEY = AttributeKey.stringKey((String)"gcp.client.version");
    private static final AttributeKey<String> GCP_CLIENT_REPO_KEY = AttributeKey.stringKey((String)"gcp.client.repo");
    private static final AttributeKey<String> THREAD_NAME_KEY = AttributeKey.stringKey((String)"thread.name");
    private final Tracer openCensusTracer;
    private final io.opentelemetry.api.trace.Tracer openTelemetryTracer;
    private final boolean enableExtendedTracing;

    TraceWrapper(Tracer openCensusTracer, io.opentelemetry.api.trace.Tracer openTelemetryTracer, boolean enableExtendedTracing) {
        this.openTelemetryTracer = openTelemetryTracer;
        this.openCensusTracer = openCensusTracer;
        this.enableExtendedTracing = enableExtendedTracing;
    }

    ISpan spanBuilder(String spanName) {
        return this.spanBuilder(spanName, Attributes.empty());
    }

    ISpan spanBuilder(String spanName, Attributes commonAttributes, Options.TransactionOption ... options) {
        return this.spanBuilder(spanName, this.createTransactionAttributes(commonAttributes, options));
    }

    ISpan spanBuilder(String spanName, Attributes attributes) {
        if (SpannerOptions.getActiveTracingFramework().equals((Object)SpannerOptions.TracingFramework.OPEN_TELEMETRY)) {
            return new OpenTelemetrySpan(this.openTelemetryTracer.spanBuilder(spanName).setAllAttributes(attributes).startSpan());
        }
        return new OpenCensusSpan(this.openCensusTracer.spanBuilder(spanName).startSpan());
    }

    ISpan spanBuilderWithExplicitParent(String spanName, ISpan parentSpan) {
        return this.spanBuilderWithExplicitParent(spanName, parentSpan, Attributes.empty());
    }

    ISpan spanBuilderWithExplicitParent(String spanName, ISpan parentSpan, Attributes attributes) {
        if (SpannerOptions.getActiveTracingFramework().equals((Object)SpannerOptions.TracingFramework.OPEN_TELEMETRY)) {
            OpenTelemetrySpan otParentSpan = (OpenTelemetrySpan)parentSpan;
            SpanBuilder otSpan = this.openTelemetryTracer.spanBuilder(spanName).setAllAttributes(attributes);
            if (otParentSpan != null && otParentSpan.getOpenTelemetrySpan() != null) {
                otSpan = otSpan.setParent(Context.current().with((ImplicitContextKeyed)otParentSpan.getOpenTelemetrySpan()));
            }
            return new OpenTelemetrySpan(otSpan.startSpan());
        }
        OpenCensusSpan parentOcSpan = (OpenCensusSpan)parentSpan;
        io.opencensus.trace.Span ocSpan = this.openCensusTracer.spanBuilderWithExplicitParent(spanName, parentOcSpan != null ? parentOcSpan.getOpenCensusSpan() : null).startSpan();
        return new OpenCensusSpan(ocSpan);
    }

    ISpan getCurrentSpan() {
        if (SpannerOptions.getActiveTracingFramework().equals((Object)SpannerOptions.TracingFramework.OPEN_TELEMETRY)) {
            return new OpenTelemetrySpan(Span.fromContext((Context)Context.current()));
        }
        return new OpenCensusSpan(this.openCensusTracer.getCurrentSpan());
    }

    ISpan getBlankSpan() {
        if (SpannerOptions.getActiveTracingFramework().equals((Object)SpannerOptions.TracingFramework.OPEN_TELEMETRY)) {
            return new OpenTelemetrySpan(Span.getInvalid());
        }
        return new OpenCensusSpan((io.opencensus.trace.Span)BlankSpan.INSTANCE);
    }

    IScope withSpan(ISpan span) {
        if (SpannerOptions.getActiveTracingFramework().equals((Object)SpannerOptions.TracingFramework.OPEN_TELEMETRY)) {
            OpenTelemetrySpan openTelemetrySpan = !(span instanceof OpenTelemetrySpan) ? new OpenTelemetrySpan(null) : (OpenTelemetrySpan)span;
            return new OpenTelemetryScope(openTelemetrySpan.getOpenTelemetrySpan().makeCurrent());
        }
        OpenCensusSpan openCensusSpan = !(span instanceof OpenCensusSpan) ? new OpenCensusSpan(null) : (OpenCensusSpan)span;
        return new OpenCensusScope(this.openCensusTracer.withSpan(openCensusSpan.getOpenCensusSpan()));
    }

    Attributes createTransactionAttributes(Attributes commonAttributes, Options.TransactionOption ... options) {
        Optional<Options.TagOption> tagOption;
        AttributesBuilder builder = commonAttributes.toBuilder();
        if (options != null && options.length > 0 && (tagOption = Arrays.stream(options).filter(option -> option instanceof Options.TagOption).map(option -> (Options.TagOption)option).findAny()).isPresent()) {
            builder.put(TRANSACTION_TAG_KEY, (Object)tagOption.get().getTag());
        }
        return builder.build();
    }

    Attributes createStatementAttributes(Statement statement, Options options) {
        if (this.enableExtendedTracing || options != null && options.hasTag()) {
            AttributesBuilder builder = Attributes.builder();
            if (this.enableExtendedTracing) {
                builder.put(DB_STATEMENT_KEY, (Object)statement.getSql());
                builder.put(THREAD_NAME_KEY, (Object)TraceWrapper.getTraceThreadName());
            }
            if (options != null && options.hasTag()) {
                builder.put(STATEMENT_TAG_KEY, (Object)options.tag());
            }
            return builder.build();
        }
        return Attributes.empty();
    }

    Attributes createStatementBatchAttributes(Iterable<Statement> statements, Options options) {
        if (this.enableExtendedTracing || options != null && options.hasTag()) {
            AttributesBuilder builder = Attributes.builder();
            if (this.enableExtendedTracing) {
                builder.put(DB_STATEMENT_ARRAY_KEY, StreamSupport.stream(statements.spliterator(), false).map(Statement::getSql).collect(Collectors.toList()));
                builder.put(THREAD_NAME_KEY, (Object)TraceWrapper.getTraceThreadName());
            }
            if (options != null && options.hasTag()) {
                builder.put(STATEMENT_TAG_KEY, (Object)options.tag());
            }
            return builder.build();
        }
        return Attributes.empty();
    }

    Attributes createTableAttributes(String tableName, Options options) {
        AttributesBuilder builder = Attributes.builder();
        builder.put(DB_TABLE_NAME_KEY, (Object)tableName);
        if (options != null && options.hasTag()) {
            builder.put(STATEMENT_TAG_KEY, (Object)options.tag());
        }
        return builder.build();
    }

    Attributes createCommonAttributes(DatabaseId db) {
        AttributesBuilder builder = Attributes.builder();
        builder.put(DB_NAME_KEY, (Object)db.getDatabase());
        builder.put(INSTANCE_NAME_KEY, (Object)db.getInstanceId().getInstance());
        builder.put(GCP_CLIENT_SERVICE_KEY, (Object)"spanner");
        builder.put(GCP_CLIENT_REPO_KEY, (Object)"googleapis/java-spanner");
        builder.put(GCP_CLIENT_VERSION_KEY, (Object)GaxProperties.getLibraryVersion(TraceWrapper.class));
        builder.put(CLOUD_REGION_KEY, (Object)BuiltInMetricsProvider.detectClientLocation());
        return builder.build();
    }

    private static String getTraceThreadName() {
        return (String)MoreObjects.firstNonNull((Object)((String)Context.current().get(OpenTelemetryContextKeys.THREAD_NAME_KEY)), (Object)Thread.currentThread().getName());
    }
}

