/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.api.gax.longrunning.OperationFuture;
import com.google.cloud.spanner.Database;
import com.google.cloud.spanner.DatabaseAdminClient;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.Dialect;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.MissingDefaultSequenceKindException;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.spanner.admin.database.v1.CreateDatabaseMetadata;
import com.google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;

class DdlClient {
    private final DatabaseAdminClient dbAdminClient;
    private final String projectId;
    private final String instanceId;
    private final String databaseName;

    static Builder newBuilder() {
        return new Builder();
    }

    private DdlClient(Builder builder) {
        this.dbAdminClient = builder.dbAdminClient;
        this.projectId = builder.projectId;
        this.instanceId = builder.instanceId;
        this.databaseName = builder.databaseName;
    }

    OperationFuture<Database, CreateDatabaseMetadata> executeCreateDatabase(String createStatement, Dialect dialect) {
        Preconditions.checkArgument((boolean)DdlClient.isCreateDatabaseStatement(createStatement));
        return this.dbAdminClient.createDatabase(this.instanceId, createStatement, dialect, Collections.emptyList());
    }

    OperationFuture<Void, UpdateDatabaseDdlMetadata> executeDdl(String ddl, byte[] protoDescriptors) {
        return this.executeDdl(Collections.singletonList(ddl), protoDescriptors);
    }

    OperationFuture<Void, UpdateDatabaseDdlMetadata> executeDdl(List<String> statements, byte[] protoDescriptors) {
        if (statements.stream().anyMatch(DdlClient::isCreateDatabaseStatement)) {
            throw SpannerExceptionFactory.newSpannerException(ErrorCode.INVALID_ARGUMENT, "CREATE DATABASE is not supported in a DDL batch");
        }
        Database.Builder dbBuilder = this.dbAdminClient.newDatabaseBuilder(DatabaseId.of(this.projectId, this.instanceId, this.databaseName));
        if (protoDescriptors != null) {
            dbBuilder.setProtoDescriptors(protoDescriptors);
        }
        Database db = dbBuilder.build();
        return this.dbAdminClient.updateDatabaseDdl(db, statements, null);
    }

    static boolean isCreateDatabaseStatement(String statement) {
        String[] tokens = statement.split("\\s+", 3);
        return tokens.length >= 2 && tokens[0].equalsIgnoreCase("CREATE") && tokens[1].equalsIgnoreCase("DATABASE");
    }

    void runWithRetryForMissingDefaultSequenceKind(Consumer<Integer> runnable, String defaultSequenceKind, Dialect dialect, AtomicReference<OperationFuture<Void, UpdateDatabaseDdlMetadata>> operationReference) {
        try {
            runnable.accept(0);
        }
        catch (Throwable t) {
            SpannerException spannerException = SpannerExceptionFactory.asSpannerException(t);
            if (!Strings.isNullOrEmpty((String)defaultSequenceKind) && spannerException instanceof MissingDefaultSequenceKindException) {
                this.setDefaultSequenceKind(defaultSequenceKind, dialect);
                int restartIndex = 0;
                if (operationReference.get() != null) {
                    try {
                        UpdateDatabaseDdlMetadata metadata = (UpdateDatabaseDdlMetadata)operationReference.get().getMetadata().get();
                        restartIndex = metadata.getCommitTimestampsCount();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                runnable.accept(restartIndex);
                return;
            }
            throw t;
        }
    }

    private void setDefaultSequenceKind(String defaultSequenceKind, Dialect dialect) {
        String ddl = dialect == Dialect.POSTGRESQL ? "alter database \"%s\" set spanner.default_sequence_kind = '%s'" : "alter database `%s` set options (default_sequence_kind='%s')";
        ddl = String.format(ddl, this.databaseName, defaultSequenceKind);
        try {
            this.executeDdl(ddl, null).get();
        }
        catch (ExecutionException executionException) {
            throw SpannerExceptionFactory.asSpannerException(executionException.getCause());
        }
        catch (InterruptedException interruptedException) {
            throw SpannerExceptionFactory.propagateInterrupt(interruptedException);
        }
    }

    static class Builder {
        private DatabaseAdminClient dbAdminClient;
        private String projectId;
        private String instanceId;
        private String databaseName;

        private Builder() {
        }

        Builder setDatabaseAdminClient(DatabaseAdminClient client) {
            Preconditions.checkNotNull((Object)client);
            this.dbAdminClient = client;
            return this;
        }

        Builder setProjectId(String projectId) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)projectId) ? 1 : 0) != 0, (Object)"Empty projectId is not allowed");
            this.projectId = projectId;
            return this;
        }

        Builder setInstanceId(String instanceId) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)instanceId) ? 1 : 0) != 0, (Object)"Empty instanceId is not allowed");
            this.instanceId = instanceId;
            return this;
        }

        Builder setDatabaseName(String name) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (Object)"Empty database name is not allowed");
            this.databaseName = name;
            return this;
        }

        DdlClient build() {
            Preconditions.checkState((this.dbAdminClient != null ? 1 : 0) != 0, (Object)"No DatabaseAdminClient specified");
            Preconditions.checkState((!Strings.isNullOrEmpty((String)this.projectId) ? 1 : 0) != 0, (Object)"No ProjectId specified");
            Preconditions.checkState((!Strings.isNullOrEmpty((String)this.instanceId) ? 1 : 0) != 0, (Object)"No InstanceId specified");
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)this.databaseName) ? 1 : 0) != 0, (Object)"No database name specified");
            return new DdlClient(this);
        }
    }
}

