/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutureCallback;
import com.google.api.core.ApiFutures;
import com.google.api.core.SettableApiFuture;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.cloud.Timestamp;
import com.google.cloud.Tuple;
import com.google.cloud.spanner.BatchClient;
import com.google.cloud.spanner.BatchReadOnlyTransaction;
import com.google.cloud.spanner.CommitResponse;
import com.google.cloud.spanner.Database;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.PartitionOptions;
import com.google.cloud.spanner.ReadOnlyTransaction;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.SpannerApiFutures;
import com.google.cloud.spanner.SpannerBatchUpdateException;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.TransactionMutationLimitExceededException;
import com.google.cloud.spanner.TransactionRunner;
import com.google.cloud.spanner.connection.AbstractBaseUnitOfWork;
import com.google.cloud.spanner.connection.AbstractStatementParser;
import com.google.cloud.spanner.connection.AnalyzeMode;
import com.google.cloud.spanner.connection.AutocommitDmlMode;
import com.google.cloud.spanner.connection.ConnectionPreconditions;
import com.google.cloud.spanner.connection.ConnectionProperties;
import com.google.cloud.spanner.connection.ConnectionState;
import com.google.cloud.spanner.connection.DdlClient;
import com.google.cloud.spanner.connection.DirectExecuteResultSet;
import com.google.cloud.spanner.connection.TransactionRetryListener;
import com.google.cloud.spanner.connection.UnitOfWork;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.spanner.admin.database.v1.CreateDatabaseMetadata;
import com.google.spanner.admin.database.v1.DatabaseAdminGrpc;
import com.google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata;
import com.google.spanner.v1.SpannerGrpc;
import io.grpc.MethodDescriptor;
import io.opentelemetry.context.Scope;
import java.util.Arrays;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;

class SingleUseTransaction
extends AbstractBaseUnitOfWork {
    private final DdlClient ddlClient;
    private final DatabaseClient dbClient;
    private final BatchClient batchClient;
    private final ConnectionState connectionState;
    private final boolean internalMetadataQuery;
    private final byte[] protoDescriptors;
    private volatile SettableApiFuture<Timestamp> readTimestamp = null;
    private volatile TransactionRunner writeTransaction;
    private boolean used = false;
    private volatile UnitOfWork.UnitOfWorkState state = UnitOfWork.UnitOfWorkState.STARTED;
    private static final Options.QueryUpdateOption[] LAST_STATEMENT_OPTIONS = new Options.QueryUpdateOption[]{Options.lastStatement()};

    static Builder newBuilder() {
        return new Builder();
    }

    private SingleUseTransaction(Builder builder) {
        super(builder);
        this.ddlClient = builder.ddlClient;
        this.dbClient = builder.dbClient;
        this.batchClient = builder.batchClient;
        this.internalMetadataQuery = builder.internalMetadataQuery;
        this.protoDescriptors = builder.protoDescriptors;
        this.connectionState = builder.connectionState;
    }

    @Override
    public boolean isSingleUse() {
        return true;
    }

    @Override
    public UnitOfWork.Type getType() {
        return UnitOfWork.Type.TRANSACTION;
    }

    @Override
    public UnitOfWork.UnitOfWorkState getState() {
        return this.state;
    }

    @Override
    public boolean isActive() {
        return false;
    }

    @Override
    public boolean isReadOnly() {
        return this.connectionState.getValue(ConnectionProperties.READONLY).getValue();
    }

    AutocommitDmlMode getAutocommitDmlMode() {
        return this.connectionState.getValue(ConnectionProperties.AUTOCOMMIT_DML_MODE).getValue();
    }

    @Override
    public boolean supportsDirectedReads(AbstractStatementParser.ParsedStatement parsedStatement) {
        return parsedStatement.isQuery();
    }

    private boolean isRetryDmlAsPartitionedDml() {
        return this.getAutocommitDmlMode() == AutocommitDmlMode.TRANSACTIONAL_WITH_FALLBACK_TO_PARTITIONED_NON_ATOMIC;
    }

    private void checkAndMarkUsed() {
        Preconditions.checkState((!this.used ? 1 : 0) != 0, (Object)"This single-use transaction has already been used");
        this.used = true;
    }

    @Override
    public ApiFuture<ResultSet> executeQueryAsync(UnitOfWork.CallType callType, AbstractStatementParser.ParsedStatement statement, AnalyzeMode analyzeMode, Options.QueryOption ... options) {
        Preconditions.checkNotNull((Object)statement);
        Preconditions.checkArgument((statement.isQuery() || statement.isUpdate() && (analyzeMode != AnalyzeMode.NONE || statement.hasReturningClause()) ? 1 : 0) != 0, (Object)"The statement must be a query, or the statement must be DML and AnalyzeMode must be PLAN or PROFILE");
        try (Scope ignore = this.span.makeCurrent();){
            this.checkAndMarkUsed();
            if (statement.isUpdate()) {
                if (analyzeMode != AnalyzeMode.NONE) {
                    ApiFuture<ResultSet> apiFuture = this.analyzeTransactionalUpdateAsync(callType, statement, analyzeMode);
                    return apiFuture;
                }
                ApiFuture<ResultSet> apiFuture = this.executeDmlReturningAsync(callType, statement, options);
                return apiFuture;
            }
            ReadOnlyTransaction currentTransaction = this.internalMetadataQuery ? this.dbClient.singleUseReadOnlyTransaction() : this.dbClient.singleUseReadOnlyTransaction(this.connectionState.getValue(ConnectionProperties.READ_ONLY_STALENESS).getValue());
            Callable<ResultSet> callable = () -> {
                try {
                    ResultSet rs = analyzeMode == AnalyzeMode.NONE ? currentTransaction.executeQuery(statement.getStatement(), options) : currentTransaction.analyzeQuery(statement.getStatement(), analyzeMode.getQueryAnalyzeMode());
                    DirectExecuteResultSet directRs = DirectExecuteResultSet.ofResultSet(rs);
                    this.state = UnitOfWork.UnitOfWorkState.COMMITTED;
                    this.readTimestamp.set((Object)currentTransaction.getReadTimestamp());
                    return directRs;
                }
                catch (Throwable t) {
                    this.state = UnitOfWork.UnitOfWorkState.COMMIT_FAILED;
                    this.readTimestamp.set(null);
                    currentTransaction.close();
                    throw t;
                }
            };
            this.readTimestamp = SettableApiFuture.create();
            ApiFuture<ResultSet> apiFuture = this.executeStatementAsync(callType, statement, callable, SpannerGrpc.getExecuteStreamingSqlMethod());
            return apiFuture;
        }
    }

    private ApiFuture<ResultSet> executeDmlReturningAsync(UnitOfWork.CallType callType, AbstractStatementParser.ParsedStatement update, Options.QueryOption ... options) {
        Callable<ResultSet> callable = () -> {
            try {
                this.writeTransaction = this.createWriteTransaction();
                ResultSet resultSet = this.writeTransaction.run(transaction -> DirectExecuteResultSet.ofResultSet(transaction.executeQuery(update.getStatement(), SingleUseTransaction.appendLastStatement(options))));
                this.state = UnitOfWork.UnitOfWorkState.COMMITTED;
                return resultSet;
            }
            catch (Throwable t) {
                this.state = UnitOfWork.UnitOfWorkState.COMMIT_FAILED;
                throw t;
            }
        };
        return this.executeStatementAsync(callType, update, callable, (Collection<MethodDescriptor<?, ?>>)ImmutableList.of((Object)SpannerGrpc.getExecuteSqlMethod(), (Object)SpannerGrpc.getCommitMethod()));
    }

    @Override
    public ApiFuture<ResultSet> partitionQueryAsync(UnitOfWork.CallType callType, AbstractStatementParser.ParsedStatement query, PartitionOptions partitionOptions, Options.QueryOption ... options) {
        try (Scope ignore = this.span.makeCurrent();){
            Callable<ResultSet> callable = () -> {
                ResultSet resultSet;
                block8: {
                    BatchReadOnlyTransaction transaction = this.batchClient.batchReadOnlyTransaction(this.connectionState.getValue(ConnectionProperties.READ_ONLY_STALENESS).getValue());
                    try {
                        ResultSet resultSet2 = this.partitionQuery(transaction, partitionOptions, query, options);
                        this.readTimestamp.set((Object)transaction.getReadTimestamp());
                        this.state = UnitOfWork.UnitOfWorkState.COMMITTED;
                        resultSet = resultSet2;
                        if (transaction == null) break block8;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (transaction != null) {
                                try {
                                    transaction.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Throwable throwable3) {
                            this.state = UnitOfWork.UnitOfWorkState.COMMIT_FAILED;
                            this.readTimestamp.set(null);
                            throw throwable3;
                        }
                    }
                    transaction.close();
                }
                return resultSet;
            };
            this.readTimestamp = SettableApiFuture.create();
            ApiFuture<ResultSet> apiFuture = this.executeStatementAsync(callType, query, callable, (Collection<MethodDescriptor<?, ?>>)ImmutableList.of((Object)SpannerGrpc.getExecuteSqlMethod(), (Object)SpannerGrpc.getCommitMethod()));
            return apiFuture;
        }
    }

    @Override
    public Timestamp getReadTimestamp() {
        ConnectionPreconditions.checkState(SpannerApiFutures.getOrNull(this.readTimestamp) != null, "There is no read timestamp available for this transaction.");
        return SpannerApiFutures.get(this.readTimestamp);
    }

    @Override
    public Timestamp getReadTimestampOrNull() {
        return SpannerApiFutures.getOrNull(this.readTimestamp);
    }

    private boolean hasCommitResponse() {
        return this.state == UnitOfWork.UnitOfWorkState.COMMITTED && this.writeTransaction != null;
    }

    @Override
    public Timestamp getCommitTimestamp() {
        ConnectionPreconditions.checkState(this.hasCommitResponse(), "There is no commit timestamp available for this transaction.");
        return this.getCommitResponse().getCommitTimestamp();
    }

    @Override
    public Timestamp getCommitTimestampOrNull() {
        CommitResponse response = this.getCommitResponseOrNull();
        return response == null ? null : response.getCommitTimestamp();
    }

    @Override
    public CommitResponse getCommitResponse() {
        ConnectionPreconditions.checkState(this.hasCommitResponse(), "There is no commit response available for this transaction.");
        return this.writeTransaction.getCommitResponse();
    }

    @Override
    public CommitResponse getCommitResponseOrNull() {
        if (this.hasCommitResponse()) {
            try {
                return this.writeTransaction.getCommitResponse();
            }
            catch (SpannerException spannerException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public ApiFuture<Void> executeDdlAsync(UnitOfWork.CallType callType, AbstractStatementParser.ParsedStatement ddl) {
        Preconditions.checkNotNull((Object)ddl);
        Preconditions.checkArgument((ddl.getType() == AbstractStatementParser.StatementType.DDL ? 1 : 0) != 0, (Object)"Statement is not a ddl statement");
        ConnectionPreconditions.checkState(!this.isReadOnly(), "DDL statements are not allowed in read-only mode");
        try (Scope ignore = this.span.makeCurrent();){
            this.checkAndMarkUsed();
            this.span.setAttribute(DB_STATEMENT_KEY, (Object)ddl.getStatement().getSql());
            Callable<Void> callable = () -> {
                try {
                    if (DdlClient.isCreateDatabaseStatement(ddl.getSqlWithoutComments())) {
                        this.executeCreateDatabase(ddl);
                    } else {
                        this.ddlClient.runWithRetryForMissingDefaultSequenceKind(restartIndex -> {
                            OperationFuture<Void, UpdateDatabaseDdlMetadata> operation = this.ddlClient.executeDdl(ddl.getSqlWithoutComments(), this.protoDescriptors);
                            this.getWithStatementTimeout(operation, ddl);
                        }, this.connectionState.getValue(ConnectionProperties.DEFAULT_SEQUENCE_KIND).getValue(), this.dbClient.getDialect(), new AtomicReference<OperationFuture<Void, UpdateDatabaseDdlMetadata>>());
                    }
                    this.state = UnitOfWork.UnitOfWorkState.COMMITTED;
                    return null;
                }
                catch (Throwable t) {
                    this.state = UnitOfWork.UnitOfWorkState.COMMIT_FAILED;
                    throw t;
                }
            };
            ApiFuture<Void> apiFuture = this.executeStatementAsync(callType, ddl, callable, DatabaseAdminGrpc.getUpdateDatabaseDdlMethod());
            return apiFuture;
        }
    }

    private void executeCreateDatabase(AbstractStatementParser.ParsedStatement ddl) {
        OperationFuture<Database, CreateDatabaseMetadata> operation = this.ddlClient.executeCreateDatabase(ddl.getSqlWithoutComments(), this.dbClient.getDialect());
        this.getWithStatementTimeout(operation, ddl);
    }

    @Override
    public ApiFuture<Long> executeUpdateAsync(UnitOfWork.CallType callType, AbstractStatementParser.ParsedStatement update, Options.UpdateOption ... options) {
        Preconditions.checkNotNull((Object)update);
        Preconditions.checkArgument((boolean)update.isUpdate(), (Object)"Statement is not an update statement");
        ConnectionPreconditions.checkState(!this.isReadOnly(), "Update statements are not allowed in read-only mode");
        try (Scope ignore = this.span.makeCurrent();){
            ApiFuture res;
            this.checkAndMarkUsed();
            switch (this.getAutocommitDmlMode()) {
                case TRANSACTIONAL: 
                case TRANSACTIONAL_WITH_FALLBACK_TO_PARTITIONED_NON_ATOMIC: {
                    res = ApiFutures.transform(this.executeTransactionalUpdateAsync(callType, update, AnalyzeMode.NONE, options), Tuple::x, (Executor)MoreExecutors.directExecutor());
                    break;
                }
                case PARTITIONED_NON_ATOMIC: {
                    res = this.executePartitionedUpdateAsync(callType, update, options);
                    break;
                }
                default: {
                    throw SpannerExceptionFactory.newSpannerException(ErrorCode.FAILED_PRECONDITION, "Unknown dml mode: " + (Object)((Object)this.getAutocommitDmlMode()));
                }
            }
            ApiFuture apiFuture = res;
            return apiFuture;
        }
    }

    @Override
    public ApiFuture<ResultSet> analyzeUpdateAsync(UnitOfWork.CallType callType, AbstractStatementParser.ParsedStatement update, AnalyzeMode analyzeMode, Options.UpdateOption ... options) {
        Preconditions.checkNotNull((Object)update);
        Preconditions.checkArgument((boolean)update.isUpdate(), (Object)"Statement is not an update statement");
        ConnectionPreconditions.checkState(!this.isReadOnly(), "Update statements are not allowed in read-only mode");
        ConnectionPreconditions.checkState(this.getAutocommitDmlMode() != AutocommitDmlMode.PARTITIONED_NON_ATOMIC, "Analyzing update statements is not supported for Partitioned DML");
        try (Scope ignore = this.span.makeCurrent();){
            this.checkAndMarkUsed();
            ApiFuture apiFuture = ApiFutures.transform(this.executeTransactionalUpdateAsync(callType, update, analyzeMode, options), Tuple::y, (Executor)MoreExecutors.directExecutor());
            return apiFuture;
        }
    }

    @Override
    public ApiFuture<long[]> executeBatchUpdateAsync(UnitOfWork.CallType callType, Iterable<AbstractStatementParser.ParsedStatement> updates, Options.UpdateOption ... options) {
        Preconditions.checkNotNull(updates);
        for (AbstractStatementParser.ParsedStatement update : updates) {
            Preconditions.checkArgument((boolean)update.isUpdate(), (Object)("Statement is not an update statement: " + update.getSqlWithoutComments()));
        }
        ConnectionPreconditions.checkState(!this.isReadOnly(), "Batch update statements are not allowed in read-only mode");
        try (Scope ignore = this.span.makeCurrent();){
            this.checkAndMarkUsed();
            switch (this.getAutocommitDmlMode()) {
                case TRANSACTIONAL: {
                    ApiFuture<long[]> apiFuture = this.executeTransactionalBatchUpdateAsync(callType, updates, options);
                    return apiFuture;
                }
                case PARTITIONED_NON_ATOMIC: {
                    throw SpannerExceptionFactory.newSpannerException(ErrorCode.FAILED_PRECONDITION, "Batch updates are not allowed in " + (Object)((Object)this.getAutocommitDmlMode()));
                }
            }
            throw SpannerExceptionFactory.newSpannerException(ErrorCode.FAILED_PRECONDITION, "Unknown dml mode: " + (Object)((Object)this.getAutocommitDmlMode()));
        }
    }

    private TransactionRunner createWriteTransaction() {
        int numOptions = 0;
        if (this.rpcPriority != null) {
            ++numOptions;
        }
        if (this.connectionState.getValue(ConnectionProperties.RETURN_COMMIT_STATS).getValue().booleanValue()) {
            ++numOptions;
        }
        if (this.excludeTxnFromChangeStreams) {
            ++numOptions;
        }
        if (this.connectionState.getValue(ConnectionProperties.MAX_COMMIT_DELAY).getValue() != null) {
            ++numOptions;
        }
        if (numOptions == 0) {
            return this.dbClient.readWriteTransaction(new Options.TransactionOption[0]);
        }
        Options.TransactionOption[] options = new Options.TransactionOption[numOptions];
        int index = 0;
        if (this.rpcPriority != null) {
            options[index++] = Options.priority(this.rpcPriority);
        }
        if (this.connectionState.getValue(ConnectionProperties.RETURN_COMMIT_STATS).getValue().booleanValue()) {
            options[index++] = Options.commitStats();
        }
        if (this.excludeTxnFromChangeStreams) {
            options[index++] = Options.excludeTxnFromChangeStreams();
        }
        if (this.connectionState.getValue(ConnectionProperties.MAX_COMMIT_DELAY).getValue() != null) {
            options[index++] = Options.maxCommitDelay(this.connectionState.getValue(ConnectionProperties.MAX_COMMIT_DELAY).getValue());
        }
        return this.dbClient.readWriteTransaction(options);
    }

    private ApiFuture<Tuple<Long, ResultSet>> executeTransactionalUpdateAsync(UnitOfWork.CallType callType, AbstractStatementParser.ParsedStatement update, AnalyzeMode analyzeMode, Options.UpdateOption ... options) {
        Callable<Tuple> callable = () -> {
            try {
                this.writeTransaction = this.createWriteTransaction();
                Tuple res = this.writeTransaction.run(transaction -> {
                    if (analyzeMode == AnalyzeMode.NONE) {
                        return Tuple.of((Object)transaction.executeUpdate(update.getStatement(), SingleUseTransaction.appendLastStatement(options)), null);
                    }
                    ResultSet resultSet = transaction.analyzeUpdateStatement(update.getStatement(), analyzeMode.getQueryAnalyzeMode(), SingleUseTransaction.appendLastStatement(options));
                    return Tuple.of(null, (Object)resultSet);
                });
                this.state = UnitOfWork.UnitOfWorkState.COMMITTED;
                return res;
            }
            catch (Throwable t) {
                this.state = UnitOfWork.UnitOfWorkState.COMMIT_FAILED;
                throw t;
            }
        };
        ApiFuture<Tuple> transactionalResult = this.executeStatementAsync(callType, update, callable, (Collection<MethodDescriptor<?, ?>>)ImmutableList.of((Object)SpannerGrpc.getExecuteSqlMethod(), (Object)SpannerGrpc.getCommitMethod()));
        if (this.isRetryDmlAsPartitionedDml()) {
            return this.addRetryUpdateAsPartitionedDmlCallback(transactionalResult, callType, update, options);
        }
        return transactionalResult;
    }

    private static Options.UpdateOption[] appendLastStatement(Options.UpdateOption[] options) {
        if (options.length == 0) {
            return LAST_STATEMENT_OPTIONS;
        }
        Options.UpdateOption[] result = new Options.UpdateOption[options.length + 1];
        System.arraycopy(options, 0, result, 0, options.length);
        result[result.length - 1] = LAST_STATEMENT_OPTIONS[0];
        return result;
    }

    private static Options.QueryOption[] appendLastStatement(Options.QueryOption[] options) {
        if (options.length == 0) {
            return LAST_STATEMENT_OPTIONS;
        }
        Options.QueryOption[] result = new Options.QueryOption[options.length + 1];
        System.arraycopy(options, 0, result, 0, options.length);
        result[result.length - 1] = LAST_STATEMENT_OPTIONS[0];
        return result;
    }

    private ApiFuture<Tuple<Long, ResultSet>> addRetryUpdateAsPartitionedDmlCallback(ApiFuture<Tuple<Long, ResultSet>> transactionalResult, UnitOfWork.CallType callType, final AbstractStatementParser.ParsedStatement update, Options.UpdateOption ... options) {
        return ApiFutures.catchingAsync(transactionalResult, TransactionMutationLimitExceededException.class, mutationLimitExceededException -> {
            final UUID executionId = UUID.randomUUID();
            for (TransactionRetryListener listener : this.transactionRetryListeners) {
                listener.retryDmlAsPartitionedDmlStarting(executionId, update.getStatement(), (TransactionMutationLimitExceededException)((Object)mutationLimitExceededException));
            }
            ApiFuture partitionedResult = ApiFutures.transform(this.executePartitionedUpdateAsync(callType, update, options), lowerBoundUpdateCount -> Tuple.of((Object)lowerBoundUpdateCount, null), (Executor)MoreExecutors.directExecutor());
            ApiFutures.addCallback((ApiFuture)partitionedResult, (ApiFutureCallback)new ApiFutureCallback<Tuple<Long, ResultSet>>(){

                public void onFailure(Throwable throwable) {
                    for (TransactionRetryListener listener : SingleUseTransaction.this.transactionRetryListeners) {
                        listener.retryDmlAsPartitionedDmlFailed(executionId, update.getStatement(), throwable);
                    }
                }

                public void onSuccess(Tuple<Long, ResultSet> result) {
                    for (TransactionRetryListener listener : SingleUseTransaction.this.transactionRetryListeners) {
                        listener.retryDmlAsPartitionedDmlFinished(executionId, update.getStatement(), (Long)result.x());
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
            return ApiFutures.catching((ApiFuture)partitionedResult, Throwable.class, input -> {
                mutationLimitExceededException.addSuppressed((Throwable)input);
                throw mutationLimitExceededException;
            }, (Executor)MoreExecutors.directExecutor());
        }, (Executor)MoreExecutors.directExecutor());
    }

    private ApiFuture<ResultSet> analyzeTransactionalUpdateAsync(UnitOfWork.CallType callType, AbstractStatementParser.ParsedStatement update, AnalyzeMode analyzeMode) {
        Callable<ResultSet> callable = () -> {
            try {
                this.writeTransaction = this.createWriteTransaction();
                ResultSet resultSet = this.writeTransaction.run(transaction -> DirectExecuteResultSet.ofResultSet(transaction.analyzeQuery(update.getStatement(), analyzeMode.getQueryAnalyzeMode())));
                this.state = UnitOfWork.UnitOfWorkState.COMMITTED;
                return resultSet;
            }
            catch (Throwable t) {
                this.state = UnitOfWork.UnitOfWorkState.COMMIT_FAILED;
                throw t;
            }
        };
        return this.executeStatementAsync(callType, update, callable, (Collection<MethodDescriptor<?, ?>>)ImmutableList.of((Object)SpannerGrpc.getExecuteSqlMethod(), (Object)SpannerGrpc.getCommitMethod()));
    }

    private ApiFuture<Long> executePartitionedUpdateAsync(UnitOfWork.CallType callType, AbstractStatementParser.ParsedStatement update, Options.UpdateOption ... options) {
        Options.UpdateOption[] effectiveOptions;
        if (this.excludeTxnFromChangeStreams) {
            if (options.length == 0) {
                effectiveOptions = new Options.UpdateOption[]{Options.excludeTxnFromChangeStreams()};
            } else {
                effectiveOptions = Arrays.copyOf(options, options.length + 1);
                effectiveOptions[effectiveOptions.length - 1] = Options.excludeTxnFromChangeStreams();
            }
        } else {
            effectiveOptions = options;
        }
        Callable<Long> callable = () -> {
            try {
                Long res = this.dbClient.executePartitionedUpdate(update.getStatement(), effectiveOptions);
                this.state = UnitOfWork.UnitOfWorkState.COMMITTED;
                return res;
            }
            catch (Throwable t) {
                this.state = UnitOfWork.UnitOfWorkState.COMMIT_FAILED;
                throw t;
            }
        };
        return this.executeStatementAsync(callType, update, callable, SpannerGrpc.getExecuteStreamingSqlMethod());
    }

    private ApiFuture<long[]> executeTransactionalBatchUpdateAsync(UnitOfWork.CallType callType, Iterable<AbstractStatementParser.ParsedStatement> updates, Options.UpdateOption ... options) {
        Callable<long[]> callable = () -> {
            this.writeTransaction = this.createWriteTransaction();
            return this.writeTransaction.run(transaction -> {
                try {
                    long[] res = transaction.batchUpdate(Iterables.transform((Iterable)updates, AbstractStatementParser.ParsedStatement::getStatement), SingleUseTransaction.appendLastStatement(options));
                    this.state = UnitOfWork.UnitOfWorkState.COMMITTED;
                    return res;
                }
                catch (Throwable t) {
                    this.state = t instanceof SpannerBatchUpdateException ? UnitOfWork.UnitOfWorkState.COMMITTED : UnitOfWork.UnitOfWorkState.COMMIT_FAILED;
                    throw t;
                }
            });
        };
        return this.executeStatementAsync(callType, AbstractStatementParser.RUN_BATCH_STATEMENT, callable, SpannerGrpc.getExecuteBatchDmlMethod());
    }

    @Override
    public ApiFuture<Void> writeAsync(UnitOfWork.CallType callType, Iterable<Mutation> mutations) {
        Preconditions.checkNotNull(mutations);
        ConnectionPreconditions.checkState(!this.isReadOnly(), "Update statements are not allowed in read-only mode");
        try (Scope ignore = this.span.makeCurrent();){
            this.checkAndMarkUsed();
            Callable<Void> callable = () -> {
                try {
                    this.writeTransaction = this.createWriteTransaction();
                    Void res = this.writeTransaction.run(transaction -> {
                        transaction.buffer(mutations);
                        return null;
                    });
                    this.state = UnitOfWork.UnitOfWorkState.COMMITTED;
                    return res;
                }
                catch (Throwable t) {
                    this.state = UnitOfWork.UnitOfWorkState.COMMIT_FAILED;
                    throw t;
                }
            };
            ApiFuture<Void> apiFuture = this.executeStatementAsync(callType, AbstractStatementParser.COMMIT_STATEMENT, callable, SpannerGrpc.getCommitMethod());
            return apiFuture;
        }
    }

    @Override
    public ApiFuture<Void> commitAsync(@Nonnull UnitOfWork.CallType callType, @Nonnull UnitOfWork.EndTransactionCallback callback) {
        throw SpannerExceptionFactory.newSpannerException(ErrorCode.FAILED_PRECONDITION, "Commit is not supported for single-use transactions");
    }

    @Override
    public ApiFuture<Void> rollbackAsync(@Nonnull UnitOfWork.CallType callType, @Nonnull UnitOfWork.EndTransactionCallback callback) {
        throw SpannerExceptionFactory.newSpannerException(ErrorCode.FAILED_PRECONDITION, "Rollback is not supported for single-use transactions");
    }

    @Override
    String getUnitOfWorkName() {
        return "single-use transaction";
    }

    @Override
    public ApiFuture<long[]> runBatchAsync(UnitOfWork.CallType callType) {
        throw SpannerExceptionFactory.newSpannerException(ErrorCode.FAILED_PRECONDITION, "Run batch is not supported for single-use transactions");
    }

    @Override
    public void abortBatch() {
        throw SpannerExceptionFactory.newSpannerException(ErrorCode.FAILED_PRECONDITION, "Run batch is not supported for single-use transactions");
    }

    static class Builder
    extends AbstractBaseUnitOfWork.Builder<Builder, SingleUseTransaction> {
        private DdlClient ddlClient;
        private DatabaseClient dbClient;
        private BatchClient batchClient;
        private ConnectionState connectionState;
        private boolean internalMetadataQuery;
        private byte[] protoDescriptors;

        private Builder() {
        }

        Builder setDdlClient(DdlClient ddlClient) {
            Preconditions.checkNotNull((Object)ddlClient);
            this.ddlClient = ddlClient;
            return this;
        }

        Builder setDatabaseClient(DatabaseClient client) {
            Preconditions.checkNotNull((Object)client);
            this.dbClient = client;
            return this;
        }

        Builder setBatchClient(BatchClient batchClient) {
            this.batchClient = (BatchClient)Preconditions.checkNotNull((Object)batchClient);
            return this;
        }

        Builder setConnectionState(ConnectionState connectionState) {
            this.connectionState = connectionState;
            return this;
        }

        Builder setInternalMetadataQuery(boolean internalMetadataQuery) {
            this.internalMetadataQuery = internalMetadataQuery;
            return this;
        }

        Builder setProtoDescriptors(byte[] protoDescriptors) {
            this.protoDescriptors = protoDescriptors;
            return this;
        }

        @Override
        SingleUseTransaction build() {
            Preconditions.checkState((this.ddlClient != null ? 1 : 0) != 0, (Object)"No DDL client specified");
            Preconditions.checkState((this.dbClient != null ? 1 : 0) != 0, (Object)"No DatabaseClient client specified");
            Preconditions.checkState((this.batchClient != null ? 1 : 0) != 0, (Object)"No BatchClient client specified");
            return new SingleUseTransaction(this);
        }
    }
}

