/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.cloud.spanner.AbortedException;
import com.google.cloud.spanner.SpannerApiFutures;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.connection.Connection;
import com.google.cloud.spanner.connection.ConnectionImpl;
import com.google.cloud.spanner.connection.UnitOfWork;

class TransactionRunnerImpl {
    private final ConnectionImpl connection;

    TransactionRunnerImpl(ConnectionImpl connection) {
        this.connection = connection;
    }

    <T> T run(Connection.TransactionCallable<T> callable) {
        this.connection.beginTransaction();
        this.connection.setRetryAbortsInternally(false, true);
        UnitOfWork transaction = this.connection.getCurrentUnitOfWorkOrStartNewUnitOfWork();
        while (true) {
            try {
                T result = callable.run(this.connection);
                SpannerApiFutures.get(this.connection.commitAsync(UnitOfWork.CallType.SYNC, ConnectionImpl.Caller.TRANSACTION_RUNNER));
                return result;
            }
            catch (AbortedException abortedException) {
                try {
                    Thread.sleep(abortedException.getRetryDelayInMillis());
                    this.connection.resetForRetry(transaction);
                }
                catch (InterruptedException interruptedException) {
                    throw SpannerExceptionFactory.propagateInterrupt(interruptedException);
                }
                catch (Throwable t) {
                    throw t;
                }
            }
        }
        finally {
            this.connection.rollbackAsync(UnitOfWork.CallType.SYNC, ConnectionImpl.Caller.TRANSACTION_RUNNER);
        }
    }
}

