/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.speech.v1p1beta1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.speech.v1p1beta1.AdaptationSettings;
import com.google.cloud.speech.v1p1beta1.CreateCustomClassRequest;
import com.google.cloud.speech.v1p1beta1.CreatePhraseSetRequest;
import com.google.cloud.speech.v1p1beta1.CustomClass;
import com.google.cloud.speech.v1p1beta1.CustomClassName;
import com.google.cloud.speech.v1p1beta1.DeleteCustomClassRequest;
import com.google.cloud.speech.v1p1beta1.DeletePhraseSetRequest;
import com.google.cloud.speech.v1p1beta1.GetCustomClassRequest;
import com.google.cloud.speech.v1p1beta1.GetPhraseSetRequest;
import com.google.cloud.speech.v1p1beta1.ListCustomClassesRequest;
import com.google.cloud.speech.v1p1beta1.ListCustomClassesResponse;
import com.google.cloud.speech.v1p1beta1.ListPhraseSetRequest;
import com.google.cloud.speech.v1p1beta1.ListPhraseSetResponse;
import com.google.cloud.speech.v1p1beta1.LocationName;
import com.google.cloud.speech.v1p1beta1.PhraseSet;
import com.google.cloud.speech.v1p1beta1.PhraseSetName;
import com.google.cloud.speech.v1p1beta1.UpdateCustomClassRequest;
import com.google.cloud.speech.v1p1beta1.UpdatePhraseSetRequest;
import com.google.cloud.speech.v1p1beta1.stub.AdaptationStub;
import com.google.cloud.speech.v1p1beta1.stub.AdaptationStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class AdaptationClient
implements BackgroundResource {
    private final AdaptationSettings settings;
    private final AdaptationStub stub;

    public static final AdaptationClient create() throws IOException {
        return AdaptationClient.create(AdaptationSettings.newBuilder().build());
    }

    public static final AdaptationClient create(AdaptationSettings settings) throws IOException {
        return new AdaptationClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final AdaptationClient create(AdaptationStub stub) {
        return new AdaptationClient(stub);
    }

    protected AdaptationClient(AdaptationSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((AdaptationStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected AdaptationClient(AdaptationStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final AdaptationSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public AdaptationStub getStub() {
        return this.stub;
    }

    public final PhraseSet createPhraseSet(LocationName parent, PhraseSet phraseSet, String phraseSetId) {
        CreatePhraseSetRequest request = CreatePhraseSetRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setPhraseSet(phraseSet).setPhraseSetId(phraseSetId).build();
        return this.createPhraseSet(request);
    }

    public final PhraseSet createPhraseSet(String parent, PhraseSet phraseSet, String phraseSetId) {
        CreatePhraseSetRequest request = CreatePhraseSetRequest.newBuilder().setParent(parent).setPhraseSet(phraseSet).setPhraseSetId(phraseSetId).build();
        return this.createPhraseSet(request);
    }

    public final PhraseSet createPhraseSet(CreatePhraseSetRequest request) {
        return (PhraseSet)this.createPhraseSetCallable().call((Object)request);
    }

    public final UnaryCallable<CreatePhraseSetRequest, PhraseSet> createPhraseSetCallable() {
        return this.stub.createPhraseSetCallable();
    }

    public final PhraseSet getPhraseSet(PhraseSetName name) {
        GetPhraseSetRequest request = GetPhraseSetRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getPhraseSet(request);
    }

    public final PhraseSet getPhraseSet(String name) {
        GetPhraseSetRequest request = GetPhraseSetRequest.newBuilder().setName(name).build();
        return this.getPhraseSet(request);
    }

    public final PhraseSet getPhraseSet(GetPhraseSetRequest request) {
        return (PhraseSet)this.getPhraseSetCallable().call((Object)request);
    }

    public final UnaryCallable<GetPhraseSetRequest, PhraseSet> getPhraseSetCallable() {
        return this.stub.getPhraseSetCallable();
    }

    public final ListPhraseSetPagedResponse listPhraseSet(LocationName parent) {
        ListPhraseSetRequest request = ListPhraseSetRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listPhraseSet(request);
    }

    public final ListPhraseSetPagedResponse listPhraseSet(String parent) {
        ListPhraseSetRequest request = ListPhraseSetRequest.newBuilder().setParent(parent).build();
        return this.listPhraseSet(request);
    }

    public final ListPhraseSetPagedResponse listPhraseSet(ListPhraseSetRequest request) {
        return (ListPhraseSetPagedResponse)((Object)this.listPhraseSetPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListPhraseSetRequest, ListPhraseSetPagedResponse> listPhraseSetPagedCallable() {
        return this.stub.listPhraseSetPagedCallable();
    }

    public final UnaryCallable<ListPhraseSetRequest, ListPhraseSetResponse> listPhraseSetCallable() {
        return this.stub.listPhraseSetCallable();
    }

    public final PhraseSet updatePhraseSet(PhraseSet phraseSet, FieldMask updateMask) {
        UpdatePhraseSetRequest request = UpdatePhraseSetRequest.newBuilder().setPhraseSet(phraseSet).setUpdateMask(updateMask).build();
        return this.updatePhraseSet(request);
    }

    public final PhraseSet updatePhraseSet(UpdatePhraseSetRequest request) {
        return (PhraseSet)this.updatePhraseSetCallable().call((Object)request);
    }

    public final UnaryCallable<UpdatePhraseSetRequest, PhraseSet> updatePhraseSetCallable() {
        return this.stub.updatePhraseSetCallable();
    }

    public final void deletePhraseSet(PhraseSetName name) {
        DeletePhraseSetRequest request = DeletePhraseSetRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deletePhraseSet(request);
    }

    public final void deletePhraseSet(String name) {
        DeletePhraseSetRequest request = DeletePhraseSetRequest.newBuilder().setName(name).build();
        this.deletePhraseSet(request);
    }

    public final void deletePhraseSet(DeletePhraseSetRequest request) {
        this.deletePhraseSetCallable().call((Object)request);
    }

    public final UnaryCallable<DeletePhraseSetRequest, Empty> deletePhraseSetCallable() {
        return this.stub.deletePhraseSetCallable();
    }

    public final CustomClass createCustomClass(LocationName parent, CustomClass customClass, String customClassId) {
        CreateCustomClassRequest request = CreateCustomClassRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setCustomClass(customClass).setCustomClassId(customClassId).build();
        return this.createCustomClass(request);
    }

    public final CustomClass createCustomClass(String parent, CustomClass customClass, String customClassId) {
        CreateCustomClassRequest request = CreateCustomClassRequest.newBuilder().setParent(parent).setCustomClass(customClass).setCustomClassId(customClassId).build();
        return this.createCustomClass(request);
    }

    public final CustomClass createCustomClass(CreateCustomClassRequest request) {
        return (CustomClass)this.createCustomClassCallable().call((Object)request);
    }

    public final UnaryCallable<CreateCustomClassRequest, CustomClass> createCustomClassCallable() {
        return this.stub.createCustomClassCallable();
    }

    public final CustomClass getCustomClass(CustomClassName name) {
        GetCustomClassRequest request = GetCustomClassRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getCustomClass(request);
    }

    public final CustomClass getCustomClass(String name) {
        GetCustomClassRequest request = GetCustomClassRequest.newBuilder().setName(name).build();
        return this.getCustomClass(request);
    }

    public final CustomClass getCustomClass(GetCustomClassRequest request) {
        return (CustomClass)this.getCustomClassCallable().call((Object)request);
    }

    public final UnaryCallable<GetCustomClassRequest, CustomClass> getCustomClassCallable() {
        return this.stub.getCustomClassCallable();
    }

    public final ListCustomClassesPagedResponse listCustomClasses(LocationName parent) {
        ListCustomClassesRequest request = ListCustomClassesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listCustomClasses(request);
    }

    public final ListCustomClassesPagedResponse listCustomClasses(String parent) {
        ListCustomClassesRequest request = ListCustomClassesRequest.newBuilder().setParent(parent).build();
        return this.listCustomClasses(request);
    }

    public final ListCustomClassesPagedResponse listCustomClasses(ListCustomClassesRequest request) {
        return (ListCustomClassesPagedResponse)((Object)this.listCustomClassesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListCustomClassesRequest, ListCustomClassesPagedResponse> listCustomClassesPagedCallable() {
        return this.stub.listCustomClassesPagedCallable();
    }

    public final UnaryCallable<ListCustomClassesRequest, ListCustomClassesResponse> listCustomClassesCallable() {
        return this.stub.listCustomClassesCallable();
    }

    public final CustomClass updateCustomClass(CustomClass customClass, FieldMask updateMask) {
        UpdateCustomClassRequest request = UpdateCustomClassRequest.newBuilder().setCustomClass(customClass).setUpdateMask(updateMask).build();
        return this.updateCustomClass(request);
    }

    public final CustomClass updateCustomClass(UpdateCustomClassRequest request) {
        return (CustomClass)this.updateCustomClassCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateCustomClassRequest, CustomClass> updateCustomClassCallable() {
        return this.stub.updateCustomClassCallable();
    }

    public final void deleteCustomClass(CustomClassName name) {
        DeleteCustomClassRequest request = DeleteCustomClassRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteCustomClass(request);
    }

    public final void deleteCustomClass(String name) {
        DeleteCustomClassRequest request = DeleteCustomClassRequest.newBuilder().setName(name).build();
        this.deleteCustomClass(request);
    }

    public final void deleteCustomClass(DeleteCustomClassRequest request) {
        this.deleteCustomClassCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteCustomClassRequest, Empty> deleteCustomClassCallable() {
        return this.stub.deleteCustomClassCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListCustomClassesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListCustomClassesRequest, ListCustomClassesResponse, CustomClass, ListCustomClassesPage, ListCustomClassesFixedSizeCollection> {
        private ListCustomClassesFixedSizeCollection(List<ListCustomClassesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListCustomClassesFixedSizeCollection createEmptyCollection() {
            return new ListCustomClassesFixedSizeCollection(null, 0);
        }

        protected ListCustomClassesFixedSizeCollection createCollection(List<ListCustomClassesPage> pages, int collectionSize) {
            return new ListCustomClassesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListCustomClassesPage
    extends AbstractPage<ListCustomClassesRequest, ListCustomClassesResponse, CustomClass, ListCustomClassesPage> {
        private ListCustomClassesPage(PageContext<ListCustomClassesRequest, ListCustomClassesResponse, CustomClass> context, ListCustomClassesResponse response) {
            super(context, (Object)response);
        }

        private static ListCustomClassesPage createEmptyPage() {
            return new ListCustomClassesPage(null, null);
        }

        protected ListCustomClassesPage createPage(PageContext<ListCustomClassesRequest, ListCustomClassesResponse, CustomClass> context, ListCustomClassesResponse response) {
            return new ListCustomClassesPage(context, response);
        }

        public ApiFuture<ListCustomClassesPage> createPageAsync(PageContext<ListCustomClassesRequest, ListCustomClassesResponse, CustomClass> context, ApiFuture<ListCustomClassesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListCustomClassesPagedResponse
    extends AbstractPagedListResponse<ListCustomClassesRequest, ListCustomClassesResponse, CustomClass, ListCustomClassesPage, ListCustomClassesFixedSizeCollection> {
        public static ApiFuture<ListCustomClassesPagedResponse> createAsync(PageContext<ListCustomClassesRequest, ListCustomClassesResponse, CustomClass> context, ApiFuture<ListCustomClassesResponse> futureResponse) {
            ApiFuture<ListCustomClassesPage> futurePage = ListCustomClassesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListCustomClassesPagedResponse((ListCustomClassesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListCustomClassesPagedResponse(ListCustomClassesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListCustomClassesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListPhraseSetFixedSizeCollection
    extends AbstractFixedSizeCollection<ListPhraseSetRequest, ListPhraseSetResponse, PhraseSet, ListPhraseSetPage, ListPhraseSetFixedSizeCollection> {
        private ListPhraseSetFixedSizeCollection(List<ListPhraseSetPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListPhraseSetFixedSizeCollection createEmptyCollection() {
            return new ListPhraseSetFixedSizeCollection(null, 0);
        }

        protected ListPhraseSetFixedSizeCollection createCollection(List<ListPhraseSetPage> pages, int collectionSize) {
            return new ListPhraseSetFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPhraseSetPage
    extends AbstractPage<ListPhraseSetRequest, ListPhraseSetResponse, PhraseSet, ListPhraseSetPage> {
        private ListPhraseSetPage(PageContext<ListPhraseSetRequest, ListPhraseSetResponse, PhraseSet> context, ListPhraseSetResponse response) {
            super(context, (Object)response);
        }

        private static ListPhraseSetPage createEmptyPage() {
            return new ListPhraseSetPage(null, null);
        }

        protected ListPhraseSetPage createPage(PageContext<ListPhraseSetRequest, ListPhraseSetResponse, PhraseSet> context, ListPhraseSetResponse response) {
            return new ListPhraseSetPage(context, response);
        }

        public ApiFuture<ListPhraseSetPage> createPageAsync(PageContext<ListPhraseSetRequest, ListPhraseSetResponse, PhraseSet> context, ApiFuture<ListPhraseSetResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPhraseSetPagedResponse
    extends AbstractPagedListResponse<ListPhraseSetRequest, ListPhraseSetResponse, PhraseSet, ListPhraseSetPage, ListPhraseSetFixedSizeCollection> {
        public static ApiFuture<ListPhraseSetPagedResponse> createAsync(PageContext<ListPhraseSetRequest, ListPhraseSetResponse, PhraseSet> context, ApiFuture<ListPhraseSetResponse> futureResponse) {
            ApiFuture<ListPhraseSetPage> futurePage = ListPhraseSetPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPhraseSetPagedResponse((ListPhraseSetPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPhraseSetPagedResponse(ListPhraseSetPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListPhraseSetFixedSizeCollection.createEmptyCollection());
        }
    }
}

