/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.speech.v1p1beta1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.speech.v1p1beta1.AdaptationClient;
import com.google.cloud.speech.v1p1beta1.CreateCustomClassRequest;
import com.google.cloud.speech.v1p1beta1.CreatePhraseSetRequest;
import com.google.cloud.speech.v1p1beta1.CustomClass;
import com.google.cloud.speech.v1p1beta1.DeleteCustomClassRequest;
import com.google.cloud.speech.v1p1beta1.DeletePhraseSetRequest;
import com.google.cloud.speech.v1p1beta1.GetCustomClassRequest;
import com.google.cloud.speech.v1p1beta1.GetPhraseSetRequest;
import com.google.cloud.speech.v1p1beta1.ListCustomClassesRequest;
import com.google.cloud.speech.v1p1beta1.ListCustomClassesResponse;
import com.google.cloud.speech.v1p1beta1.ListPhraseSetRequest;
import com.google.cloud.speech.v1p1beta1.ListPhraseSetResponse;
import com.google.cloud.speech.v1p1beta1.PhraseSet;
import com.google.cloud.speech.v1p1beta1.UpdateCustomClassRequest;
import com.google.cloud.speech.v1p1beta1.UpdatePhraseSetRequest;
import com.google.cloud.speech.v1p1beta1.stub.AdaptationStub;
import com.google.cloud.speech.v1p1beta1.stub.GrpcAdaptationStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;

@BetaApi
public class AdaptationStubSettings
extends StubSettings<AdaptationStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<CreatePhraseSetRequest, PhraseSet> createPhraseSetSettings;
    private final UnaryCallSettings<GetPhraseSetRequest, PhraseSet> getPhraseSetSettings;
    private final PagedCallSettings<ListPhraseSetRequest, ListPhraseSetResponse, AdaptationClient.ListPhraseSetPagedResponse> listPhraseSetSettings;
    private final UnaryCallSettings<UpdatePhraseSetRequest, PhraseSet> updatePhraseSetSettings;
    private final UnaryCallSettings<DeletePhraseSetRequest, Empty> deletePhraseSetSettings;
    private final UnaryCallSettings<CreateCustomClassRequest, CustomClass> createCustomClassSettings;
    private final UnaryCallSettings<GetCustomClassRequest, CustomClass> getCustomClassSettings;
    private final PagedCallSettings<ListCustomClassesRequest, ListCustomClassesResponse, AdaptationClient.ListCustomClassesPagedResponse> listCustomClassesSettings;
    private final UnaryCallSettings<UpdateCustomClassRequest, CustomClass> updateCustomClassSettings;
    private final UnaryCallSettings<DeleteCustomClassRequest, Empty> deleteCustomClassSettings;
    private static final PagedListDescriptor<ListPhraseSetRequest, ListPhraseSetResponse, PhraseSet> LIST_PHRASE_SET_PAGE_STR_DESC = new PagedListDescriptor<ListPhraseSetRequest, ListPhraseSetResponse, PhraseSet>(){

        public String emptyToken() {
            return "";
        }

        public ListPhraseSetRequest injectToken(ListPhraseSetRequest payload, String token) {
            return ListPhraseSetRequest.newBuilder((ListPhraseSetRequest)payload).setPageToken(token).build();
        }

        public ListPhraseSetRequest injectPageSize(ListPhraseSetRequest payload, int pageSize) {
            return ListPhraseSetRequest.newBuilder((ListPhraseSetRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListPhraseSetRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListPhraseSetResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<PhraseSet> extractResources(ListPhraseSetResponse payload) {
            return payload.getPhraseSetsList() == null ? ImmutableList.of() : payload.getPhraseSetsList();
        }
    };
    private static final PagedListDescriptor<ListCustomClassesRequest, ListCustomClassesResponse, CustomClass> LIST_CUSTOM_CLASSES_PAGE_STR_DESC = new PagedListDescriptor<ListCustomClassesRequest, ListCustomClassesResponse, CustomClass>(){

        public String emptyToken() {
            return "";
        }

        public ListCustomClassesRequest injectToken(ListCustomClassesRequest payload, String token) {
            return ListCustomClassesRequest.newBuilder((ListCustomClassesRequest)payload).setPageToken(token).build();
        }

        public ListCustomClassesRequest injectPageSize(ListCustomClassesRequest payload, int pageSize) {
            return ListCustomClassesRequest.newBuilder((ListCustomClassesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListCustomClassesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListCustomClassesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<CustomClass> extractResources(ListCustomClassesResponse payload) {
            return payload.getCustomClassesList() == null ? ImmutableList.of() : payload.getCustomClassesList();
        }
    };
    private static final PagedListResponseFactory<ListPhraseSetRequest, ListPhraseSetResponse, AdaptationClient.ListPhraseSetPagedResponse> LIST_PHRASE_SET_PAGE_STR_FACT = new PagedListResponseFactory<ListPhraseSetRequest, ListPhraseSetResponse, AdaptationClient.ListPhraseSetPagedResponse>(){

        public ApiFuture<AdaptationClient.ListPhraseSetPagedResponse> getFuturePagedResponse(UnaryCallable<ListPhraseSetRequest, ListPhraseSetResponse> callable, ListPhraseSetRequest request, ApiCallContext context, ApiFuture<ListPhraseSetResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_PHRASE_SET_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return AdaptationClient.ListPhraseSetPagedResponse.createAsync((PageContext<ListPhraseSetRequest, ListPhraseSetResponse, PhraseSet>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListCustomClassesRequest, ListCustomClassesResponse, AdaptationClient.ListCustomClassesPagedResponse> LIST_CUSTOM_CLASSES_PAGE_STR_FACT = new PagedListResponseFactory<ListCustomClassesRequest, ListCustomClassesResponse, AdaptationClient.ListCustomClassesPagedResponse>(){

        public ApiFuture<AdaptationClient.ListCustomClassesPagedResponse> getFuturePagedResponse(UnaryCallable<ListCustomClassesRequest, ListCustomClassesResponse> callable, ListCustomClassesRequest request, ApiCallContext context, ApiFuture<ListCustomClassesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_CUSTOM_CLASSES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return AdaptationClient.ListCustomClassesPagedResponse.createAsync((PageContext<ListCustomClassesRequest, ListCustomClassesResponse, CustomClass>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreatePhraseSetRequest, PhraseSet> createPhraseSetSettings() {
        return this.createPhraseSetSettings;
    }

    public UnaryCallSettings<GetPhraseSetRequest, PhraseSet> getPhraseSetSettings() {
        return this.getPhraseSetSettings;
    }

    public PagedCallSettings<ListPhraseSetRequest, ListPhraseSetResponse, AdaptationClient.ListPhraseSetPagedResponse> listPhraseSetSettings() {
        return this.listPhraseSetSettings;
    }

    public UnaryCallSettings<UpdatePhraseSetRequest, PhraseSet> updatePhraseSetSettings() {
        return this.updatePhraseSetSettings;
    }

    public UnaryCallSettings<DeletePhraseSetRequest, Empty> deletePhraseSetSettings() {
        return this.deletePhraseSetSettings;
    }

    public UnaryCallSettings<CreateCustomClassRequest, CustomClass> createCustomClassSettings() {
        return this.createCustomClassSettings;
    }

    public UnaryCallSettings<GetCustomClassRequest, CustomClass> getCustomClassSettings() {
        return this.getCustomClassSettings;
    }

    public PagedCallSettings<ListCustomClassesRequest, ListCustomClassesResponse, AdaptationClient.ListCustomClassesPagedResponse> listCustomClassesSettings() {
        return this.listCustomClassesSettings;
    }

    public UnaryCallSettings<UpdateCustomClassRequest, CustomClass> updateCustomClassSettings() {
        return this.updateCustomClassSettings;
    }

    public UnaryCallSettings<DeleteCustomClassRequest, Empty> deleteCustomClassSettings() {
        return this.deleteCustomClassSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public AdaptationStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcAdaptationStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "speech.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "speech.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return AdaptationStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(AdaptationStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected AdaptationStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createPhraseSetSettings = settingsBuilder.createPhraseSetSettings().build();
        this.getPhraseSetSettings = settingsBuilder.getPhraseSetSettings().build();
        this.listPhraseSetSettings = settingsBuilder.listPhraseSetSettings().build();
        this.updatePhraseSetSettings = settingsBuilder.updatePhraseSetSettings().build();
        this.deletePhraseSetSettings = settingsBuilder.deletePhraseSetSettings().build();
        this.createCustomClassSettings = settingsBuilder.createCustomClassSettings().build();
        this.getCustomClassSettings = settingsBuilder.getCustomClassSettings().build();
        this.listCustomClassesSettings = settingsBuilder.listCustomClassesSettings().build();
        this.updateCustomClassSettings = settingsBuilder.updateCustomClassSettings().build();
        this.deleteCustomClassSettings = settingsBuilder.deleteCustomClassSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<AdaptationStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreatePhraseSetRequest, PhraseSet> createPhraseSetSettings;
        private final UnaryCallSettings.Builder<GetPhraseSetRequest, PhraseSet> getPhraseSetSettings;
        private final PagedCallSettings.Builder<ListPhraseSetRequest, ListPhraseSetResponse, AdaptationClient.ListPhraseSetPagedResponse> listPhraseSetSettings;
        private final UnaryCallSettings.Builder<UpdatePhraseSetRequest, PhraseSet> updatePhraseSetSettings;
        private final UnaryCallSettings.Builder<DeletePhraseSetRequest, Empty> deletePhraseSetSettings;
        private final UnaryCallSettings.Builder<CreateCustomClassRequest, CustomClass> createCustomClassSettings;
        private final UnaryCallSettings.Builder<GetCustomClassRequest, CustomClass> getCustomClassSettings;
        private final PagedCallSettings.Builder<ListCustomClassesRequest, ListCustomClassesResponse, AdaptationClient.ListCustomClassesPagedResponse> listCustomClassesSettings;
        private final UnaryCallSettings.Builder<UpdateCustomClassRequest, CustomClass> updateCustomClassSettings;
        private final UnaryCallSettings.Builder<DeleteCustomClassRequest, Empty> deleteCustomClassSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createPhraseSetSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getPhraseSetSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listPhraseSetSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_PHRASE_SET_PAGE_STR_FACT);
            this.updatePhraseSetSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deletePhraseSetSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createCustomClassSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getCustomClassSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listCustomClassesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_CUSTOM_CLASSES_PAGE_STR_FACT);
            this.updateCustomClassSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteCustomClassSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createPhraseSetSettings, this.getPhraseSetSettings, this.listPhraseSetSettings, this.updatePhraseSetSettings, this.deletePhraseSetSettings, this.createCustomClassSettings, this.getCustomClassSettings, this.listCustomClassesSettings, this.updateCustomClassSettings, this.deleteCustomClassSettings);
            Builder.initDefaults(this);
        }

        protected Builder(AdaptationStubSettings settings) {
            super((StubSettings)settings);
            this.createPhraseSetSettings = settings.createPhraseSetSettings.toBuilder();
            this.getPhraseSetSettings = settings.getPhraseSetSettings.toBuilder();
            this.listPhraseSetSettings = settings.listPhraseSetSettings.toBuilder();
            this.updatePhraseSetSettings = settings.updatePhraseSetSettings.toBuilder();
            this.deletePhraseSetSettings = settings.deletePhraseSetSettings.toBuilder();
            this.createCustomClassSettings = settings.createCustomClassSettings.toBuilder();
            this.getCustomClassSettings = settings.getCustomClassSettings.toBuilder();
            this.listCustomClassesSettings = settings.listCustomClassesSettings.toBuilder();
            this.updateCustomClassSettings = settings.updateCustomClassSettings.toBuilder();
            this.deleteCustomClassSettings = settings.deleteCustomClassSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createPhraseSetSettings, this.getPhraseSetSettings, this.listPhraseSetSettings, this.updatePhraseSetSettings, this.deletePhraseSetSettings, this.createCustomClassSettings, this.getCustomClassSettings, this.listCustomClassesSettings, this.updateCustomClassSettings, this.deleteCustomClassSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(AdaptationStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)AdaptationStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)AdaptationStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(AdaptationStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(AdaptationStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createPhraseSetSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getPhraseSetSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listPhraseSetSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.updatePhraseSetSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.deletePhraseSetSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createCustomClassSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getCustomClassSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listCustomClassesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.updateCustomClassSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.deleteCustomClassSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreatePhraseSetRequest, PhraseSet> createPhraseSetSettings() {
            return this.createPhraseSetSettings;
        }

        public UnaryCallSettings.Builder<GetPhraseSetRequest, PhraseSet> getPhraseSetSettings() {
            return this.getPhraseSetSettings;
        }

        public PagedCallSettings.Builder<ListPhraseSetRequest, ListPhraseSetResponse, AdaptationClient.ListPhraseSetPagedResponse> listPhraseSetSettings() {
            return this.listPhraseSetSettings;
        }

        public UnaryCallSettings.Builder<UpdatePhraseSetRequest, PhraseSet> updatePhraseSetSettings() {
            return this.updatePhraseSetSettings;
        }

        public UnaryCallSettings.Builder<DeletePhraseSetRequest, Empty> deletePhraseSetSettings() {
            return this.deletePhraseSetSettings;
        }

        public UnaryCallSettings.Builder<CreateCustomClassRequest, CustomClass> createCustomClassSettings() {
            return this.createCustomClassSettings;
        }

        public UnaryCallSettings.Builder<GetCustomClassRequest, CustomClass> getCustomClassSettings() {
            return this.getCustomClassSettings;
        }

        public PagedCallSettings.Builder<ListCustomClassesRequest, ListCustomClassesResponse, AdaptationClient.ListCustomClassesPagedResponse> listCustomClassesSettings() {
            return this.listCustomClassesSettings;
        }

        public UnaryCallSettings.Builder<UpdateCustomClassRequest, CustomClass> updateCustomClassSettings() {
            return this.updateCustomClassSettings;
        }

        public UnaryCallSettings.Builder<DeleteCustomClassRequest, Empty> deleteCustomClassSettings() {
            return this.deleteCustomClassSettings;
        }

        public AdaptationStubSettings build() throws IOException {
            return new AdaptationStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

