/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.speech.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.rpc.BidiStreamingCallable;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.speech.v1.LongRunningRecognizeMetadata;
import com.google.cloud.speech.v1.LongRunningRecognizeRequest;
import com.google.cloud.speech.v1.LongRunningRecognizeResponse;
import com.google.cloud.speech.v1.RecognitionAudio;
import com.google.cloud.speech.v1.RecognitionConfig;
import com.google.cloud.speech.v1.RecognizeRequest;
import com.google.cloud.speech.v1.RecognizeResponse;
import com.google.cloud.speech.v1.SpeechSettings;
import com.google.cloud.speech.v1.StreamingRecognizeRequest;
import com.google.cloud.speech.v1.StreamingRecognizeResponse;
import com.google.cloud.speech.v1.stub.SpeechStub;
import com.google.cloud.speech.v1.stub.SpeechStubSettings;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class SpeechClient
implements BackgroundResource {
    private final SpeechSettings settings;
    private final SpeechStub stub;
    private final com.google.api.gax.httpjson.longrunning.OperationsClient httpJsonOperationsClient;
    private final OperationsClient operationsClient;

    public static final SpeechClient create() throws IOException {
        return SpeechClient.create(SpeechSettings.newBuilder().build());
    }

    public static final SpeechClient create(SpeechSettings settings) throws IOException {
        return new SpeechClient(settings);
    }

    public static final SpeechClient create(SpeechStub stub) {
        return new SpeechClient(stub);
    }

    protected SpeechClient(SpeechSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((SpeechStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected SpeechClient(SpeechStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final SpeechSettings getSettings() {
        return this.settings;
    }

    public SpeechStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final com.google.api.gax.httpjson.longrunning.OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final RecognizeResponse recognize(RecognitionConfig config, RecognitionAudio audio) {
        RecognizeRequest request = RecognizeRequest.newBuilder().setConfig(config).setAudio(audio).build();
        return this.recognize(request);
    }

    public final RecognizeResponse recognize(RecognizeRequest request) {
        return (RecognizeResponse)this.recognizeCallable().call((Object)request);
    }

    public final UnaryCallable<RecognizeRequest, RecognizeResponse> recognizeCallable() {
        return this.stub.recognizeCallable();
    }

    public final OperationFuture<LongRunningRecognizeResponse, LongRunningRecognizeMetadata> longRunningRecognizeAsync(RecognitionConfig config, RecognitionAudio audio) {
        LongRunningRecognizeRequest request = LongRunningRecognizeRequest.newBuilder().setConfig(config).setAudio(audio).build();
        return this.longRunningRecognizeAsync(request);
    }

    public final OperationFuture<LongRunningRecognizeResponse, LongRunningRecognizeMetadata> longRunningRecognizeAsync(LongRunningRecognizeRequest request) {
        return this.longRunningRecognizeOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<LongRunningRecognizeRequest, LongRunningRecognizeResponse, LongRunningRecognizeMetadata> longRunningRecognizeOperationCallable() {
        return this.stub.longRunningRecognizeOperationCallable();
    }

    public final UnaryCallable<LongRunningRecognizeRequest, Operation> longRunningRecognizeCallable() {
        return this.stub.longRunningRecognizeCallable();
    }

    public final BidiStreamingCallable<StreamingRecognizeRequest, StreamingRecognizeResponse> streamingRecognizeCallable() {
        return this.stub.streamingRecognizeCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

